package travel.wink.sdk.travel.agent.api;

import travel.wink.sdk.travel.agent.invoker.ApiClient;

import travel.wink.sdk.travel.agent.model.AffiliateAccountAgent;
import travel.wink.sdk.travel.agent.model.BookingAgent;
import travel.wink.sdk.travel.agent.model.BookingConfirmationsAgent;
import travel.wink.sdk.travel.agent.model.BooleanResponseAgent;
import travel.wink.sdk.travel.agent.model.CancellationDetailAgent;
import travel.wink.sdk.travel.agent.model.CreateAgentBooking400Response;
import travel.wink.sdk.travel.agent.model.CreateAgentBookingRequestAgent;
import travel.wink.sdk.travel.agent.model.GenericErrorMessage;
import travel.wink.sdk.travel.agent.model.PageBookingAgent;
import travel.wink.sdk.travel.agent.model.StateAgent;
import travel.wink.sdk.travel.agent.model.UpsertTravelAgentRequestAgent;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Arrays;
import java.util.stream.Collectors;

import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:21:53.341573209+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class TravelAgentApi {
    private ApiClient apiClient;

    public TravelAgentApi() {
        this(new ApiClient());
    }

    @Autowired
    public TravelAgentApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    
    /**
     * Cancel Booking
     * Cancel a booking by its booking identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Cancel booking owned by company identifier
     * @param bookingIdentifier Cancel booking by identifier
     * @param cancellationDetailAgent The cancellationDetailAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingAgent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec cancelBookingAsTravelAgentRequestCreation(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull String bookingIdentifier, @jakarta.annotation.Nonnull CancellationDetailAgent cancellationDetailAgent, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = cancellationDetailAgent;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling cancelBookingAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bookingIdentifier' is set
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling cancelBookingAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancellationDetailAgent' is set
        if (cancellationDetailAgent == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationDetailAgent' when calling cancelBookingAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingAgent> localVarReturnType = new ParameterizedTypeReference<BookingAgent>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/booking/{bookingIdentifier}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Cancel Booking
     * Cancel a booking by its booking identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Cancel booking owned by company identifier
     * @param bookingIdentifier Cancel booking by identifier
     * @param cancellationDetailAgent The cancellationDetailAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingAgent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingAgent> cancelBookingAsTravelAgent(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull String bookingIdentifier, @jakarta.annotation.Nonnull CancellationDetailAgent cancellationDetailAgent, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingAgent> localVarReturnType = new ParameterizedTypeReference<BookingAgent>() {};
        return cancelBookingAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, cancellationDetailAgent, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Cancel Booking
     * Cancel a booking by its booking identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Cancel booking owned by company identifier
     * @param bookingIdentifier Cancel booking by identifier
     * @param cancellationDetailAgent The cancellationDetailAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BookingAgent&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingAgent>> cancelBookingAsTravelAgentWithHttpInfo(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull String bookingIdentifier, @jakarta.annotation.Nonnull CancellationDetailAgent cancellationDetailAgent, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingAgent> localVarReturnType = new ParameterizedTypeReference<BookingAgent>() {};
        return cancelBookingAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, cancellationDetailAgent, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Cancel Booking
     * Cancel a booking by its booking identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Cancel booking owned by company identifier
     * @param bookingIdentifier Cancel booking by identifier
     * @param cancellationDetailAgent The cancellationDetailAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec cancelBookingAsTravelAgentWithResponseSpec(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull String bookingIdentifier, @jakarta.annotation.Nonnull CancellationDetailAgent cancellationDetailAgent, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return cancelBookingAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, cancellationDetailAgent, winkVersion);
    }

    /**
     * Create Agent Booking
     * Create agent booking. Expects the agent to be a registered agent with TripPay and have available funds to cover the booking amount.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param createAgentBookingRequestAgent The createAgentBookingRequestAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingConfirmationsAgent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createAgentBookingRequestCreation(@jakarta.annotation.Nonnull CreateAgentBookingRequestAgent createAgentBookingRequestAgent, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = createAgentBookingRequestAgent;
        // verify the required parameter 'createAgentBookingRequestAgent' is set
        if (createAgentBookingRequestAgent == null) {
            throw new WebClientResponseException("Missing the required parameter 'createAgentBookingRequestAgent' when calling createAgentBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingConfirmationsAgent> localVarReturnType = new ParameterizedTypeReference<BookingConfirmationsAgent>() {};
        return apiClient.invokeAPI("/api/booking/agent", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Agent Booking
     * Create agent booking. Expects the agent to be a registered agent with TripPay and have available funds to cover the booking amount.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param createAgentBookingRequestAgent The createAgentBookingRequestAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingConfirmationsAgent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingConfirmationsAgent> createAgentBooking(@jakarta.annotation.Nonnull CreateAgentBookingRequestAgent createAgentBookingRequestAgent, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingConfirmationsAgent> localVarReturnType = new ParameterizedTypeReference<BookingConfirmationsAgent>() {};
        return createAgentBookingRequestCreation(createAgentBookingRequestAgent, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Agent Booking
     * Create agent booking. Expects the agent to be a registered agent with TripPay and have available funds to cover the booking amount.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param createAgentBookingRequestAgent The createAgentBookingRequestAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BookingConfirmationsAgent&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingConfirmationsAgent>> createAgentBookingWithHttpInfo(@jakarta.annotation.Nonnull CreateAgentBookingRequestAgent createAgentBookingRequestAgent, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingConfirmationsAgent> localVarReturnType = new ParameterizedTypeReference<BookingConfirmationsAgent>() {};
        return createAgentBookingRequestCreation(createAgentBookingRequestAgent, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Agent Booking
     * Create agent booking. Expects the agent to be a registered agent with TripPay and have available funds to cover the booking amount.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param createAgentBookingRequestAgent The createAgentBookingRequestAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createAgentBookingWithResponseSpec(@jakarta.annotation.Nonnull CreateAgentBookingRequestAgent createAgentBookingRequestAgent, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return createAgentBookingRequestCreation(createAgentBookingRequestAgent, winkVersion);
    }

    /**
     * Resend Booking Confirmation
     * Resends booking confirmation email to traveler.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Resend booking owned by company identifier
     * @param bookingIdentifier Resend booking by identifier
     * @param body Empty request body
     * @param winkVersion The winkVersion parameter
     * @return BooleanResponseAgent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec resendBookingConfirmationEmailAsTravelAgentRequestCreation(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull String bookingIdentifier, @jakarta.annotation.Nullable Object body, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = body;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling resendBookingConfirmationEmailAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bookingIdentifier' is set
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling resendBookingConfirmationEmailAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new WebClientResponseException("Missing the required parameter 'body' when calling resendBookingConfirmationEmailAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BooleanResponseAgent> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAgent>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/booking/{bookingIdentifier}/resend", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Resend Booking Confirmation
     * Resends booking confirmation email to traveler.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Resend booking owned by company identifier
     * @param bookingIdentifier Resend booking by identifier
     * @param body Empty request body
     * @param winkVersion The winkVersion parameter
     * @return BooleanResponseAgent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BooleanResponseAgent> resendBookingConfirmationEmailAsTravelAgent(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull String bookingIdentifier, @jakarta.annotation.Nullable Object body, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAgent> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAgent>() {};
        return resendBookingConfirmationEmailAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, body, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Resend Booking Confirmation
     * Resends booking confirmation email to traveler.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Resend booking owned by company identifier
     * @param bookingIdentifier Resend booking by identifier
     * @param body Empty request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BooleanResponseAgent&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BooleanResponseAgent>> resendBookingConfirmationEmailAsTravelAgentWithHttpInfo(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull String bookingIdentifier, @jakarta.annotation.Nullable Object body, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAgent> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAgent>() {};
        return resendBookingConfirmationEmailAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, body, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Resend Booking Confirmation
     * Resends booking confirmation email to traveler.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Resend booking owned by company identifier
     * @param bookingIdentifier Resend booking by identifier
     * @param body Empty request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec resendBookingConfirmationEmailAsTravelAgentWithResponseSpec(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull String bookingIdentifier, @jakarta.annotation.Nullable Object body, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return resendBookingConfirmationEmailAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, body, winkVersion);
    }

    /**
     * Show Booking
     * Show a booking record by its identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show booking for company identifier
     * @param bookingIdentifier Show booking with booking identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return BookingAgent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBookingAsTravelAgentRequestCreation(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull String bookingIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showBookingAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bookingIdentifier' is set
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling showBookingAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingAgent> localVarReturnType = new ParameterizedTypeReference<BookingAgent>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/booking/{bookingIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Booking
     * Show a booking record by its identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show booking for company identifier
     * @param bookingIdentifier Show booking with booking identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return BookingAgent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingAgent> showBookingAsTravelAgent(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull String bookingIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingAgent> localVarReturnType = new ParameterizedTypeReference<BookingAgent>() {};
        return showBookingAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Booking
     * Show a booking record by its identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show booking for company identifier
     * @param bookingIdentifier Show booking with booking identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;BookingAgent&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingAgent>> showBookingAsTravelAgentWithHttpInfo(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull String bookingIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingAgent> localVarReturnType = new ParameterizedTypeReference<BookingAgent>() {};
        return showBookingAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Booking
     * Show a booking record by its identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show booking for company identifier
     * @param bookingIdentifier Show booking with booking identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showBookingAsTravelAgentWithResponseSpec(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull String bookingIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showBookingAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, winkVersion, accept);
    }

    /**
     * Show Bookings
     * Show bookings for the company that helped create those booking.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show bookings for company identifier
     * @param stateAgent The stateAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return PageBookingAgent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBookingGridAsTravelAgentRequestCreation(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull StateAgent stateAgent, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = stateAgent;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showBookingGridAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'stateAgent' is set
        if (stateAgent == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateAgent' when calling showBookingGridAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageBookingAgent> localVarReturnType = new ParameterizedTypeReference<PageBookingAgent>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/booking/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Bookings
     * Show bookings for the company that helped create those booking.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show bookings for company identifier
     * @param stateAgent The stateAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return PageBookingAgent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageBookingAgent> showBookingGridAsTravelAgent(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull StateAgent stateAgent, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingAgent> localVarReturnType = new ParameterizedTypeReference<PageBookingAgent>() {};
        return showBookingGridAsTravelAgentRequestCreation(companyIdentifier, stateAgent, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Bookings
     * Show bookings for the company that helped create those booking.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show bookings for company identifier
     * @param stateAgent The stateAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageBookingAgent&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageBookingAgent>> showBookingGridAsTravelAgentWithHttpInfo(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull StateAgent stateAgent, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingAgent> localVarReturnType = new ParameterizedTypeReference<PageBookingAgent>() {};
        return showBookingGridAsTravelAgentRequestCreation(companyIdentifier, stateAgent, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Bookings
     * Show bookings for the company that helped create those booking.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show bookings for company identifier
     * @param stateAgent The stateAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showBookingGridAsTravelAgentWithResponseSpec(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull StateAgent stateAgent, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return showBookingGridAsTravelAgentRequestCreation(companyIdentifier, stateAgent, winkVersion);
    }

    /**
     * Update Agent
     * Update an existing agent
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update agent by company id
     * @param upsertTravelAgentRequestAgent The upsertTravelAgentRequestAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return AffiliateAccountAgent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateAgentRequestCreation(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull UpsertTravelAgentRequestAgent upsertTravelAgentRequestAgent, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = upsertTravelAgentRequestAgent;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertTravelAgentRequestAgent' is set
        if (upsertTravelAgentRequestAgent == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertTravelAgentRequestAgent' when calling updateAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AffiliateAccountAgent> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAgent>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/agent", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Agent
     * Update an existing agent
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update agent by company id
     * @param upsertTravelAgentRequestAgent The upsertTravelAgentRequestAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return AffiliateAccountAgent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AffiliateAccountAgent> updateAgent(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull UpsertTravelAgentRequestAgent upsertTravelAgentRequestAgent, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAgent> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAgent>() {};
        return updateAgentRequestCreation(companyIdentifier, upsertTravelAgentRequestAgent, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Agent
     * Update an existing agent
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update agent by company id
     * @param upsertTravelAgentRequestAgent The upsertTravelAgentRequestAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;AffiliateAccountAgent&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AffiliateAccountAgent>> updateAgentWithHttpInfo(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull UpsertTravelAgentRequestAgent upsertTravelAgentRequestAgent, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAgent> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAgent>() {};
        return updateAgentRequestCreation(companyIdentifier, upsertTravelAgentRequestAgent, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Agent
     * Update an existing agent
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update agent by company id
     * @param upsertTravelAgentRequestAgent The upsertTravelAgentRequestAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateAgentWithResponseSpec(@jakarta.annotation.Nonnull String companyIdentifier, @jakarta.annotation.Nonnull UpsertTravelAgentRequestAgent upsertTravelAgentRequestAgent, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return updateAgentRequestCreation(companyIdentifier, upsertTravelAgentRequestAgent, winkVersion);
    }
}
