/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/customization-client): A single endpoint to retrieve whitelabel + customization information for the booking customization.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Travel Agent API The Travel Agent API exposes endpoints to manage agent-facilitated bookings. This API lets you:  1. Travel Agent: Manage agent entity. 2. Booking: Create / Manage bookings  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.travel.agent.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.travel.agent.model.AddressAgent;
import travel.wink.sdk.travel.agent.model.AffiliateAccountUserAgent;
import travel.wink.sdk.travel.agent.model.CustomMonetaryAmount;
import travel.wink.sdk.travel.agent.model.ManagedByEntityAgent;
import travel.wink.sdk.travel.agent.model.SimpleMultimediaAgent;
import travel.wink.sdk.travel.agent.model.TravelAgentAgent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * AffiliateAccountAgent
 */
@JsonPropertyOrder({
  AffiliateAccountAgent.JSON_PROPERTY_ID,
  AffiliateAccountAgent.JSON_PROPERTY_CREATED_DATE,
  AffiliateAccountAgent.JSON_PROPERTY_LAST_UPDATE,
  AffiliateAccountAgent.JSON_PROPERTY_VERSION,
  AffiliateAccountAgent.JSON_PROPERTY_USER_IDENTIFIER,
  AffiliateAccountAgent.JSON_PROPERTY_OWNER,
  AffiliateAccountAgent.JSON_PROPERTY_NAME,
  AffiliateAccountAgent.JSON_PROPERTY_URL_NAME,
  AffiliateAccountAgent.JSON_PROPERTY_LEGAL_NAME,
  AffiliateAccountAgent.JSON_PROPERTY_ENABLED,
  AffiliateAccountAgent.JSON_PROPERTY_APPROVED,
  AffiliateAccountAgent.JSON_PROPERTY_COMPANY_TYPE,
  AffiliateAccountAgent.JSON_PROPERTY_TYPE,
  AffiliateAccountAgent.JSON_PROPERTY_DESCRIPTION,
  AffiliateAccountAgent.JSON_PROPERTY_ADDRESS,
  AffiliateAccountAgent.JSON_PROPERTY_MANAGERS,
  AffiliateAccountAgent.JSON_PROPERTY_LOGO,
  AffiliateAccountAgent.JSON_PROPERTY_TRAVEL_AGENT,
  AffiliateAccountAgent.JSON_PROPERTY_MANAGED_BY,
  AffiliateAccountAgent.JSON_PROPERTY_ONLINE_PRESENCE,
  AffiliateAccountAgent.JSON_PROPERTY_ANNUAL_TRAVEL_SPEND_IN_DOLLARS,
  AffiliateAccountAgent.JSON_PROPERTY_PLANS,
  AffiliateAccountAgent.JSON_PROPERTY_PREVIOUS_URL_NAME_LIST
})
@JsonTypeName("AffiliateAccount_Agent")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:21:53.341573209+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class AffiliateAccountAgent {
  public static final String JSON_PROPERTY_ID = "id";
  @jakarta.annotation.Nullable
  private String id;

  public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
  @jakarta.annotation.Nullable
  private java.time.LocalDateTime createdDate;

  public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
  @jakarta.annotation.Nullable
  private java.time.LocalDateTime lastUpdate;

  public static final String JSON_PROPERTY_VERSION = "version";
  @jakarta.annotation.Nullable
  private Long version;

  public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
  @jakarta.annotation.Nonnull
  private UUID userIdentifier;

  public static final String JSON_PROPERTY_OWNER = "owner";
  @jakarta.annotation.Nonnull
  private AffiliateAccountUserAgent owner;

  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nonnull
  private String name;

  public static final String JSON_PROPERTY_URL_NAME = "urlName";
  @jakarta.annotation.Nonnull
  private String urlName;

  public static final String JSON_PROPERTY_LEGAL_NAME = "legalName";
  @jakarta.annotation.Nullable
  private String legalName;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  @jakarta.annotation.Nonnull
  private Boolean enabled;

  public static final String JSON_PROPERTY_APPROVED = "approved";
  @jakarta.annotation.Nonnull
  private Boolean approved = false;

  /**
   * Type of company
   */
  public enum CompanyTypeEnum {
    COMPANY(String.valueOf("COMPANY")),
    
    INDIVIDUAL(String.valueOf("INDIVIDUAL"));

    private String value;

    CompanyTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CompanyTypeEnum fromValue(String value) {
      for (CompanyTypeEnum b : CompanyTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_COMPANY_TYPE = "companyType";
  @jakarta.annotation.Nonnull
  private CompanyTypeEnum companyType;

  /**
   * Type of sales channel
   */
  public enum TypeEnum {
    DIRECT(String.valueOf("DIRECT")),
    
    APPLICATION(String.valueOf("APPLICATION")),
    
    HOTEL(String.valueOf("HOTEL")),
    
    TRAVELIKO(String.valueOf("TRAVELIKO")),
    
    CORPORATE(String.valueOf("CORPORATE")),
    
    TRAVEL_AGENT(String.valueOf("TRAVEL_AGENT")),
    
    INFLUENCER(String.valueOf("INFLUENCER")),
    
    BLOGGER(String.valueOf("BLOGGER")),
    
    DESTINATION(String.valueOf("DESTINATION")),
    
    CHANNEL_MANAGER(String.valueOf("CHANNEL_MANAGER")),
    
    PROPERTY_MANAGEMENT_SYSTEM(String.valueOf("PROPERTY_MANAGEMENT_SYSTEM")),
    
    CENTRAL_RESERVATION_SYSTEM(String.valueOf("CENTRAL_RESERVATION_SYSTEM")),
    
    GOOGLE_HOTEL_API(String.valueOf("GOOGLE_HOTEL_API")),
    
    MANAGEMENT_COMPANY(String.valueOf("MANAGEMENT_COMPANY")),
    
    CHAIN(String.valueOf("CHAIN")),
    
    BRAND(String.valueOf("BRAND")),
    
    EVENT_ORGANIZER(String.valueOf("EVENT_ORGANIZER"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  @jakarta.annotation.Nonnull
  private TypeEnum type;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  @jakarta.annotation.Nullable
  private String description;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  @jakarta.annotation.Nonnull
  private AddressAgent address;

  public static final String JSON_PROPERTY_MANAGERS = "managers";
  @jakarta.annotation.Nullable
  private List<@Valid AffiliateAccountUserAgent> managers = new ArrayList<>();

  public static final String JSON_PROPERTY_LOGO = "logo";
  @jakarta.annotation.Nullable
  private SimpleMultimediaAgent logo;

  public static final String JSON_PROPERTY_TRAVEL_AGENT = "travelAgent";
  @jakarta.annotation.Nullable
  private TravelAgentAgent travelAgent;

  public static final String JSON_PROPERTY_MANAGED_BY = "managedBy";
  @jakarta.annotation.Nullable
  private ManagedByEntityAgent managedBy;

  public static final String JSON_PROPERTY_ONLINE_PRESENCE = "onlinePresence";
  @jakarta.annotation.Nullable
  private List<Object> onlinePresence = new ArrayList<>();

  public static final String JSON_PROPERTY_ANNUAL_TRAVEL_SPEND_IN_DOLLARS = "annualTravelSpendInDollars";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount annualTravelSpendInDollars;

  public static final String JSON_PROPERTY_PLANS = "plans";
  @jakarta.annotation.Nullable
  private List<Object> plans = new ArrayList<>();

  public static final String JSON_PROPERTY_PREVIOUS_URL_NAME_LIST = "previousUrlNameList";
  @jakarta.annotation.Nullable
  private List<Object> previousUrlNameList = new ArrayList<>();

  public AffiliateAccountAgent() {
  }

  public AffiliateAccountAgent id(@jakarta.annotation.Nullable String id) {
    
    this.id = id;
    return this;
  }

  /**
   * Document UUID
   * @return id
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(@jakarta.annotation.Nullable String id) {
    this.id = id;
  }

  public AffiliateAccountAgent createdDate(@jakarta.annotation.Nullable java.time.LocalDateTime createdDate) {
    
    this.createdDate = createdDate;
    return this;
  }

  /**
   * Datetime this record was first created
   * @return createdDate
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCreatedDate() {
    return createdDate;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedDate(@jakarta.annotation.Nullable java.time.LocalDateTime createdDate) {
    this.createdDate = createdDate;
  }

  public AffiliateAccountAgent lastUpdate(@jakarta.annotation.Nullable java.time.LocalDateTime lastUpdate) {
    
    this.lastUpdate = lastUpdate;
    return this;
  }

  /**
   * Datetime this record was last updated
   * @return lastUpdate
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getLastUpdate() {
    return lastUpdate;
  }


  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastUpdate(@jakarta.annotation.Nullable java.time.LocalDateTime lastUpdate) {
    this.lastUpdate = lastUpdate;
  }

  public AffiliateAccountAgent version(@jakarta.annotation.Nullable Long version) {
    
    this.version = version;
    return this;
  }

  /**
   * Version property that shows how many times this document has been persisted. Document will not persist if the version property is less than current version property in the system. Result in an optimistic locking exception.
   * @return version
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(@jakarta.annotation.Nullable Long version) {
    this.version = version;
  }

  public AffiliateAccountAgent userIdentifier(@jakarta.annotation.Nonnull UUID userIdentifier) {
    
    this.userIdentifier = userIdentifier;
    return this;
  }

  /**
   * User or Registered client owner identifier that created this record
   * @return userIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getUserIdentifier() {
    return userIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUserIdentifier(@jakarta.annotation.Nonnull UUID userIdentifier) {
    this.userIdentifier = userIdentifier;
  }

  public AffiliateAccountAgent owner(@jakarta.annotation.Nonnull AffiliateAccountUserAgent owner) {
    
    this.owner = owner;
    return this;
  }

  /**
   * Owner
   * @return owner
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AffiliateAccountUserAgent getOwner() {
    return owner;
  }


  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwner(@jakarta.annotation.Nonnull AffiliateAccountUserAgent owner) {
    this.owner = owner;
  }

  public AffiliateAccountAgent name(@jakarta.annotation.Nonnull String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Name of company
   * @return name
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(@jakarta.annotation.Nonnull String name) {
    this.name = name;
  }

  public AffiliateAccountAgent urlName(@jakarta.annotation.Nonnull String urlName) {
    
    this.urlName = urlName;
    return this;
  }

  /**
   * Url slug of company name
   * @return urlName
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getUrlName() {
    return urlName;
  }


  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUrlName(@jakarta.annotation.Nonnull String urlName) {
    this.urlName = urlName;
  }

  public AffiliateAccountAgent legalName(@jakarta.annotation.Nullable String legalName) {
    
    this.legalName = legalName;
    return this;
  }

  /**
   * Legal name of entity if other than name
   * @return legalName
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LEGAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLegalName() {
    return legalName;
  }


  @JsonProperty(JSON_PROPERTY_LEGAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalName(@jakarta.annotation.Nullable String legalName) {
    this.legalName = legalName;
  }

  public AffiliateAccountAgent enabled(@jakarta.annotation.Nonnull Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

  /**
   * Whether this company is enabled by reactive.
   * @return enabled
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnabled(@jakarta.annotation.Nonnull Boolean enabled) {
    this.enabled = enabled;
  }

  public AffiliateAccountAgent approved(@jakarta.annotation.Nonnull Boolean approved) {
    
    this.approved = approved;
    return this;
  }

  /**
   * Whether this company has been approved by KYC.
   * @return approved
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_APPROVED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getApproved() {
    return approved;
  }


  @JsonProperty(JSON_PROPERTY_APPROVED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setApproved(@jakarta.annotation.Nonnull Boolean approved) {
    this.approved = approved;
  }

  public AffiliateAccountAgent companyType(@jakarta.annotation.Nonnull CompanyTypeEnum companyType) {
    
    this.companyType = companyType;
    return this;
  }

  /**
   * Type of company
   * @return companyType
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_COMPANY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CompanyTypeEnum getCompanyType() {
    return companyType;
  }


  @JsonProperty(JSON_PROPERTY_COMPANY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCompanyType(@jakarta.annotation.Nonnull CompanyTypeEnum companyType) {
    this.companyType = companyType;
  }

  public AffiliateAccountAgent type(@jakarta.annotation.Nonnull TypeEnum type) {
    
    this.type = type;
    return this;
  }

  /**
   * Type of sales channel
   * @return type
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(@jakarta.annotation.Nonnull TypeEnum type) {
    this.type = type;
  }

  public AffiliateAccountAgent description(@jakarta.annotation.Nullable String description) {
    
    this.description = description;
    return this;
  }

  /**
   * A personal message from the company.
   * @return description
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(@jakarta.annotation.Nullable String description) {
    this.description = description;
  }

  public AffiliateAccountAgent address(@jakarta.annotation.Nonnull AddressAgent address) {
    
    this.address = address;
    return this;
  }

  /**
   * Get address
   * @return address
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AddressAgent getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAddress(@jakarta.annotation.Nonnull AddressAgent address) {
    this.address = address;
  }

  public AffiliateAccountAgent managers(@jakarta.annotation.Nullable List<@Valid AffiliateAccountUserAgent> managers) {
    
    this.managers = managers;
    return this;
  }

  public AffiliateAccountAgent addManagersItem(AffiliateAccountUserAgent managersItem) {
    if (this.managers == null) {
      this.managers = new ArrayList<>();
    }
    this.managers.add(managersItem);
    return this;
  }

  /**
   * Get managers
   * @return managers
   */
  @jakarta.annotation.Nullable
  @Valid
 @Size(min=0,max=30)
  @JsonProperty(JSON_PROPERTY_MANAGERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid AffiliateAccountUserAgent> getManagers() {
    return managers;
  }


  @JsonProperty(JSON_PROPERTY_MANAGERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setManagers(@jakarta.annotation.Nullable List<@Valid AffiliateAccountUserAgent> managers) {
    this.managers = managers;
  }

  public AffiliateAccountAgent logo(@jakarta.annotation.Nullable SimpleMultimediaAgent logo) {
    
    this.logo = logo;
    return this;
  }

  /**
   * Customize account with a custom logo / profile picture.
   * @return logo
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LOGO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SimpleMultimediaAgent getLogo() {
    return logo;
  }


  @JsonProperty(JSON_PROPERTY_LOGO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLogo(@jakarta.annotation.Nullable SimpleMultimediaAgent logo) {
    this.logo = logo;
  }

  public AffiliateAccountAgent travelAgent(@jakarta.annotation.Nullable TravelAgentAgent travelAgent) {
    
    this.travelAgent = travelAgent;
    return this;
  }

  /**
   * Customize account with a custom logo / profile picture.
   * @return travelAgent
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TRAVEL_AGENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TravelAgentAgent getTravelAgent() {
    return travelAgent;
  }


  @JsonProperty(JSON_PROPERTY_TRAVEL_AGENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTravelAgent(@jakarta.annotation.Nullable TravelAgentAgent travelAgent) {
    this.travelAgent = travelAgent;
  }

  public AffiliateAccountAgent managedBy(@jakarta.annotation.Nullable ManagedByEntityAgent managedBy) {
    
    this.managedBy = managedBy;
    return this;
  }

  /**
   * If another company entity is managing this property, on behalf of the property, it can be specified here and the managing entity would be applicable a management fee on every booking.
   * @return managedBy
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MANAGED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ManagedByEntityAgent getManagedBy() {
    return managedBy;
  }


  @JsonProperty(JSON_PROPERTY_MANAGED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setManagedBy(@jakarta.annotation.Nullable ManagedByEntityAgent managedBy) {
    this.managedBy = managedBy;
  }

  public AffiliateAccountAgent onlinePresence(@jakarta.annotation.Nullable List<Object> onlinePresence) {
    
    this.onlinePresence = onlinePresence;
    return this;
  }

  public AffiliateAccountAgent addOnlinePresenceItem(Object onlinePresenceItem) {
    if (this.onlinePresence == null) {
      this.onlinePresence = new ArrayList<>();
    }
    this.onlinePresence.add(onlinePresenceItem);
    return this;
  }

  /**
   * Get onlinePresence
   * @return onlinePresence
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ONLINE_PRESENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getOnlinePresence() {
    return onlinePresence;
  }


  @JsonProperty(JSON_PROPERTY_ONLINE_PRESENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOnlinePresence(@jakarta.annotation.Nullable List<Object> onlinePresence) {
    this.onlinePresence = onlinePresence;
  }

  public AffiliateAccountAgent annualTravelSpendInDollars(@jakarta.annotation.Nullable CustomMonetaryAmount annualTravelSpendInDollars) {
    
    this.annualTravelSpendInDollars = annualTravelSpendInDollars;
    return this;
  }

  /**
   * How much user or company spends on travel per year.
   * @return annualTravelSpendInDollars
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ANNUAL_TRAVEL_SPEND_IN_DOLLARS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getAnnualTravelSpendInDollars() {
    return annualTravelSpendInDollars;
  }


  @JsonProperty(JSON_PROPERTY_ANNUAL_TRAVEL_SPEND_IN_DOLLARS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnnualTravelSpendInDollars(@jakarta.annotation.Nullable CustomMonetaryAmount annualTravelSpendInDollars) {
    this.annualTravelSpendInDollars = annualTravelSpendInDollars;
  }

  public AffiliateAccountAgent plans(@jakarta.annotation.Nullable List<Object> plans) {
    
    this.plans = plans;
    return this;
  }

  public AffiliateAccountAgent addPlansItem(Object plansItem) {
    if (this.plans == null) {
      this.plans = new ArrayList<>();
    }
    this.plans.add(plansItem);
    return this;
  }

  /**
   * Get plans
   * @return plans
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PLANS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getPlans() {
    return plans;
  }


  @JsonProperty(JSON_PROPERTY_PLANS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlans(@jakarta.annotation.Nullable List<Object> plans) {
    this.plans = plans;
  }

  public AffiliateAccountAgent previousUrlNameList(@jakarta.annotation.Nullable List<Object> previousUrlNameList) {
    
    this.previousUrlNameList = previousUrlNameList;
    return this;
  }

  public AffiliateAccountAgent addPreviousUrlNameListItem(Object previousUrlNameListItem) {
    if (this.previousUrlNameList == null) {
      this.previousUrlNameList = new ArrayList<>();
    }
    this.previousUrlNameList.add(previousUrlNameListItem);
    return this;
  }

  /**
   * Get previousUrlNameList
   * @return previousUrlNameList
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PREVIOUS_URL_NAME_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getPreviousUrlNameList() {
    return previousUrlNameList;
  }


  @JsonProperty(JSON_PROPERTY_PREVIOUS_URL_NAME_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPreviousUrlNameList(@jakarta.annotation.Nullable List<Object> previousUrlNameList) {
    this.previousUrlNameList = previousUrlNameList;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AffiliateAccountAgent affiliateAccountAgent = (AffiliateAccountAgent) o;
    return Objects.equals(this.id, affiliateAccountAgent.id) &&
        Objects.equals(this.createdDate, affiliateAccountAgent.createdDate) &&
        Objects.equals(this.lastUpdate, affiliateAccountAgent.lastUpdate) &&
        Objects.equals(this.version, affiliateAccountAgent.version) &&
        Objects.equals(this.userIdentifier, affiliateAccountAgent.userIdentifier) &&
        Objects.equals(this.owner, affiliateAccountAgent.owner) &&
        Objects.equals(this.name, affiliateAccountAgent.name) &&
        Objects.equals(this.urlName, affiliateAccountAgent.urlName) &&
        Objects.equals(this.legalName, affiliateAccountAgent.legalName) &&
        Objects.equals(this.enabled, affiliateAccountAgent.enabled) &&
        Objects.equals(this.approved, affiliateAccountAgent.approved) &&
        Objects.equals(this.companyType, affiliateAccountAgent.companyType) &&
        Objects.equals(this.type, affiliateAccountAgent.type) &&
        Objects.equals(this.description, affiliateAccountAgent.description) &&
        Objects.equals(this.address, affiliateAccountAgent.address) &&
        Objects.equals(this.managers, affiliateAccountAgent.managers) &&
        Objects.equals(this.logo, affiliateAccountAgent.logo) &&
        Objects.equals(this.travelAgent, affiliateAccountAgent.travelAgent) &&
        Objects.equals(this.managedBy, affiliateAccountAgent.managedBy) &&
        Objects.equals(this.onlinePresence, affiliateAccountAgent.onlinePresence) &&
        Objects.equals(this.annualTravelSpendInDollars, affiliateAccountAgent.annualTravelSpendInDollars) &&
        Objects.equals(this.plans, affiliateAccountAgent.plans) &&
        Objects.equals(this.previousUrlNameList, affiliateAccountAgent.previousUrlNameList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdDate, lastUpdate, version, userIdentifier, owner, name, urlName, legalName, enabled, approved, companyType, type, description, address, managers, logo, travelAgent, managedBy, onlinePresence, annualTravelSpendInDollars, plans, previousUrlNameList);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AffiliateAccountAgent {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    lastUpdate: ").append(toIndentedString(lastUpdate)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    userIdentifier: ").append(toIndentedString(userIdentifier)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    urlName: ").append(toIndentedString(urlName)).append("\n");
    sb.append("    legalName: ").append(toIndentedString(legalName)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    approved: ").append(toIndentedString(approved)).append("\n");
    sb.append("    companyType: ").append(toIndentedString(companyType)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    managers: ").append(toIndentedString(managers)).append("\n");
    sb.append("    logo: ").append(toIndentedString(logo)).append("\n");
    sb.append("    travelAgent: ").append(toIndentedString(travelAgent)).append("\n");
    sb.append("    managedBy: ").append(toIndentedString(managedBy)).append("\n");
    sb.append("    onlinePresence: ").append(toIndentedString(onlinePresence)).append("\n");
    sb.append("    annualTravelSpendInDollars: ").append(toIndentedString(annualTravelSpendInDollars)).append("\n");
    sb.append("    plans: ").append(toIndentedString(plans)).append("\n");
    sb.append("    previousUrlNameList: ").append(toIndentedString(previousUrlNameList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

