/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/customization-client): A single endpoint to retrieve whitelabel + customization information for the booking customization.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Travel Agent API The Travel Agent API exposes endpoints to manage agent-facilitated bookings. This API lets you:  1. Travel Agent: Manage agent entity. 2. Booking: Create / Manage bookings  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.travel.agent.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.travel.agent.model.BookingAncillaryAgent;
import travel.wink.sdk.travel.agent.model.BookingContractAgent;
import travel.wink.sdk.travel.agent.model.BookingUserAgent;
import travel.wink.sdk.travel.agent.model.BookingUserSessionAgent;
import travel.wink.sdk.travel.agent.model.CommissionableEntryAgent;
import travel.wink.sdk.travel.agent.model.CustomMonetaryAmount;
import travel.wink.sdk.travel.agent.model.CustomizationLightweightAgent;
import travel.wink.sdk.travel.agent.model.PropertyAggregateLightweightAgent;
import travel.wink.sdk.travel.agent.model.ReviewLightweightAgent;
import travel.wink.sdk.travel.agent.model.RoomStayAgent;
import travel.wink.sdk.travel.agent.model.SocialAgent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * BookingAgent
 */
@JsonPropertyOrder({
  BookingAgent.JSON_PROPERTY_ID,
  BookingAgent.JSON_PROPERTY_CREATED_DATE,
  BookingAgent.JSON_PROPERTY_LAST_UPDATE,
  BookingAgent.JSON_PROPERTY_VERSION,
  BookingAgent.JSON_PROPERTY_CREATION,
  BookingAgent.JSON_PROPERTY_GROUP_IDENTIFIER,
  BookingAgent.JSON_PROPERTY_CUSTOMIZATION,
  BookingAgent.JSON_PROPERTY_BOOKING_CODE,
  BookingAgent.JSON_PROPERTY_USER,
  BookingAgent.JSON_PROPERTY_USER_SESSION,
  BookingAgent.JSON_PROPERTY_SERVER_URL,
  BookingAgent.JSON_PROPERTY_SOCIALS,
  BookingAgent.JSON_PROPERTY_REVIEW,
  BookingAgent.JSON_PROPERTY_EMAIL_HEADER_LOGO_URL,
  BookingAgent.JSON_PROPERTY_LOGO_IDENTIFIER,
  BookingAgent.JSON_PROPERTY_HOTEL,
  BookingAgent.JSON_PROPERTY_ROOM_STAY,
  BookingAgent.JSON_PROPERTY_SPECIAL_REQUESTS,
  BookingAgent.JSON_PROPERTY_COMMENT,
  BookingAgent.JSON_PROPERTY_EARLY_CHECK_IN_CHARGE,
  BookingAgent.JSON_PROPERTY_LATE_CHECK_OUT_CHARGE,
  BookingAgent.JSON_PROPERTY_EARLY_CHECK_IN_CHARGE_PERCENT,
  BookingAgent.JSON_PROPERTY_LATE_CHECK_OUT_CHARGE_PERCENT,
  BookingAgent.JSON_PROPERTY_HOTEL_IMAGE_URL,
  BookingAgent.JSON_PROPERTY_ROOM_IMAGE_URL,
  BookingAgent.JSON_PROPERTY_COMMISSION_LIST,
  BookingAgent.JSON_PROPERTY_ANCILLARY_LIST,
  BookingAgent.JSON_PROPERTY_BOOKING_CONTRACT,
  BookingAgent.JSON_PROPERTY_STATIC_MAP_IMAGE_URL,
  BookingAgent.JSON_PROPERTY_STATIC_MAP_URL,
  BookingAgent.JSON_PROPERTY_STATUS,
  BookingAgent.JSON_PROPERTY_MEETING_ROOMS,
  BookingAgent.JSON_PROPERTY_RESTAURANTS,
  BookingAgent.JSON_PROPERTY_SPAS,
  BookingAgent.JSON_PROPERTY_ACTIVITIES,
  BookingAgent.JSON_PROPERTY_ATTRACTIONS,
  BookingAgent.JSON_PROPERTY_PLACES,
  BookingAgent.JSON_PROPERTY_ROOM_TYPE_ANCILLARIES,
  BookingAgent.JSON_PROPERTY_ADD_ONS,
  BookingAgent.JSON_PROPERTY_RATE_SOURCE,
  BookingAgent.JSON_PROPERTY_HAS_ADD_ONS,
  BookingAgent.JSON_PROPERTY_CANCELLABLE_BY_AGENT,
  BookingAgent.JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER,
  BookingAgent.JSON_PROPERTY_CANCELLABLE_BY_TRAVELER,
  BookingAgent.JSON_PROPERTY_REPORTING_EXTRA_CHARGE_LIST,
  BookingAgent.JSON_PROPERTY_HAS_BREAKFAST,
  BookingAgent.JSON_PROPERTY_HAS_BRUNCH,
  BookingAgent.JSON_PROPERTY_HAS_LUNCH,
  BookingAgent.JSON_PROPERTY_HAS_DINNER,
  BookingAgent.JSON_PROPERTY_HAS_ALL_INCLUSIVE,
  BookingAgent.JSON_PROPERTY_HAS_ALL_INCLUSIVE_PLUS_ALCOHOL,
  BookingAgent.JSON_PROPERTY_HAS_ROOM_TYPE_ANCILLARIES,
  BookingAgent.JSON_PROPERTY_HAS_FOOD,
  BookingAgent.JSON_PROPERTY_HAS_RESTAURANTS,
  BookingAgent.JSON_PROPERTY_HAS_MEETING_ROOMS,
  BookingAgent.JSON_PROPERTY_HAS_SPAS,
  BookingAgent.JSON_PROPERTY_HAS_ACTIVITIES,
  BookingAgent.JSON_PROPERTY_HAS_ATTRACTIONS,
  BookingAgent.JSON_PROPERTY_HAS_PLACES,
  BookingAgent.JSON_PROPERTY_REPORTING_DAILY_RATE_LIST,
  BookingAgent.JSON_PROPERTY_REPORTING_ANCILLARY_LIST
})
@JsonTypeName("Booking_Agent")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:21:53.341573209+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class BookingAgent {
  public static final String JSON_PROPERTY_ID = "id";
  @jakarta.annotation.Nullable
  private String id;

  public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
  @jakarta.annotation.Nullable
  private java.time.LocalDateTime createdDate;

  public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
  @jakarta.annotation.Nullable
  private java.time.LocalDateTime lastUpdate;

  public static final String JSON_PROPERTY_VERSION = "version";
  @jakarta.annotation.Nullable
  private Long version;

  /**
   * Communicates whether the booking was created normally or if it failed or was just for testing.
   */
  public enum CreationEnum {
    NORMAL(String.valueOf("NORMAL")),
    
    TEST(String.valueOf("TEST")),
    
    FAILED(String.valueOf("FAILED"));

    private String value;

    CreationEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CreationEnum fromValue(String value) {
      for (CreationEnum b : CreationEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CREATION = "creation";
  @jakarta.annotation.Nonnull
  private CreationEnum creation = CreationEnum.NORMAL;

  public static final String JSON_PROPERTY_GROUP_IDENTIFIER = "groupIdentifier";
  @jakarta.annotation.Nonnull
  private UUID groupIdentifier;

  public static final String JSON_PROPERTY_CUSTOMIZATION = "customization";
  @jakarta.annotation.Nonnull
  private CustomizationLightweightAgent customization;

  public static final String JSON_PROPERTY_BOOKING_CODE = "bookingCode";
  @jakarta.annotation.Nonnull
  private String bookingCode;

  public static final String JSON_PROPERTY_USER = "user";
  @jakarta.annotation.Nonnull
  private BookingUserAgent user;

  public static final String JSON_PROPERTY_USER_SESSION = "userSession";
  @jakarta.annotation.Nonnull
  private BookingUserSessionAgent userSession;

  public static final String JSON_PROPERTY_SERVER_URL = "serverUrl";
  @jakarta.annotation.Nonnull
  private String serverUrl;

  public static final String JSON_PROPERTY_SOCIALS = "socials";
  @jakarta.annotation.Nullable
  private List<@Valid SocialAgent> socials = new ArrayList<>();

  public static final String JSON_PROPERTY_REVIEW = "review";
  @jakarta.annotation.Nullable
  private ReviewLightweightAgent review;

  public static final String JSON_PROPERTY_EMAIL_HEADER_LOGO_URL = "emailHeaderLogoUrl";
  @jakarta.annotation.Nonnull
  private String emailHeaderLogoUrl;

  public static final String JSON_PROPERTY_LOGO_IDENTIFIER = "logoIdentifier";
  @jakarta.annotation.Nullable
  private String logoIdentifier;

  public static final String JSON_PROPERTY_HOTEL = "hotel";
  @jakarta.annotation.Nonnull
  private PropertyAggregateLightweightAgent hotel;

  public static final String JSON_PROPERTY_ROOM_STAY = "roomStay";
  @jakarta.annotation.Nullable
  private RoomStayAgent roomStay;

  public static final String JSON_PROPERTY_SPECIAL_REQUESTS = "specialRequests";
  @jakarta.annotation.Nullable
  private String specialRequests;

  public static final String JSON_PROPERTY_COMMENT = "comment";
  @jakarta.annotation.Nullable
  private String comment;

  public static final String JSON_PROPERTY_EARLY_CHECK_IN_CHARGE = "earlyCheckInCharge";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount earlyCheckInCharge;

  public static final String JSON_PROPERTY_LATE_CHECK_OUT_CHARGE = "lateCheckOutCharge";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount lateCheckOutCharge;

  public static final String JSON_PROPERTY_EARLY_CHECK_IN_CHARGE_PERCENT = "earlyCheckInChargePercent";
  @jakarta.annotation.Nullable
  private Float earlyCheckInChargePercent;

  public static final String JSON_PROPERTY_LATE_CHECK_OUT_CHARGE_PERCENT = "lateCheckOutChargePercent";
  @jakarta.annotation.Nullable
  private Float lateCheckOutChargePercent;

  public static final String JSON_PROPERTY_HOTEL_IMAGE_URL = "hotelImageUrl";
  @jakarta.annotation.Nonnull
  private String hotelImageUrl;

  public static final String JSON_PROPERTY_ROOM_IMAGE_URL = "roomImageUrl";
  @jakarta.annotation.Nonnull
  private String roomImageUrl;

  public static final String JSON_PROPERTY_COMMISSION_LIST = "commissionList";
  @jakarta.annotation.Nullable
  private List<@Valid CommissionableEntryAgent> commissionList = new ArrayList<>();

  public static final String JSON_PROPERTY_ANCILLARY_LIST = "ancillaryList";
  @jakarta.annotation.Nullable
  private List<@Valid BookingAncillaryAgent> ancillaryList = new ArrayList<>();

  public static final String JSON_PROPERTY_BOOKING_CONTRACT = "bookingContract";
  @jakarta.annotation.Nullable
  private BookingContractAgent bookingContract;

  public static final String JSON_PROPERTY_STATIC_MAP_IMAGE_URL = "staticMapImageUrl";
  @jakarta.annotation.Nullable
  private String staticMapImageUrl;

  public static final String JSON_PROPERTY_STATIC_MAP_URL = "staticMapUrl";
  @jakarta.annotation.Nullable
  private String staticMapUrl;

  /**
   * Convenience data point to show which status the booking currently has.
   */
  public enum StatusEnum {
    CANCELLED_BY_HOTEL(String.valueOf("CANCELLED_BY_HOTEL")),
    
    CANCELLED_BY_GUEST(String.valueOf("CANCELLED_BY_GUEST")),
    
    CANCELLED_BY_ADMIN(String.valueOf("CANCELLED_BY_ADMIN")),
    
    CANCELLED_BY_SALES_CHANNEL(String.valueOf("CANCELLED_BY_SALES_CHANNEL")),
    
    PAST(String.valueOf("PAST")),
    
    FUTURE(String.valueOf("FUTURE")),
    
    CANCELLED_BY_ACQUIRER(String.valueOf("CANCELLED_BY_ACQUIRER")),
    
    ACTIVE(String.valueOf("ACTIVE")),
    
    FAILED(String.valueOf("FAILED")),
    
    FULLY_REFUNDED(String.valueOf("FULLY_REFUNDED"));

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  @jakarta.annotation.Nullable
  private StatusEnum status;

  public static final String JSON_PROPERTY_MEETING_ROOMS = "meetingRooms";
  @jakarta.annotation.Nullable
  private List<@Valid BookingAncillaryAgent> meetingRooms = new ArrayList<>();

  public static final String JSON_PROPERTY_RESTAURANTS = "restaurants";
  @jakarta.annotation.Nullable
  private List<@Valid BookingAncillaryAgent> restaurants = new ArrayList<>();

  public static final String JSON_PROPERTY_SPAS = "spas";
  @jakarta.annotation.Nullable
  private List<@Valid BookingAncillaryAgent> spas = new ArrayList<>();

  public static final String JSON_PROPERTY_ACTIVITIES = "activities";
  @jakarta.annotation.Nullable
  private List<@Valid BookingAncillaryAgent> activities = new ArrayList<>();

  public static final String JSON_PROPERTY_ATTRACTIONS = "attractions";
  @jakarta.annotation.Nullable
  private List<@Valid BookingAncillaryAgent> attractions = new ArrayList<>();

  public static final String JSON_PROPERTY_PLACES = "places";
  @jakarta.annotation.Nullable
  private List<@Valid BookingAncillaryAgent> places = new ArrayList<>();

  public static final String JSON_PROPERTY_ROOM_TYPE_ANCILLARIES = "roomTypeAncillaries";
  @jakarta.annotation.Nullable
  private List<@Valid BookingAncillaryAgent> roomTypeAncillaries = new ArrayList<>();

  public static final String JSON_PROPERTY_ADD_ONS = "addOns";
  @jakarta.annotation.Nullable
  private List<@Valid BookingAncillaryAgent> addOns = new ArrayList<>();

  public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
  @jakarta.annotation.Nullable
  private String rateSource;

  public static final String JSON_PROPERTY_HAS_ADD_ONS = "hasAddOns";
  @jakarta.annotation.Nullable
  private Boolean hasAddOns;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_AGENT = "cancellableByAgent";
  @jakarta.annotation.Nullable
  private Boolean cancellableByAgent;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER = "cancellableBySupplier";
  @jakarta.annotation.Nullable
  private Boolean cancellableBySupplier;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
  @jakarta.annotation.Nullable
  private Boolean cancellableByTraveler;

  public static final String JSON_PROPERTY_REPORTING_EXTRA_CHARGE_LIST = "reportingExtraChargeList";
  @jakarta.annotation.Nullable
  private List<Object> reportingExtraChargeList = new ArrayList<>();

  public static final String JSON_PROPERTY_HAS_BREAKFAST = "hasBreakfast";
  @jakarta.annotation.Nullable
  private Boolean hasBreakfast;

  public static final String JSON_PROPERTY_HAS_BRUNCH = "hasBrunch";
  @jakarta.annotation.Nullable
  private Boolean hasBrunch;

  public static final String JSON_PROPERTY_HAS_LUNCH = "hasLunch";
  @jakarta.annotation.Nullable
  private Boolean hasLunch;

  public static final String JSON_PROPERTY_HAS_DINNER = "hasDinner";
  @jakarta.annotation.Nullable
  private Boolean hasDinner;

  public static final String JSON_PROPERTY_HAS_ALL_INCLUSIVE = "hasAllInclusive";
  @jakarta.annotation.Nullable
  private Boolean hasAllInclusive;

  public static final String JSON_PROPERTY_HAS_ALL_INCLUSIVE_PLUS_ALCOHOL = "hasAllInclusivePlusAlcohol";
  @jakarta.annotation.Nullable
  private Boolean hasAllInclusivePlusAlcohol;

  public static final String JSON_PROPERTY_HAS_ROOM_TYPE_ANCILLARIES = "hasRoomTypeAncillaries";
  @jakarta.annotation.Nullable
  private Boolean hasRoomTypeAncillaries;

  public static final String JSON_PROPERTY_HAS_FOOD = "hasFood";
  @jakarta.annotation.Nullable
  private Boolean hasFood;

  public static final String JSON_PROPERTY_HAS_RESTAURANTS = "hasRestaurants";
  @jakarta.annotation.Nullable
  private Boolean hasRestaurants;

  public static final String JSON_PROPERTY_HAS_MEETING_ROOMS = "hasMeetingRooms";
  @jakarta.annotation.Nullable
  private Boolean hasMeetingRooms;

  public static final String JSON_PROPERTY_HAS_SPAS = "hasSpas";
  @jakarta.annotation.Nullable
  private Boolean hasSpas;

  public static final String JSON_PROPERTY_HAS_ACTIVITIES = "hasActivities";
  @jakarta.annotation.Nullable
  private Boolean hasActivities;

  public static final String JSON_PROPERTY_HAS_ATTRACTIONS = "hasAttractions";
  @jakarta.annotation.Nullable
  private Boolean hasAttractions;

  public static final String JSON_PROPERTY_HAS_PLACES = "hasPlaces";
  @jakarta.annotation.Nullable
  private Boolean hasPlaces;

  public static final String JSON_PROPERTY_REPORTING_DAILY_RATE_LIST = "reportingDailyRateList";
  @jakarta.annotation.Nullable
  private List<Object> reportingDailyRateList = new ArrayList<>();

  public static final String JSON_PROPERTY_REPORTING_ANCILLARY_LIST = "reportingAncillaryList";
  @jakarta.annotation.Nullable
  private List<Object> reportingAncillaryList = new ArrayList<>();

  public BookingAgent() {
  }

  public BookingAgent id(@jakarta.annotation.Nullable String id) {
    
    this.id = id;
    return this;
  }

  /**
   * Document UUID
   * @return id
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(@jakarta.annotation.Nullable String id) {
    this.id = id;
  }

  public BookingAgent createdDate(@jakarta.annotation.Nullable java.time.LocalDateTime createdDate) {
    
    this.createdDate = createdDate;
    return this;
  }

  /**
   * Datetime this record was first created
   * @return createdDate
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCreatedDate() {
    return createdDate;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedDate(@jakarta.annotation.Nullable java.time.LocalDateTime createdDate) {
    this.createdDate = createdDate;
  }

  public BookingAgent lastUpdate(@jakarta.annotation.Nullable java.time.LocalDateTime lastUpdate) {
    
    this.lastUpdate = lastUpdate;
    return this;
  }

  /**
   * Datetime this record was last updated
   * @return lastUpdate
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getLastUpdate() {
    return lastUpdate;
  }


  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastUpdate(@jakarta.annotation.Nullable java.time.LocalDateTime lastUpdate) {
    this.lastUpdate = lastUpdate;
  }

  public BookingAgent version(@jakarta.annotation.Nullable Long version) {
    
    this.version = version;
    return this;
  }

  /**
   * Version property that shows how many times this document has been persisted. Document will not persist if the version property is less than current version property in the system. Result in an optimistic locking exception.
   * @return version
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(@jakarta.annotation.Nullable Long version) {
    this.version = version;
  }

  public BookingAgent creation(@jakarta.annotation.Nonnull CreationEnum creation) {
    
    this.creation = creation;
    return this;
  }

  /**
   * Communicates whether the booking was created normally or if it failed or was just for testing.
   * @return creation
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CREATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CreationEnum getCreation() {
    return creation;
  }


  @JsonProperty(JSON_PROPERTY_CREATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCreation(@jakarta.annotation.Nonnull CreationEnum creation) {
    this.creation = creation;
  }

  public BookingAgent groupIdentifier(@jakarta.annotation.Nonnull UUID groupIdentifier) {
    
    this.groupIdentifier = groupIdentifier;
    return this;
  }

  /**
   * Unique record identifier for the collection of bookings that were made at the same time.
   * @return groupIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_GROUP_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getGroupIdentifier() {
    return groupIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setGroupIdentifier(@jakarta.annotation.Nonnull UUID groupIdentifier) {
    this.groupIdentifier = groupIdentifier;
  }

  public BookingAgent customization(@jakarta.annotation.Nonnull CustomizationLightweightAgent customization) {
    
    this.customization = customization;
    return this;
  }

  /**
   * Which customization configuration record did the entity application used to facilitate in making this booking happen.
   * @return customization
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CUSTOMIZATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomizationLightweightAgent getCustomization() {
    return customization;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOMIZATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCustomization(@jakarta.annotation.Nonnull CustomizationLightweightAgent customization) {
    this.customization = customization;
  }

  public BookingAgent bookingCode(@jakarta.annotation.Nonnull String bookingCode) {
    
    this.bookingCode = bookingCode;
    return this;
  }

  /**
   * Unique user-friendly booking geoname. This code should be used when corresponding with travelers.
   * @return bookingCode
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getBookingCode() {
    return bookingCode;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBookingCode(@jakarta.annotation.Nonnull String bookingCode) {
    this.bookingCode = bookingCode;
  }

  public BookingAgent user(@jakarta.annotation.Nonnull BookingUserAgent user) {
    
    this.user = user;
    return this;
  }

  /**
   * User details for the authenticated person that made the booking.
   * @return user
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BookingUserAgent getUser() {
    return user;
  }


  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUser(@jakarta.annotation.Nonnull BookingUserAgent user) {
    this.user = user;
  }

  public BookingAgent userSession(@jakarta.annotation.Nonnull BookingUserSessionAgent userSession) {
    
    this.userSession = userSession;
    return this;
  }

  /**
   * User session state as it was when the user made the booking.
   * @return userSession
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SESSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BookingUserSessionAgent getUserSession() {
    return userSession;
  }


  @JsonProperty(JSON_PROPERTY_USER_SESSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUserSession(@jakarta.annotation.Nonnull BookingUserSessionAgent userSession) {
    this.userSession = userSession;
  }

  public BookingAgent serverUrl(@jakarta.annotation.Nonnull String serverUrl) {
    
    this.serverUrl = serverUrl;
    return this;
  }

  /**
   * The URL the booking occurred
   * @return serverUrl
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SERVER_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getServerUrl() {
    return serverUrl;
  }


  @JsonProperty(JSON_PROPERTY_SERVER_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setServerUrl(@jakarta.annotation.Nonnull String serverUrl) {
    this.serverUrl = serverUrl;
  }

  public BookingAgent socials(@jakarta.annotation.Nullable List<@Valid SocialAgent> socials) {
    
    this.socials = socials;
    return this;
  }

  public BookingAgent addSocialsItem(SocialAgent socialsItem) {
    if (this.socials == null) {
      this.socials = new ArrayList<>();
    }
    this.socials.add(socialsItem);
    return this;
  }

  /**
   * List of all social network account property has for the traveler to get in touch.
   * @return socials
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid SocialAgent> getSocials() {
    return socials;
  }


  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocials(@jakarta.annotation.Nullable List<@Valid SocialAgent> socials) {
    this.socials = socials;
  }

  public BookingAgent review(@jakarta.annotation.Nullable ReviewLightweightAgent review) {
    
    this.review = review;
    return this;
  }

  /**
   * User review created by the traveler after the booking completed.
   * @return review
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REVIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ReviewLightweightAgent getReview() {
    return review;
  }


  @JsonProperty(JSON_PROPERTY_REVIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReview(@jakarta.annotation.Nullable ReviewLightweightAgent review) {
    this.review = review;
  }

  public BookingAgent emailHeaderLogoUrl(@jakarta.annotation.Nonnull String emailHeaderLogoUrl) {
    
    this.emailHeaderLogoUrl = emailHeaderLogoUrl;
    return this;
  }

  /**
   * Full url of the image logo optimized for emails
   * @return emailHeaderLogoUrl
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_EMAIL_HEADER_LOGO_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getEmailHeaderLogoUrl() {
    return emailHeaderLogoUrl;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL_HEADER_LOGO_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEmailHeaderLogoUrl(@jakarta.annotation.Nonnull String emailHeaderLogoUrl) {
    this.emailHeaderLogoUrl = emailHeaderLogoUrl;
  }

  public BookingAgent logoIdentifier(@jakarta.annotation.Nullable String logoIdentifier) {
    
    this.logoIdentifier = logoIdentifier;
    return this;
  }

  /**
   * Logo cloudinary identifier for potential reuse
   * @return logoIdentifier
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOGO_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLogoIdentifier() {
    return logoIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_LOGO_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLogoIdentifier(@jakarta.annotation.Nullable String logoIdentifier) {
    this.logoIdentifier = logoIdentifier;
  }

  public BookingAgent hotel(@jakarta.annotation.Nonnull PropertyAggregateLightweightAgent hotel) {
    
    this.hotel = hotel;
    return this;
  }

  /**
   * Combined property data.
   * @return hotel
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PropertyAggregateLightweightAgent getHotel() {
    return hotel;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotel(@jakarta.annotation.Nonnull PropertyAggregateLightweightAgent hotel) {
    this.hotel = hotel;
  }

  public BookingAgent roomStay(@jakarta.annotation.Nullable RoomStayAgent roomStay) {
    
    this.roomStay = roomStay;
    return this;
  }

  /**
   * All information about the room that was booked.
   * @return roomStay
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_STAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RoomStayAgent getRoomStay() {
    return roomStay;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_STAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomStay(@jakarta.annotation.Nullable RoomStayAgent roomStay) {
    this.roomStay = roomStay;
  }

  public BookingAgent specialRequests(@jakarta.annotation.Nullable String specialRequests) {
    
    this.specialRequests = specialRequests;
    return this;
  }

  /**
   * Free text where the traveler can add a message to the property.
   * @return specialRequests
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SPECIAL_REQUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSpecialRequests() {
    return specialRequests;
  }


  @JsonProperty(JSON_PROPERTY_SPECIAL_REQUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSpecialRequests(@jakarta.annotation.Nullable String specialRequests) {
    this.specialRequests = specialRequests;
  }

  public BookingAgent comment(@jakarta.annotation.Nullable String comment) {
    
    this.comment = comment;
    return this;
  }

  /**
   * Internal comment field the platform can add and make available to channel manager partners.
   * @return comment
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COMMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getComment() {
    return comment;
  }


  @JsonProperty(JSON_PROPERTY_COMMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setComment(@jakarta.annotation.Nullable String comment) {
    this.comment = comment;
  }

  public BookingAgent earlyCheckInCharge(@jakarta.annotation.Nullable CustomMonetaryAmount earlyCheckInCharge) {
    
    this.earlyCheckInCharge = earlyCheckInCharge;
    return this;
  }

  /**
   * Early check-in charge fixed amount that is due if guest checks out early.
   * @return earlyCheckInCharge
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_EARLY_CHECK_IN_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getEarlyCheckInCharge() {
    return earlyCheckInCharge;
  }


  @JsonProperty(JSON_PROPERTY_EARLY_CHECK_IN_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEarlyCheckInCharge(@jakarta.annotation.Nullable CustomMonetaryAmount earlyCheckInCharge) {
    this.earlyCheckInCharge = earlyCheckInCharge;
  }

  public BookingAgent lateCheckOutCharge(@jakarta.annotation.Nullable CustomMonetaryAmount lateCheckOutCharge) {
    
    this.lateCheckOutCharge = lateCheckOutCharge;
    return this;
  }

  /**
   * Late check-out charge fixed amount that is due if guest checks out late.
   * @return lateCheckOutCharge
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LATE_CHECK_OUT_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getLateCheckOutCharge() {
    return lateCheckOutCharge;
  }


  @JsonProperty(JSON_PROPERTY_LATE_CHECK_OUT_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLateCheckOutCharge(@jakarta.annotation.Nullable CustomMonetaryAmount lateCheckOutCharge) {
    this.lateCheckOutCharge = lateCheckOutCharge;
  }

  public BookingAgent earlyCheckInChargePercent(@jakarta.annotation.Nullable Float earlyCheckInChargePercent) {
    
    this.earlyCheckInChargePercent = earlyCheckInChargePercent;
    return this;
  }

  /**
   * Early check-in charge calculated in percent of first room night price.
   * @return earlyCheckInChargePercent
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EARLY_CHECK_IN_CHARGE_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getEarlyCheckInChargePercent() {
    return earlyCheckInChargePercent;
  }


  @JsonProperty(JSON_PROPERTY_EARLY_CHECK_IN_CHARGE_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEarlyCheckInChargePercent(@jakarta.annotation.Nullable Float earlyCheckInChargePercent) {
    this.earlyCheckInChargePercent = earlyCheckInChargePercent;
  }

  public BookingAgent lateCheckOutChargePercent(@jakarta.annotation.Nullable Float lateCheckOutChargePercent) {
    
    this.lateCheckOutChargePercent = lateCheckOutChargePercent;
    return this;
  }

  /**
   * Early check-in charge calculated in percent of first room night price.
   * @return lateCheckOutChargePercent
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LATE_CHECK_OUT_CHARGE_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getLateCheckOutChargePercent() {
    return lateCheckOutChargePercent;
  }


  @JsonProperty(JSON_PROPERTY_LATE_CHECK_OUT_CHARGE_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLateCheckOutChargePercent(@jakarta.annotation.Nullable Float lateCheckOutChargePercent) {
    this.lateCheckOutChargePercent = lateCheckOutChargePercent;
  }

  public BookingAgent hotelImageUrl(@jakarta.annotation.Nonnull String hotelImageUrl) {
    
    this.hotelImageUrl = hotelImageUrl;
    return this;
  }

  /**
   * Absolute URL of hotel image that can be used as-is
   * @return hotelImageUrl
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_HOTEL_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getHotelImageUrl() {
    return hotelImageUrl;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelImageUrl(@jakarta.annotation.Nonnull String hotelImageUrl) {
    this.hotelImageUrl = hotelImageUrl;
  }

  public BookingAgent roomImageUrl(@jakarta.annotation.Nonnull String roomImageUrl) {
    
    this.roomImageUrl = roomImageUrl;
    return this;
  }

  /**
   * Absolute URL of room image that can be used as-is
   * @return roomImageUrl
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ROOM_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomImageUrl() {
    return roomImageUrl;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomImageUrl(@jakarta.annotation.Nonnull String roomImageUrl) {
    this.roomImageUrl = roomImageUrl;
  }

  public BookingAgent commissionList(@jakarta.annotation.Nullable List<@Valid CommissionableEntryAgent> commissionList) {
    
    this.commissionList = commissionList;
    return this;
  }

  public BookingAgent addCommissionListItem(CommissionableEntryAgent commissionListItem) {
    if (this.commissionList == null) {
      this.commissionList = new ArrayList<>();
    }
    this.commissionList.add(commissionListItem);
    return this;
  }

  /**
   * List of all travel inventory entries that are due a commission to the affiliate.
   * @return commissionList
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMMISSION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid CommissionableEntryAgent> getCommissionList() {
    return commissionList;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionList(@jakarta.annotation.Nullable List<@Valid CommissionableEntryAgent> commissionList) {
    this.commissionList = commissionList;
  }

  public BookingAgent ancillaryList(@jakarta.annotation.Nullable List<@Valid BookingAncillaryAgent> ancillaryList) {
    
    this.ancillaryList = ancillaryList;
    return this;
  }

  public BookingAgent addAncillaryListItem(BookingAncillaryAgent ancillaryListItem) {
    if (this.ancillaryList == null) {
      this.ancillaryList = new ArrayList<>();
    }
    this.ancillaryList.add(ancillaryListItem);
    return this;
  }

  /**
   * Get ancillaryList
   * @return ancillaryList
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ANCILLARY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid BookingAncillaryAgent> getAncillaryList() {
    return ancillaryList;
  }


  @JsonProperty(JSON_PROPERTY_ANCILLARY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAncillaryList(@jakarta.annotation.Nullable List<@Valid BookingAncillaryAgent> ancillaryList) {
    this.ancillaryList = ancillaryList;
  }

  public BookingAgent bookingContract(@jakarta.annotation.Nullable BookingContractAgent bookingContract) {
    
    this.bookingContract = bookingContract;
    return this;
  }

  /**
   * Booking contract created by TripPay
   * @return bookingContract
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BOOKING_CONTRACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BookingContractAgent getBookingContract() {
    return bookingContract;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_CONTRACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookingContract(@jakarta.annotation.Nullable BookingContractAgent bookingContract) {
    this.bookingContract = bookingContract;
  }

  public BookingAgent staticMapImageUrl(@jakarta.annotation.Nullable String staticMapImageUrl) {
    
    this.staticMapImageUrl = staticMapImageUrl;
    return this;
  }

  /**
   * Url of map image that can be sent via email
   * @return staticMapImageUrl
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_STATIC_MAP_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStaticMapImageUrl() {
    return staticMapImageUrl;
  }


  @JsonProperty(JSON_PROPERTY_STATIC_MAP_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStaticMapImageUrl(@jakarta.annotation.Nullable String staticMapImageUrl) {
    this.staticMapImageUrl = staticMapImageUrl;
  }

  public BookingAgent staticMapUrl(@jakarta.annotation.Nullable String staticMapUrl) {
    
    this.staticMapUrl = staticMapUrl;
    return this;
  }

  /**
   * Url of map image location on Google Maps
   * @return staticMapUrl
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_STATIC_MAP_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStaticMapUrl() {
    return staticMapUrl;
  }


  @JsonProperty(JSON_PROPERTY_STATIC_MAP_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStaticMapUrl(@jakarta.annotation.Nullable String staticMapUrl) {
    this.staticMapUrl = staticMapUrl;
  }

  public BookingAgent status(@jakarta.annotation.Nullable StatusEnum status) {
    
    this.status = status;
    return this;
  }

  /**
   * Convenience data point to show which status the booking currently has.
   * @return status
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(@jakarta.annotation.Nullable StatusEnum status) {
    this.status = status;
  }

  public BookingAgent meetingRooms(@jakarta.annotation.Nullable List<@Valid BookingAncillaryAgent> meetingRooms) {
    
    this.meetingRooms = meetingRooms;
    return this;
  }

  public BookingAgent addMeetingRoomsItem(BookingAncillaryAgent meetingRoomsItem) {
    if (this.meetingRooms == null) {
      this.meetingRooms = new ArrayList<>();
    }
    this.meetingRooms.add(meetingRoomsItem);
    return this;
  }

  /**
   * Meeting room reservation records.
   * @return meetingRooms
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid BookingAncillaryAgent> getMeetingRooms() {
    return meetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeetingRooms(@jakarta.annotation.Nullable List<@Valid BookingAncillaryAgent> meetingRooms) {
    this.meetingRooms = meetingRooms;
  }

  public BookingAgent restaurants(@jakarta.annotation.Nullable List<@Valid BookingAncillaryAgent> restaurants) {
    
    this.restaurants = restaurants;
    return this;
  }

  public BookingAgent addRestaurantsItem(BookingAncillaryAgent restaurantsItem) {
    if (this.restaurants == null) {
      this.restaurants = new ArrayList<>();
    }
    this.restaurants.add(restaurantsItem);
    return this;
  }

  /**
   * Restaurant reservation records.
   * @return restaurants
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid BookingAncillaryAgent> getRestaurants() {
    return restaurants;
  }


  @JsonProperty(JSON_PROPERTY_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRestaurants(@jakarta.annotation.Nullable List<@Valid BookingAncillaryAgent> restaurants) {
    this.restaurants = restaurants;
  }

  public BookingAgent spas(@jakarta.annotation.Nullable List<@Valid BookingAncillaryAgent> spas) {
    
    this.spas = spas;
    return this;
  }

  public BookingAgent addSpasItem(BookingAncillaryAgent spasItem) {
    if (this.spas == null) {
      this.spas = new ArrayList<>();
    }
    this.spas.add(spasItem);
    return this;
  }

  /**
   * Spa reservation records.
   * @return spas
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid BookingAncillaryAgent> getSpas() {
    return spas;
  }


  @JsonProperty(JSON_PROPERTY_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSpas(@jakarta.annotation.Nullable List<@Valid BookingAncillaryAgent> spas) {
    this.spas = spas;
  }

  public BookingAgent activities(@jakarta.annotation.Nullable List<@Valid BookingAncillaryAgent> activities) {
    
    this.activities = activities;
    return this;
  }

  public BookingAgent addActivitiesItem(BookingAncillaryAgent activitiesItem) {
    if (this.activities == null) {
      this.activities = new ArrayList<>();
    }
    this.activities.add(activitiesItem);
    return this;
  }

  /**
   * Activity reservation records.
   * @return activities
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid BookingAncillaryAgent> getActivities() {
    return activities;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActivities(@jakarta.annotation.Nullable List<@Valid BookingAncillaryAgent> activities) {
    this.activities = activities;
  }

  public BookingAgent attractions(@jakarta.annotation.Nullable List<@Valid BookingAncillaryAgent> attractions) {
    
    this.attractions = attractions;
    return this;
  }

  public BookingAgent addAttractionsItem(BookingAncillaryAgent attractionsItem) {
    if (this.attractions == null) {
      this.attractions = new ArrayList<>();
    }
    this.attractions.add(attractionsItem);
    return this;
  }

  /**
   * Attraction reservation records.
   * @return attractions
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid BookingAncillaryAgent> getAttractions() {
    return attractions;
  }


  @JsonProperty(JSON_PROPERTY_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttractions(@jakarta.annotation.Nullable List<@Valid BookingAncillaryAgent> attractions) {
    this.attractions = attractions;
  }

  public BookingAgent places(@jakarta.annotation.Nullable List<@Valid BookingAncillaryAgent> places) {
    
    this.places = places;
    return this;
  }

  public BookingAgent addPlacesItem(BookingAncillaryAgent placesItem) {
    if (this.places == null) {
      this.places = new ArrayList<>();
    }
    this.places.add(placesItem);
    return this;
  }

  /**
   * Place reservation records.
   * @return places
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid BookingAncillaryAgent> getPlaces() {
    return places;
  }


  @JsonProperty(JSON_PROPERTY_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlaces(@jakarta.annotation.Nullable List<@Valid BookingAncillaryAgent> places) {
    this.places = places;
  }

  public BookingAgent roomTypeAncillaries(@jakarta.annotation.Nullable List<@Valid BookingAncillaryAgent> roomTypeAncillaries) {
    
    this.roomTypeAncillaries = roomTypeAncillaries;
    return this;
  }

  public BookingAgent addRoomTypeAncillariesItem(BookingAncillaryAgent roomTypeAncillariesItem) {
    if (this.roomTypeAncillaries == null) {
      this.roomTypeAncillaries = new ArrayList<>();
    }
    this.roomTypeAncillaries.add(roomTypeAncillariesItem);
    return this;
  }

  /**
   * Room type ancillary records.
   * @return roomTypeAncillaries
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid BookingAncillaryAgent> getRoomTypeAncillaries() {
    return roomTypeAncillaries;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomTypeAncillaries(@jakarta.annotation.Nullable List<@Valid BookingAncillaryAgent> roomTypeAncillaries) {
    this.roomTypeAncillaries = roomTypeAncillaries;
  }

  public BookingAgent addOns(@jakarta.annotation.Nullable List<@Valid BookingAncillaryAgent> addOns) {
    
    this.addOns = addOns;
    return this;
  }

  public BookingAgent addAddOnsItem(BookingAncillaryAgent addOnsItem) {
    if (this.addOns == null) {
      this.addOns = new ArrayList<>();
    }
    this.addOns.add(addOnsItem);
    return this;
  }

  /**
   * Add-on records.
   * @return addOns
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid BookingAncillaryAgent> getAddOns() {
    return addOns;
  }


  @JsonProperty(JSON_PROPERTY_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddOns(@jakarta.annotation.Nullable List<@Valid BookingAncillaryAgent> addOns) {
    this.addOns = addOns;
  }

  public BookingAgent rateSource(@jakarta.annotation.Nullable String rateSource) {
    
    this.rateSource = rateSource;
    return this;
  }

  /**
   * Rate origin. This is usually the property channel manager.
   * @return rateSource
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRateSource() {
    return rateSource;
  }


  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateSource(@jakarta.annotation.Nullable String rateSource) {
    this.rateSource = rateSource;
  }

  public BookingAgent hasAddOns(@jakarta.annotation.Nullable Boolean hasAddOns) {
    
    this.hasAddOns = hasAddOns;
    return this;
  }

  /**
   * Convenience data point to check if any add-on offers are in this booking.
   * @return hasAddOns
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasAddOns() {
    return hasAddOns;
  }


  @JsonProperty(JSON_PROPERTY_HAS_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasAddOns(@jakarta.annotation.Nullable Boolean hasAddOns) {
    this.hasAddOns = hasAddOns;
  }

  public BookingAgent cancellableByAgent(@jakarta.annotation.Nullable Boolean cancellableByAgent) {
    
    this.cancellableByAgent = cancellableByAgent;
    return this;
  }

  /**
   * Whether the booking can still be cancelled completely by the agent.
   * @return cancellableByAgent
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_AGENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableByAgent() {
    return cancellableByAgent;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_AGENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableByAgent(@jakarta.annotation.Nullable Boolean cancellableByAgent) {
    this.cancellableByAgent = cancellableByAgent;
  }

  public BookingAgent cancellableBySupplier(@jakarta.annotation.Nullable Boolean cancellableBySupplier) {
    
    this.cancellableBySupplier = cancellableBySupplier;
    return this;
  }

  /**
   * Whether the booking can still be cancelled completely by the supplier.
   * @return cancellableBySupplier
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableBySupplier() {
    return cancellableBySupplier;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableBySupplier(@jakarta.annotation.Nullable Boolean cancellableBySupplier) {
    this.cancellableBySupplier = cancellableBySupplier;
  }

  public BookingAgent cancellableByTraveler(@jakarta.annotation.Nullable Boolean cancellableByTraveler) {
    
    this.cancellableByTraveler = cancellableByTraveler;
    return this;
  }

  /**
   * Whether the booking can still be cancelled completely by the traveller.
   * @return cancellableByTraveler
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableByTraveler() {
    return cancellableByTraveler;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableByTraveler(@jakarta.annotation.Nullable Boolean cancellableByTraveler) {
    this.cancellableByTraveler = cancellableByTraveler;
  }

  public BookingAgent reportingExtraChargeList(@jakarta.annotation.Nullable List<Object> reportingExtraChargeList) {
    
    this.reportingExtraChargeList = reportingExtraChargeList;
    return this;
  }

  public BookingAgent addReportingExtraChargeListItem(Object reportingExtraChargeListItem) {
    if (this.reportingExtraChargeList == null) {
      this.reportingExtraChargeList = new ArrayList<>();
    }
    this.reportingExtraChargeList.add(reportingExtraChargeListItem);
    return this;
  }

  /**
   * Get reportingExtraChargeList
   * @return reportingExtraChargeList
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REPORTING_EXTRA_CHARGE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getReportingExtraChargeList() {
    return reportingExtraChargeList;
  }


  @JsonProperty(JSON_PROPERTY_REPORTING_EXTRA_CHARGE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReportingExtraChargeList(@jakarta.annotation.Nullable List<Object> reportingExtraChargeList) {
    this.reportingExtraChargeList = reportingExtraChargeList;
  }

  public BookingAgent hasBreakfast(@jakarta.annotation.Nullable Boolean hasBreakfast) {
    
    this.hasBreakfast = hasBreakfast;
    return this;
  }

  /**
   * Convenience data point to get to breakfast quickly.
   * @return hasBreakfast
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_BREAKFAST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasBreakfast() {
    return hasBreakfast;
  }


  @JsonProperty(JSON_PROPERTY_HAS_BREAKFAST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasBreakfast(@jakarta.annotation.Nullable Boolean hasBreakfast) {
    this.hasBreakfast = hasBreakfast;
  }

  public BookingAgent hasBrunch(@jakarta.annotation.Nullable Boolean hasBrunch) {
    
    this.hasBrunch = hasBrunch;
    return this;
  }

  /**
   * Convenience data point to get to brunch quickly.
   * @return hasBrunch
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_BRUNCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasBrunch() {
    return hasBrunch;
  }


  @JsonProperty(JSON_PROPERTY_HAS_BRUNCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasBrunch(@jakarta.annotation.Nullable Boolean hasBrunch) {
    this.hasBrunch = hasBrunch;
  }

  public BookingAgent hasLunch(@jakarta.annotation.Nullable Boolean hasLunch) {
    
    this.hasLunch = hasLunch;
    return this;
  }

  /**
   * Convenience data point to get to lunch quickly.
   * @return hasLunch
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_LUNCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasLunch() {
    return hasLunch;
  }


  @JsonProperty(JSON_PROPERTY_HAS_LUNCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasLunch(@jakarta.annotation.Nullable Boolean hasLunch) {
    this.hasLunch = hasLunch;
  }

  public BookingAgent hasDinner(@jakarta.annotation.Nullable Boolean hasDinner) {
    
    this.hasDinner = hasDinner;
    return this;
  }

  /**
   * Convenience data point to get to dinner quickly.
   * @return hasDinner
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_DINNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasDinner() {
    return hasDinner;
  }


  @JsonProperty(JSON_PROPERTY_HAS_DINNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasDinner(@jakarta.annotation.Nullable Boolean hasDinner) {
    this.hasDinner = hasDinner;
  }

  public BookingAgent hasAllInclusive(@jakarta.annotation.Nullable Boolean hasAllInclusive) {
    
    this.hasAllInclusive = hasAllInclusive;
    return this;
  }

  /**
   * Convenience data point to get to all-inclusive quickly.
   * @return hasAllInclusive
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_ALL_INCLUSIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasAllInclusive() {
    return hasAllInclusive;
  }


  @JsonProperty(JSON_PROPERTY_HAS_ALL_INCLUSIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasAllInclusive(@jakarta.annotation.Nullable Boolean hasAllInclusive) {
    this.hasAllInclusive = hasAllInclusive;
  }

  public BookingAgent hasAllInclusivePlusAlcohol(@jakarta.annotation.Nullable Boolean hasAllInclusivePlusAlcohol) {
    
    this.hasAllInclusivePlusAlcohol = hasAllInclusivePlusAlcohol;
    return this;
  }

  /**
   * Convenience data point to get to all-inclusive with alcohol quickly.
   * @return hasAllInclusivePlusAlcohol
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_ALL_INCLUSIVE_PLUS_ALCOHOL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasAllInclusivePlusAlcohol() {
    return hasAllInclusivePlusAlcohol;
  }


  @JsonProperty(JSON_PROPERTY_HAS_ALL_INCLUSIVE_PLUS_ALCOHOL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasAllInclusivePlusAlcohol(@jakarta.annotation.Nullable Boolean hasAllInclusivePlusAlcohol) {
    this.hasAllInclusivePlusAlcohol = hasAllInclusivePlusAlcohol;
  }

  public BookingAgent hasRoomTypeAncillaries(@jakarta.annotation.Nullable Boolean hasRoomTypeAncillaries) {
    
    this.hasRoomTypeAncillaries = hasRoomTypeAncillaries;
    return this;
  }

  /**
   * Convenience data point to check if any room type ancillaries are in this booking.
   * @return hasRoomTypeAncillaries
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasRoomTypeAncillaries() {
    return hasRoomTypeAncillaries;
  }


  @JsonProperty(JSON_PROPERTY_HAS_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasRoomTypeAncillaries(@jakarta.annotation.Nullable Boolean hasRoomTypeAncillaries) {
    this.hasRoomTypeAncillaries = hasRoomTypeAncillaries;
  }

  public BookingAgent hasFood(@jakarta.annotation.Nullable Boolean hasFood) {
    
    this.hasFood = hasFood;
    return this;
  }

  /**
   * Convenience data point to check if any food is included in this booking.
   * @return hasFood
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_FOOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasFood() {
    return hasFood;
  }


  @JsonProperty(JSON_PROPERTY_HAS_FOOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasFood(@jakarta.annotation.Nullable Boolean hasFood) {
    this.hasFood = hasFood;
  }

  public BookingAgent hasRestaurants(@jakarta.annotation.Nullable Boolean hasRestaurants) {
    
    this.hasRestaurants = hasRestaurants;
    return this;
  }

  /**
   * Convenience data point to check if any restaurant reservations are included in this booking.
   * @return hasRestaurants
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasRestaurants() {
    return hasRestaurants;
  }


  @JsonProperty(JSON_PROPERTY_HAS_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasRestaurants(@jakarta.annotation.Nullable Boolean hasRestaurants) {
    this.hasRestaurants = hasRestaurants;
  }

  public BookingAgent hasMeetingRooms(@jakarta.annotation.Nullable Boolean hasMeetingRooms) {
    
    this.hasMeetingRooms = hasMeetingRooms;
    return this;
  }

  /**
   * Convenience data point to check if any meeting room reservations are included in this booking.
   * @return hasMeetingRooms
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasMeetingRooms() {
    return hasMeetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_HAS_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasMeetingRooms(@jakarta.annotation.Nullable Boolean hasMeetingRooms) {
    this.hasMeetingRooms = hasMeetingRooms;
  }

  public BookingAgent hasSpas(@jakarta.annotation.Nullable Boolean hasSpas) {
    
    this.hasSpas = hasSpas;
    return this;
  }

  /**
   * Convenience data point to check if any spa reservations are included in this booking.
   * @return hasSpas
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasSpas() {
    return hasSpas;
  }


  @JsonProperty(JSON_PROPERTY_HAS_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasSpas(@jakarta.annotation.Nullable Boolean hasSpas) {
    this.hasSpas = hasSpas;
  }

  public BookingAgent hasActivities(@jakarta.annotation.Nullable Boolean hasActivities) {
    
    this.hasActivities = hasActivities;
    return this;
  }

  /**
   * Convenience data point to check if any activity reservations are included in this booking.
   * @return hasActivities
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasActivities() {
    return hasActivities;
  }


  @JsonProperty(JSON_PROPERTY_HAS_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasActivities(@jakarta.annotation.Nullable Boolean hasActivities) {
    this.hasActivities = hasActivities;
  }

  public BookingAgent hasAttractions(@jakarta.annotation.Nullable Boolean hasAttractions) {
    
    this.hasAttractions = hasAttractions;
    return this;
  }

  /**
   * Convenience data point to check if any attractions reservations are included in this booking.
   * @return hasAttractions
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasAttractions() {
    return hasAttractions;
  }


  @JsonProperty(JSON_PROPERTY_HAS_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasAttractions(@jakarta.annotation.Nullable Boolean hasAttractions) {
    this.hasAttractions = hasAttractions;
  }

  public BookingAgent hasPlaces(@jakarta.annotation.Nullable Boolean hasPlaces) {
    
    this.hasPlaces = hasPlaces;
    return this;
  }

  /**
   * Convenience data point to check if any place reservations are included in this booking.
   * @return hasPlaces
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasPlaces() {
    return hasPlaces;
  }


  @JsonProperty(JSON_PROPERTY_HAS_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasPlaces(@jakarta.annotation.Nullable Boolean hasPlaces) {
    this.hasPlaces = hasPlaces;
  }

  public BookingAgent reportingDailyRateList(@jakarta.annotation.Nullable List<Object> reportingDailyRateList) {
    
    this.reportingDailyRateList = reportingDailyRateList;
    return this;
  }

  public BookingAgent addReportingDailyRateListItem(Object reportingDailyRateListItem) {
    if (this.reportingDailyRateList == null) {
      this.reportingDailyRateList = new ArrayList<>();
    }
    this.reportingDailyRateList.add(reportingDailyRateListItem);
    return this;
  }

  /**
   * Get reportingDailyRateList
   * @return reportingDailyRateList
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REPORTING_DAILY_RATE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getReportingDailyRateList() {
    return reportingDailyRateList;
  }


  @JsonProperty(JSON_PROPERTY_REPORTING_DAILY_RATE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReportingDailyRateList(@jakarta.annotation.Nullable List<Object> reportingDailyRateList) {
    this.reportingDailyRateList = reportingDailyRateList;
  }

  public BookingAgent reportingAncillaryList(@jakarta.annotation.Nullable List<Object> reportingAncillaryList) {
    
    this.reportingAncillaryList = reportingAncillaryList;
    return this;
  }

  public BookingAgent addReportingAncillaryListItem(Object reportingAncillaryListItem) {
    if (this.reportingAncillaryList == null) {
      this.reportingAncillaryList = new ArrayList<>();
    }
    this.reportingAncillaryList.add(reportingAncillaryListItem);
    return this;
  }

  /**
   * Get reportingAncillaryList
   * @return reportingAncillaryList
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REPORTING_ANCILLARY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getReportingAncillaryList() {
    return reportingAncillaryList;
  }


  @JsonProperty(JSON_PROPERTY_REPORTING_ANCILLARY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReportingAncillaryList(@jakarta.annotation.Nullable List<Object> reportingAncillaryList) {
    this.reportingAncillaryList = reportingAncillaryList;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingAgent bookingAgent = (BookingAgent) o;
    return Objects.equals(this.id, bookingAgent.id) &&
        Objects.equals(this.createdDate, bookingAgent.createdDate) &&
        Objects.equals(this.lastUpdate, bookingAgent.lastUpdate) &&
        Objects.equals(this.version, bookingAgent.version) &&
        Objects.equals(this.creation, bookingAgent.creation) &&
        Objects.equals(this.groupIdentifier, bookingAgent.groupIdentifier) &&
        Objects.equals(this.customization, bookingAgent.customization) &&
        Objects.equals(this.bookingCode, bookingAgent.bookingCode) &&
        Objects.equals(this.user, bookingAgent.user) &&
        Objects.equals(this.userSession, bookingAgent.userSession) &&
        Objects.equals(this.serverUrl, bookingAgent.serverUrl) &&
        Objects.equals(this.socials, bookingAgent.socials) &&
        Objects.equals(this.review, bookingAgent.review) &&
        Objects.equals(this.emailHeaderLogoUrl, bookingAgent.emailHeaderLogoUrl) &&
        Objects.equals(this.logoIdentifier, bookingAgent.logoIdentifier) &&
        Objects.equals(this.hotel, bookingAgent.hotel) &&
        Objects.equals(this.roomStay, bookingAgent.roomStay) &&
        Objects.equals(this.specialRequests, bookingAgent.specialRequests) &&
        Objects.equals(this.comment, bookingAgent.comment) &&
        Objects.equals(this.earlyCheckInCharge, bookingAgent.earlyCheckInCharge) &&
        Objects.equals(this.lateCheckOutCharge, bookingAgent.lateCheckOutCharge) &&
        Objects.equals(this.earlyCheckInChargePercent, bookingAgent.earlyCheckInChargePercent) &&
        Objects.equals(this.lateCheckOutChargePercent, bookingAgent.lateCheckOutChargePercent) &&
        Objects.equals(this.hotelImageUrl, bookingAgent.hotelImageUrl) &&
        Objects.equals(this.roomImageUrl, bookingAgent.roomImageUrl) &&
        Objects.equals(this.commissionList, bookingAgent.commissionList) &&
        Objects.equals(this.ancillaryList, bookingAgent.ancillaryList) &&
        Objects.equals(this.bookingContract, bookingAgent.bookingContract) &&
        Objects.equals(this.staticMapImageUrl, bookingAgent.staticMapImageUrl) &&
        Objects.equals(this.staticMapUrl, bookingAgent.staticMapUrl) &&
        Objects.equals(this.status, bookingAgent.status) &&
        Objects.equals(this.meetingRooms, bookingAgent.meetingRooms) &&
        Objects.equals(this.restaurants, bookingAgent.restaurants) &&
        Objects.equals(this.spas, bookingAgent.spas) &&
        Objects.equals(this.activities, bookingAgent.activities) &&
        Objects.equals(this.attractions, bookingAgent.attractions) &&
        Objects.equals(this.places, bookingAgent.places) &&
        Objects.equals(this.roomTypeAncillaries, bookingAgent.roomTypeAncillaries) &&
        Objects.equals(this.addOns, bookingAgent.addOns) &&
        Objects.equals(this.rateSource, bookingAgent.rateSource) &&
        Objects.equals(this.hasAddOns, bookingAgent.hasAddOns) &&
        Objects.equals(this.cancellableByAgent, bookingAgent.cancellableByAgent) &&
        Objects.equals(this.cancellableBySupplier, bookingAgent.cancellableBySupplier) &&
        Objects.equals(this.cancellableByTraveler, bookingAgent.cancellableByTraveler) &&
        Objects.equals(this.reportingExtraChargeList, bookingAgent.reportingExtraChargeList) &&
        Objects.equals(this.hasBreakfast, bookingAgent.hasBreakfast) &&
        Objects.equals(this.hasBrunch, bookingAgent.hasBrunch) &&
        Objects.equals(this.hasLunch, bookingAgent.hasLunch) &&
        Objects.equals(this.hasDinner, bookingAgent.hasDinner) &&
        Objects.equals(this.hasAllInclusive, bookingAgent.hasAllInclusive) &&
        Objects.equals(this.hasAllInclusivePlusAlcohol, bookingAgent.hasAllInclusivePlusAlcohol) &&
        Objects.equals(this.hasRoomTypeAncillaries, bookingAgent.hasRoomTypeAncillaries) &&
        Objects.equals(this.hasFood, bookingAgent.hasFood) &&
        Objects.equals(this.hasRestaurants, bookingAgent.hasRestaurants) &&
        Objects.equals(this.hasMeetingRooms, bookingAgent.hasMeetingRooms) &&
        Objects.equals(this.hasSpas, bookingAgent.hasSpas) &&
        Objects.equals(this.hasActivities, bookingAgent.hasActivities) &&
        Objects.equals(this.hasAttractions, bookingAgent.hasAttractions) &&
        Objects.equals(this.hasPlaces, bookingAgent.hasPlaces) &&
        Objects.equals(this.reportingDailyRateList, bookingAgent.reportingDailyRateList) &&
        Objects.equals(this.reportingAncillaryList, bookingAgent.reportingAncillaryList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdDate, lastUpdate, version, creation, groupIdentifier, customization, bookingCode, user, userSession, serverUrl, socials, review, emailHeaderLogoUrl, logoIdentifier, hotel, roomStay, specialRequests, comment, earlyCheckInCharge, lateCheckOutCharge, earlyCheckInChargePercent, lateCheckOutChargePercent, hotelImageUrl, roomImageUrl, commissionList, ancillaryList, bookingContract, staticMapImageUrl, staticMapUrl, status, meetingRooms, restaurants, spas, activities, attractions, places, roomTypeAncillaries, addOns, rateSource, hasAddOns, cancellableByAgent, cancellableBySupplier, cancellableByTraveler, reportingExtraChargeList, hasBreakfast, hasBrunch, hasLunch, hasDinner, hasAllInclusive, hasAllInclusivePlusAlcohol, hasRoomTypeAncillaries, hasFood, hasRestaurants, hasMeetingRooms, hasSpas, hasActivities, hasAttractions, hasPlaces, reportingDailyRateList, reportingAncillaryList);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingAgent {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    lastUpdate: ").append(toIndentedString(lastUpdate)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    creation: ").append(toIndentedString(creation)).append("\n");
    sb.append("    groupIdentifier: ").append(toIndentedString(groupIdentifier)).append("\n");
    sb.append("    customization: ").append(toIndentedString(customization)).append("\n");
    sb.append("    bookingCode: ").append(toIndentedString(bookingCode)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    userSession: ").append(toIndentedString(userSession)).append("\n");
    sb.append("    serverUrl: ").append(toIndentedString(serverUrl)).append("\n");
    sb.append("    socials: ").append(toIndentedString(socials)).append("\n");
    sb.append("    review: ").append(toIndentedString(review)).append("\n");
    sb.append("    emailHeaderLogoUrl: ").append(toIndentedString(emailHeaderLogoUrl)).append("\n");
    sb.append("    logoIdentifier: ").append(toIndentedString(logoIdentifier)).append("\n");
    sb.append("    hotel: ").append(toIndentedString(hotel)).append("\n");
    sb.append("    roomStay: ").append(toIndentedString(roomStay)).append("\n");
    sb.append("    specialRequests: ").append(toIndentedString(specialRequests)).append("\n");
    sb.append("    comment: ").append(toIndentedString(comment)).append("\n");
    sb.append("    earlyCheckInCharge: ").append(toIndentedString(earlyCheckInCharge)).append("\n");
    sb.append("    lateCheckOutCharge: ").append(toIndentedString(lateCheckOutCharge)).append("\n");
    sb.append("    earlyCheckInChargePercent: ").append(toIndentedString(earlyCheckInChargePercent)).append("\n");
    sb.append("    lateCheckOutChargePercent: ").append(toIndentedString(lateCheckOutChargePercent)).append("\n");
    sb.append("    hotelImageUrl: ").append(toIndentedString(hotelImageUrl)).append("\n");
    sb.append("    roomImageUrl: ").append(toIndentedString(roomImageUrl)).append("\n");
    sb.append("    commissionList: ").append(toIndentedString(commissionList)).append("\n");
    sb.append("    ancillaryList: ").append(toIndentedString(ancillaryList)).append("\n");
    sb.append("    bookingContract: ").append(toIndentedString(bookingContract)).append("\n");
    sb.append("    staticMapImageUrl: ").append(toIndentedString(staticMapImageUrl)).append("\n");
    sb.append("    staticMapUrl: ").append(toIndentedString(staticMapUrl)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    meetingRooms: ").append(toIndentedString(meetingRooms)).append("\n");
    sb.append("    restaurants: ").append(toIndentedString(restaurants)).append("\n");
    sb.append("    spas: ").append(toIndentedString(spas)).append("\n");
    sb.append("    activities: ").append(toIndentedString(activities)).append("\n");
    sb.append("    attractions: ").append(toIndentedString(attractions)).append("\n");
    sb.append("    places: ").append(toIndentedString(places)).append("\n");
    sb.append("    roomTypeAncillaries: ").append(toIndentedString(roomTypeAncillaries)).append("\n");
    sb.append("    addOns: ").append(toIndentedString(addOns)).append("\n");
    sb.append("    rateSource: ").append(toIndentedString(rateSource)).append("\n");
    sb.append("    hasAddOns: ").append(toIndentedString(hasAddOns)).append("\n");
    sb.append("    cancellableByAgent: ").append(toIndentedString(cancellableByAgent)).append("\n");
    sb.append("    cancellableBySupplier: ").append(toIndentedString(cancellableBySupplier)).append("\n");
    sb.append("    cancellableByTraveler: ").append(toIndentedString(cancellableByTraveler)).append("\n");
    sb.append("    reportingExtraChargeList: ").append(toIndentedString(reportingExtraChargeList)).append("\n");
    sb.append("    hasBreakfast: ").append(toIndentedString(hasBreakfast)).append("\n");
    sb.append("    hasBrunch: ").append(toIndentedString(hasBrunch)).append("\n");
    sb.append("    hasLunch: ").append(toIndentedString(hasLunch)).append("\n");
    sb.append("    hasDinner: ").append(toIndentedString(hasDinner)).append("\n");
    sb.append("    hasAllInclusive: ").append(toIndentedString(hasAllInclusive)).append("\n");
    sb.append("    hasAllInclusivePlusAlcohol: ").append(toIndentedString(hasAllInclusivePlusAlcohol)).append("\n");
    sb.append("    hasRoomTypeAncillaries: ").append(toIndentedString(hasRoomTypeAncillaries)).append("\n");
    sb.append("    hasFood: ").append(toIndentedString(hasFood)).append("\n");
    sb.append("    hasRestaurants: ").append(toIndentedString(hasRestaurants)).append("\n");
    sb.append("    hasMeetingRooms: ").append(toIndentedString(hasMeetingRooms)).append("\n");
    sb.append("    hasSpas: ").append(toIndentedString(hasSpas)).append("\n");
    sb.append("    hasActivities: ").append(toIndentedString(hasActivities)).append("\n");
    sb.append("    hasAttractions: ").append(toIndentedString(hasAttractions)).append("\n");
    sb.append("    hasPlaces: ").append(toIndentedString(hasPlaces)).append("\n");
    sb.append("    reportingDailyRateList: ").append(toIndentedString(reportingDailyRateList)).append("\n");
    sb.append("    reportingAncillaryList: ").append(toIndentedString(reportingAncillaryList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

