/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/customization-client): A single endpoint to retrieve whitelabel + customization information for the booking customization.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Travel Agent API The Travel Agent API exposes endpoints to manage agent-facilitated bookings. This API lets you:  1. Travel Agent: Manage agent entity. 2. Booking: Create / Manage bookings  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.travel.agent.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import travel.wink.sdk.travel.agent.model.AuthenticatedUserAgent;
import travel.wink.sdk.travel.agent.model.BeneficiaryAgent;
import travel.wink.sdk.travel.agent.model.BookingContractItemAgent;
import travel.wink.sdk.travel.agent.model.BookingContractPaymentDetailsAgent;
import travel.wink.sdk.travel.agent.model.CustomMonetaryAmount;
import travel.wink.sdk.travel.agent.model.PayoutAgent;
import travel.wink.sdk.travel.agent.model.QuoteLightweightAgent;
import travel.wink.sdk.travel.agent.model.RefundAgent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * BookingContractAgent
 */
@JsonPropertyOrder({
  BookingContractAgent.JSON_PROPERTY_BOOKING_CONTRACT_IDENTIFIER,
  BookingContractAgent.JSON_PROPERTY_CREATED_DATE,
  BookingContractAgent.JSON_PROPERTY_LAST_UPDATE,
  BookingContractAgent.JSON_PROPERTY_FEDERATED_ORGANIZATION_IDENTIFIER,
  BookingContractAgent.JSON_PROPERTY_FEDERATED_ORGANIZATION_NAME,
  BookingContractAgent.JSON_PROPERTY_USER,
  BookingContractAgent.JSON_PROPERTY_IP_ADDRESS,
  BookingContractAgent.JSON_PROPERTY_TRACE_ID,
  BookingContractAgent.JSON_PROPERTY_SOURCE_URL,
  BookingContractAgent.JSON_PROPERTY_IDENTIFIER,
  BookingContractAgent.JSON_PROPERTY_SUPPLIER_IDENTIFIER,
  BookingContractAgent.JSON_PROPERTY_SUPPLIER_NAME,
  BookingContractAgent.JSON_PROPERTY_DISPLAY_PRICE_QUOTE,
  BookingContractAgent.JSON_PROPERTY_SUPPLIER_PRICE_QUOTE,
  BookingContractAgent.JSON_PROPERTY_INTERNAL_PRICE_QUOTE,
  BookingContractAgent.JSON_PROPERTY_CAPTURE_PRICE_QUOTE,
  BookingContractAgent.JSON_PROPERTY_ITEM_LIST,
  BookingContractAgent.JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER,
  BookingContractAgent.JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE,
  BookingContractAgent.JSON_PROPERTY_PAYMENT,
  BookingContractAgent.JSON_PROPERTY_CANCELLED,
  BookingContractAgent.JSON_PROPERTY_CANCELLED_ON,
  BookingContractAgent.JSON_PROPERTY_CANCELLER,
  BookingContractAgent.JSON_PROPERTY_CANCELLATION_TYPE,
  BookingContractAgent.JSON_PROPERTY_CANCELLER_USER_IDENTIFIER,
  BookingContractAgent.JSON_PROPERTY_CANCEL_REASON,
  BookingContractAgent.JSON_PROPERTY_FUNDS_PROCESSED,
  BookingContractAgent.JSON_PROPERTY_REFUNDS,
  BookingContractAgent.JSON_PROPERTY_PAYOUTS,
  BookingContractAgent.JSON_PROPERTY_SOURCE_CURRENCY,
  BookingContractAgent.JSON_PROPERTY_DISPLAY_CURRENCY,
  BookingContractAgent.JSON_PROPERTY_SUPPLIER_CURRENCY,
  BookingContractAgent.JSON_PROPERTY_INTERNAL_CURRENCY,
  BookingContractAgent.JSON_PROPERTY_CAPTURE_CURRENCY,
  BookingContractAgent.JSON_PROPERTY_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER,
  BookingContractAgent.JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER,
  BookingContractAgent.JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER,
  BookingContractAgent.JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER,
  BookingContractAgent.JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER,
  BookingContractAgent.JSON_PROPERTY_NET_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_METADATA,
  BookingContractAgent.JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_FEES_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_FEES_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_FEES_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_FEES_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_FEES_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_SALES_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_SALES_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_SALES_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_SALES_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_SALES_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FEES_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FEES_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FEES_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FEES_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FEES_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_SALES_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_SALES_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_SALES_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_SALES_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_SALES_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_FUNDS_AVAILABLE_DATE,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FEES_IN_PERCENT_WITH_REFUND,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FEES_IN_PERCENT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT_WITH_REFUND,
  BookingContractAgent.JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT_WITH_REFUND,
  BookingContractAgent.JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT_WITH_REFUND,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT,
  BookingContractAgent.JSON_PROPERTY_ORIGINAL_FEES_IN_PERCENT,
  BookingContractAgent.JSON_PROPERTY_ORIGINAL_AFFILIATE_AGENCY_FEES_IN_PERCENT,
  BookingContractAgent.JSON_PROPERTY_ORIGINAL_SUPPLIER_AGENCY_FEES_IN_PERCENT,
  BookingContractAgent.JSON_PROPERTY_ORIGINAL_COMMISSIONS_IN_PERCENT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_CUSTOMERS_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_CUSTOMERS_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_CUSTOMERS_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_CUSTOMERS_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_CUSTOMERS_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_SOURCE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_CAPTURE_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_DISPLAY_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_SUPPLIER_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_INTERNAL_AMOUNT,
  BookingContractAgent.JSON_PROPERTY_HAS_REFUNDS,
  BookingContractAgent.JSON_PROPERTY_HAS_SUCCESSFUL_REFUNDS,
  BookingContractAgent.JSON_PROPERTY_HAS_PENDING_REFUNDS,
  BookingContractAgent.JSON_PROPERTY_HAS_FAILED_REFUNDS,
  BookingContractAgent.JSON_PROPERTY_PLATFORM_IDENTIFIER,
  BookingContractAgent.JSON_PROPERTY_TOTAL_FUNDS_GROUPED_BY_BENEFICIARY,
  BookingContractAgent.JSON_PROPERTY_TOTAL_TOKENS_EARNED,
  BookingContractAgent.JSON_PROPERTY_SELF_ACQUIRING,
  BookingContractAgent.JSON_PROPERTY_LODGING,
  BookingContractAgent.JSON_PROPERTY_CANCELLABLE_BY_AGENT,
  BookingContractAgent.JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER,
  BookingContractAgent.JSON_PROPERTY_CANCELLABLE_BY_TRAVELER,
  BookingContractAgent.JSON_PROPERTY_FULLY_REFUNDED,
  BookingContractAgent.JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES,
  BookingContractAgent.JSON_PROPERTY_IS_CANCELLABLE_WITH_POTENTIAL_CHARGES
})
@JsonTypeName("BookingContract_Agent")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:21:53.341573209+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class BookingContractAgent {
  public static final String JSON_PROPERTY_BOOKING_CONTRACT_IDENTIFIER = "bookingContractIdentifier";
  @jakarta.annotation.Nullable
  private UUID bookingContractIdentifier;

  public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
  @jakarta.annotation.Nullable
  private java.time.LocalDateTime createdDate;

  public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
  @jakarta.annotation.Nullable
  private java.time.LocalDateTime lastUpdate;

  public static final String JSON_PROPERTY_FEDERATED_ORGANIZATION_IDENTIFIER = "federatedOrganizationIdentifier";
  @jakarta.annotation.Nonnull
  private String federatedOrganizationIdentifier;

  public static final String JSON_PROPERTY_FEDERATED_ORGANIZATION_NAME = "federatedOrganizationName";
  @jakarta.annotation.Nonnull
  private String federatedOrganizationName;

  public static final String JSON_PROPERTY_USER = "user";
  @jakarta.annotation.Nonnull
  private AuthenticatedUserAgent user;

  public static final String JSON_PROPERTY_IP_ADDRESS = "ipAddress";
  @jakarta.annotation.Nonnull
  private String ipAddress;

  public static final String JSON_PROPERTY_TRACE_ID = "traceId";
  @jakarta.annotation.Nonnull
  private String traceId;

  public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
  @jakarta.annotation.Nonnull
  private String sourceUrl;

  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  @jakarta.annotation.Nonnull
  private UUID identifier;

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
  @jakarta.annotation.Nonnull
  private UUID supplierIdentifier;

  public static final String JSON_PROPERTY_SUPPLIER_NAME = "supplierName";
  @jakarta.annotation.Nonnull
  private String supplierName;

  public static final String JSON_PROPERTY_DISPLAY_PRICE_QUOTE = "displayPriceQuote";
  @jakarta.annotation.Nonnull
  private QuoteLightweightAgent displayPriceQuote;

  public static final String JSON_PROPERTY_SUPPLIER_PRICE_QUOTE = "supplierPriceQuote";
  @jakarta.annotation.Nonnull
  private QuoteLightweightAgent supplierPriceQuote;

  public static final String JSON_PROPERTY_INTERNAL_PRICE_QUOTE = "internalPriceQuote";
  @jakarta.annotation.Nonnull
  private QuoteLightweightAgent internalPriceQuote;

  public static final String JSON_PROPERTY_CAPTURE_PRICE_QUOTE = "capturePriceQuote";
  @jakarta.annotation.Nonnull
  private QuoteLightweightAgent capturePriceQuote;

  public static final String JSON_PROPERTY_ITEM_LIST = "itemList";
  @jakarta.annotation.Nonnull
  private List<@Valid BookingContractItemAgent> itemList = new ArrayList<>();

  public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER = "externalSupplierIdentifier";
  @jakarta.annotation.Nullable
  private String externalSupplierIdentifier;

  public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
  @jakarta.annotation.Nullable
  private String externalSupplierBookingCode;

  public static final String JSON_PROPERTY_PAYMENT = "payment";
  @jakarta.annotation.Nonnull
  private BookingContractPaymentDetailsAgent payment;

  public static final String JSON_PROPERTY_CANCELLED = "cancelled";
  @jakarta.annotation.Nonnull
  private Boolean cancelled = false;

  public static final String JSON_PROPERTY_CANCELLED_ON = "cancelledOn";
  @jakarta.annotation.Nullable
  private java.time.LocalDateTime cancelledOn;

  /**
   * Type of entity that cancelled the booking.
   */
  public enum CancellerEnum {
    SALES_CHANNEL(String.valueOf("SALES_CHANNEL")),
    
    SUPPLIER(String.valueOf("SUPPLIER")),
    
    TRAVELER(String.valueOf("TRAVELER")),
    
    ACQUIRER(String.valueOf("ACQUIRER")),
    
    ADMINISTRATOR(String.valueOf("ADMINISTRATOR"));

    private String value;

    CancellerEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CancellerEnum fromValue(String value) {
      for (CancellerEnum b : CancellerEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CANCELLER = "canceller";
  @jakarta.annotation.Nullable
  private CancellerEnum canceller;

  /**
   * Reason type.
   */
  public enum CancellationTypeEnum {
    DUPLICATE(String.valueOf("DUPLICATE")),
    
    CANCELLATION(String.valueOf("CANCELLATION")),
    
    NO_SHOW(String.valueOf("NO_SHOW")),
    
    CC_INVALID(String.valueOf("CC_INVALID")),
    
    CC_INSUFFICIENT(String.valueOf("CC_INSUFFICIENT")),
    
    DISCRETIONARY(String.valueOf("DISCRETIONARY"));

    private String value;

    CancellationTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CancellationTypeEnum fromValue(String value) {
      for (CancellationTypeEnum b : CancellationTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CANCELLATION_TYPE = "cancellationType";
  @jakarta.annotation.Nullable
  private CancellationTypeEnum cancellationType;

  public static final String JSON_PROPERTY_CANCELLER_USER_IDENTIFIER = "cancellerUserIdentifier";
  @jakarta.annotation.Nullable
  private String cancellerUserIdentifier;

  public static final String JSON_PROPERTY_CANCEL_REASON = "cancelReason";
  @jakarta.annotation.Nullable
  private String cancelReason;

  public static final String JSON_PROPERTY_FUNDS_PROCESSED = "fundsProcessed";
  @jakarta.annotation.Nullable
  private Boolean fundsProcessed;

  public static final String JSON_PROPERTY_REFUNDS = "refunds";
  @jakarta.annotation.Nullable
  private List<@Valid RefundAgent> refunds = new ArrayList<>();

  public static final String JSON_PROPERTY_PAYOUTS = "payouts";
  @jakarta.annotation.Nullable
  private List<@Valid PayoutAgent> payouts = new ArrayList<>();

  public static final String JSON_PROPERTY_SOURCE_CURRENCY = "sourceCurrency";
  @jakarta.annotation.Nonnull
  private String sourceCurrency;

  public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
  @jakarta.annotation.Nonnull
  private String displayCurrency;

  public static final String JSON_PROPERTY_SUPPLIER_CURRENCY = "supplierCurrency";
  @jakarta.annotation.Nonnull
  private String supplierCurrency;

  public static final String JSON_PROPERTY_INTERNAL_CURRENCY = "internalCurrency";
  @jakarta.annotation.Nonnull
  private String internalCurrency;

  public static final String JSON_PROPERTY_CAPTURE_CURRENCY = "captureCurrency";
  @jakarta.annotation.Nonnull
  private String captureCurrency;

  public static final String JSON_PROPERTY_SOURCE_AMOUNT = "sourceAmount";
  @jakarta.annotation.Nonnull
  private BigDecimal sourceAmount;

  public static final String JSON_PROPERTY_DISPLAY_AMOUNT = "displayAmount";
  @jakarta.annotation.Nonnull
  private BigDecimal displayAmount;

  public static final String JSON_PROPERTY_SUPPLIER_AMOUNT = "supplierAmount";
  @jakarta.annotation.Nonnull
  private BigDecimal supplierAmount;

  public static final String JSON_PROPERTY_INTERNAL_AMOUNT = "internalAmount";
  @jakarta.annotation.Nonnull
  private BigDecimal internalAmount;

  public static final String JSON_PROPERTY_CAPTURE_AMOUNT = "captureAmount";
  @jakarta.annotation.Nonnull
  private BigDecimal captureAmount;

  public static final String JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER = "sourceAmountRefundModifier";
  @jakarta.annotation.Nullable
  private BigDecimal sourceAmountRefundModifier;

  public static final String JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER = "displayAmountRefundModifier";
  @jakarta.annotation.Nullable
  private BigDecimal displayAmountRefundModifier;

  public static final String JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER = "supplierAmountRefundModifier";
  @jakarta.annotation.Nullable
  private BigDecimal supplierAmountRefundModifier;

  public static final String JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER = "internalAmountRefundModifier";
  @jakarta.annotation.Nullable
  private BigDecimal internalAmountRefundModifier;

  public static final String JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER = "captureAmountRefundModifier";
  @jakarta.annotation.Nullable
  private BigDecimal captureAmountRefundModifier;

  public static final String JSON_PROPERTY_NET_SOURCE_AMOUNT = "netSourceAmount";
  @jakarta.annotation.Nullable
  private BigDecimal netSourceAmount;

  public static final String JSON_PROPERTY_NET_DISPLAY_AMOUNT = "netDisplayAmount";
  @jakarta.annotation.Nullable
  private BigDecimal netDisplayAmount;

  public static final String JSON_PROPERTY_NET_SUPPLIER_AMOUNT = "netSupplierAmount";
  @jakarta.annotation.Nullable
  private BigDecimal netSupplierAmount;

  public static final String JSON_PROPERTY_NET_INTERNAL_AMOUNT = "netInternalAmount";
  @jakarta.annotation.Nullable
  private BigDecimal netInternalAmount;

  public static final String JSON_PROPERTY_NET_CAPTURE_AMOUNT = "netCaptureAmount";
  @jakarta.annotation.Nullable
  private BigDecimal netCaptureAmount;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  @jakarta.annotation.Nullable
  private Map<String, String> metadata = new HashMap<>();

  public static final String JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT = "netCommissionableTotalSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netCommissionableTotalSourceAmount;

  public static final String JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT = "netCommissionableTotalCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netCommissionableTotalCaptureAmount;

  public static final String JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT = "netCommissionableTotalDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netCommissionableTotalDisplayAmount;

  public static final String JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT = "netCommissionableTotalSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netCommissionableTotalSupplierAmount;

  public static final String JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT = "netCommissionableTotalInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netCommissionableTotalInternalAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT = "netTotalFeesAndCommissionsSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalFeesAndCommissionsSourceAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT = "netTotalFeesAndCommissionsCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalFeesAndCommissionsCaptureAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT = "netTotalFeesAndCommissionsDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalFeesAndCommissionsDisplayAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT = "netTotalFeesAndCommissionsSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalFeesAndCommissionsSupplierAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT = "netTotalFeesAndCommissionsInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalFeesAndCommissionsInternalAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_SOURCE_AMOUNT = "netTotalFeesSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalFeesSourceAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_CAPTURE_AMOUNT = "netTotalFeesCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalFeesCaptureAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_DISPLAY_AMOUNT = "netTotalFeesDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalFeesDisplayAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_SUPPLIER_AMOUNT = "netTotalFeesSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalFeesSupplierAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_INTERNAL_AMOUNT = "netTotalFeesInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalFeesInternalAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT = "netTotalTripPayFeeSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalTripPayFeeSourceAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT = "netTotalTripPayFeeCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalTripPayFeeCaptureAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT = "netTotalTripPayFeeDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalTripPayFeeDisplayAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT = "netTotalTripPayFeeSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalTripPayFeeSupplierAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT = "netTotalTripPayFeeInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalTripPayFeeInternalAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SALES_SOURCE_AMOUNT = "netTotalSalesSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalSalesSourceAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SALES_CAPTURE_AMOUNT = "netTotalSalesCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalSalesCaptureAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SALES_DISPLAY_AMOUNT = "netTotalSalesDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalSalesDisplayAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SALES_SUPPLIER_AMOUNT = "netTotalSalesSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalSalesSupplierAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SALES_INTERNAL_AMOUNT = "netTotalSalesInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalSalesInternalAmount;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT = "commissionableTotalSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount commissionableTotalSourceAmount;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT = "commissionableTotalCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount commissionableTotalCaptureAmount;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT = "commissionableTotalDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount commissionableTotalDisplayAmount;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT = "commissionableTotalSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount commissionableTotalSupplierAmount;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT = "commissionableTotalInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount commissionableTotalInternalAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT = "totalFeesAndCommissionsSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalFeesAndCommissionsSourceAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT = "totalFeesAndCommissionsCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalFeesAndCommissionsCaptureAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT = "totalFeesAndCommissionsDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalFeesAndCommissionsDisplayAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT = "totalFeesAndCommissionsSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalFeesAndCommissionsSupplierAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT = "totalFeesAndCommissionsInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalFeesAndCommissionsInternalAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_SOURCE_AMOUNT = "totalFeesSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalFeesSourceAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_CAPTURE_AMOUNT = "totalFeesCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalFeesCaptureAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_DISPLAY_AMOUNT = "totalFeesDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalFeesDisplayAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_SUPPLIER_AMOUNT = "totalFeesSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalFeesSupplierAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_INTERNAL_AMOUNT = "totalFeesInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalFeesInternalAmount;

  public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT = "totalTripPayFeeSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalTripPayFeeSourceAmount;

  public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT = "totalTripPayFeeCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalTripPayFeeCaptureAmount;

  public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT = "totalTripPayFeeDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalTripPayFeeDisplayAmount;

  public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT = "totalTripPayFeeSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalTripPayFeeSupplierAmount;

  public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT = "totalTripPayFeeInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalTripPayFeeInternalAmount;

  public static final String JSON_PROPERTY_TOTAL_SALES_SOURCE_AMOUNT = "totalSalesSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalSalesSourceAmount;

  public static final String JSON_PROPERTY_TOTAL_SALES_CAPTURE_AMOUNT = "totalSalesCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalSalesCaptureAmount;

  public static final String JSON_PROPERTY_TOTAL_SALES_DISPLAY_AMOUNT = "totalSalesDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalSalesDisplayAmount;

  public static final String JSON_PROPERTY_TOTAL_SALES_SUPPLIER_AMOUNT = "totalSalesSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalSalesSupplierAmount;

  public static final String JSON_PROPERTY_TOTAL_SALES_INTERNAL_AMOUNT = "totalSalesInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalSalesInternalAmount;

  public static final String JSON_PROPERTY_FUNDS_AVAILABLE_DATE = "fundsAvailableDate";
  @jakarta.annotation.Nullable
  private LocalDate fundsAvailableDate;

  public static final String JSON_PROPERTY_TOTAL_FEES_IN_PERCENT_WITH_REFUND = "totalFeesInPercentWithRefund";
  @jakarta.annotation.Nullable
  private Float totalFeesInPercentWithRefund;

  public static final String JSON_PROPERTY_TOTAL_FEES_IN_PERCENT = "totalFeesInPercent";
  @jakarta.annotation.Nullable
  private Float totalFeesInPercent;

  public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT_WITH_REFUND = "totalTripPayFeeInPercentWithRefund";
  @jakarta.annotation.Nullable
  private Float totalTripPayFeeInPercentWithRefund;

  public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT = "totalTripPayFeeInPercent";
  @jakarta.annotation.Nullable
  private Float totalTripPayFeeInPercent;

  public static final String JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT_WITH_REFUND = "totalCommissionsInPercentWithRefund";
  @jakarta.annotation.Nullable
  private Float totalCommissionsInPercentWithRefund;

  public static final String JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT = "totalCommissionsInPercent";
  @jakarta.annotation.Nullable
  private Float totalCommissionsInPercent;

  public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT_WITH_REFUND = "totalFeesAndCommissionsInPercentWithRefund";
  @jakarta.annotation.Nullable
  private Float totalFeesAndCommissionsInPercentWithRefund;

  public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT = "totalFeesAndCommissionsInPercent";
  @jakarta.annotation.Nullable
  private Float totalFeesAndCommissionsInPercent;

  public static final String JSON_PROPERTY_ORIGINAL_FEES_IN_PERCENT = "originalFeesInPercent";
  @jakarta.annotation.Nullable
  private BigDecimal originalFeesInPercent;

  public static final String JSON_PROPERTY_ORIGINAL_AFFILIATE_AGENCY_FEES_IN_PERCENT = "originalAffiliateAgencyFeesInPercent";
  @jakarta.annotation.Nullable
  private BigDecimal originalAffiliateAgencyFeesInPercent;

  public static final String JSON_PROPERTY_ORIGINAL_SUPPLIER_AGENCY_FEES_IN_PERCENT = "originalSupplierAgencyFeesInPercent";
  @jakarta.annotation.Nullable
  private BigDecimal originalSupplierAgencyFeesInPercent;

  public static final String JSON_PROPERTY_ORIGINAL_COMMISSIONS_IN_PERCENT = "originalCommissionsInPercent";
  @jakarta.annotation.Nullable
  private BigDecimal originalCommissionsInPercent;

  public static final String JSON_PROPERTY_NET_TOTAL_CUSTOMERS_SOURCE_AMOUNT = "netTotalCustomersSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalCustomersSourceAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_CUSTOMERS_CAPTURE_AMOUNT = "netTotalCustomersCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalCustomersCaptureAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_CUSTOMERS_DISPLAY_AMOUNT = "netTotalCustomersDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalCustomersDisplayAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_CUSTOMERS_SUPPLIER_AMOUNT = "netTotalCustomersSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalCustomersSupplierAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_CUSTOMERS_INTERNAL_AMOUNT = "netTotalCustomersInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalCustomersInternalAmount;

  public static final String JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_SOURCE_AMOUNT = "totalAffiliateAgencyFeesSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalAffiliateAgencyFeesSourceAmount;

  public static final String JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_CAPTURE_AMOUNT = "totalAffiliateAgencyFeesCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalAffiliateAgencyFeesCaptureAmount;

  public static final String JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_DISPLAY_AMOUNT = "totalAffiliateAgencyFeesDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalAffiliateAgencyFeesDisplayAmount;

  public static final String JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_SUPPLIER_AMOUNT = "totalAffiliateAgencyFeesSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalAffiliateAgencyFeesSupplierAmount;

  public static final String JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_INTERNAL_AMOUNT = "totalAffiliateAgencyFeesInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalAffiliateAgencyFeesInternalAmount;

  public static final String JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_SOURCE_AMOUNT = "totalSupplierAgencyFeesSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalSupplierAgencyFeesSourceAmount;

  public static final String JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_CAPTURE_AMOUNT = "totalSupplierAgencyFeesCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalSupplierAgencyFeesCaptureAmount;

  public static final String JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_DISPLAY_AMOUNT = "totalSupplierAgencyFeesDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalSupplierAgencyFeesDisplayAmount;

  public static final String JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_SUPPLIER_AMOUNT = "totalSupplierAgencyFeesSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalSupplierAgencyFeesSupplierAmount;

  public static final String JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_INTERNAL_AMOUNT = "totalSupplierAgencyFeesInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalSupplierAgencyFeesInternalAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_SOURCE_AMOUNT = "netTotalAffiliateAgencyFeesSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalAffiliateAgencyFeesSourceAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_CAPTURE_AMOUNT = "netTotalAffiliateAgencyFeesCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalAffiliateAgencyFeesCaptureAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_DISPLAY_AMOUNT = "netTotalAffiliateAgencyFeesDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalAffiliateAgencyFeesDisplayAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_SUPPLIER_AMOUNT = "netTotalAffiliateAgencyFeesSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalAffiliateAgencyFeesSupplierAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_INTERNAL_AMOUNT = "netTotalAffiliateAgencyFeesInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalAffiliateAgencyFeesInternalAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_SOURCE_AMOUNT = "netTotalSupplierAgencyFeesSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalSupplierAgencyFeesSourceAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_CAPTURE_AMOUNT = "netTotalSupplierAgencyFeesCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalSupplierAgencyFeesCaptureAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_DISPLAY_AMOUNT = "netTotalSupplierAgencyFeesDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalSupplierAgencyFeesDisplayAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_SUPPLIER_AMOUNT = "netTotalSupplierAgencyFeesSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalSupplierAgencyFeesSupplierAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_INTERNAL_AMOUNT = "netTotalSupplierAgencyFeesInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalSupplierAgencyFeesInternalAmount;

  public static final String JSON_PROPERTY_HAS_REFUNDS = "hasRefunds";
  @jakarta.annotation.Nullable
  private Boolean hasRefunds;

  public static final String JSON_PROPERTY_HAS_SUCCESSFUL_REFUNDS = "hasSuccessfulRefunds";
  @jakarta.annotation.Nullable
  private Boolean hasSuccessfulRefunds;

  public static final String JSON_PROPERTY_HAS_PENDING_REFUNDS = "hasPendingRefunds";
  @jakarta.annotation.Nullable
  private Boolean hasPendingRefunds;

  public static final String JSON_PROPERTY_HAS_FAILED_REFUNDS = "hasFailedRefunds";
  @jakarta.annotation.Nullable
  private Boolean hasFailedRefunds;

  public static final String JSON_PROPERTY_PLATFORM_IDENTIFIER = "platformIdentifier";
  @jakarta.annotation.Nullable
  private String platformIdentifier;

  public static final String JSON_PROPERTY_TOTAL_FUNDS_GROUPED_BY_BENEFICIARY = "totalFundsGroupedByBeneficiary";
  @jakarta.annotation.Nullable
  private List<@Valid BeneficiaryAgent> totalFundsGroupedByBeneficiary = new ArrayList<>();

  public static final String JSON_PROPERTY_TOTAL_TOKENS_EARNED = "totalTokensEarned";
  @jakarta.annotation.Nullable
  private Long totalTokensEarned;

  public static final String JSON_PROPERTY_SELF_ACQUIRING = "selfAcquiring";
  @jakarta.annotation.Nullable
  private Boolean selfAcquiring;

  public static final String JSON_PROPERTY_LODGING = "lodging";
  @jakarta.annotation.Nullable
  private BookingContractItemAgent lodging;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_AGENT = "cancellableByAgent";
  @jakarta.annotation.Nullable
  private Boolean cancellableByAgent;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER = "cancellableBySupplier";
  @jakarta.annotation.Nullable
  private Boolean cancellableBySupplier;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
  @jakarta.annotation.Nullable
  private Boolean cancellableByTraveler;

  public static final String JSON_PROPERTY_FULLY_REFUNDED = "fullyRefunded";
  @jakarta.annotation.Nullable
  private Boolean fullyRefunded;

  public static final String JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES = "cancellableWithNoCharges";
  @jakarta.annotation.Nullable
  private Boolean cancellableWithNoCharges;

  public static final String JSON_PROPERTY_IS_CANCELLABLE_WITH_POTENTIAL_CHARGES = "isCancellableWithPotentialCharges";
  @jakarta.annotation.Nullable
  private Boolean isCancellableWithPotentialCharges;

  public BookingContractAgent() {
  }

  public BookingContractAgent bookingContractIdentifier(@jakarta.annotation.Nullable UUID bookingContractIdentifier) {
    
    this.bookingContractIdentifier = bookingContractIdentifier;
    return this;
  }

  /**
   * Document UUID
   * @return bookingContractIdentifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BOOKING_CONTRACT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getBookingContractIdentifier() {
    return bookingContractIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_CONTRACT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookingContractIdentifier(@jakarta.annotation.Nullable UUID bookingContractIdentifier) {
    this.bookingContractIdentifier = bookingContractIdentifier;
  }

  public BookingContractAgent createdDate(@jakarta.annotation.Nullable java.time.LocalDateTime createdDate) {
    
    this.createdDate = createdDate;
    return this;
  }

  /**
   * Datetime this record was first created
   * @return createdDate
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCreatedDate() {
    return createdDate;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedDate(@jakarta.annotation.Nullable java.time.LocalDateTime createdDate) {
    this.createdDate = createdDate;
  }

  public BookingContractAgent lastUpdate(@jakarta.annotation.Nullable java.time.LocalDateTime lastUpdate) {
    
    this.lastUpdate = lastUpdate;
    return this;
  }

  /**
   * Datetime this record was last updated
   * @return lastUpdate
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getLastUpdate() {
    return lastUpdate;
  }


  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastUpdate(@jakarta.annotation.Nullable java.time.LocalDateTime lastUpdate) {
    this.lastUpdate = lastUpdate;
  }

  public BookingContractAgent federatedOrganizationIdentifier(@jakarta.annotation.Nonnull String federatedOrganizationIdentifier) {
    
    this.federatedOrganizationIdentifier = federatedOrganizationIdentifier;
    return this;
  }

  /**
   * The auth realm owner ID
   * @return federatedOrganizationIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_FEDERATED_ORGANIZATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getFederatedOrganizationIdentifier() {
    return federatedOrganizationIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_FEDERATED_ORGANIZATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFederatedOrganizationIdentifier(@jakarta.annotation.Nonnull String federatedOrganizationIdentifier) {
    this.federatedOrganizationIdentifier = federatedOrganizationIdentifier;
  }

  public BookingContractAgent federatedOrganizationName(@jakarta.annotation.Nonnull String federatedOrganizationName) {
    
    this.federatedOrganizationName = federatedOrganizationName;
    return this;
  }

  /**
   * The auth realm owner name
   * @return federatedOrganizationName
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_FEDERATED_ORGANIZATION_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getFederatedOrganizationName() {
    return federatedOrganizationName;
  }


  @JsonProperty(JSON_PROPERTY_FEDERATED_ORGANIZATION_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFederatedOrganizationName(@jakarta.annotation.Nonnull String federatedOrganizationName) {
    this.federatedOrganizationName = federatedOrganizationName;
  }

  public BookingContractAgent user(@jakarta.annotation.Nonnull AuthenticatedUserAgent user) {
    
    this.user = user;
    return this;
  }

  /**
   * The authenticated user ID that made the request
   * @return user
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AuthenticatedUserAgent getUser() {
    return user;
  }


  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUser(@jakarta.annotation.Nonnull AuthenticatedUserAgent user) {
    this.user = user;
  }

  public BookingContractAgent ipAddress(@jakarta.annotation.Nonnull String ipAddress) {
    
    this.ipAddress = ipAddress;
    return this;
  }

  /**
   * Caller&#39;s IP address
   * @return ipAddress
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_IP_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIpAddress() {
    return ipAddress;
  }


  @JsonProperty(JSON_PROPERTY_IP_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIpAddress(@jakarta.annotation.Nonnull String ipAddress) {
    this.ipAddress = ipAddress;
  }

  public BookingContractAgent traceId(@jakarta.annotation.Nonnull String traceId) {
    
    this.traceId = traceId;
    return this;
  }

  /**
   * Way to track which booking contracts were made together
   * @return traceId
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTraceId() {
    return traceId;
  }


  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTraceId(@jakarta.annotation.Nonnull String traceId) {
    this.traceId = traceId;
  }

  public BookingContractAgent sourceUrl(@jakarta.annotation.Nonnull String sourceUrl) {
    
    this.sourceUrl = sourceUrl;
    return this;
  }

  /**
   * Where did the booking occur
   * @return sourceUrl
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSourceUrl() {
    return sourceUrl;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceUrl(@jakarta.annotation.Nonnull String sourceUrl) {
    this.sourceUrl = sourceUrl;
  }

  public BookingContractAgent identifier(@jakarta.annotation.Nonnull UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

  /**
   * Unique identifier used to track the contract. Create a UUID for this purpose.
   * @return identifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(@jakarta.annotation.Nonnull UUID identifier) {
    this.identifier = identifier;
  }

  public BookingContractAgent supplierIdentifier(@jakarta.annotation.Nonnull UUID supplierIdentifier) {
    
    this.supplierIdentifier = supplierIdentifier;
    return this;
  }

  /**
   * Supplier identifier
   * @return supplierIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getSupplierIdentifier() {
    return supplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierIdentifier(@jakarta.annotation.Nonnull UUID supplierIdentifier) {
    this.supplierIdentifier = supplierIdentifier;
  }

  public BookingContractAgent supplierName(@jakarta.annotation.Nonnull String supplierName) {
    
    this.supplierName = supplierName;
    return this;
  }

  /**
   * Supplier name
   * @return supplierName
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSupplierName() {
    return supplierName;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierName(@jakarta.annotation.Nonnull String supplierName) {
    this.supplierName = supplierName;
  }

  public BookingContractAgent displayPriceQuote(@jakarta.annotation.Nonnull QuoteLightweightAgent displayPriceQuote) {
    
    this.displayPriceQuote = displayPriceQuote;
    return this;
  }

  /**
   * The quote used to create totalDisplayPrice.
   * @return displayPriceQuote
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteLightweightAgent getDisplayPriceQuote() {
    return displayPriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayPriceQuote(@jakarta.annotation.Nonnull QuoteLightweightAgent displayPriceQuote) {
    this.displayPriceQuote = displayPriceQuote;
  }

  public BookingContractAgent supplierPriceQuote(@jakarta.annotation.Nonnull QuoteLightweightAgent supplierPriceQuote) {
    
    this.supplierPriceQuote = supplierPriceQuote;
    return this;
  }

  /**
   * The quote used to create totalSupplierPrice.
   * @return supplierPriceQuote
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteLightweightAgent getSupplierPriceQuote() {
    return supplierPriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierPriceQuote(@jakarta.annotation.Nonnull QuoteLightweightAgent supplierPriceQuote) {
    this.supplierPriceQuote = supplierPriceQuote;
  }

  public BookingContractAgent internalPriceQuote(@jakarta.annotation.Nonnull QuoteLightweightAgent internalPriceQuote) {
    
    this.internalPriceQuote = internalPriceQuote;
    return this;
  }

  /**
   * The quote used to create totalInternalPrice.
   * @return internalPriceQuote
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteLightweightAgent getInternalPriceQuote() {
    return internalPriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternalPriceQuote(@jakarta.annotation.Nonnull QuoteLightweightAgent internalPriceQuote) {
    this.internalPriceQuote = internalPriceQuote;
  }

  public BookingContractAgent capturePriceQuote(@jakarta.annotation.Nonnull QuoteLightweightAgent capturePriceQuote) {
    
    this.capturePriceQuote = capturePriceQuote;
    return this;
  }

  /**
   * The quote used to create totalCapturePrice.
   * @return capturePriceQuote
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteLightweightAgent getCapturePriceQuote() {
    return capturePriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCapturePriceQuote(@jakarta.annotation.Nonnull QuoteLightweightAgent capturePriceQuote) {
    this.capturePriceQuote = capturePriceQuote;
  }

  public BookingContractAgent itemList(@jakarta.annotation.Nonnull List<@Valid BookingContractItemAgent> itemList) {
    
    this.itemList = itemList;
    return this;
  }

  public BookingContractAgent addItemListItem(BookingContractItemAgent itemListItem) {
    if (this.itemList == null) {
      this.itemList = new ArrayList<>();
    }
    this.itemList.add(itemListItem);
    return this;
  }

  /**
   * Holds one booking line item for a specific supplier.
   * @return itemList
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_ITEM_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<@Valid BookingContractItemAgent> getItemList() {
    return itemList;
  }


  @JsonProperty(JSON_PROPERTY_ITEM_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setItemList(@jakarta.annotation.Nonnull List<@Valid BookingContractItemAgent> itemList) {
    this.itemList = itemList;
  }

  public BookingContractAgent externalSupplierIdentifier(@jakarta.annotation.Nullable String externalSupplierIdentifier) {
    
    this.externalSupplierIdentifier = externalSupplierIdentifier;
    return this;
  }

  /**
   * Contract creator can choose to geoname this record with her own identifier
   * @return externalSupplierIdentifier
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalSupplierIdentifier() {
    return externalSupplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalSupplierIdentifier(@jakarta.annotation.Nullable String externalSupplierIdentifier) {
    this.externalSupplierIdentifier = externalSupplierIdentifier;
  }

  public BookingContractAgent externalSupplierBookingCode(@jakarta.annotation.Nullable String externalSupplierBookingCode) {
    
    this.externalSupplierBookingCode = externalSupplierBookingCode;
    return this;
  }

  /**
   * External booking code generated by the affiliate
   * @return externalSupplierBookingCode
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalSupplierBookingCode() {
    return externalSupplierBookingCode;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalSupplierBookingCode(@jakarta.annotation.Nullable String externalSupplierBookingCode) {
    this.externalSupplierBookingCode = externalSupplierBookingCode;
  }

  public BookingContractAgent payment(@jakarta.annotation.Nonnull BookingContractPaymentDetailsAgent payment) {
    
    this.payment = payment;
    return this;
  }

  /**
   * Payment details the merchant provided us at the time of payment.
   * @return payment
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_PAYMENT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BookingContractPaymentDetailsAgent getPayment() {
    return payment;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPayment(@jakarta.annotation.Nonnull BookingContractPaymentDetailsAgent payment) {
    this.payment = payment;
  }

  public BookingContractAgent cancelled(@jakarta.annotation.Nonnull Boolean cancelled) {
    
    this.cancelled = cancelled;
    return this;
  }

  /**
   * Optional geoname externalIdentifier to remote inventory.
   * @return cancelled
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getCancelled() {
    return cancelled;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCancelled(@jakarta.annotation.Nonnull Boolean cancelled) {
    this.cancelled = cancelled;
  }

  public BookingContractAgent cancelledOn(@jakarta.annotation.Nullable java.time.LocalDateTime cancelledOn) {
    
    this.cancelledOn = cancelledOn;
    return this;
  }

  /**
   * When the booking was cancelled.
   * @return cancelledOn
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CANCELLED_ON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCancelledOn() {
    return cancelledOn;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLED_ON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelledOn(@jakarta.annotation.Nullable java.time.LocalDateTime cancelledOn) {
    this.cancelledOn = cancelledOn;
  }

  public BookingContractAgent canceller(@jakarta.annotation.Nullable CancellerEnum canceller) {
    
    this.canceller = canceller;
    return this;
  }

  /**
   * Type of entity that cancelled the booking.
   * @return canceller
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CancellerEnum getCanceller() {
    return canceller;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCanceller(@jakarta.annotation.Nullable CancellerEnum canceller) {
    this.canceller = canceller;
  }

  public BookingContractAgent cancellationType(@jakarta.annotation.Nullable CancellationTypeEnum cancellationType) {
    
    this.cancellationType = cancellationType;
    return this;
  }

  /**
   * Reason type.
   * @return cancellationType
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CancellationTypeEnum getCancellationType() {
    return cancellationType;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellationType(@jakarta.annotation.Nullable CancellationTypeEnum cancellationType) {
    this.cancellationType = cancellationType;
  }

  public BookingContractAgent cancellerUserIdentifier(@jakarta.annotation.Nullable String cancellerUserIdentifier) {
    
    this.cancellerUserIdentifier = cancellerUserIdentifier;
    return this;
  }

  /**
   * User identifier that cancelled the entity.
   * @return cancellerUserIdentifier
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLER_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCancellerUserIdentifier() {
    return cancellerUserIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLER_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellerUserIdentifier(@jakarta.annotation.Nullable String cancellerUserIdentifier) {
    this.cancellerUserIdentifier = cancellerUserIdentifier;
  }

  public BookingContractAgent cancelReason(@jakarta.annotation.Nullable String cancelReason) {
    
    this.cancelReason = cancelReason;
    return this;
  }

  /**
   * Reason for cancellation.
   * @return cancelReason
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCEL_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCancelReason() {
    return cancelReason;
  }


  @JsonProperty(JSON_PROPERTY_CANCEL_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelReason(@jakarta.annotation.Nullable String cancelReason) {
    this.cancelReason = cancelReason;
  }

  public BookingContractAgent fundsProcessed(@jakarta.annotation.Nullable Boolean fundsProcessed) {
    
    this.fundsProcessed = fundsProcessed;
    return this;
  }

  /**
   * Whether a funds transfer request has been created for this booking.
   * @return fundsProcessed
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FUNDS_PROCESSED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getFundsProcessed() {
    return fundsProcessed;
  }


  @JsonProperty(JSON_PROPERTY_FUNDS_PROCESSED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundsProcessed(@jakarta.annotation.Nullable Boolean fundsProcessed) {
    this.fundsProcessed = fundsProcessed;
  }

  public BookingContractAgent refunds(@jakarta.annotation.Nullable List<@Valid RefundAgent> refunds) {
    
    this.refunds = refunds;
    return this;
  }

  public BookingContractAgent addRefundsItem(RefundAgent refundsItem) {
    if (this.refunds == null) {
      this.refunds = new ArrayList<>();
    }
    this.refunds.add(refundsItem);
    return this;
  }

  /**
   * An optional list of refunds that occurred with this booking. If the refund amount(s) is the same as the total price, the booking also gets cancelled.
   * @return refunds
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid RefundAgent> getRefunds() {
    return refunds;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefunds(@jakarta.annotation.Nullable List<@Valid RefundAgent> refunds) {
    this.refunds = refunds;
  }

  public BookingContractAgent payouts(@jakarta.annotation.Nullable List<@Valid PayoutAgent> payouts) {
    
    this.payouts = payouts;
    return this;
  }

  public BookingContractAgent addPayoutsItem(PayoutAgent payoutsItem) {
    if (this.payouts == null) {
      this.payouts = new ArrayList<>();
    }
    this.payouts.add(payoutsItem);
    return this;
  }

  /**
   * An optional list of refunds that occurred with this booking. If the refund amount(s) is the same as the total price, the booking also gets cancelled.
   * @return payouts
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PAYOUTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid PayoutAgent> getPayouts() {
    return payouts;
  }


  @JsonProperty(JSON_PROPERTY_PAYOUTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayouts(@jakarta.annotation.Nullable List<@Valid PayoutAgent> payouts) {
    this.payouts = payouts;
  }

  public BookingContractAgent sourceCurrency(@jakarta.annotation.Nonnull String sourceCurrency) {
    
    this.sourceCurrency = sourceCurrency;
    return this;
  }

  /**
   * The source currency
   * @return sourceCurrency
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSourceCurrency() {
    return sourceCurrency;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceCurrency(@jakarta.annotation.Nonnull String sourceCurrency) {
    this.sourceCurrency = sourceCurrency;
  }

  public BookingContractAgent displayCurrency(@jakarta.annotation.Nonnull String displayCurrency) {
    
    this.displayCurrency = displayCurrency;
    return this;
  }

  /**
   * The display currency
   * @return displayCurrency
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDisplayCurrency() {
    return displayCurrency;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayCurrency(@jakarta.annotation.Nonnull String displayCurrency) {
    this.displayCurrency = displayCurrency;
  }

  public BookingContractAgent supplierCurrency(@jakarta.annotation.Nonnull String supplierCurrency) {
    
    this.supplierCurrency = supplierCurrency;
    return this;
  }

  /**
   * The supplier currency
   * @return supplierCurrency
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSupplierCurrency() {
    return supplierCurrency;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierCurrency(@jakarta.annotation.Nonnull String supplierCurrency) {
    this.supplierCurrency = supplierCurrency;
  }

  public BookingContractAgent internalCurrency(@jakarta.annotation.Nonnull String internalCurrency) {
    
    this.internalCurrency = internalCurrency;
    return this;
  }

  /**
   * The internal currency
   * @return internalCurrency
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getInternalCurrency() {
    return internalCurrency;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternalCurrency(@jakarta.annotation.Nonnull String internalCurrency) {
    this.internalCurrency = internalCurrency;
  }

  public BookingContractAgent captureCurrency(@jakarta.annotation.Nonnull String captureCurrency) {
    
    this.captureCurrency = captureCurrency;
    return this;
  }

  /**
   * The capture currency
   * @return captureCurrency
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCaptureCurrency() {
    return captureCurrency;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCaptureCurrency(@jakarta.annotation.Nonnull String captureCurrency) {
    this.captureCurrency = captureCurrency;
  }

  public BookingContractAgent sourceAmount(@jakarta.annotation.Nonnull BigDecimal sourceAmount) {
    
    this.sourceAmount = sourceAmount;
    return this;
  }

  /**
   * The total initial price as quoted in the original TripPay contract.
   * minimum: 0
   * @return sourceAmount
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getSourceAmount() {
    return sourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceAmount(@jakarta.annotation.Nonnull BigDecimal sourceAmount) {
    this.sourceAmount = sourceAmount;
  }

  public BookingContractAgent displayAmount(@jakarta.annotation.Nonnull BigDecimal displayAmount) {
    
    this.displayAmount = displayAmount;
    return this;
  }

  /**
   * The total display price.
   * minimum: 0
   * @return displayAmount
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getDisplayAmount() {
    return displayAmount;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayAmount(@jakarta.annotation.Nonnull BigDecimal displayAmount) {
    this.displayAmount = displayAmount;
  }

  public BookingContractAgent supplierAmount(@jakarta.annotation.Nonnull BigDecimal supplierAmount) {
    
    this.supplierAmount = supplierAmount;
    return this;
  }

  /**
   * The total supplier price.
   * minimum: 0
   * @return supplierAmount
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getSupplierAmount() {
    return supplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierAmount(@jakarta.annotation.Nonnull BigDecimal supplierAmount) {
    this.supplierAmount = supplierAmount;
  }

  public BookingContractAgent internalAmount(@jakarta.annotation.Nonnull BigDecimal internalAmount) {
    
    this.internalAmount = internalAmount;
    return this;
  }

  /**
   * Get internalAmount
   * minimum: 0
   * @return internalAmount
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getInternalAmount() {
    return internalAmount;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternalAmount(@jakarta.annotation.Nonnull BigDecimal internalAmount) {
    this.internalAmount = internalAmount;
  }

  public BookingContractAgent captureAmount(@jakarta.annotation.Nonnull BigDecimal captureAmount) {
    
    this.captureAmount = captureAmount;
    return this;
  }

  /**
   * The total capture price.
   * minimum: 0
   * @return captureAmount
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getCaptureAmount() {
    return captureAmount;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCaptureAmount(@jakarta.annotation.Nonnull BigDecimal captureAmount) {
    this.captureAmount = captureAmount;
  }

  public BookingContractAgent sourceAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal sourceAmountRefundModifier) {
    
    this.sourceAmountRefundModifier = sourceAmountRefundModifier;
    return this;
  }

  /**
   * The source amount still due after a partial refund occurs.
   * @return sourceAmountRefundModifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourceAmountRefundModifier() {
    return sourceAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal sourceAmountRefundModifier) {
    this.sourceAmountRefundModifier = sourceAmountRefundModifier;
  }

  public BookingContractAgent displayAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal displayAmountRefundModifier) {
    
    this.displayAmountRefundModifier = displayAmountRefundModifier;
    return this;
  }

  /**
   * The display amount still due after a partial refund occurs.
   * @return displayAmountRefundModifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getDisplayAmountRefundModifier() {
    return displayAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal displayAmountRefundModifier) {
    this.displayAmountRefundModifier = displayAmountRefundModifier;
  }

  public BookingContractAgent supplierAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal supplierAmountRefundModifier) {
    
    this.supplierAmountRefundModifier = supplierAmountRefundModifier;
    return this;
  }

  /**
   * The supplier amount still due after a partial refund occurs.
   * @return supplierAmountRefundModifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSupplierAmountRefundModifier() {
    return supplierAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal supplierAmountRefundModifier) {
    this.supplierAmountRefundModifier = supplierAmountRefundModifier;
  }

  public BookingContractAgent internalAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal internalAmountRefundModifier) {
    
    this.internalAmountRefundModifier = internalAmountRefundModifier;
    return this;
  }

  /**
   * The internal amount still due after a partial refund occurs.
   * @return internalAmountRefundModifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalAmountRefundModifier() {
    return internalAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal internalAmountRefundModifier) {
    this.internalAmountRefundModifier = internalAmountRefundModifier;
  }

  public BookingContractAgent captureAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal captureAmountRefundModifier) {
    
    this.captureAmountRefundModifier = captureAmountRefundModifier;
    return this;
  }

  /**
   * The capture amount still due after a partial refund occurs.
   * @return captureAmountRefundModifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getCaptureAmountRefundModifier() {
    return captureAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCaptureAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal captureAmountRefundModifier) {
    this.captureAmountRefundModifier = captureAmountRefundModifier;
  }

  public BookingContractAgent netSourceAmount(@jakarta.annotation.Nullable BigDecimal netSourceAmount) {
    
    this.netSourceAmount = netSourceAmount;
    return this;
  }

  /**
   * The total initial price as quoted in the original TripPay contract.
   * @return netSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getNetSourceAmount() {
    return netSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetSourceAmount(@jakarta.annotation.Nullable BigDecimal netSourceAmount) {
    this.netSourceAmount = netSourceAmount;
  }

  public BookingContractAgent netDisplayAmount(@jakarta.annotation.Nullable BigDecimal netDisplayAmount) {
    
    this.netDisplayAmount = netDisplayAmount;
    return this;
  }

  /**
   * The total display price.
   * @return netDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getNetDisplayAmount() {
    return netDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetDisplayAmount(@jakarta.annotation.Nullable BigDecimal netDisplayAmount) {
    this.netDisplayAmount = netDisplayAmount;
  }

  public BookingContractAgent netSupplierAmount(@jakarta.annotation.Nullable BigDecimal netSupplierAmount) {
    
    this.netSupplierAmount = netSupplierAmount;
    return this;
  }

  /**
   * The total supplier price.
   * @return netSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getNetSupplierAmount() {
    return netSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetSupplierAmount(@jakarta.annotation.Nullable BigDecimal netSupplierAmount) {
    this.netSupplierAmount = netSupplierAmount;
  }

  public BookingContractAgent netInternalAmount(@jakarta.annotation.Nullable BigDecimal netInternalAmount) {
    
    this.netInternalAmount = netInternalAmount;
    return this;
  }

  /**
   * Get netInternalAmount
   * @return netInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getNetInternalAmount() {
    return netInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetInternalAmount(@jakarta.annotation.Nullable BigDecimal netInternalAmount) {
    this.netInternalAmount = netInternalAmount;
  }

  public BookingContractAgent netCaptureAmount(@jakarta.annotation.Nullable BigDecimal netCaptureAmount) {
    
    this.netCaptureAmount = netCaptureAmount;
    return this;
  }

  /**
   * The total capture price.
   * @return netCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getNetCaptureAmount() {
    return netCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetCaptureAmount(@jakarta.annotation.Nullable BigDecimal netCaptureAmount) {
    this.netCaptureAmount = netCaptureAmount;
  }

  public BookingContractAgent metadata(@jakarta.annotation.Nullable Map<String, String> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public BookingContractAgent putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

  /**
   * Place to add more data related to the booking contract.
   * @return metadata
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(@jakarta.annotation.Nullable Map<String, String> metadata) {
    this.metadata = metadata;
  }

  public BookingContractAgent netCommissionableTotalSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netCommissionableTotalSourceAmount) {
    
    this.netCommissionableTotalSourceAmount = netCommissionableTotalSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency the affiliate is owed.
   * @return netCommissionableTotalSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetCommissionableTotalSourceAmount() {
    return netCommissionableTotalSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetCommissionableTotalSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netCommissionableTotalSourceAmount) {
    this.netCommissionableTotalSourceAmount = netCommissionableTotalSourceAmount;
  }

  public BookingContractAgent netCommissionableTotalCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netCommissionableTotalCaptureAmount) {
    
    this.netCommissionableTotalCaptureAmount = netCommissionableTotalCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency the affiliate is owed.
   * @return netCommissionableTotalCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetCommissionableTotalCaptureAmount() {
    return netCommissionableTotalCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetCommissionableTotalCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netCommissionableTotalCaptureAmount) {
    this.netCommissionableTotalCaptureAmount = netCommissionableTotalCaptureAmount;
  }

  public BookingContractAgent netCommissionableTotalDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netCommissionableTotalDisplayAmount) {
    
    this.netCommissionableTotalDisplayAmount = netCommissionableTotalDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency the affiliate is owed.
   * @return netCommissionableTotalDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetCommissionableTotalDisplayAmount() {
    return netCommissionableTotalDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetCommissionableTotalDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netCommissionableTotalDisplayAmount) {
    this.netCommissionableTotalDisplayAmount = netCommissionableTotalDisplayAmount;
  }

  public BookingContractAgent netCommissionableTotalSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netCommissionableTotalSupplierAmount) {
    
    this.netCommissionableTotalSupplierAmount = netCommissionableTotalSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency the affiliate is owed.
   * @return netCommissionableTotalSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetCommissionableTotalSupplierAmount() {
    return netCommissionableTotalSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetCommissionableTotalSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netCommissionableTotalSupplierAmount) {
    this.netCommissionableTotalSupplierAmount = netCommissionableTotalSupplierAmount;
  }

  public BookingContractAgent netCommissionableTotalInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netCommissionableTotalInternalAmount) {
    
    this.netCommissionableTotalInternalAmount = netCommissionableTotalInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency the affiliate is owed.
   * @return netCommissionableTotalInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetCommissionableTotalInternalAmount() {
    return netCommissionableTotalInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetCommissionableTotalInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netCommissionableTotalInternalAmount) {
    this.netCommissionableTotalInternalAmount = netCommissionableTotalInternalAmount;
  }

  public BookingContractAgent netTotalFeesAndCommissionsSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesAndCommissionsSourceAmount) {
    
    this.netTotalFeesAndCommissionsSourceAmount = netTotalFeesAndCommissionsSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency that is fees and commission.
   * @return netTotalFeesAndCommissionsSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesAndCommissionsSourceAmount() {
    return netTotalFeesAndCommissionsSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesAndCommissionsSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesAndCommissionsSourceAmount) {
    this.netTotalFeesAndCommissionsSourceAmount = netTotalFeesAndCommissionsSourceAmount;
  }

  public BookingContractAgent netTotalFeesAndCommissionsCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesAndCommissionsCaptureAmount) {
    
    this.netTotalFeesAndCommissionsCaptureAmount = netTotalFeesAndCommissionsCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency the affiliate is owed.
   * @return netTotalFeesAndCommissionsCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesAndCommissionsCaptureAmount() {
    return netTotalFeesAndCommissionsCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesAndCommissionsCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesAndCommissionsCaptureAmount) {
    this.netTotalFeesAndCommissionsCaptureAmount = netTotalFeesAndCommissionsCaptureAmount;
  }

  public BookingContractAgent netTotalFeesAndCommissionsDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesAndCommissionsDisplayAmount) {
    
    this.netTotalFeesAndCommissionsDisplayAmount = netTotalFeesAndCommissionsDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency the affiliate is owed.
   * @return netTotalFeesAndCommissionsDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesAndCommissionsDisplayAmount() {
    return netTotalFeesAndCommissionsDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesAndCommissionsDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesAndCommissionsDisplayAmount) {
    this.netTotalFeesAndCommissionsDisplayAmount = netTotalFeesAndCommissionsDisplayAmount;
  }

  public BookingContractAgent netTotalFeesAndCommissionsSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesAndCommissionsSupplierAmount) {
    
    this.netTotalFeesAndCommissionsSupplierAmount = netTotalFeesAndCommissionsSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency the affiliate is owed.
   * @return netTotalFeesAndCommissionsSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesAndCommissionsSupplierAmount() {
    return netTotalFeesAndCommissionsSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesAndCommissionsSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesAndCommissionsSupplierAmount) {
    this.netTotalFeesAndCommissionsSupplierAmount = netTotalFeesAndCommissionsSupplierAmount;
  }

  public BookingContractAgent netTotalFeesAndCommissionsInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesAndCommissionsInternalAmount) {
    
    this.netTotalFeesAndCommissionsInternalAmount = netTotalFeesAndCommissionsInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency the affiliate is owed.
   * @return netTotalFeesAndCommissionsInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesAndCommissionsInternalAmount() {
    return netTotalFeesAndCommissionsInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesAndCommissionsInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesAndCommissionsInternalAmount) {
    this.netTotalFeesAndCommissionsInternalAmount = netTotalFeesAndCommissionsInternalAmount;
  }

  public BookingContractAgent netTotalFeesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesSourceAmount) {
    
    this.netTotalFeesSourceAmount = netTotalFeesSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency that is fees and commission.
   * @return netTotalFeesSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesSourceAmount() {
    return netTotalFeesSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesSourceAmount) {
    this.netTotalFeesSourceAmount = netTotalFeesSourceAmount;
  }

  public BookingContractAgent netTotalFeesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesCaptureAmount) {
    
    this.netTotalFeesCaptureAmount = netTotalFeesCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency the affiliate is owed.
   * @return netTotalFeesCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesCaptureAmount() {
    return netTotalFeesCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesCaptureAmount) {
    this.netTotalFeesCaptureAmount = netTotalFeesCaptureAmount;
  }

  public BookingContractAgent netTotalFeesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesDisplayAmount) {
    
    this.netTotalFeesDisplayAmount = netTotalFeesDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency the affiliate is owed.
   * @return netTotalFeesDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesDisplayAmount() {
    return netTotalFeesDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesDisplayAmount) {
    this.netTotalFeesDisplayAmount = netTotalFeesDisplayAmount;
  }

  public BookingContractAgent netTotalFeesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesSupplierAmount) {
    
    this.netTotalFeesSupplierAmount = netTotalFeesSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency the affiliate is owed.
   * @return netTotalFeesSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesSupplierAmount() {
    return netTotalFeesSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesSupplierAmount) {
    this.netTotalFeesSupplierAmount = netTotalFeesSupplierAmount;
  }

  public BookingContractAgent netTotalFeesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesInternalAmount) {
    
    this.netTotalFeesInternalAmount = netTotalFeesInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency the affiliate is owed.
   * @return netTotalFeesInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesInternalAmount() {
    return netTotalFeesInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesInternalAmount) {
    this.netTotalFeesInternalAmount = netTotalFeesInternalAmount;
  }

  public BookingContractAgent netTotalTripPayFeeSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalTripPayFeeSourceAmount) {
    
    this.netTotalTripPayFeeSourceAmount = netTotalTripPayFeeSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency that is fees and commission.
   * @return netTotalTripPayFeeSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalTripPayFeeSourceAmount() {
    return netTotalTripPayFeeSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalTripPayFeeSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalTripPayFeeSourceAmount) {
    this.netTotalTripPayFeeSourceAmount = netTotalTripPayFeeSourceAmount;
  }

  public BookingContractAgent netTotalTripPayFeeCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalTripPayFeeCaptureAmount) {
    
    this.netTotalTripPayFeeCaptureAmount = netTotalTripPayFeeCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency the affiliate is owed.
   * @return netTotalTripPayFeeCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalTripPayFeeCaptureAmount() {
    return netTotalTripPayFeeCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalTripPayFeeCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalTripPayFeeCaptureAmount) {
    this.netTotalTripPayFeeCaptureAmount = netTotalTripPayFeeCaptureAmount;
  }

  public BookingContractAgent netTotalTripPayFeeDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalTripPayFeeDisplayAmount) {
    
    this.netTotalTripPayFeeDisplayAmount = netTotalTripPayFeeDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency the affiliate is owed.
   * @return netTotalTripPayFeeDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalTripPayFeeDisplayAmount() {
    return netTotalTripPayFeeDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalTripPayFeeDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalTripPayFeeDisplayAmount) {
    this.netTotalTripPayFeeDisplayAmount = netTotalTripPayFeeDisplayAmount;
  }

  public BookingContractAgent netTotalTripPayFeeSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalTripPayFeeSupplierAmount) {
    
    this.netTotalTripPayFeeSupplierAmount = netTotalTripPayFeeSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency the affiliate is owed.
   * @return netTotalTripPayFeeSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalTripPayFeeSupplierAmount() {
    return netTotalTripPayFeeSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalTripPayFeeSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalTripPayFeeSupplierAmount) {
    this.netTotalTripPayFeeSupplierAmount = netTotalTripPayFeeSupplierAmount;
  }

  public BookingContractAgent netTotalTripPayFeeInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalTripPayFeeInternalAmount) {
    
    this.netTotalTripPayFeeInternalAmount = netTotalTripPayFeeInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency the affiliate is owed.
   * @return netTotalTripPayFeeInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalTripPayFeeInternalAmount() {
    return netTotalTripPayFeeInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalTripPayFeeInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalTripPayFeeInternalAmount) {
    this.netTotalTripPayFeeInternalAmount = netTotalTripPayFeeInternalAmount;
  }

  public BookingContractAgent netTotalSalesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSalesSourceAmount) {
    
    this.netTotalSalesSourceAmount = netTotalSalesSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency that is fees and commission.
   * @return netTotalSalesSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSalesSourceAmount() {
    return netTotalSalesSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSalesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSalesSourceAmount) {
    this.netTotalSalesSourceAmount = netTotalSalesSourceAmount;
  }

  public BookingContractAgent netTotalSalesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSalesCaptureAmount) {
    
    this.netTotalSalesCaptureAmount = netTotalSalesCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency the affiliate is owed.
   * @return netTotalSalesCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSalesCaptureAmount() {
    return netTotalSalesCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSalesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSalesCaptureAmount) {
    this.netTotalSalesCaptureAmount = netTotalSalesCaptureAmount;
  }

  public BookingContractAgent netTotalSalesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSalesDisplayAmount) {
    
    this.netTotalSalesDisplayAmount = netTotalSalesDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency the affiliate is owed.
   * @return netTotalSalesDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSalesDisplayAmount() {
    return netTotalSalesDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSalesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSalesDisplayAmount) {
    this.netTotalSalesDisplayAmount = netTotalSalesDisplayAmount;
  }

  public BookingContractAgent netTotalSalesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSalesSupplierAmount) {
    
    this.netTotalSalesSupplierAmount = netTotalSalesSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency the affiliate is owed.
   * @return netTotalSalesSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSalesSupplierAmount() {
    return netTotalSalesSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSalesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSalesSupplierAmount) {
    this.netTotalSalesSupplierAmount = netTotalSalesSupplierAmount;
  }

  public BookingContractAgent netTotalSalesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSalesInternalAmount) {
    
    this.netTotalSalesInternalAmount = netTotalSalesInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency the affiliate is owed.
   * @return netTotalSalesInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSalesInternalAmount() {
    return netTotalSalesInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSalesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSalesInternalAmount) {
    this.netTotalSalesInternalAmount = netTotalSalesInternalAmount;
  }

  public BookingContractAgent commissionableTotalSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount commissionableTotalSourceAmount) {
    
    this.commissionableTotalSourceAmount = commissionableTotalSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency the affiliate is owed.
   * @return commissionableTotalSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getCommissionableTotalSourceAmount() {
    return commissionableTotalSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount commissionableTotalSourceAmount) {
    this.commissionableTotalSourceAmount = commissionableTotalSourceAmount;
  }

  public BookingContractAgent commissionableTotalCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount commissionableTotalCaptureAmount) {
    
    this.commissionableTotalCaptureAmount = commissionableTotalCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency the affiliate is owed.
   * @return commissionableTotalCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getCommissionableTotalCaptureAmount() {
    return commissionableTotalCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount commissionableTotalCaptureAmount) {
    this.commissionableTotalCaptureAmount = commissionableTotalCaptureAmount;
  }

  public BookingContractAgent commissionableTotalDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount commissionableTotalDisplayAmount) {
    
    this.commissionableTotalDisplayAmount = commissionableTotalDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency the affiliate is owed.
   * @return commissionableTotalDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getCommissionableTotalDisplayAmount() {
    return commissionableTotalDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount commissionableTotalDisplayAmount) {
    this.commissionableTotalDisplayAmount = commissionableTotalDisplayAmount;
  }

  public BookingContractAgent commissionableTotalSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount commissionableTotalSupplierAmount) {
    
    this.commissionableTotalSupplierAmount = commissionableTotalSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency the affiliate is owed.
   * @return commissionableTotalSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getCommissionableTotalSupplierAmount() {
    return commissionableTotalSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount commissionableTotalSupplierAmount) {
    this.commissionableTotalSupplierAmount = commissionableTotalSupplierAmount;
  }

  public BookingContractAgent commissionableTotalInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount commissionableTotalInternalAmount) {
    
    this.commissionableTotalInternalAmount = commissionableTotalInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency the affiliate is owed.
   * @return commissionableTotalInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getCommissionableTotalInternalAmount() {
    return commissionableTotalInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount commissionableTotalInternalAmount) {
    this.commissionableTotalInternalAmount = commissionableTotalInternalAmount;
  }

  public BookingContractAgent totalFeesAndCommissionsSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesAndCommissionsSourceAmount) {
    
    this.totalFeesAndCommissionsSourceAmount = totalFeesAndCommissionsSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency that is fees and commission.
   * @return totalFeesAndCommissionsSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesAndCommissionsSourceAmount() {
    return totalFeesAndCommissionsSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesAndCommissionsSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesAndCommissionsSourceAmount) {
    this.totalFeesAndCommissionsSourceAmount = totalFeesAndCommissionsSourceAmount;
  }

  public BookingContractAgent totalFeesAndCommissionsCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesAndCommissionsCaptureAmount) {
    
    this.totalFeesAndCommissionsCaptureAmount = totalFeesAndCommissionsCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency the affiliate is owed.
   * @return totalFeesAndCommissionsCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesAndCommissionsCaptureAmount() {
    return totalFeesAndCommissionsCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesAndCommissionsCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesAndCommissionsCaptureAmount) {
    this.totalFeesAndCommissionsCaptureAmount = totalFeesAndCommissionsCaptureAmount;
  }

  public BookingContractAgent totalFeesAndCommissionsDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesAndCommissionsDisplayAmount) {
    
    this.totalFeesAndCommissionsDisplayAmount = totalFeesAndCommissionsDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency the affiliate is owed.
   * @return totalFeesAndCommissionsDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesAndCommissionsDisplayAmount() {
    return totalFeesAndCommissionsDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesAndCommissionsDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesAndCommissionsDisplayAmount) {
    this.totalFeesAndCommissionsDisplayAmount = totalFeesAndCommissionsDisplayAmount;
  }

  public BookingContractAgent totalFeesAndCommissionsSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesAndCommissionsSupplierAmount) {
    
    this.totalFeesAndCommissionsSupplierAmount = totalFeesAndCommissionsSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency the affiliate is owed.
   * @return totalFeesAndCommissionsSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesAndCommissionsSupplierAmount() {
    return totalFeesAndCommissionsSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesAndCommissionsSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesAndCommissionsSupplierAmount) {
    this.totalFeesAndCommissionsSupplierAmount = totalFeesAndCommissionsSupplierAmount;
  }

  public BookingContractAgent totalFeesAndCommissionsInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesAndCommissionsInternalAmount) {
    
    this.totalFeesAndCommissionsInternalAmount = totalFeesAndCommissionsInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency the affiliate is owed.
   * @return totalFeesAndCommissionsInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesAndCommissionsInternalAmount() {
    return totalFeesAndCommissionsInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesAndCommissionsInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesAndCommissionsInternalAmount) {
    this.totalFeesAndCommissionsInternalAmount = totalFeesAndCommissionsInternalAmount;
  }

  public BookingContractAgent totalFeesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesSourceAmount) {
    
    this.totalFeesSourceAmount = totalFeesSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency that is fees and commission.
   * @return totalFeesSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesSourceAmount() {
    return totalFeesSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesSourceAmount) {
    this.totalFeesSourceAmount = totalFeesSourceAmount;
  }

  public BookingContractAgent totalFeesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesCaptureAmount) {
    
    this.totalFeesCaptureAmount = totalFeesCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency the affiliate is owed.
   * @return totalFeesCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesCaptureAmount() {
    return totalFeesCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesCaptureAmount) {
    this.totalFeesCaptureAmount = totalFeesCaptureAmount;
  }

  public BookingContractAgent totalFeesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesDisplayAmount) {
    
    this.totalFeesDisplayAmount = totalFeesDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency the affiliate is owed.
   * @return totalFeesDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesDisplayAmount() {
    return totalFeesDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesDisplayAmount) {
    this.totalFeesDisplayAmount = totalFeesDisplayAmount;
  }

  public BookingContractAgent totalFeesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesSupplierAmount) {
    
    this.totalFeesSupplierAmount = totalFeesSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency the affiliate is owed.
   * @return totalFeesSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesSupplierAmount() {
    return totalFeesSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesSupplierAmount) {
    this.totalFeesSupplierAmount = totalFeesSupplierAmount;
  }

  public BookingContractAgent totalFeesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesInternalAmount) {
    
    this.totalFeesInternalAmount = totalFeesInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency the affiliate is owed.
   * @return totalFeesInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesInternalAmount() {
    return totalFeesInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesInternalAmount) {
    this.totalFeesInternalAmount = totalFeesInternalAmount;
  }

  public BookingContractAgent totalTripPayFeeSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalTripPayFeeSourceAmount) {
    
    this.totalTripPayFeeSourceAmount = totalTripPayFeeSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency that is fees and commission.
   * @return totalTripPayFeeSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalTripPayFeeSourceAmount() {
    return totalTripPayFeeSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTripPayFeeSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalTripPayFeeSourceAmount) {
    this.totalTripPayFeeSourceAmount = totalTripPayFeeSourceAmount;
  }

  public BookingContractAgent totalTripPayFeeCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalTripPayFeeCaptureAmount) {
    
    this.totalTripPayFeeCaptureAmount = totalTripPayFeeCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency the affiliate is owed.
   * @return totalTripPayFeeCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalTripPayFeeCaptureAmount() {
    return totalTripPayFeeCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTripPayFeeCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalTripPayFeeCaptureAmount) {
    this.totalTripPayFeeCaptureAmount = totalTripPayFeeCaptureAmount;
  }

  public BookingContractAgent totalTripPayFeeDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalTripPayFeeDisplayAmount) {
    
    this.totalTripPayFeeDisplayAmount = totalTripPayFeeDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency the affiliate is owed.
   * @return totalTripPayFeeDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalTripPayFeeDisplayAmount() {
    return totalTripPayFeeDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTripPayFeeDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalTripPayFeeDisplayAmount) {
    this.totalTripPayFeeDisplayAmount = totalTripPayFeeDisplayAmount;
  }

  public BookingContractAgent totalTripPayFeeSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalTripPayFeeSupplierAmount) {
    
    this.totalTripPayFeeSupplierAmount = totalTripPayFeeSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency the affiliate is owed.
   * @return totalTripPayFeeSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalTripPayFeeSupplierAmount() {
    return totalTripPayFeeSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTripPayFeeSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalTripPayFeeSupplierAmount) {
    this.totalTripPayFeeSupplierAmount = totalTripPayFeeSupplierAmount;
  }

  public BookingContractAgent totalTripPayFeeInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalTripPayFeeInternalAmount) {
    
    this.totalTripPayFeeInternalAmount = totalTripPayFeeInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency the affiliate is owed.
   * @return totalTripPayFeeInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalTripPayFeeInternalAmount() {
    return totalTripPayFeeInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTripPayFeeInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalTripPayFeeInternalAmount) {
    this.totalTripPayFeeInternalAmount = totalTripPayFeeInternalAmount;
  }

  public BookingContractAgent totalSalesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSalesSourceAmount) {
    
    this.totalSalesSourceAmount = totalSalesSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency that is fees and commission.
   * @return totalSalesSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSalesSourceAmount() {
    return totalSalesSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSalesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSalesSourceAmount) {
    this.totalSalesSourceAmount = totalSalesSourceAmount;
  }

  public BookingContractAgent totalSalesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSalesCaptureAmount) {
    
    this.totalSalesCaptureAmount = totalSalesCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency the affiliate is owed.
   * @return totalSalesCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSalesCaptureAmount() {
    return totalSalesCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSalesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSalesCaptureAmount) {
    this.totalSalesCaptureAmount = totalSalesCaptureAmount;
  }

  public BookingContractAgent totalSalesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSalesDisplayAmount) {
    
    this.totalSalesDisplayAmount = totalSalesDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency the affiliate is owed.
   * @return totalSalesDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSalesDisplayAmount() {
    return totalSalesDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSalesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSalesDisplayAmount) {
    this.totalSalesDisplayAmount = totalSalesDisplayAmount;
  }

  public BookingContractAgent totalSalesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSalesSupplierAmount) {
    
    this.totalSalesSupplierAmount = totalSalesSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency the affiliate is owed.
   * @return totalSalesSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSalesSupplierAmount() {
    return totalSalesSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSalesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSalesSupplierAmount) {
    this.totalSalesSupplierAmount = totalSalesSupplierAmount;
  }

  public BookingContractAgent totalSalesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSalesInternalAmount) {
    
    this.totalSalesInternalAmount = totalSalesInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency the affiliate is owed.
   * @return totalSalesInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSalesInternalAmount() {
    return totalSalesInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSalesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSalesInternalAmount) {
    this.totalSalesInternalAmount = totalSalesInternalAmount;
  }

  public BookingContractAgent fundsAvailableDate(@jakarta.annotation.Nullable LocalDate fundsAvailableDate) {
    
    this.fundsAvailableDate = fundsAvailableDate;
    return this;
  }

  /**
   * Returns the date the funds will be released to the customer.
   * @return fundsAvailableDate
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FUNDS_AVAILABLE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getFundsAvailableDate() {
    return fundsAvailableDate;
  }


  @JsonProperty(JSON_PROPERTY_FUNDS_AVAILABLE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundsAvailableDate(@jakarta.annotation.Nullable LocalDate fundsAvailableDate) {
    this.fundsAvailableDate = fundsAvailableDate;
  }

  public BookingContractAgent totalFeesInPercentWithRefund(@jakarta.annotation.Nullable Float totalFeesInPercentWithRefund) {
    
    this.totalFeesInPercentWithRefund = totalFeesInPercentWithRefund;
    return this;
  }

  /**
   * All amounts that are not of type SALE
   * @return totalFeesInPercentWithRefund
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalFeesInPercentWithRefund() {
    return totalFeesInPercentWithRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesInPercentWithRefund(@jakarta.annotation.Nullable Float totalFeesInPercentWithRefund) {
    this.totalFeesInPercentWithRefund = totalFeesInPercentWithRefund;
  }

  public BookingContractAgent totalFeesInPercent(@jakarta.annotation.Nullable Float totalFeesInPercent) {
    
    this.totalFeesInPercent = totalFeesInPercent;
    return this;
  }

  /**
   * All amounts that are not of type SALE before a refund was applied
   * @return totalFeesInPercent
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalFeesInPercent() {
    return totalFeesInPercent;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesInPercent(@jakarta.annotation.Nullable Float totalFeesInPercent) {
    this.totalFeesInPercent = totalFeesInPercent;
  }

  public BookingContractAgent totalTripPayFeeInPercentWithRefund(@jakarta.annotation.Nullable Float totalTripPayFeeInPercentWithRefund) {
    
    this.totalTripPayFeeInPercentWithRefund = totalTripPayFeeInPercentWithRefund;
    return this;
  }

  /**
   * All amounts that are not of type SALE
   * @return totalTripPayFeeInPercentWithRefund
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalTripPayFeeInPercentWithRefund() {
    return totalTripPayFeeInPercentWithRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTripPayFeeInPercentWithRefund(@jakarta.annotation.Nullable Float totalTripPayFeeInPercentWithRefund) {
    this.totalTripPayFeeInPercentWithRefund = totalTripPayFeeInPercentWithRefund;
  }

  public BookingContractAgent totalTripPayFeeInPercent(@jakarta.annotation.Nullable Float totalTripPayFeeInPercent) {
    
    this.totalTripPayFeeInPercent = totalTripPayFeeInPercent;
    return this;
  }

  /**
   * All amounts that are not of type SALE before a refund was applied
   * @return totalTripPayFeeInPercent
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalTripPayFeeInPercent() {
    return totalTripPayFeeInPercent;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTripPayFeeInPercent(@jakarta.annotation.Nullable Float totalTripPayFeeInPercent) {
    this.totalTripPayFeeInPercent = totalTripPayFeeInPercent;
  }

  public BookingContractAgent totalCommissionsInPercentWithRefund(@jakarta.annotation.Nullable Float totalCommissionsInPercentWithRefund) {
    
    this.totalCommissionsInPercentWithRefund = totalCommissionsInPercentWithRefund;
    return this;
  }

  /**
   * All amounts that are not of type SALE
   * @return totalCommissionsInPercentWithRefund
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalCommissionsInPercentWithRefund() {
    return totalCommissionsInPercentWithRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalCommissionsInPercentWithRefund(@jakarta.annotation.Nullable Float totalCommissionsInPercentWithRefund) {
    this.totalCommissionsInPercentWithRefund = totalCommissionsInPercentWithRefund;
  }

  public BookingContractAgent totalCommissionsInPercent(@jakarta.annotation.Nullable Float totalCommissionsInPercent) {
    
    this.totalCommissionsInPercent = totalCommissionsInPercent;
    return this;
  }

  /**
   * All amounts that are not of type SALE before a refund was applied
   * @return totalCommissionsInPercent
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalCommissionsInPercent() {
    return totalCommissionsInPercent;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalCommissionsInPercent(@jakarta.annotation.Nullable Float totalCommissionsInPercent) {
    this.totalCommissionsInPercent = totalCommissionsInPercent;
  }

  public BookingContractAgent totalFeesAndCommissionsInPercentWithRefund(@jakarta.annotation.Nullable Float totalFeesAndCommissionsInPercentWithRefund) {
    
    this.totalFeesAndCommissionsInPercentWithRefund = totalFeesAndCommissionsInPercentWithRefund;
    return this;
  }

  /**
   * All amounts that are not of type SALE
   * @return totalFeesAndCommissionsInPercentWithRefund
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalFeesAndCommissionsInPercentWithRefund() {
    return totalFeesAndCommissionsInPercentWithRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesAndCommissionsInPercentWithRefund(@jakarta.annotation.Nullable Float totalFeesAndCommissionsInPercentWithRefund) {
    this.totalFeesAndCommissionsInPercentWithRefund = totalFeesAndCommissionsInPercentWithRefund;
  }

  public BookingContractAgent totalFeesAndCommissionsInPercent(@jakarta.annotation.Nullable Float totalFeesAndCommissionsInPercent) {
    
    this.totalFeesAndCommissionsInPercent = totalFeesAndCommissionsInPercent;
    return this;
  }

  /**
   * All amounts that are not of type SALE before a refund was applied
   * @return totalFeesAndCommissionsInPercent
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalFeesAndCommissionsInPercent() {
    return totalFeesAndCommissionsInPercent;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesAndCommissionsInPercent(@jakarta.annotation.Nullable Float totalFeesAndCommissionsInPercent) {
    this.totalFeesAndCommissionsInPercent = totalFeesAndCommissionsInPercent;
  }

  public BookingContractAgent originalFeesInPercent(@jakarta.annotation.Nullable BigDecimal originalFeesInPercent) {
    
    this.originalFeesInPercent = originalFeesInPercent;
    return this;
  }

  /**
   * All amounts that are not of type SALE before a refund was applied
   * @return originalFeesInPercent
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ORIGINAL_FEES_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getOriginalFeesInPercent() {
    return originalFeesInPercent;
  }


  @JsonProperty(JSON_PROPERTY_ORIGINAL_FEES_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOriginalFeesInPercent(@jakarta.annotation.Nullable BigDecimal originalFeesInPercent) {
    this.originalFeesInPercent = originalFeesInPercent;
  }

  public BookingContractAgent originalAffiliateAgencyFeesInPercent(@jakarta.annotation.Nullable BigDecimal originalAffiliateAgencyFeesInPercent) {
    
    this.originalAffiliateAgencyFeesInPercent = originalAffiliateAgencyFeesInPercent;
    return this;
  }

  /**
   * Affiliate agent fee in percent
   * @return originalAffiliateAgencyFeesInPercent
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ORIGINAL_AFFILIATE_AGENCY_FEES_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getOriginalAffiliateAgencyFeesInPercent() {
    return originalAffiliateAgencyFeesInPercent;
  }


  @JsonProperty(JSON_PROPERTY_ORIGINAL_AFFILIATE_AGENCY_FEES_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOriginalAffiliateAgencyFeesInPercent(@jakarta.annotation.Nullable BigDecimal originalAffiliateAgencyFeesInPercent) {
    this.originalAffiliateAgencyFeesInPercent = originalAffiliateAgencyFeesInPercent;
  }

  public BookingContractAgent originalSupplierAgencyFeesInPercent(@jakarta.annotation.Nullable BigDecimal originalSupplierAgencyFeesInPercent) {
    
    this.originalSupplierAgencyFeesInPercent = originalSupplierAgencyFeesInPercent;
    return this;
  }

  /**
   * Supplier agent fee in percent
   * @return originalSupplierAgencyFeesInPercent
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ORIGINAL_SUPPLIER_AGENCY_FEES_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getOriginalSupplierAgencyFeesInPercent() {
    return originalSupplierAgencyFeesInPercent;
  }


  @JsonProperty(JSON_PROPERTY_ORIGINAL_SUPPLIER_AGENCY_FEES_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOriginalSupplierAgencyFeesInPercent(@jakarta.annotation.Nullable BigDecimal originalSupplierAgencyFeesInPercent) {
    this.originalSupplierAgencyFeesInPercent = originalSupplierAgencyFeesInPercent;
  }

  public BookingContractAgent originalCommissionsInPercent(@jakarta.annotation.Nullable BigDecimal originalCommissionsInPercent) {
    
    this.originalCommissionsInPercent = originalCommissionsInPercent;
    return this;
  }

  /**
   * All amounts that are not of type SALE before a refund was applied
   * @return originalCommissionsInPercent
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ORIGINAL_COMMISSIONS_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getOriginalCommissionsInPercent() {
    return originalCommissionsInPercent;
  }


  @JsonProperty(JSON_PROPERTY_ORIGINAL_COMMISSIONS_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOriginalCommissionsInPercent(@jakarta.annotation.Nullable BigDecimal originalCommissionsInPercent) {
    this.originalCommissionsInPercent = originalCommissionsInPercent;
  }

  public BookingContractAgent netTotalCustomersSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalCustomersSourceAmount) {
    
    this.netTotalCustomersSourceAmount = netTotalCustomersSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency that is fees and commission.
   * @return netTotalCustomersSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalCustomersSourceAmount() {
    return netTotalCustomersSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalCustomersSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalCustomersSourceAmount) {
    this.netTotalCustomersSourceAmount = netTotalCustomersSourceAmount;
  }

  public BookingContractAgent netTotalCustomersCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalCustomersCaptureAmount) {
    
    this.netTotalCustomersCaptureAmount = netTotalCustomersCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency the affiliate is owed.
   * @return netTotalCustomersCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalCustomersCaptureAmount() {
    return netTotalCustomersCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalCustomersCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalCustomersCaptureAmount) {
    this.netTotalCustomersCaptureAmount = netTotalCustomersCaptureAmount;
  }

  public BookingContractAgent netTotalCustomersDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalCustomersDisplayAmount) {
    
    this.netTotalCustomersDisplayAmount = netTotalCustomersDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency the affiliate is owed.
   * @return netTotalCustomersDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalCustomersDisplayAmount() {
    return netTotalCustomersDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalCustomersDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalCustomersDisplayAmount) {
    this.netTotalCustomersDisplayAmount = netTotalCustomersDisplayAmount;
  }

  public BookingContractAgent netTotalCustomersSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalCustomersSupplierAmount) {
    
    this.netTotalCustomersSupplierAmount = netTotalCustomersSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency the affiliate is owed.
   * @return netTotalCustomersSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalCustomersSupplierAmount() {
    return netTotalCustomersSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalCustomersSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalCustomersSupplierAmount) {
    this.netTotalCustomersSupplierAmount = netTotalCustomersSupplierAmount;
  }

  public BookingContractAgent netTotalCustomersInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalCustomersInternalAmount) {
    
    this.netTotalCustomersInternalAmount = netTotalCustomersInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency the affiliate is owed.
   * @return netTotalCustomersInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalCustomersInternalAmount() {
    return netTotalCustomersInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalCustomersInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalCustomersInternalAmount) {
    this.netTotalCustomersInternalAmount = netTotalCustomersInternalAmount;
  }

  public BookingContractAgent totalAffiliateAgencyFeesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalAffiliateAgencyFeesSourceAmount) {
    
    this.totalAffiliateAgencyFeesSourceAmount = totalAffiliateAgencyFeesSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency owed affiliate agency.
   * @return totalAffiliateAgencyFeesSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalAffiliateAgencyFeesSourceAmount() {
    return totalAffiliateAgencyFeesSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalAffiliateAgencyFeesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalAffiliateAgencyFeesSourceAmount) {
    this.totalAffiliateAgencyFeesSourceAmount = totalAffiliateAgencyFeesSourceAmount;
  }

  public BookingContractAgent totalAffiliateAgencyFeesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalAffiliateAgencyFeesCaptureAmount) {
    
    this.totalAffiliateAgencyFeesCaptureAmount = totalAffiliateAgencyFeesCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency owed affiliate agency.
   * @return totalAffiliateAgencyFeesCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalAffiliateAgencyFeesCaptureAmount() {
    return totalAffiliateAgencyFeesCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalAffiliateAgencyFeesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalAffiliateAgencyFeesCaptureAmount) {
    this.totalAffiliateAgencyFeesCaptureAmount = totalAffiliateAgencyFeesCaptureAmount;
  }

  public BookingContractAgent totalAffiliateAgencyFeesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalAffiliateAgencyFeesDisplayAmount) {
    
    this.totalAffiliateAgencyFeesDisplayAmount = totalAffiliateAgencyFeesDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency owed affiliate agency.
   * @return totalAffiliateAgencyFeesDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalAffiliateAgencyFeesDisplayAmount() {
    return totalAffiliateAgencyFeesDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalAffiliateAgencyFeesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalAffiliateAgencyFeesDisplayAmount) {
    this.totalAffiliateAgencyFeesDisplayAmount = totalAffiliateAgencyFeesDisplayAmount;
  }

  public BookingContractAgent totalAffiliateAgencyFeesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalAffiliateAgencyFeesSupplierAmount) {
    
    this.totalAffiliateAgencyFeesSupplierAmount = totalAffiliateAgencyFeesSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency owed affiliate agency.
   * @return totalAffiliateAgencyFeesSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalAffiliateAgencyFeesSupplierAmount() {
    return totalAffiliateAgencyFeesSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalAffiliateAgencyFeesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalAffiliateAgencyFeesSupplierAmount) {
    this.totalAffiliateAgencyFeesSupplierAmount = totalAffiliateAgencyFeesSupplierAmount;
  }

  public BookingContractAgent totalAffiliateAgencyFeesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalAffiliateAgencyFeesInternalAmount) {
    
    this.totalAffiliateAgencyFeesInternalAmount = totalAffiliateAgencyFeesInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency owed affiliate agency.
   * @return totalAffiliateAgencyFeesInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalAffiliateAgencyFeesInternalAmount() {
    return totalAffiliateAgencyFeesInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalAffiliateAgencyFeesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalAffiliateAgencyFeesInternalAmount) {
    this.totalAffiliateAgencyFeesInternalAmount = totalAffiliateAgencyFeesInternalAmount;
  }

  public BookingContractAgent totalSupplierAgencyFeesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSupplierAgencyFeesSourceAmount) {
    
    this.totalSupplierAgencyFeesSourceAmount = totalSupplierAgencyFeesSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency owed supplier agency.
   * @return totalSupplierAgencyFeesSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSupplierAgencyFeesSourceAmount() {
    return totalSupplierAgencyFeesSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSupplierAgencyFeesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSupplierAgencyFeesSourceAmount) {
    this.totalSupplierAgencyFeesSourceAmount = totalSupplierAgencyFeesSourceAmount;
  }

  public BookingContractAgent totalSupplierAgencyFeesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSupplierAgencyFeesCaptureAmount) {
    
    this.totalSupplierAgencyFeesCaptureAmount = totalSupplierAgencyFeesCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency owed supplier agency.
   * @return totalSupplierAgencyFeesCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSupplierAgencyFeesCaptureAmount() {
    return totalSupplierAgencyFeesCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSupplierAgencyFeesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSupplierAgencyFeesCaptureAmount) {
    this.totalSupplierAgencyFeesCaptureAmount = totalSupplierAgencyFeesCaptureAmount;
  }

  public BookingContractAgent totalSupplierAgencyFeesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSupplierAgencyFeesDisplayAmount) {
    
    this.totalSupplierAgencyFeesDisplayAmount = totalSupplierAgencyFeesDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency owed supplier agency.
   * @return totalSupplierAgencyFeesDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSupplierAgencyFeesDisplayAmount() {
    return totalSupplierAgencyFeesDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSupplierAgencyFeesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSupplierAgencyFeesDisplayAmount) {
    this.totalSupplierAgencyFeesDisplayAmount = totalSupplierAgencyFeesDisplayAmount;
  }

  public BookingContractAgent totalSupplierAgencyFeesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSupplierAgencyFeesSupplierAmount) {
    
    this.totalSupplierAgencyFeesSupplierAmount = totalSupplierAgencyFeesSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency owed supplier agency.
   * @return totalSupplierAgencyFeesSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSupplierAgencyFeesSupplierAmount() {
    return totalSupplierAgencyFeesSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSupplierAgencyFeesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSupplierAgencyFeesSupplierAmount) {
    this.totalSupplierAgencyFeesSupplierAmount = totalSupplierAgencyFeesSupplierAmount;
  }

  public BookingContractAgent totalSupplierAgencyFeesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSupplierAgencyFeesInternalAmount) {
    
    this.totalSupplierAgencyFeesInternalAmount = totalSupplierAgencyFeesInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency owed supplier agency.
   * @return totalSupplierAgencyFeesInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSupplierAgencyFeesInternalAmount() {
    return totalSupplierAgencyFeesInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSupplierAgencyFeesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSupplierAgencyFeesInternalAmount) {
    this.totalSupplierAgencyFeesInternalAmount = totalSupplierAgencyFeesInternalAmount;
  }

  public BookingContractAgent netTotalAffiliateAgencyFeesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalAffiliateAgencyFeesSourceAmount) {
    
    this.netTotalAffiliateAgencyFeesSourceAmount = netTotalAffiliateAgencyFeesSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency owed affiliate agency.
   * @return netTotalAffiliateAgencyFeesSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalAffiliateAgencyFeesSourceAmount() {
    return netTotalAffiliateAgencyFeesSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalAffiliateAgencyFeesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalAffiliateAgencyFeesSourceAmount) {
    this.netTotalAffiliateAgencyFeesSourceAmount = netTotalAffiliateAgencyFeesSourceAmount;
  }

  public BookingContractAgent netTotalAffiliateAgencyFeesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalAffiliateAgencyFeesCaptureAmount) {
    
    this.netTotalAffiliateAgencyFeesCaptureAmount = netTotalAffiliateAgencyFeesCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency owed affiliate agency.
   * @return netTotalAffiliateAgencyFeesCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalAffiliateAgencyFeesCaptureAmount() {
    return netTotalAffiliateAgencyFeesCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalAffiliateAgencyFeesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalAffiliateAgencyFeesCaptureAmount) {
    this.netTotalAffiliateAgencyFeesCaptureAmount = netTotalAffiliateAgencyFeesCaptureAmount;
  }

  public BookingContractAgent netTotalAffiliateAgencyFeesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalAffiliateAgencyFeesDisplayAmount) {
    
    this.netTotalAffiliateAgencyFeesDisplayAmount = netTotalAffiliateAgencyFeesDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency owed affiliate agency.
   * @return netTotalAffiliateAgencyFeesDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalAffiliateAgencyFeesDisplayAmount() {
    return netTotalAffiliateAgencyFeesDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalAffiliateAgencyFeesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalAffiliateAgencyFeesDisplayAmount) {
    this.netTotalAffiliateAgencyFeesDisplayAmount = netTotalAffiliateAgencyFeesDisplayAmount;
  }

  public BookingContractAgent netTotalAffiliateAgencyFeesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalAffiliateAgencyFeesSupplierAmount) {
    
    this.netTotalAffiliateAgencyFeesSupplierAmount = netTotalAffiliateAgencyFeesSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency owed affiliate agency.
   * @return netTotalAffiliateAgencyFeesSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalAffiliateAgencyFeesSupplierAmount() {
    return netTotalAffiliateAgencyFeesSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalAffiliateAgencyFeesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalAffiliateAgencyFeesSupplierAmount) {
    this.netTotalAffiliateAgencyFeesSupplierAmount = netTotalAffiliateAgencyFeesSupplierAmount;
  }

  public BookingContractAgent netTotalAffiliateAgencyFeesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalAffiliateAgencyFeesInternalAmount) {
    
    this.netTotalAffiliateAgencyFeesInternalAmount = netTotalAffiliateAgencyFeesInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency owed affiliate agency.
   * @return netTotalAffiliateAgencyFeesInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalAffiliateAgencyFeesInternalAmount() {
    return netTotalAffiliateAgencyFeesInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalAffiliateAgencyFeesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalAffiliateAgencyFeesInternalAmount) {
    this.netTotalAffiliateAgencyFeesInternalAmount = netTotalAffiliateAgencyFeesInternalAmount;
  }

  public BookingContractAgent netTotalSupplierAgencyFeesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSupplierAgencyFeesSourceAmount) {
    
    this.netTotalSupplierAgencyFeesSourceAmount = netTotalSupplierAgencyFeesSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency owed supplier agency.
   * @return netTotalSupplierAgencyFeesSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSupplierAgencyFeesSourceAmount() {
    return netTotalSupplierAgencyFeesSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSupplierAgencyFeesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSupplierAgencyFeesSourceAmount) {
    this.netTotalSupplierAgencyFeesSourceAmount = netTotalSupplierAgencyFeesSourceAmount;
  }

  public BookingContractAgent netTotalSupplierAgencyFeesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSupplierAgencyFeesCaptureAmount) {
    
    this.netTotalSupplierAgencyFeesCaptureAmount = netTotalSupplierAgencyFeesCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency owed supplier agency.
   * @return netTotalSupplierAgencyFeesCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSupplierAgencyFeesCaptureAmount() {
    return netTotalSupplierAgencyFeesCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSupplierAgencyFeesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSupplierAgencyFeesCaptureAmount) {
    this.netTotalSupplierAgencyFeesCaptureAmount = netTotalSupplierAgencyFeesCaptureAmount;
  }

  public BookingContractAgent netTotalSupplierAgencyFeesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSupplierAgencyFeesDisplayAmount) {
    
    this.netTotalSupplierAgencyFeesDisplayAmount = netTotalSupplierAgencyFeesDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency owed supplier agency.
   * @return netTotalSupplierAgencyFeesDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSupplierAgencyFeesDisplayAmount() {
    return netTotalSupplierAgencyFeesDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSupplierAgencyFeesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSupplierAgencyFeesDisplayAmount) {
    this.netTotalSupplierAgencyFeesDisplayAmount = netTotalSupplierAgencyFeesDisplayAmount;
  }

  public BookingContractAgent netTotalSupplierAgencyFeesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSupplierAgencyFeesSupplierAmount) {
    
    this.netTotalSupplierAgencyFeesSupplierAmount = netTotalSupplierAgencyFeesSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency owed supplier agency.
   * @return netTotalSupplierAgencyFeesSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSupplierAgencyFeesSupplierAmount() {
    return netTotalSupplierAgencyFeesSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSupplierAgencyFeesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSupplierAgencyFeesSupplierAmount) {
    this.netTotalSupplierAgencyFeesSupplierAmount = netTotalSupplierAgencyFeesSupplierAmount;
  }

  public BookingContractAgent netTotalSupplierAgencyFeesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSupplierAgencyFeesInternalAmount) {
    
    this.netTotalSupplierAgencyFeesInternalAmount = netTotalSupplierAgencyFeesInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency owed supplier agency.
   * @return netTotalSupplierAgencyFeesInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSupplierAgencyFeesInternalAmount() {
    return netTotalSupplierAgencyFeesInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSupplierAgencyFeesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSupplierAgencyFeesInternalAmount) {
    this.netTotalSupplierAgencyFeesInternalAmount = netTotalSupplierAgencyFeesInternalAmount;
  }

  public BookingContractAgent hasRefunds(@jakarta.annotation.Nullable Boolean hasRefunds) {
    
    this.hasRefunds = hasRefunds;
    return this;
  }

  /**
   * Indicates whether any refund in any state is present.
   * @return hasRefunds
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasRefunds() {
    return hasRefunds;
  }


  @JsonProperty(JSON_PROPERTY_HAS_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasRefunds(@jakarta.annotation.Nullable Boolean hasRefunds) {
    this.hasRefunds = hasRefunds;
  }

  public BookingContractAgent hasSuccessfulRefunds(@jakarta.annotation.Nullable Boolean hasSuccessfulRefunds) {
    
    this.hasSuccessfulRefunds = hasSuccessfulRefunds;
    return this;
  }

  /**
   * Indicates whether a successful refund is present.
   * @return hasSuccessfulRefunds
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_SUCCESSFUL_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasSuccessfulRefunds() {
    return hasSuccessfulRefunds;
  }


  @JsonProperty(JSON_PROPERTY_HAS_SUCCESSFUL_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasSuccessfulRefunds(@jakarta.annotation.Nullable Boolean hasSuccessfulRefunds) {
    this.hasSuccessfulRefunds = hasSuccessfulRefunds;
  }

  public BookingContractAgent hasPendingRefunds(@jakarta.annotation.Nullable Boolean hasPendingRefunds) {
    
    this.hasPendingRefunds = hasPendingRefunds;
    return this;
  }

  /**
   * Indicates whether a pending refund is present.
   * @return hasPendingRefunds
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_PENDING_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasPendingRefunds() {
    return hasPendingRefunds;
  }


  @JsonProperty(JSON_PROPERTY_HAS_PENDING_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasPendingRefunds(@jakarta.annotation.Nullable Boolean hasPendingRefunds) {
    this.hasPendingRefunds = hasPendingRefunds;
  }

  public BookingContractAgent hasFailedRefunds(@jakarta.annotation.Nullable Boolean hasFailedRefunds) {
    
    this.hasFailedRefunds = hasFailedRefunds;
    return this;
  }

  /**
   * Indicates whether a failed refund is present.
   * @return hasFailedRefunds
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_FAILED_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasFailedRefunds() {
    return hasFailedRefunds;
  }


  @JsonProperty(JSON_PROPERTY_HAS_FAILED_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasFailedRefunds(@jakarta.annotation.Nullable Boolean hasFailedRefunds) {
    this.hasFailedRefunds = hasFailedRefunds;
  }

  public BookingContractAgent platformIdentifier(@jakarta.annotation.Nullable String platformIdentifier) {
    
    this.platformIdentifier = platformIdentifier;
    return this;
  }

  /**
   * Returns the account identifier for the beneficiary taking a platform fee
   * @return platformIdentifier
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PLATFORM_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPlatformIdentifier() {
    return platformIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_PLATFORM_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlatformIdentifier(@jakarta.annotation.Nullable String platformIdentifier) {
    this.platformIdentifier = platformIdentifier;
  }

  public BookingContractAgent totalFundsGroupedByBeneficiary(@jakarta.annotation.Nullable List<@Valid BeneficiaryAgent> totalFundsGroupedByBeneficiary) {
    
    this.totalFundsGroupedByBeneficiary = totalFundsGroupedByBeneficiary;
    return this;
  }

  public BookingContractAgent addTotalFundsGroupedByBeneficiaryItem(BeneficiaryAgent totalFundsGroupedByBeneficiaryItem) {
    if (this.totalFundsGroupedByBeneficiary == null) {
      this.totalFundsGroupedByBeneficiary = new ArrayList<>();
    }
    this.totalFundsGroupedByBeneficiary.add(totalFundsGroupedByBeneficiaryItem);
    return this;
  }

  /**
   * Returns all the beneficiaries in this contract with their total amounts
   * @return totalFundsGroupedByBeneficiary
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FUNDS_GROUPED_BY_BENEFICIARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid BeneficiaryAgent> getTotalFundsGroupedByBeneficiary() {
    return totalFundsGroupedByBeneficiary;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FUNDS_GROUPED_BY_BENEFICIARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFundsGroupedByBeneficiary(@jakarta.annotation.Nullable List<@Valid BeneficiaryAgent> totalFundsGroupedByBeneficiary) {
    this.totalFundsGroupedByBeneficiary = totalFundsGroupedByBeneficiary;
  }

  public BookingContractAgent totalTokensEarned(@jakarta.annotation.Nullable Long totalTokensEarned) {
    
    this.totalTokensEarned = totalTokensEarned;
    return this;
  }

  /**
   * Total amount of tokens minted on this contract.
   * @return totalTokensEarned
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_TOKENS_EARNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTotalTokensEarned() {
    return totalTokensEarned;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TOKENS_EARNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTokensEarned(@jakarta.annotation.Nullable Long totalTokensEarned) {
    this.totalTokensEarned = totalTokensEarned;
  }

  public BookingContractAgent selfAcquiring(@jakarta.annotation.Nullable Boolean selfAcquiring) {
    
    this.selfAcquiring = selfAcquiring;
    return this;
  }

  /**
   * Get selfAcquiring
   * @return selfAcquiring
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SELF_ACQUIRING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSelfAcquiring() {
    return selfAcquiring;
  }


  @JsonProperty(JSON_PROPERTY_SELF_ACQUIRING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSelfAcquiring(@jakarta.annotation.Nullable Boolean selfAcquiring) {
    this.selfAcquiring = selfAcquiring;
  }

  public BookingContractAgent lodging(@jakarta.annotation.Nullable BookingContractItemAgent lodging) {
    
    this.lodging = lodging;
    return this;
  }

  /**
   * Returns the lodging item only.
   * @return lodging
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LODGING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BookingContractItemAgent getLodging() {
    return lodging;
  }


  @JsonProperty(JSON_PROPERTY_LODGING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLodging(@jakarta.annotation.Nullable BookingContractItemAgent lodging) {
    this.lodging = lodging;
  }

  public BookingContractAgent cancellableByAgent(@jakarta.annotation.Nullable Boolean cancellableByAgent) {
    
    this.cancellableByAgent = cancellableByAgent;
    return this;
  }

  /**
   * Whether the booking can still be cancelled completely by an agent.
   * @return cancellableByAgent
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_AGENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableByAgent() {
    return cancellableByAgent;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_AGENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableByAgent(@jakarta.annotation.Nullable Boolean cancellableByAgent) {
    this.cancellableByAgent = cancellableByAgent;
  }

  public BookingContractAgent cancellableBySupplier(@jakarta.annotation.Nullable Boolean cancellableBySupplier) {
    
    this.cancellableBySupplier = cancellableBySupplier;
    return this;
  }

  /**
   * Whether the booking can still be cancelled completely by the supplier.
   * @return cancellableBySupplier
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableBySupplier() {
    return cancellableBySupplier;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableBySupplier(@jakarta.annotation.Nullable Boolean cancellableBySupplier) {
    this.cancellableBySupplier = cancellableBySupplier;
  }

  public BookingContractAgent cancellableByTraveler(@jakarta.annotation.Nullable Boolean cancellableByTraveler) {
    
    this.cancellableByTraveler = cancellableByTraveler;
    return this;
  }

  /**
   * Whether the booking can still be cancelled completely by the traveller.
   * @return cancellableByTraveler
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableByTraveler() {
    return cancellableByTraveler;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableByTraveler(@jakarta.annotation.Nullable Boolean cancellableByTraveler) {
    this.cancellableByTraveler = cancellableByTraveler;
  }

  public BookingContractAgent fullyRefunded(@jakarta.annotation.Nullable Boolean fullyRefunded) {
    
    this.fullyRefunded = fullyRefunded;
    return this;
  }

  /**
   * Get fullyRefunded
   * @return fullyRefunded
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FULLY_REFUNDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getFullyRefunded() {
    return fullyRefunded;
  }


  @JsonProperty(JSON_PROPERTY_FULLY_REFUNDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFullyRefunded(@jakarta.annotation.Nullable Boolean fullyRefunded) {
    this.fullyRefunded = fullyRefunded;
  }

  public BookingContractAgent cancellableWithNoCharges(@jakarta.annotation.Nullable Boolean cancellableWithNoCharges) {
    
    this.cancellableWithNoCharges = cancellableWithNoCharges;
    return this;
  }

  /**
   * Whether the cancellation comes at no cost to the traveler.
   * @return cancellableWithNoCharges
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableWithNoCharges() {
    return cancellableWithNoCharges;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableWithNoCharges(@jakarta.annotation.Nullable Boolean cancellableWithNoCharges) {
    this.cancellableWithNoCharges = cancellableWithNoCharges;
  }

  public BookingContractAgent isCancellableWithPotentialCharges(@jakarta.annotation.Nullable Boolean isCancellableWithPotentialCharges) {
    
    this.isCancellableWithPotentialCharges = isCancellableWithPotentialCharges;
    return this;
  }

  /**
   * Whether a cancellation comes with partial charges. I.e. Only some of the items in contract are not fully refundable.
   * @return isCancellableWithPotentialCharges
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IS_CANCELLABLE_WITH_POTENTIAL_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsCancellableWithPotentialCharges() {
    return isCancellableWithPotentialCharges;
  }


  @JsonProperty(JSON_PROPERTY_IS_CANCELLABLE_WITH_POTENTIAL_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsCancellableWithPotentialCharges(@jakarta.annotation.Nullable Boolean isCancellableWithPotentialCharges) {
    this.isCancellableWithPotentialCharges = isCancellableWithPotentialCharges;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingContractAgent bookingContractAgent = (BookingContractAgent) o;
    return Objects.equals(this.bookingContractIdentifier, bookingContractAgent.bookingContractIdentifier) &&
        Objects.equals(this.createdDate, bookingContractAgent.createdDate) &&
        Objects.equals(this.lastUpdate, bookingContractAgent.lastUpdate) &&
        Objects.equals(this.federatedOrganizationIdentifier, bookingContractAgent.federatedOrganizationIdentifier) &&
        Objects.equals(this.federatedOrganizationName, bookingContractAgent.federatedOrganizationName) &&
        Objects.equals(this.user, bookingContractAgent.user) &&
        Objects.equals(this.ipAddress, bookingContractAgent.ipAddress) &&
        Objects.equals(this.traceId, bookingContractAgent.traceId) &&
        Objects.equals(this.sourceUrl, bookingContractAgent.sourceUrl) &&
        Objects.equals(this.identifier, bookingContractAgent.identifier) &&
        Objects.equals(this.supplierIdentifier, bookingContractAgent.supplierIdentifier) &&
        Objects.equals(this.supplierName, bookingContractAgent.supplierName) &&
        Objects.equals(this.displayPriceQuote, bookingContractAgent.displayPriceQuote) &&
        Objects.equals(this.supplierPriceQuote, bookingContractAgent.supplierPriceQuote) &&
        Objects.equals(this.internalPriceQuote, bookingContractAgent.internalPriceQuote) &&
        Objects.equals(this.capturePriceQuote, bookingContractAgent.capturePriceQuote) &&
        Objects.equals(this.itemList, bookingContractAgent.itemList) &&
        Objects.equals(this.externalSupplierIdentifier, bookingContractAgent.externalSupplierIdentifier) &&
        Objects.equals(this.externalSupplierBookingCode, bookingContractAgent.externalSupplierBookingCode) &&
        Objects.equals(this.payment, bookingContractAgent.payment) &&
        Objects.equals(this.cancelled, bookingContractAgent.cancelled) &&
        Objects.equals(this.cancelledOn, bookingContractAgent.cancelledOn) &&
        Objects.equals(this.canceller, bookingContractAgent.canceller) &&
        Objects.equals(this.cancellationType, bookingContractAgent.cancellationType) &&
        Objects.equals(this.cancellerUserIdentifier, bookingContractAgent.cancellerUserIdentifier) &&
        Objects.equals(this.cancelReason, bookingContractAgent.cancelReason) &&
        Objects.equals(this.fundsProcessed, bookingContractAgent.fundsProcessed) &&
        Objects.equals(this.refunds, bookingContractAgent.refunds) &&
        Objects.equals(this.payouts, bookingContractAgent.payouts) &&
        Objects.equals(this.sourceCurrency, bookingContractAgent.sourceCurrency) &&
        Objects.equals(this.displayCurrency, bookingContractAgent.displayCurrency) &&
        Objects.equals(this.supplierCurrency, bookingContractAgent.supplierCurrency) &&
        Objects.equals(this.internalCurrency, bookingContractAgent.internalCurrency) &&
        Objects.equals(this.captureCurrency, bookingContractAgent.captureCurrency) &&
        Objects.equals(this.sourceAmount, bookingContractAgent.sourceAmount) &&
        Objects.equals(this.displayAmount, bookingContractAgent.displayAmount) &&
        Objects.equals(this.supplierAmount, bookingContractAgent.supplierAmount) &&
        Objects.equals(this.internalAmount, bookingContractAgent.internalAmount) &&
        Objects.equals(this.captureAmount, bookingContractAgent.captureAmount) &&
        Objects.equals(this.sourceAmountRefundModifier, bookingContractAgent.sourceAmountRefundModifier) &&
        Objects.equals(this.displayAmountRefundModifier, bookingContractAgent.displayAmountRefundModifier) &&
        Objects.equals(this.supplierAmountRefundModifier, bookingContractAgent.supplierAmountRefundModifier) &&
        Objects.equals(this.internalAmountRefundModifier, bookingContractAgent.internalAmountRefundModifier) &&
        Objects.equals(this.captureAmountRefundModifier, bookingContractAgent.captureAmountRefundModifier) &&
        Objects.equals(this.netSourceAmount, bookingContractAgent.netSourceAmount) &&
        Objects.equals(this.netDisplayAmount, bookingContractAgent.netDisplayAmount) &&
        Objects.equals(this.netSupplierAmount, bookingContractAgent.netSupplierAmount) &&
        Objects.equals(this.netInternalAmount, bookingContractAgent.netInternalAmount) &&
        Objects.equals(this.netCaptureAmount, bookingContractAgent.netCaptureAmount) &&
        Objects.equals(this.metadata, bookingContractAgent.metadata) &&
        Objects.equals(this.netCommissionableTotalSourceAmount, bookingContractAgent.netCommissionableTotalSourceAmount) &&
        Objects.equals(this.netCommissionableTotalCaptureAmount, bookingContractAgent.netCommissionableTotalCaptureAmount) &&
        Objects.equals(this.netCommissionableTotalDisplayAmount, bookingContractAgent.netCommissionableTotalDisplayAmount) &&
        Objects.equals(this.netCommissionableTotalSupplierAmount, bookingContractAgent.netCommissionableTotalSupplierAmount) &&
        Objects.equals(this.netCommissionableTotalInternalAmount, bookingContractAgent.netCommissionableTotalInternalAmount) &&
        Objects.equals(this.netTotalFeesAndCommissionsSourceAmount, bookingContractAgent.netTotalFeesAndCommissionsSourceAmount) &&
        Objects.equals(this.netTotalFeesAndCommissionsCaptureAmount, bookingContractAgent.netTotalFeesAndCommissionsCaptureAmount) &&
        Objects.equals(this.netTotalFeesAndCommissionsDisplayAmount, bookingContractAgent.netTotalFeesAndCommissionsDisplayAmount) &&
        Objects.equals(this.netTotalFeesAndCommissionsSupplierAmount, bookingContractAgent.netTotalFeesAndCommissionsSupplierAmount) &&
        Objects.equals(this.netTotalFeesAndCommissionsInternalAmount, bookingContractAgent.netTotalFeesAndCommissionsInternalAmount) &&
        Objects.equals(this.netTotalFeesSourceAmount, bookingContractAgent.netTotalFeesSourceAmount) &&
        Objects.equals(this.netTotalFeesCaptureAmount, bookingContractAgent.netTotalFeesCaptureAmount) &&
        Objects.equals(this.netTotalFeesDisplayAmount, bookingContractAgent.netTotalFeesDisplayAmount) &&
        Objects.equals(this.netTotalFeesSupplierAmount, bookingContractAgent.netTotalFeesSupplierAmount) &&
        Objects.equals(this.netTotalFeesInternalAmount, bookingContractAgent.netTotalFeesInternalAmount) &&
        Objects.equals(this.netTotalTripPayFeeSourceAmount, bookingContractAgent.netTotalTripPayFeeSourceAmount) &&
        Objects.equals(this.netTotalTripPayFeeCaptureAmount, bookingContractAgent.netTotalTripPayFeeCaptureAmount) &&
        Objects.equals(this.netTotalTripPayFeeDisplayAmount, bookingContractAgent.netTotalTripPayFeeDisplayAmount) &&
        Objects.equals(this.netTotalTripPayFeeSupplierAmount, bookingContractAgent.netTotalTripPayFeeSupplierAmount) &&
        Objects.equals(this.netTotalTripPayFeeInternalAmount, bookingContractAgent.netTotalTripPayFeeInternalAmount) &&
        Objects.equals(this.netTotalSalesSourceAmount, bookingContractAgent.netTotalSalesSourceAmount) &&
        Objects.equals(this.netTotalSalesCaptureAmount, bookingContractAgent.netTotalSalesCaptureAmount) &&
        Objects.equals(this.netTotalSalesDisplayAmount, bookingContractAgent.netTotalSalesDisplayAmount) &&
        Objects.equals(this.netTotalSalesSupplierAmount, bookingContractAgent.netTotalSalesSupplierAmount) &&
        Objects.equals(this.netTotalSalesInternalAmount, bookingContractAgent.netTotalSalesInternalAmount) &&
        Objects.equals(this.commissionableTotalSourceAmount, bookingContractAgent.commissionableTotalSourceAmount) &&
        Objects.equals(this.commissionableTotalCaptureAmount, bookingContractAgent.commissionableTotalCaptureAmount) &&
        Objects.equals(this.commissionableTotalDisplayAmount, bookingContractAgent.commissionableTotalDisplayAmount) &&
        Objects.equals(this.commissionableTotalSupplierAmount, bookingContractAgent.commissionableTotalSupplierAmount) &&
        Objects.equals(this.commissionableTotalInternalAmount, bookingContractAgent.commissionableTotalInternalAmount) &&
        Objects.equals(this.totalFeesAndCommissionsSourceAmount, bookingContractAgent.totalFeesAndCommissionsSourceAmount) &&
        Objects.equals(this.totalFeesAndCommissionsCaptureAmount, bookingContractAgent.totalFeesAndCommissionsCaptureAmount) &&
        Objects.equals(this.totalFeesAndCommissionsDisplayAmount, bookingContractAgent.totalFeesAndCommissionsDisplayAmount) &&
        Objects.equals(this.totalFeesAndCommissionsSupplierAmount, bookingContractAgent.totalFeesAndCommissionsSupplierAmount) &&
        Objects.equals(this.totalFeesAndCommissionsInternalAmount, bookingContractAgent.totalFeesAndCommissionsInternalAmount) &&
        Objects.equals(this.totalFeesSourceAmount, bookingContractAgent.totalFeesSourceAmount) &&
        Objects.equals(this.totalFeesCaptureAmount, bookingContractAgent.totalFeesCaptureAmount) &&
        Objects.equals(this.totalFeesDisplayAmount, bookingContractAgent.totalFeesDisplayAmount) &&
        Objects.equals(this.totalFeesSupplierAmount, bookingContractAgent.totalFeesSupplierAmount) &&
        Objects.equals(this.totalFeesInternalAmount, bookingContractAgent.totalFeesInternalAmount) &&
        Objects.equals(this.totalTripPayFeeSourceAmount, bookingContractAgent.totalTripPayFeeSourceAmount) &&
        Objects.equals(this.totalTripPayFeeCaptureAmount, bookingContractAgent.totalTripPayFeeCaptureAmount) &&
        Objects.equals(this.totalTripPayFeeDisplayAmount, bookingContractAgent.totalTripPayFeeDisplayAmount) &&
        Objects.equals(this.totalTripPayFeeSupplierAmount, bookingContractAgent.totalTripPayFeeSupplierAmount) &&
        Objects.equals(this.totalTripPayFeeInternalAmount, bookingContractAgent.totalTripPayFeeInternalAmount) &&
        Objects.equals(this.totalSalesSourceAmount, bookingContractAgent.totalSalesSourceAmount) &&
        Objects.equals(this.totalSalesCaptureAmount, bookingContractAgent.totalSalesCaptureAmount) &&
        Objects.equals(this.totalSalesDisplayAmount, bookingContractAgent.totalSalesDisplayAmount) &&
        Objects.equals(this.totalSalesSupplierAmount, bookingContractAgent.totalSalesSupplierAmount) &&
        Objects.equals(this.totalSalesInternalAmount, bookingContractAgent.totalSalesInternalAmount) &&
        Objects.equals(this.fundsAvailableDate, bookingContractAgent.fundsAvailableDate) &&
        Objects.equals(this.totalFeesInPercentWithRefund, bookingContractAgent.totalFeesInPercentWithRefund) &&
        Objects.equals(this.totalFeesInPercent, bookingContractAgent.totalFeesInPercent) &&
        Objects.equals(this.totalTripPayFeeInPercentWithRefund, bookingContractAgent.totalTripPayFeeInPercentWithRefund) &&
        Objects.equals(this.totalTripPayFeeInPercent, bookingContractAgent.totalTripPayFeeInPercent) &&
        Objects.equals(this.totalCommissionsInPercentWithRefund, bookingContractAgent.totalCommissionsInPercentWithRefund) &&
        Objects.equals(this.totalCommissionsInPercent, bookingContractAgent.totalCommissionsInPercent) &&
        Objects.equals(this.totalFeesAndCommissionsInPercentWithRefund, bookingContractAgent.totalFeesAndCommissionsInPercentWithRefund) &&
        Objects.equals(this.totalFeesAndCommissionsInPercent, bookingContractAgent.totalFeesAndCommissionsInPercent) &&
        Objects.equals(this.originalFeesInPercent, bookingContractAgent.originalFeesInPercent) &&
        Objects.equals(this.originalAffiliateAgencyFeesInPercent, bookingContractAgent.originalAffiliateAgencyFeesInPercent) &&
        Objects.equals(this.originalSupplierAgencyFeesInPercent, bookingContractAgent.originalSupplierAgencyFeesInPercent) &&
        Objects.equals(this.originalCommissionsInPercent, bookingContractAgent.originalCommissionsInPercent) &&
        Objects.equals(this.netTotalCustomersSourceAmount, bookingContractAgent.netTotalCustomersSourceAmount) &&
        Objects.equals(this.netTotalCustomersCaptureAmount, bookingContractAgent.netTotalCustomersCaptureAmount) &&
        Objects.equals(this.netTotalCustomersDisplayAmount, bookingContractAgent.netTotalCustomersDisplayAmount) &&
        Objects.equals(this.netTotalCustomersSupplierAmount, bookingContractAgent.netTotalCustomersSupplierAmount) &&
        Objects.equals(this.netTotalCustomersInternalAmount, bookingContractAgent.netTotalCustomersInternalAmount) &&
        Objects.equals(this.totalAffiliateAgencyFeesSourceAmount, bookingContractAgent.totalAffiliateAgencyFeesSourceAmount) &&
        Objects.equals(this.totalAffiliateAgencyFeesCaptureAmount, bookingContractAgent.totalAffiliateAgencyFeesCaptureAmount) &&
        Objects.equals(this.totalAffiliateAgencyFeesDisplayAmount, bookingContractAgent.totalAffiliateAgencyFeesDisplayAmount) &&
        Objects.equals(this.totalAffiliateAgencyFeesSupplierAmount, bookingContractAgent.totalAffiliateAgencyFeesSupplierAmount) &&
        Objects.equals(this.totalAffiliateAgencyFeesInternalAmount, bookingContractAgent.totalAffiliateAgencyFeesInternalAmount) &&
        Objects.equals(this.totalSupplierAgencyFeesSourceAmount, bookingContractAgent.totalSupplierAgencyFeesSourceAmount) &&
        Objects.equals(this.totalSupplierAgencyFeesCaptureAmount, bookingContractAgent.totalSupplierAgencyFeesCaptureAmount) &&
        Objects.equals(this.totalSupplierAgencyFeesDisplayAmount, bookingContractAgent.totalSupplierAgencyFeesDisplayAmount) &&
        Objects.equals(this.totalSupplierAgencyFeesSupplierAmount, bookingContractAgent.totalSupplierAgencyFeesSupplierAmount) &&
        Objects.equals(this.totalSupplierAgencyFeesInternalAmount, bookingContractAgent.totalSupplierAgencyFeesInternalAmount) &&
        Objects.equals(this.netTotalAffiliateAgencyFeesSourceAmount, bookingContractAgent.netTotalAffiliateAgencyFeesSourceAmount) &&
        Objects.equals(this.netTotalAffiliateAgencyFeesCaptureAmount, bookingContractAgent.netTotalAffiliateAgencyFeesCaptureAmount) &&
        Objects.equals(this.netTotalAffiliateAgencyFeesDisplayAmount, bookingContractAgent.netTotalAffiliateAgencyFeesDisplayAmount) &&
        Objects.equals(this.netTotalAffiliateAgencyFeesSupplierAmount, bookingContractAgent.netTotalAffiliateAgencyFeesSupplierAmount) &&
        Objects.equals(this.netTotalAffiliateAgencyFeesInternalAmount, bookingContractAgent.netTotalAffiliateAgencyFeesInternalAmount) &&
        Objects.equals(this.netTotalSupplierAgencyFeesSourceAmount, bookingContractAgent.netTotalSupplierAgencyFeesSourceAmount) &&
        Objects.equals(this.netTotalSupplierAgencyFeesCaptureAmount, bookingContractAgent.netTotalSupplierAgencyFeesCaptureAmount) &&
        Objects.equals(this.netTotalSupplierAgencyFeesDisplayAmount, bookingContractAgent.netTotalSupplierAgencyFeesDisplayAmount) &&
        Objects.equals(this.netTotalSupplierAgencyFeesSupplierAmount, bookingContractAgent.netTotalSupplierAgencyFeesSupplierAmount) &&
        Objects.equals(this.netTotalSupplierAgencyFeesInternalAmount, bookingContractAgent.netTotalSupplierAgencyFeesInternalAmount) &&
        Objects.equals(this.hasRefunds, bookingContractAgent.hasRefunds) &&
        Objects.equals(this.hasSuccessfulRefunds, bookingContractAgent.hasSuccessfulRefunds) &&
        Objects.equals(this.hasPendingRefunds, bookingContractAgent.hasPendingRefunds) &&
        Objects.equals(this.hasFailedRefunds, bookingContractAgent.hasFailedRefunds) &&
        Objects.equals(this.platformIdentifier, bookingContractAgent.platformIdentifier) &&
        Objects.equals(this.totalFundsGroupedByBeneficiary, bookingContractAgent.totalFundsGroupedByBeneficiary) &&
        Objects.equals(this.totalTokensEarned, bookingContractAgent.totalTokensEarned) &&
        Objects.equals(this.selfAcquiring, bookingContractAgent.selfAcquiring) &&
        Objects.equals(this.lodging, bookingContractAgent.lodging) &&
        Objects.equals(this.cancellableByAgent, bookingContractAgent.cancellableByAgent) &&
        Objects.equals(this.cancellableBySupplier, bookingContractAgent.cancellableBySupplier) &&
        Objects.equals(this.cancellableByTraveler, bookingContractAgent.cancellableByTraveler) &&
        Objects.equals(this.fullyRefunded, bookingContractAgent.fullyRefunded) &&
        Objects.equals(this.cancellableWithNoCharges, bookingContractAgent.cancellableWithNoCharges) &&
        Objects.equals(this.isCancellableWithPotentialCharges, bookingContractAgent.isCancellableWithPotentialCharges);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bookingContractIdentifier, createdDate, lastUpdate, federatedOrganizationIdentifier, federatedOrganizationName, user, ipAddress, traceId, sourceUrl, identifier, supplierIdentifier, supplierName, displayPriceQuote, supplierPriceQuote, internalPriceQuote, capturePriceQuote, itemList, externalSupplierIdentifier, externalSupplierBookingCode, payment, cancelled, cancelledOn, canceller, cancellationType, cancellerUserIdentifier, cancelReason, fundsProcessed, refunds, payouts, sourceCurrency, displayCurrency, supplierCurrency, internalCurrency, captureCurrency, sourceAmount, displayAmount, supplierAmount, internalAmount, captureAmount, sourceAmountRefundModifier, displayAmountRefundModifier, supplierAmountRefundModifier, internalAmountRefundModifier, captureAmountRefundModifier, netSourceAmount, netDisplayAmount, netSupplierAmount, netInternalAmount, netCaptureAmount, metadata, netCommissionableTotalSourceAmount, netCommissionableTotalCaptureAmount, netCommissionableTotalDisplayAmount, netCommissionableTotalSupplierAmount, netCommissionableTotalInternalAmount, netTotalFeesAndCommissionsSourceAmount, netTotalFeesAndCommissionsCaptureAmount, netTotalFeesAndCommissionsDisplayAmount, netTotalFeesAndCommissionsSupplierAmount, netTotalFeesAndCommissionsInternalAmount, netTotalFeesSourceAmount, netTotalFeesCaptureAmount, netTotalFeesDisplayAmount, netTotalFeesSupplierAmount, netTotalFeesInternalAmount, netTotalTripPayFeeSourceAmount, netTotalTripPayFeeCaptureAmount, netTotalTripPayFeeDisplayAmount, netTotalTripPayFeeSupplierAmount, netTotalTripPayFeeInternalAmount, netTotalSalesSourceAmount, netTotalSalesCaptureAmount, netTotalSalesDisplayAmount, netTotalSalesSupplierAmount, netTotalSalesInternalAmount, commissionableTotalSourceAmount, commissionableTotalCaptureAmount, commissionableTotalDisplayAmount, commissionableTotalSupplierAmount, commissionableTotalInternalAmount, totalFeesAndCommissionsSourceAmount, totalFeesAndCommissionsCaptureAmount, totalFeesAndCommissionsDisplayAmount, totalFeesAndCommissionsSupplierAmount, totalFeesAndCommissionsInternalAmount, totalFeesSourceAmount, totalFeesCaptureAmount, totalFeesDisplayAmount, totalFeesSupplierAmount, totalFeesInternalAmount, totalTripPayFeeSourceAmount, totalTripPayFeeCaptureAmount, totalTripPayFeeDisplayAmount, totalTripPayFeeSupplierAmount, totalTripPayFeeInternalAmount, totalSalesSourceAmount, totalSalesCaptureAmount, totalSalesDisplayAmount, totalSalesSupplierAmount, totalSalesInternalAmount, fundsAvailableDate, totalFeesInPercentWithRefund, totalFeesInPercent, totalTripPayFeeInPercentWithRefund, totalTripPayFeeInPercent, totalCommissionsInPercentWithRefund, totalCommissionsInPercent, totalFeesAndCommissionsInPercentWithRefund, totalFeesAndCommissionsInPercent, originalFeesInPercent, originalAffiliateAgencyFeesInPercent, originalSupplierAgencyFeesInPercent, originalCommissionsInPercent, netTotalCustomersSourceAmount, netTotalCustomersCaptureAmount, netTotalCustomersDisplayAmount, netTotalCustomersSupplierAmount, netTotalCustomersInternalAmount, totalAffiliateAgencyFeesSourceAmount, totalAffiliateAgencyFeesCaptureAmount, totalAffiliateAgencyFeesDisplayAmount, totalAffiliateAgencyFeesSupplierAmount, totalAffiliateAgencyFeesInternalAmount, totalSupplierAgencyFeesSourceAmount, totalSupplierAgencyFeesCaptureAmount, totalSupplierAgencyFeesDisplayAmount, totalSupplierAgencyFeesSupplierAmount, totalSupplierAgencyFeesInternalAmount, netTotalAffiliateAgencyFeesSourceAmount, netTotalAffiliateAgencyFeesCaptureAmount, netTotalAffiliateAgencyFeesDisplayAmount, netTotalAffiliateAgencyFeesSupplierAmount, netTotalAffiliateAgencyFeesInternalAmount, netTotalSupplierAgencyFeesSourceAmount, netTotalSupplierAgencyFeesCaptureAmount, netTotalSupplierAgencyFeesDisplayAmount, netTotalSupplierAgencyFeesSupplierAmount, netTotalSupplierAgencyFeesInternalAmount, hasRefunds, hasSuccessfulRefunds, hasPendingRefunds, hasFailedRefunds, platformIdentifier, totalFundsGroupedByBeneficiary, totalTokensEarned, selfAcquiring, lodging, cancellableByAgent, cancellableBySupplier, cancellableByTraveler, fullyRefunded, cancellableWithNoCharges, isCancellableWithPotentialCharges);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingContractAgent {\n");
    sb.append("    bookingContractIdentifier: ").append(toIndentedString(bookingContractIdentifier)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    lastUpdate: ").append(toIndentedString(lastUpdate)).append("\n");
    sb.append("    federatedOrganizationIdentifier: ").append(toIndentedString(federatedOrganizationIdentifier)).append("\n");
    sb.append("    federatedOrganizationName: ").append(toIndentedString(federatedOrganizationName)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    ipAddress: ").append(toIndentedString(ipAddress)).append("\n");
    sb.append("    traceId: ").append(toIndentedString(traceId)).append("\n");
    sb.append("    sourceUrl: ").append(toIndentedString(sourceUrl)).append("\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    supplierIdentifier: ").append(toIndentedString(supplierIdentifier)).append("\n");
    sb.append("    supplierName: ").append(toIndentedString(supplierName)).append("\n");
    sb.append("    displayPriceQuote: ").append(toIndentedString(displayPriceQuote)).append("\n");
    sb.append("    supplierPriceQuote: ").append(toIndentedString(supplierPriceQuote)).append("\n");
    sb.append("    internalPriceQuote: ").append(toIndentedString(internalPriceQuote)).append("\n");
    sb.append("    capturePriceQuote: ").append(toIndentedString(capturePriceQuote)).append("\n");
    sb.append("    itemList: ").append(toIndentedString(itemList)).append("\n");
    sb.append("    externalSupplierIdentifier: ").append(toIndentedString(externalSupplierIdentifier)).append("\n");
    sb.append("    externalSupplierBookingCode: ").append(toIndentedString(externalSupplierBookingCode)).append("\n");
    sb.append("    payment: ").append(toIndentedString(payment)).append("\n");
    sb.append("    cancelled: ").append(toIndentedString(cancelled)).append("\n");
    sb.append("    cancelledOn: ").append(toIndentedString(cancelledOn)).append("\n");
    sb.append("    canceller: ").append(toIndentedString(canceller)).append("\n");
    sb.append("    cancellationType: ").append(toIndentedString(cancellationType)).append("\n");
    sb.append("    cancellerUserIdentifier: ").append(toIndentedString(cancellerUserIdentifier)).append("\n");
    sb.append("    cancelReason: ").append(toIndentedString(cancelReason)).append("\n");
    sb.append("    fundsProcessed: ").append(toIndentedString(fundsProcessed)).append("\n");
    sb.append("    refunds: ").append(toIndentedString(refunds)).append("\n");
    sb.append("    payouts: ").append(toIndentedString(payouts)).append("\n");
    sb.append("    sourceCurrency: ").append(toIndentedString(sourceCurrency)).append("\n");
    sb.append("    displayCurrency: ").append(toIndentedString(displayCurrency)).append("\n");
    sb.append("    supplierCurrency: ").append(toIndentedString(supplierCurrency)).append("\n");
    sb.append("    internalCurrency: ").append(toIndentedString(internalCurrency)).append("\n");
    sb.append("    captureCurrency: ").append(toIndentedString(captureCurrency)).append("\n");
    sb.append("    sourceAmount: ").append(toIndentedString(sourceAmount)).append("\n");
    sb.append("    displayAmount: ").append(toIndentedString(displayAmount)).append("\n");
    sb.append("    supplierAmount: ").append(toIndentedString(supplierAmount)).append("\n");
    sb.append("    internalAmount: ").append(toIndentedString(internalAmount)).append("\n");
    sb.append("    captureAmount: ").append(toIndentedString(captureAmount)).append("\n");
    sb.append("    sourceAmountRefundModifier: ").append(toIndentedString(sourceAmountRefundModifier)).append("\n");
    sb.append("    displayAmountRefundModifier: ").append(toIndentedString(displayAmountRefundModifier)).append("\n");
    sb.append("    supplierAmountRefundModifier: ").append(toIndentedString(supplierAmountRefundModifier)).append("\n");
    sb.append("    internalAmountRefundModifier: ").append(toIndentedString(internalAmountRefundModifier)).append("\n");
    sb.append("    captureAmountRefundModifier: ").append(toIndentedString(captureAmountRefundModifier)).append("\n");
    sb.append("    netSourceAmount: ").append(toIndentedString(netSourceAmount)).append("\n");
    sb.append("    netDisplayAmount: ").append(toIndentedString(netDisplayAmount)).append("\n");
    sb.append("    netSupplierAmount: ").append(toIndentedString(netSupplierAmount)).append("\n");
    sb.append("    netInternalAmount: ").append(toIndentedString(netInternalAmount)).append("\n");
    sb.append("    netCaptureAmount: ").append(toIndentedString(netCaptureAmount)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    netCommissionableTotalSourceAmount: ").append(toIndentedString(netCommissionableTotalSourceAmount)).append("\n");
    sb.append("    netCommissionableTotalCaptureAmount: ").append(toIndentedString(netCommissionableTotalCaptureAmount)).append("\n");
    sb.append("    netCommissionableTotalDisplayAmount: ").append(toIndentedString(netCommissionableTotalDisplayAmount)).append("\n");
    sb.append("    netCommissionableTotalSupplierAmount: ").append(toIndentedString(netCommissionableTotalSupplierAmount)).append("\n");
    sb.append("    netCommissionableTotalInternalAmount: ").append(toIndentedString(netCommissionableTotalInternalAmount)).append("\n");
    sb.append("    netTotalFeesAndCommissionsSourceAmount: ").append(toIndentedString(netTotalFeesAndCommissionsSourceAmount)).append("\n");
    sb.append("    netTotalFeesAndCommissionsCaptureAmount: ").append(toIndentedString(netTotalFeesAndCommissionsCaptureAmount)).append("\n");
    sb.append("    netTotalFeesAndCommissionsDisplayAmount: ").append(toIndentedString(netTotalFeesAndCommissionsDisplayAmount)).append("\n");
    sb.append("    netTotalFeesAndCommissionsSupplierAmount: ").append(toIndentedString(netTotalFeesAndCommissionsSupplierAmount)).append("\n");
    sb.append("    netTotalFeesAndCommissionsInternalAmount: ").append(toIndentedString(netTotalFeesAndCommissionsInternalAmount)).append("\n");
    sb.append("    netTotalFeesSourceAmount: ").append(toIndentedString(netTotalFeesSourceAmount)).append("\n");
    sb.append("    netTotalFeesCaptureAmount: ").append(toIndentedString(netTotalFeesCaptureAmount)).append("\n");
    sb.append("    netTotalFeesDisplayAmount: ").append(toIndentedString(netTotalFeesDisplayAmount)).append("\n");
    sb.append("    netTotalFeesSupplierAmount: ").append(toIndentedString(netTotalFeesSupplierAmount)).append("\n");
    sb.append("    netTotalFeesInternalAmount: ").append(toIndentedString(netTotalFeesInternalAmount)).append("\n");
    sb.append("    netTotalTripPayFeeSourceAmount: ").append(toIndentedString(netTotalTripPayFeeSourceAmount)).append("\n");
    sb.append("    netTotalTripPayFeeCaptureAmount: ").append(toIndentedString(netTotalTripPayFeeCaptureAmount)).append("\n");
    sb.append("    netTotalTripPayFeeDisplayAmount: ").append(toIndentedString(netTotalTripPayFeeDisplayAmount)).append("\n");
    sb.append("    netTotalTripPayFeeSupplierAmount: ").append(toIndentedString(netTotalTripPayFeeSupplierAmount)).append("\n");
    sb.append("    netTotalTripPayFeeInternalAmount: ").append(toIndentedString(netTotalTripPayFeeInternalAmount)).append("\n");
    sb.append("    netTotalSalesSourceAmount: ").append(toIndentedString(netTotalSalesSourceAmount)).append("\n");
    sb.append("    netTotalSalesCaptureAmount: ").append(toIndentedString(netTotalSalesCaptureAmount)).append("\n");
    sb.append("    netTotalSalesDisplayAmount: ").append(toIndentedString(netTotalSalesDisplayAmount)).append("\n");
    sb.append("    netTotalSalesSupplierAmount: ").append(toIndentedString(netTotalSalesSupplierAmount)).append("\n");
    sb.append("    netTotalSalesInternalAmount: ").append(toIndentedString(netTotalSalesInternalAmount)).append("\n");
    sb.append("    commissionableTotalSourceAmount: ").append(toIndentedString(commissionableTotalSourceAmount)).append("\n");
    sb.append("    commissionableTotalCaptureAmount: ").append(toIndentedString(commissionableTotalCaptureAmount)).append("\n");
    sb.append("    commissionableTotalDisplayAmount: ").append(toIndentedString(commissionableTotalDisplayAmount)).append("\n");
    sb.append("    commissionableTotalSupplierAmount: ").append(toIndentedString(commissionableTotalSupplierAmount)).append("\n");
    sb.append("    commissionableTotalInternalAmount: ").append(toIndentedString(commissionableTotalInternalAmount)).append("\n");
    sb.append("    totalFeesAndCommissionsSourceAmount: ").append(toIndentedString(totalFeesAndCommissionsSourceAmount)).append("\n");
    sb.append("    totalFeesAndCommissionsCaptureAmount: ").append(toIndentedString(totalFeesAndCommissionsCaptureAmount)).append("\n");
    sb.append("    totalFeesAndCommissionsDisplayAmount: ").append(toIndentedString(totalFeesAndCommissionsDisplayAmount)).append("\n");
    sb.append("    totalFeesAndCommissionsSupplierAmount: ").append(toIndentedString(totalFeesAndCommissionsSupplierAmount)).append("\n");
    sb.append("    totalFeesAndCommissionsInternalAmount: ").append(toIndentedString(totalFeesAndCommissionsInternalAmount)).append("\n");
    sb.append("    totalFeesSourceAmount: ").append(toIndentedString(totalFeesSourceAmount)).append("\n");
    sb.append("    totalFeesCaptureAmount: ").append(toIndentedString(totalFeesCaptureAmount)).append("\n");
    sb.append("    totalFeesDisplayAmount: ").append(toIndentedString(totalFeesDisplayAmount)).append("\n");
    sb.append("    totalFeesSupplierAmount: ").append(toIndentedString(totalFeesSupplierAmount)).append("\n");
    sb.append("    totalFeesInternalAmount: ").append(toIndentedString(totalFeesInternalAmount)).append("\n");
    sb.append("    totalTripPayFeeSourceAmount: ").append(toIndentedString(totalTripPayFeeSourceAmount)).append("\n");
    sb.append("    totalTripPayFeeCaptureAmount: ").append(toIndentedString(totalTripPayFeeCaptureAmount)).append("\n");
    sb.append("    totalTripPayFeeDisplayAmount: ").append(toIndentedString(totalTripPayFeeDisplayAmount)).append("\n");
    sb.append("    totalTripPayFeeSupplierAmount: ").append(toIndentedString(totalTripPayFeeSupplierAmount)).append("\n");
    sb.append("    totalTripPayFeeInternalAmount: ").append(toIndentedString(totalTripPayFeeInternalAmount)).append("\n");
    sb.append("    totalSalesSourceAmount: ").append(toIndentedString(totalSalesSourceAmount)).append("\n");
    sb.append("    totalSalesCaptureAmount: ").append(toIndentedString(totalSalesCaptureAmount)).append("\n");
    sb.append("    totalSalesDisplayAmount: ").append(toIndentedString(totalSalesDisplayAmount)).append("\n");
    sb.append("    totalSalesSupplierAmount: ").append(toIndentedString(totalSalesSupplierAmount)).append("\n");
    sb.append("    totalSalesInternalAmount: ").append(toIndentedString(totalSalesInternalAmount)).append("\n");
    sb.append("    fundsAvailableDate: ").append(toIndentedString(fundsAvailableDate)).append("\n");
    sb.append("    totalFeesInPercentWithRefund: ").append(toIndentedString(totalFeesInPercentWithRefund)).append("\n");
    sb.append("    totalFeesInPercent: ").append(toIndentedString(totalFeesInPercent)).append("\n");
    sb.append("    totalTripPayFeeInPercentWithRefund: ").append(toIndentedString(totalTripPayFeeInPercentWithRefund)).append("\n");
    sb.append("    totalTripPayFeeInPercent: ").append(toIndentedString(totalTripPayFeeInPercent)).append("\n");
    sb.append("    totalCommissionsInPercentWithRefund: ").append(toIndentedString(totalCommissionsInPercentWithRefund)).append("\n");
    sb.append("    totalCommissionsInPercent: ").append(toIndentedString(totalCommissionsInPercent)).append("\n");
    sb.append("    totalFeesAndCommissionsInPercentWithRefund: ").append(toIndentedString(totalFeesAndCommissionsInPercentWithRefund)).append("\n");
    sb.append("    totalFeesAndCommissionsInPercent: ").append(toIndentedString(totalFeesAndCommissionsInPercent)).append("\n");
    sb.append("    originalFeesInPercent: ").append(toIndentedString(originalFeesInPercent)).append("\n");
    sb.append("    originalAffiliateAgencyFeesInPercent: ").append(toIndentedString(originalAffiliateAgencyFeesInPercent)).append("\n");
    sb.append("    originalSupplierAgencyFeesInPercent: ").append(toIndentedString(originalSupplierAgencyFeesInPercent)).append("\n");
    sb.append("    originalCommissionsInPercent: ").append(toIndentedString(originalCommissionsInPercent)).append("\n");
    sb.append("    netTotalCustomersSourceAmount: ").append(toIndentedString(netTotalCustomersSourceAmount)).append("\n");
    sb.append("    netTotalCustomersCaptureAmount: ").append(toIndentedString(netTotalCustomersCaptureAmount)).append("\n");
    sb.append("    netTotalCustomersDisplayAmount: ").append(toIndentedString(netTotalCustomersDisplayAmount)).append("\n");
    sb.append("    netTotalCustomersSupplierAmount: ").append(toIndentedString(netTotalCustomersSupplierAmount)).append("\n");
    sb.append("    netTotalCustomersInternalAmount: ").append(toIndentedString(netTotalCustomersInternalAmount)).append("\n");
    sb.append("    totalAffiliateAgencyFeesSourceAmount: ").append(toIndentedString(totalAffiliateAgencyFeesSourceAmount)).append("\n");
    sb.append("    totalAffiliateAgencyFeesCaptureAmount: ").append(toIndentedString(totalAffiliateAgencyFeesCaptureAmount)).append("\n");
    sb.append("    totalAffiliateAgencyFeesDisplayAmount: ").append(toIndentedString(totalAffiliateAgencyFeesDisplayAmount)).append("\n");
    sb.append("    totalAffiliateAgencyFeesSupplierAmount: ").append(toIndentedString(totalAffiliateAgencyFeesSupplierAmount)).append("\n");
    sb.append("    totalAffiliateAgencyFeesInternalAmount: ").append(toIndentedString(totalAffiliateAgencyFeesInternalAmount)).append("\n");
    sb.append("    totalSupplierAgencyFeesSourceAmount: ").append(toIndentedString(totalSupplierAgencyFeesSourceAmount)).append("\n");
    sb.append("    totalSupplierAgencyFeesCaptureAmount: ").append(toIndentedString(totalSupplierAgencyFeesCaptureAmount)).append("\n");
    sb.append("    totalSupplierAgencyFeesDisplayAmount: ").append(toIndentedString(totalSupplierAgencyFeesDisplayAmount)).append("\n");
    sb.append("    totalSupplierAgencyFeesSupplierAmount: ").append(toIndentedString(totalSupplierAgencyFeesSupplierAmount)).append("\n");
    sb.append("    totalSupplierAgencyFeesInternalAmount: ").append(toIndentedString(totalSupplierAgencyFeesInternalAmount)).append("\n");
    sb.append("    netTotalAffiliateAgencyFeesSourceAmount: ").append(toIndentedString(netTotalAffiliateAgencyFeesSourceAmount)).append("\n");
    sb.append("    netTotalAffiliateAgencyFeesCaptureAmount: ").append(toIndentedString(netTotalAffiliateAgencyFeesCaptureAmount)).append("\n");
    sb.append("    netTotalAffiliateAgencyFeesDisplayAmount: ").append(toIndentedString(netTotalAffiliateAgencyFeesDisplayAmount)).append("\n");
    sb.append("    netTotalAffiliateAgencyFeesSupplierAmount: ").append(toIndentedString(netTotalAffiliateAgencyFeesSupplierAmount)).append("\n");
    sb.append("    netTotalAffiliateAgencyFeesInternalAmount: ").append(toIndentedString(netTotalAffiliateAgencyFeesInternalAmount)).append("\n");
    sb.append("    netTotalSupplierAgencyFeesSourceAmount: ").append(toIndentedString(netTotalSupplierAgencyFeesSourceAmount)).append("\n");
    sb.append("    netTotalSupplierAgencyFeesCaptureAmount: ").append(toIndentedString(netTotalSupplierAgencyFeesCaptureAmount)).append("\n");
    sb.append("    netTotalSupplierAgencyFeesDisplayAmount: ").append(toIndentedString(netTotalSupplierAgencyFeesDisplayAmount)).append("\n");
    sb.append("    netTotalSupplierAgencyFeesSupplierAmount: ").append(toIndentedString(netTotalSupplierAgencyFeesSupplierAmount)).append("\n");
    sb.append("    netTotalSupplierAgencyFeesInternalAmount: ").append(toIndentedString(netTotalSupplierAgencyFeesInternalAmount)).append("\n");
    sb.append("    hasRefunds: ").append(toIndentedString(hasRefunds)).append("\n");
    sb.append("    hasSuccessfulRefunds: ").append(toIndentedString(hasSuccessfulRefunds)).append("\n");
    sb.append("    hasPendingRefunds: ").append(toIndentedString(hasPendingRefunds)).append("\n");
    sb.append("    hasFailedRefunds: ").append(toIndentedString(hasFailedRefunds)).append("\n");
    sb.append("    platformIdentifier: ").append(toIndentedString(platformIdentifier)).append("\n");
    sb.append("    totalFundsGroupedByBeneficiary: ").append(toIndentedString(totalFundsGroupedByBeneficiary)).append("\n");
    sb.append("    totalTokensEarned: ").append(toIndentedString(totalTokensEarned)).append("\n");
    sb.append("    selfAcquiring: ").append(toIndentedString(selfAcquiring)).append("\n");
    sb.append("    lodging: ").append(toIndentedString(lodging)).append("\n");
    sb.append("    cancellableByAgent: ").append(toIndentedString(cancellableByAgent)).append("\n");
    sb.append("    cancellableBySupplier: ").append(toIndentedString(cancellableBySupplier)).append("\n");
    sb.append("    cancellableByTraveler: ").append(toIndentedString(cancellableByTraveler)).append("\n");
    sb.append("    fullyRefunded: ").append(toIndentedString(fullyRefunded)).append("\n");
    sb.append("    cancellableWithNoCharges: ").append(toIndentedString(cancellableWithNoCharges)).append("\n");
    sb.append("    isCancellableWithPotentialCharges: ").append(toIndentedString(isCancellableWithPotentialCharges)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

