/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/customization-client): A single endpoint to retrieve whitelabel + customization information for the booking customization.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Travel Agent API The Travel Agent API exposes endpoints to manage agent-facilitated bookings. This API lets you:  1. Travel Agent: Manage agent entity. 2. Booking: Create / Manage bookings  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.travel.agent.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.sdk.travel.agent.model.BookingItineraryAgent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * User session information containing itinerary and other user related data.
 */
@JsonPropertyOrder({
  BookingUserSessionAgent.JSON_PROPERTY_ITINERARY,
  BookingUserSessionAgent.JSON_PROPERTY_LANGUAGE,
  BookingUserSessionAgent.JSON_PROPERTY_CURRENCY,
  BookingUserSessionAgent.JSON_PROPERTY_PROMOTIONAL_CODES,
  BookingUserSessionAgent.JSON_PROPERTY_SELECTED_ROOM_CONFIGURATION_INDEX,
  BookingUserSessionAgent.JSON_PROPERTY_LIFESTYLE
})
@JsonTypeName("BookingUserSession_Agent")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:21:53.341573209+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class BookingUserSessionAgent {
  public static final String JSON_PROPERTY_ITINERARY = "itinerary";
  @jakarta.annotation.Nonnull
  private BookingItineraryAgent itinerary;

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  @jakarta.annotation.Nullable
  private String language;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  @jakarta.annotation.Nullable
  private String currency;

  public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
  @jakarta.annotation.Nullable
  private List<Object> promotionalCodes = new ArrayList<>();

  public static final String JSON_PROPERTY_SELECTED_ROOM_CONFIGURATION_INDEX = "selectedRoomConfigurationIndex";
  @jakarta.annotation.Nullable
  private Integer selectedRoomConfigurationIndex;

  /**
   * The preferred user lifestyle.
   */
  public enum LifestyleEnum {
    LIFESTYLE_HEALTH_FITNESS(String.valueOf("LIFESTYLE_HEALTH_FITNESS")),
    
    LIFESTYLE_RELAX(String.valueOf("LIFESTYLE_RELAX")),
    
    LIFESTYLE_ADULT_ONLY(String.valueOf("LIFESTYLE_ADULT_ONLY")),
    
    LIFESTYLE_ADVENTURE(String.valueOf("LIFESTYLE_ADVENTURE")),
    
    LIFESTYLE_BUSINESS(String.valueOf("LIFESTYLE_BUSINESS")),
    
    LIFESTYLE_LGBT(String.valueOf("LIFESTYLE_LGBT")),
    
    LIFESTYLE_SINGLE_PARENT(String.valueOf("LIFESTYLE_SINGLE_PARENT")),
    
    LIFESTYLE_SOLO_FEMALE(String.valueOf("LIFESTYLE_SOLO_FEMALE")),
    
    LIFESTYLE_BEAUTY(String.valueOf("LIFESTYLE_BEAUTY")),
    
    LIFESTYLE_FOODIE(String.valueOf("LIFESTYLE_FOODIE")),
    
    LIFESTYLE_FAMILY(String.valueOf("LIFESTYLE_FAMILY")),
    
    LIFESTYLE_ROMANCE(String.valueOf("LIFESTYLE_ROMANCE")),
    
    LIFESTYLE_COUPLE(String.valueOf("LIFESTYLE_COUPLE")),
    
    LIFESTYLE_SOLO(String.valueOf("LIFESTYLE_SOLO")),
    
    LIFESTYLE_BACKPACKER(String.valueOf("LIFESTYLE_BACKPACKER")),
    
    LIFESTYLE_SHOPPING(String.valueOf("LIFESTYLE_SHOPPING")),
    
    LIFESTYLE_SPORTS(String.valueOf("LIFESTYLE_SPORTS")),
    
    LIFESTYLE_MOUNTAIN(String.valueOf("LIFESTYLE_MOUNTAIN")),
    
    LIFESTYLE_BEACH(String.valueOf("LIFESTYLE_BEACH")),
    
    LIFESTYLE_CITY(String.valueOf("LIFESTYLE_CITY")),
    
    LIFESTYLE_COUNTRY(String.valueOf("LIFESTYLE_COUNTRY")),
    
    LIFESTYLE_CULTURE(String.valueOf("LIFESTYLE_CULTURE")),
    
    LIFESTYLE_ECO(String.valueOf("LIFESTYLE_ECO"));

    private String value;

    LifestyleEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LifestyleEnum fromValue(String value) {
      for (LifestyleEnum b : LifestyleEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIFESTYLE = "lifestyle";
  @jakarta.annotation.Nullable
  private LifestyleEnum lifestyle;

  public BookingUserSessionAgent() {
  }

  public BookingUserSessionAgent itinerary(@jakarta.annotation.Nonnull BookingItineraryAgent itinerary) {
    
    this.itinerary = itinerary;
    return this;
  }

  /**
   * Dates and travel info.
   * @return itinerary
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BookingItineraryAgent getItinerary() {
    return itinerary;
  }


  @JsonProperty(JSON_PROPERTY_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setItinerary(@jakarta.annotation.Nonnull BookingItineraryAgent itinerary) {
    this.itinerary = itinerary;
  }

  public BookingUserSessionAgent language(@jakarta.annotation.Nullable String language) {
    
    this.language = language;
    return this;
  }

  /**
   * User&#39;s language preference
   * @return language
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguage(@jakarta.annotation.Nullable String language) {
    this.language = language;
  }

  public BookingUserSessionAgent currency(@jakarta.annotation.Nullable String currency) {
    
    this.currency = currency;
    return this;
  }

  /**
   * User&#39;s currency preference
   * @return currency
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(@jakarta.annotation.Nullable String currency) {
    this.currency = currency;
  }

  public BookingUserSessionAgent promotionalCodes(@jakarta.annotation.Nullable List<Object> promotionalCodes) {
    
    this.promotionalCodes = promotionalCodes;
    return this;
  }

  public BookingUserSessionAgent addPromotionalCodesItem(Object promotionalCodesItem) {
    if (this.promotionalCodes == null) {
      this.promotionalCodes = new ArrayList<>();
    }
    this.promotionalCodes.add(promotionalCodesItem);
    return this;
  }

  /**
   * Get promotionalCodes
   * @return promotionalCodes
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getPromotionalCodes() {
    return promotionalCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalCodes(@jakarta.annotation.Nullable List<Object> promotionalCodes) {
    this.promotionalCodes = promotionalCodes;
  }

  public BookingUserSessionAgent selectedRoomConfigurationIndex(@jakarta.annotation.Nullable Integer selectedRoomConfigurationIndex) {
    
    this.selectedRoomConfigurationIndex = selectedRoomConfigurationIndex;
    return this;
  }

  /**
   * User can pass the current room configuration index to retrieve rates specifically for that room configuration.
   * @return selectedRoomConfigurationIndex
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SELECTED_ROOM_CONFIGURATION_INDEX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSelectedRoomConfigurationIndex() {
    return selectedRoomConfigurationIndex;
  }


  @JsonProperty(JSON_PROPERTY_SELECTED_ROOM_CONFIGURATION_INDEX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSelectedRoomConfigurationIndex(@jakarta.annotation.Nullable Integer selectedRoomConfigurationIndex) {
    this.selectedRoomConfigurationIndex = selectedRoomConfigurationIndex;
  }

  public BookingUserSessionAgent lifestyle(@jakarta.annotation.Nullable LifestyleEnum lifestyle) {
    
    this.lifestyle = lifestyle;
    return this;
  }

  /**
   * The preferred user lifestyle.
   * @return lifestyle
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIFESTYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifestyleEnum getLifestyle() {
    return lifestyle;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyle(@jakarta.annotation.Nullable LifestyleEnum lifestyle) {
    this.lifestyle = lifestyle;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingUserSessionAgent bookingUserSessionAgent = (BookingUserSessionAgent) o;
    return Objects.equals(this.itinerary, bookingUserSessionAgent.itinerary) &&
        Objects.equals(this.language, bookingUserSessionAgent.language) &&
        Objects.equals(this.currency, bookingUserSessionAgent.currency) &&
        Objects.equals(this.promotionalCodes, bookingUserSessionAgent.promotionalCodes) &&
        Objects.equals(this.selectedRoomConfigurationIndex, bookingUserSessionAgent.selectedRoomConfigurationIndex) &&
        Objects.equals(this.lifestyle, bookingUserSessionAgent.lifestyle);
  }

  @Override
  public int hashCode() {
    return Objects.hash(itinerary, language, currency, promotionalCodes, selectedRoomConfigurationIndex, lifestyle);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingUserSessionAgent {\n");
    sb.append("    itinerary: ").append(toIndentedString(itinerary)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    promotionalCodes: ").append(toIndentedString(promotionalCodes)).append("\n");
    sb.append("    selectedRoomConfigurationIndex: ").append(toIndentedString(selectedRoomConfigurationIndex)).append("\n");
    sb.append("    lifestyle: ").append(toIndentedString(lifestyle)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

