/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.travel.agent.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import travel.wink.sdk.travel.agent.invoker.ApiClient;
import travel.wink.sdk.travel.agent.model.AffiliateAccountAgent;
import travel.wink.sdk.travel.agent.model.BookingAgent;
import travel.wink.sdk.travel.agent.model.BookingConfirmationsAgent;
import travel.wink.sdk.travel.agent.model.BooleanResponseAgent;
import travel.wink.sdk.travel.agent.model.CancellationDetailAgent;
import travel.wink.sdk.travel.agent.model.CreateAgentBookingRequestAgent;
import travel.wink.sdk.travel.agent.model.PageBookingAgent;
import travel.wink.sdk.travel.agent.model.StateAgent;
import travel.wink.sdk.travel.agent.model.UpsertTravelAgentRequestAgent;

public class TravelAgentApi {
    private ApiClient apiClient;

    public TravelAgentApi() {
        this(new ApiClient());
    }

    @Autowired
    public TravelAgentApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec cancelBookingAsTravelAgentRequestCreation(@Nonnull String companyIdentifier, @Nonnull String bookingIdentifier, @Nonnull CancellationDetailAgent cancellationDetailAgent, @Nullable String winkVersion) throws WebClientResponseException {
        CancellationDetailAgent postBody = cancellationDetailAgent;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling cancelBookingAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling cancelBookingAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (cancellationDetailAgent == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationDetailAgent' when calling cancelBookingAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingAgent> localVarReturnType = new ParameterizedTypeReference<BookingAgent>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/booking/{bookingIdentifier}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingAgent> cancelBookingAsTravelAgent(@Nonnull String companyIdentifier, @Nonnull String bookingIdentifier, @Nonnull CancellationDetailAgent cancellationDetailAgent, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingAgent> localVarReturnType = new ParameterizedTypeReference<BookingAgent>(this){};
        return this.cancelBookingAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, cancellationDetailAgent, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingAgent>> cancelBookingAsTravelAgentWithHttpInfo(@Nonnull String companyIdentifier, @Nonnull String bookingIdentifier, @Nonnull CancellationDetailAgent cancellationDetailAgent, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingAgent> localVarReturnType = new ParameterizedTypeReference<BookingAgent>(this){};
        return this.cancelBookingAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, cancellationDetailAgent, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec cancelBookingAsTravelAgentWithResponseSpec(@Nonnull String companyIdentifier, @Nonnull String bookingIdentifier, @Nonnull CancellationDetailAgent cancellationDetailAgent, @Nullable String winkVersion) throws WebClientResponseException {
        return this.cancelBookingAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, cancellationDetailAgent, winkVersion);
    }

    private WebClient.ResponseSpec createAgentBookingRequestCreation(@Nonnull CreateAgentBookingRequestAgent createAgentBookingRequestAgent, @Nullable String winkVersion) throws WebClientResponseException {
        CreateAgentBookingRequestAgent postBody = createAgentBookingRequestAgent;
        if (createAgentBookingRequestAgent == null) {
            throw new WebClientResponseException("Missing the required parameter 'createAgentBookingRequestAgent' when calling createAgentBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingConfirmationsAgent> localVarReturnType = new ParameterizedTypeReference<BookingConfirmationsAgent>(this){};
        return this.apiClient.invokeAPI("/api/booking/agent", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingConfirmationsAgent> createAgentBooking(@Nonnull CreateAgentBookingRequestAgent createAgentBookingRequestAgent, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingConfirmationsAgent> localVarReturnType = new ParameterizedTypeReference<BookingConfirmationsAgent>(this){};
        return this.createAgentBookingRequestCreation(createAgentBookingRequestAgent, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingConfirmationsAgent>> createAgentBookingWithHttpInfo(@Nonnull CreateAgentBookingRequestAgent createAgentBookingRequestAgent, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingConfirmationsAgent> localVarReturnType = new ParameterizedTypeReference<BookingConfirmationsAgent>(this){};
        return this.createAgentBookingRequestCreation(createAgentBookingRequestAgent, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createAgentBookingWithResponseSpec(@Nonnull CreateAgentBookingRequestAgent createAgentBookingRequestAgent, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createAgentBookingRequestCreation(createAgentBookingRequestAgent, winkVersion);
    }

    private WebClient.ResponseSpec resendBookingConfirmationEmailAsTravelAgentRequestCreation(@Nonnull String companyIdentifier, @Nonnull String bookingIdentifier, @Nullable Object body, @Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = body;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling resendBookingConfirmationEmailAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling resendBookingConfirmationEmailAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (body == null) {
            throw new WebClientResponseException("Missing the required parameter 'body' when calling resendBookingConfirmationEmailAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BooleanResponseAgent> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAgent>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/booking/{bookingIdentifier}/resend", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BooleanResponseAgent> resendBookingConfirmationEmailAsTravelAgent(@Nonnull String companyIdentifier, @Nonnull String bookingIdentifier, @Nullable Object body, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAgent> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAgent>(this){};
        return this.resendBookingConfirmationEmailAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, body, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BooleanResponseAgent>> resendBookingConfirmationEmailAsTravelAgentWithHttpInfo(@Nonnull String companyIdentifier, @Nonnull String bookingIdentifier, @Nullable Object body, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAgent> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAgent>(this){};
        return this.resendBookingConfirmationEmailAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, body, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec resendBookingConfirmationEmailAsTravelAgentWithResponseSpec(@Nonnull String companyIdentifier, @Nonnull String bookingIdentifier, @Nullable Object body, @Nullable String winkVersion) throws WebClientResponseException {
        return this.resendBookingConfirmationEmailAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, body, winkVersion);
    }

    private WebClient.ResponseSpec showBookingAsTravelAgentRequestCreation(@Nonnull String companyIdentifier, @Nonnull String bookingIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showBookingAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling showBookingAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingAgent> localVarReturnType = new ParameterizedTypeReference<BookingAgent>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/booking/{bookingIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingAgent> showBookingAsTravelAgent(@Nonnull String companyIdentifier, @Nonnull String bookingIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingAgent> localVarReturnType = new ParameterizedTypeReference<BookingAgent>(this){};
        return this.showBookingAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingAgent>> showBookingAsTravelAgentWithHttpInfo(@Nonnull String companyIdentifier, @Nonnull String bookingIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingAgent> localVarReturnType = new ParameterizedTypeReference<BookingAgent>(this){};
        return this.showBookingAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showBookingAsTravelAgentWithResponseSpec(@Nonnull String companyIdentifier, @Nonnull String bookingIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showBookingAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showBookingGridAsTravelAgentRequestCreation(@Nonnull String companyIdentifier, @Nonnull StateAgent stateAgent, @Nullable String winkVersion) throws WebClientResponseException {
        StateAgent postBody = stateAgent;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showBookingGridAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (stateAgent == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateAgent' when calling showBookingGridAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageBookingAgent> localVarReturnType = new ParameterizedTypeReference<PageBookingAgent>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/booking/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageBookingAgent> showBookingGridAsTravelAgent(@Nonnull String companyIdentifier, @Nonnull StateAgent stateAgent, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingAgent> localVarReturnType = new ParameterizedTypeReference<PageBookingAgent>(this){};
        return this.showBookingGridAsTravelAgentRequestCreation(companyIdentifier, stateAgent, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageBookingAgent>> showBookingGridAsTravelAgentWithHttpInfo(@Nonnull String companyIdentifier, @Nonnull StateAgent stateAgent, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingAgent> localVarReturnType = new ParameterizedTypeReference<PageBookingAgent>(this){};
        return this.showBookingGridAsTravelAgentRequestCreation(companyIdentifier, stateAgent, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showBookingGridAsTravelAgentWithResponseSpec(@Nonnull String companyIdentifier, @Nonnull StateAgent stateAgent, @Nullable String winkVersion) throws WebClientResponseException {
        return this.showBookingGridAsTravelAgentRequestCreation(companyIdentifier, stateAgent, winkVersion);
    }

    private WebClient.ResponseSpec updateAgentRequestCreation(@Nonnull String companyIdentifier, @Nonnull UpsertTravelAgentRequestAgent upsertTravelAgentRequestAgent, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertTravelAgentRequestAgent postBody = upsertTravelAgentRequestAgent;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertTravelAgentRequestAgent == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertTravelAgentRequestAgent' when calling updateAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AffiliateAccountAgent> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAgent>(this){};
        return this.apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/agent", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AffiliateAccountAgent> updateAgent(@Nonnull String companyIdentifier, @Nonnull UpsertTravelAgentRequestAgent upsertTravelAgentRequestAgent, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAgent> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAgent>(this){};
        return this.updateAgentRequestCreation(companyIdentifier, upsertTravelAgentRequestAgent, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AffiliateAccountAgent>> updateAgentWithHttpInfo(@Nonnull String companyIdentifier, @Nonnull UpsertTravelAgentRequestAgent upsertTravelAgentRequestAgent, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AffiliateAccountAgent> localVarReturnType = new ParameterizedTypeReference<AffiliateAccountAgent>(this){};
        return this.updateAgentRequestCreation(companyIdentifier, upsertTravelAgentRequestAgent, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateAgentWithResponseSpec(@Nonnull String companyIdentifier, @Nonnull UpsertTravelAgentRequestAgent upsertTravelAgentRequestAgent, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateAgentRequestCreation(companyIdentifier, upsertTravelAgentRequestAgent, winkVersion);
    }
}

