/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.travel.agent.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import travel.wink.sdk.travel.agent.model.BedAgent;

@JsonPropertyOrder(value={"type", "bedList"})
@JsonTypeName(value="Bedroom_Agent")
public class BedroomAgent {
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nonnull
    private TypeEnum type;
    public static final String JSON_PROPERTY_BED_LIST = "bedList";
    @Nonnull
    private List<@Valid BedAgent> bedList = new ArrayList<BedAgent>();

    public BedroomAgent type(@Nonnull TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(@Nonnull TypeEnum type) {
        this.type = type;
    }

    public BedroomAgent bedList(@Nonnull List<@Valid BedAgent> bedList) {
        this.bedList = bedList;
        return this;
    }

    public BedroomAgent addBedListItem(BedAgent bedListItem) {
        if (this.bedList == null) {
            this.bedList = new ArrayList<BedAgent>();
        }
        this.bedList.add(bedListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="bedList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) List<@Valid BedAgent> getBedList() {
        return this.bedList;
    }

    @JsonProperty(value="bedList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBedList(@Nonnull List<@Valid BedAgent> bedList) {
        this.bedList = bedList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BedroomAgent bedroomAgent = (BedroomAgent)o;
        return Objects.equals((Object)this.type, (Object)bedroomAgent.type) && Objects.equals(this.bedList, bedroomAgent.bedList);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.bedList});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BedroomAgent {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    bedList: ").append(this.toIndentedString(this.bedList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        MASTER(String.valueOf("MASTER")),
        QUEEN(String.valueOf("QUEEN")),
        JUNIOR(String.valueOf("JUNIOR")),
        DORMITORY(String.valueOf("DORMITORY")),
        BEDROOM_1(String.valueOf("BEDROOM_1")),
        BEDROOM_2(String.valueOf("BEDROOM_2")),
        BEDROOM_3(String.valueOf("BEDROOM_3")),
        BEDROOM_4(String.valueOf("BEDROOM_4")),
        BEDROOM_5(String.valueOf("BEDROOM_5")),
        BEDROOM_6(String.valueOf("BEDROOM_6")),
        BEDROOM_7(String.valueOf("BEDROOM_7")),
        BEDROOM_8(String.valueOf("BEDROOM_8")),
        BEDROOM_9(String.valueOf("BEDROOM_9")),
        BEDROOM_10(String.valueOf("BEDROOM_10"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

