/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.travel.agent.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.travel.agent.model.BedroomConfigurationAgent;
import travel.wink.sdk.travel.agent.model.ContactAgent;
import travel.wink.sdk.travel.agent.model.GeoJsonPointAgent;
import travel.wink.sdk.travel.agent.model.SimpleAddressAgent;
import travel.wink.sdk.travel.agent.model.SimpleDescriptionAgent;
import travel.wink.sdk.travel.agent.model.SimpleMultimediaAgent;
import travel.wink.sdk.travel.agent.model.SocialAgent;
import travel.wink.sdk.travel.agent.model.TravelInventoryRecognitionAgent;

@JsonPropertyOrder(value={"identifier", "hotelIdentifier", "featuredInd", "lifestyleType", "location", "descriptions", "multimedias", "contact", "address", "commissionable", "name", "proximityCode", "sort", "minAgeAppropriateCode", "bookable", "active", "disabilityFeatures", "securityFeatures", "socials", "pricePoint", "recognitionList", "maxOccupancy", "minOccupancy", "quantity", "nonSmoking", "bedroomConfigurationList", "size", "maxAdultOccupancy", "maxChildOccupancy", "bathroomCount", "livingRoomCount", "maxRollaways", "roomCategory", "floor", "roomLocationCode", "roomViewCode", "composite", "compositeCount", "roomClassificationCode", "roomArchitectureCode", "roomGender", "sharedRoomInd", "maxCribs", "amenities", "includedAdultOccupancy", "includedChildOccupancy"})
@JsonTypeName(value="GuestRoomLightweight_Agent")
public class GuestRoomLightweightAgent {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    @Nonnull
    private UUID identifier;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    @Nonnull
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_FEATURED_IND = "featuredInd";
    @Nonnull
    private Boolean featuredInd;
    public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
    @Nullable
    private LifestyleTypeEnum lifestyleType;
    public static final String JSON_PROPERTY_LOCATION = "location";
    @Nonnull
    private GeoJsonPointAgent location;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    @Nonnull
    private List<@Valid SimpleDescriptionAgent> descriptions = new ArrayList<SimpleDescriptionAgent>();
    public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
    @Nonnull
    private List<@Valid SimpleMultimediaAgent> multimedias = new ArrayList<SimpleMultimediaAgent>();
    public static final String JSON_PROPERTY_CONTACT = "contact";
    @Nonnull
    private ContactAgent contact;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    @Nonnull
    private SimpleAddressAgent address;
    public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
    @Nonnull
    private Boolean commissionable = true;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_PROXIMITY_CODE = "proximityCode";
    @Nonnull
    private String proximityCode;
    public static final String JSON_PROPERTY_SORT = "sort";
    @Nullable
    private Integer sort;
    public static final String JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE = "minAgeAppropriateCode";
    @Nullable
    private String minAgeAppropriateCode;
    public static final String JSON_PROPERTY_BOOKABLE = "bookable";
    @Nonnull
    private Boolean bookable = true;
    public static final String JSON_PROPERTY_ACTIVE = "active";
    @Nonnull
    private Boolean active = true;
    public static final String JSON_PROPERTY_DISABILITY_FEATURES = "disabilityFeatures";
    @Nullable
    private List<String> disabilityFeatures = new ArrayList<String>();
    public static final String JSON_PROPERTY_SECURITY_FEATURES = "securityFeatures";
    @Nullable
    private List<String> securityFeatures = new ArrayList<String>();
    public static final String JSON_PROPERTY_SOCIALS = "socials";
    @Nullable
    private List<@Valid SocialAgent> socials = new ArrayList<SocialAgent>();
    public static final String JSON_PROPERTY_PRICE_POINT = "pricePoint";
    @Nonnull
    private PricePointEnum pricePoint = PricePointEnum.THREE;
    public static final String JSON_PROPERTY_RECOGNITION_LIST = "recognitionList";
    @Nullable
    private List<@Valid TravelInventoryRecognitionAgent> recognitionList = new ArrayList<TravelInventoryRecognitionAgent>();
    public static final String JSON_PROPERTY_MAX_OCCUPANCY = "maxOccupancy";
    @Nonnull
    private Integer maxOccupancy = 2;
    public static final String JSON_PROPERTY_MIN_OCCUPANCY = "minOccupancy";
    @Nonnull
    private Integer minOccupancy = 1;
    public static final String JSON_PROPERTY_QUANTITY = "quantity";
    @Nonnull
    private Integer quantity;
    public static final String JSON_PROPERTY_NON_SMOKING = "nonSmoking";
    @Nonnull
    private Boolean nonSmoking;
    public static final String JSON_PROPERTY_BEDROOM_CONFIGURATION_LIST = "bedroomConfigurationList";
    @Nonnull
    private List<@Valid BedroomConfigurationAgent> bedroomConfigurationList = new ArrayList<BedroomConfigurationAgent>();
    public static final String JSON_PROPERTY_SIZE = "size";
    @Nonnull
    private Float size;
    public static final String JSON_PROPERTY_MAX_ADULT_OCCUPANCY = "maxAdultOccupancy";
    @Nonnull
    private Integer maxAdultOccupancy = 2;
    public static final String JSON_PROPERTY_MAX_CHILD_OCCUPANCY = "maxChildOccupancy";
    @Nonnull
    private Integer maxChildOccupancy = 0;
    public static final String JSON_PROPERTY_BATHROOM_COUNT = "bathroomCount";
    @Nonnull
    private Integer bathroomCount = 1;
    public static final String JSON_PROPERTY_LIVING_ROOM_COUNT = "livingRoomCount";
    @Nonnull
    private Integer livingRoomCount = 1;
    public static final String JSON_PROPERTY_MAX_ROLLAWAYS = "maxRollaways";
    @Nonnull
    private Integer maxRollaways = 0;
    public static final String JSON_PROPERTY_ROOM_CATEGORY = "roomCategory";
    @Nonnull
    private String roomCategory;
    public static final String JSON_PROPERTY_FLOOR = "floor";
    @Nullable
    private String floor;
    public static final String JSON_PROPERTY_ROOM_LOCATION_CODE = "roomLocationCode";
    @Nonnull
    private String roomLocationCode;
    public static final String JSON_PROPERTY_ROOM_VIEW_CODE = "roomViewCode";
    @Nonnull
    private String roomViewCode;
    public static final String JSON_PROPERTY_COMPOSITE = "composite";
    @Nonnull
    private Boolean composite = false;
    public static final String JSON_PROPERTY_COMPOSITE_COUNT = "compositeCount";
    @Nonnull
    private Integer compositeCount = 0;
    public static final String JSON_PROPERTY_ROOM_CLASSIFICATION_CODE = "roomClassificationCode";
    @Nonnull
    private String roomClassificationCode;
    public static final String JSON_PROPERTY_ROOM_ARCHITECTURE_CODE = "roomArchitectureCode";
    @Nonnull
    private String roomArchitectureCode;
    public static final String JSON_PROPERTY_ROOM_GENDER = "roomGender";
    @Nullable
    private RoomGenderEnum roomGender = RoomGenderEnum.UNKNOWN;
    public static final String JSON_PROPERTY_SHARED_ROOM_IND = "sharedRoomInd";
    @Nonnull
    private Boolean sharedRoomInd = false;
    public static final String JSON_PROPERTY_MAX_CRIBS = "maxCribs";
    @Nonnull
    private Integer maxCribs = 0;
    public static final String JSON_PROPERTY_AMENITIES = "amenities";
    @Nullable
    private List<String> amenities = new ArrayList<String>();
    public static final String JSON_PROPERTY_INCLUDED_ADULT_OCCUPANCY = "includedAdultOccupancy";
    @Nonnull
    private Integer includedAdultOccupancy = 2;
    public static final String JSON_PROPERTY_INCLUDED_CHILD_OCCUPANCY = "includedChildOccupancy";
    @Nonnull
    private Integer includedChildOccupancy = 0;

    public GuestRoomLightweightAgent identifier(@Nonnull UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(@Nonnull UUID identifier) {
        this.identifier = identifier;
    }

    public GuestRoomLightweightAgent hotelIdentifier(@Nonnull UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(@Nonnull UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public GuestRoomLightweightAgent featuredInd(@Nonnull Boolean featuredInd) {
        this.featuredInd = featuredInd;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="featuredInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getFeaturedInd() {
        return this.featuredInd;
    }

    @JsonProperty(value="featuredInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFeaturedInd(@Nonnull Boolean featuredInd) {
        this.featuredInd = featuredInd;
    }

    public GuestRoomLightweightAgent lifestyleType(@Nullable LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifestyleTypeEnum getLifestyleType() {
        return this.lifestyleType;
    }

    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifestyleType(@Nullable LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
    }

    public GuestRoomLightweightAgent location(@Nonnull GeoJsonPointAgent location) {
        this.location = location;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GeoJsonPointAgent getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLocation(@Nonnull GeoJsonPointAgent location) {
        this.location = location;
    }

    public GuestRoomLightweightAgent descriptions(@Nonnull List<@Valid SimpleDescriptionAgent> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public GuestRoomLightweightAgent addDescriptionsItem(SimpleDescriptionAgent descriptionsItem) {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<SimpleDescriptionAgent>();
        }
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) List<@Valid SimpleDescriptionAgent> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(@Nonnull List<@Valid SimpleDescriptionAgent> descriptions) {
        this.descriptions = descriptions;
    }

    public GuestRoomLightweightAgent multimedias(@Nonnull List<@Valid SimpleMultimediaAgent> multimedias) {
        this.multimedias = multimedias;
        return this;
    }

    public GuestRoomLightweightAgent addMultimediasItem(SimpleMultimediaAgent multimediasItem) {
        if (this.multimedias == null) {
            this.multimedias = new ArrayList<SimpleMultimediaAgent>();
        }
        this.multimedias.add(multimediasItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) List<@Valid SimpleMultimediaAgent> getMultimedias() {
        return this.multimedias;
    }

    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMultimedias(@Nonnull List<@Valid SimpleMultimediaAgent> multimedias) {
        this.multimedias = multimedias;
    }

    public GuestRoomLightweightAgent contact(@Nonnull ContactAgent contact) {
        this.contact = contact;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ContactAgent getContact() {
        return this.contact;
    }

    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContact(@Nonnull ContactAgent contact) {
        this.contact = contact;
    }

    public GuestRoomLightweightAgent address(@Nonnull SimpleAddressAgent address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SimpleAddressAgent getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress(@Nonnull SimpleAddressAgent address) {
        this.address = address;
    }

    public GuestRoomLightweightAgent commissionable(@Nonnull Boolean commissionable) {
        this.commissionable = commissionable;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getCommissionable() {
        return this.commissionable;
    }

    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCommissionable(@Nonnull Boolean commissionable) {
        this.commissionable = commissionable;
    }

    public GuestRoomLightweightAgent name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public GuestRoomLightweightAgent proximityCode(@Nonnull String proximityCode) {
        this.proximityCode = proximityCode;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="proximityCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getProximityCode() {
        return this.proximityCode;
    }

    @JsonProperty(value="proximityCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProximityCode(@Nonnull String proximityCode) {
        this.proximityCode = proximityCode;
    }

    public GuestRoomLightweightAgent sort(@Nullable Integer sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(@Nullable Integer sort) {
        this.sort = sort;
    }

    public GuestRoomLightweightAgent minAgeAppropriateCode(@Nullable String minAgeAppropriateCode) {
        this.minAgeAppropriateCode = minAgeAppropriateCode;
        return this;
    }

    @Nullable
    @JsonProperty(value="minAgeAppropriateCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMinAgeAppropriateCode() {
        return this.minAgeAppropriateCode;
    }

    @JsonProperty(value="minAgeAppropriateCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinAgeAppropriateCode(@Nullable String minAgeAppropriateCode) {
        this.minAgeAppropriateCode = minAgeAppropriateCode;
    }

    public GuestRoomLightweightAgent bookable(@Nonnull Boolean bookable) {
        this.bookable = bookable;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="bookable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getBookable() {
        return this.bookable;
    }

    @JsonProperty(value="bookable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBookable(@Nonnull Boolean bookable) {
        this.bookable = bookable;
    }

    public GuestRoomLightweightAgent active(@Nonnull Boolean active) {
        this.active = active;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setActive(@Nonnull Boolean active) {
        this.active = active;
    }

    public GuestRoomLightweightAgent disabilityFeatures(@Nullable List<String> disabilityFeatures) {
        this.disabilityFeatures = disabilityFeatures;
        return this;
    }

    public GuestRoomLightweightAgent addDisabilityFeaturesItem(String disabilityFeaturesItem) {
        if (this.disabilityFeatures == null) {
            this.disabilityFeatures = new ArrayList<String>();
        }
        this.disabilityFeatures.add(disabilityFeaturesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="disabilityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDisabilityFeatures() {
        return this.disabilityFeatures;
    }

    @JsonProperty(value="disabilityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisabilityFeatures(@Nullable List<String> disabilityFeatures) {
        this.disabilityFeatures = disabilityFeatures;
    }

    public GuestRoomLightweightAgent securityFeatures(@Nullable List<String> securityFeatures) {
        this.securityFeatures = securityFeatures;
        return this;
    }

    public GuestRoomLightweightAgent addSecurityFeaturesItem(String securityFeaturesItem) {
        if (this.securityFeatures == null) {
            this.securityFeatures = new ArrayList<String>();
        }
        this.securityFeatures.add(securityFeaturesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="securityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSecurityFeatures() {
        return this.securityFeatures;
    }

    @JsonProperty(value="securityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecurityFeatures(@Nullable List<String> securityFeatures) {
        this.securityFeatures = securityFeatures;
    }

    public GuestRoomLightweightAgent socials(@Nullable List<@Valid SocialAgent> socials) {
        this.socials = socials;
        return this;
    }

    public GuestRoomLightweightAgent addSocialsItem(SocialAgent socialsItem) {
        if (this.socials == null) {
            this.socials = new ArrayList<SocialAgent>();
        }
        this.socials.add(socialsItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid List<@Valid SocialAgent> getSocials() {
        return this.socials;
    }

    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSocials(@Nullable List<@Valid SocialAgent> socials) {
        this.socials = socials;
    }

    public GuestRoomLightweightAgent pricePoint(@Nonnull PricePointEnum pricePoint) {
        this.pricePoint = pricePoint;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="pricePoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricePointEnum getPricePoint() {
        return this.pricePoint;
    }

    @JsonProperty(value="pricePoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPricePoint(@Nonnull PricePointEnum pricePoint) {
        this.pricePoint = pricePoint;
    }

    public GuestRoomLightweightAgent recognitionList(@Nullable List<@Valid TravelInventoryRecognitionAgent> recognitionList) {
        this.recognitionList = recognitionList;
        return this;
    }

    public GuestRoomLightweightAgent addRecognitionListItem(TravelInventoryRecognitionAgent recognitionListItem) {
        if (this.recognitionList == null) {
            this.recognitionList = new ArrayList<TravelInventoryRecognitionAgent>();
        }
        this.recognitionList.add(recognitionListItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="recognitionList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid List<@Valid TravelInventoryRecognitionAgent> getRecognitionList() {
        return this.recognitionList;
    }

    @JsonProperty(value="recognitionList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecognitionList(@Nullable List<@Valid TravelInventoryRecognitionAgent> recognitionList) {
        this.recognitionList = recognitionList;
    }

    public GuestRoomLightweightAgent maxOccupancy(@Nonnull Integer maxOccupancy) {
        this.maxOccupancy = maxOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="maxOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMaxOccupancy() {
        return this.maxOccupancy;
    }

    @JsonProperty(value="maxOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxOccupancy(@Nonnull Integer maxOccupancy) {
        this.maxOccupancy = maxOccupancy;
    }

    public GuestRoomLightweightAgent minOccupancy(@Nonnull Integer minOccupancy) {
        this.minOccupancy = minOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="minOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMinOccupancy() {
        return this.minOccupancy;
    }

    @JsonProperty(value="minOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMinOccupancy(@Nonnull Integer minOccupancy) {
        this.minOccupancy = minOccupancy;
    }

    public GuestRoomLightweightAgent quantity(@Nonnull Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setQuantity(@Nonnull Integer quantity) {
        this.quantity = quantity;
    }

    public GuestRoomLightweightAgent nonSmoking(@Nonnull Boolean nonSmoking) {
        this.nonSmoking = nonSmoking;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="nonSmoking")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getNonSmoking() {
        return this.nonSmoking;
    }

    @JsonProperty(value="nonSmoking")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNonSmoking(@Nonnull Boolean nonSmoking) {
        this.nonSmoking = nonSmoking;
    }

    public GuestRoomLightweightAgent bedroomConfigurationList(@Nonnull List<@Valid BedroomConfigurationAgent> bedroomConfigurationList) {
        this.bedroomConfigurationList = bedroomConfigurationList;
        return this;
    }

    public GuestRoomLightweightAgent addBedroomConfigurationListItem(BedroomConfigurationAgent bedroomConfigurationListItem) {
        if (this.bedroomConfigurationList == null) {
            this.bedroomConfigurationList = new ArrayList<BedroomConfigurationAgent>();
        }
        this.bedroomConfigurationList.add(bedroomConfigurationListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="bedroomConfigurationList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) List<@Valid BedroomConfigurationAgent> getBedroomConfigurationList() {
        return this.bedroomConfigurationList;
    }

    @JsonProperty(value="bedroomConfigurationList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBedroomConfigurationList(@Nonnull List<@Valid BedroomConfigurationAgent> bedroomConfigurationList) {
        this.bedroomConfigurationList = bedroomConfigurationList;
    }

    public GuestRoomLightweightAgent size(@Nonnull Float size) {
        this.size = size;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="1")
    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="1") Float getSize() {
        return this.size;
    }

    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSize(@Nonnull Float size) {
        this.size = size;
    }

    public GuestRoomLightweightAgent maxAdultOccupancy(@Nonnull Integer maxAdultOccupancy) {
        this.maxAdultOccupancy = maxAdultOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="maxAdultOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMaxAdultOccupancy() {
        return this.maxAdultOccupancy;
    }

    @JsonProperty(value="maxAdultOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxAdultOccupancy(@Nonnull Integer maxAdultOccupancy) {
        this.maxAdultOccupancy = maxAdultOccupancy;
    }

    public GuestRoomLightweightAgent maxChildOccupancy(@Nonnull Integer maxChildOccupancy) {
        this.maxChildOccupancy = maxChildOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="maxChildOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getMaxChildOccupancy() {
        return this.maxChildOccupancy;
    }

    @JsonProperty(value="maxChildOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxChildOccupancy(@Nonnull Integer maxChildOccupancy) {
        this.maxChildOccupancy = maxChildOccupancy;
    }

    public GuestRoomLightweightAgent bathroomCount(@Nonnull Integer bathroomCount) {
        this.bathroomCount = bathroomCount;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="bathroomCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getBathroomCount() {
        return this.bathroomCount;
    }

    @JsonProperty(value="bathroomCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBathroomCount(@Nonnull Integer bathroomCount) {
        this.bathroomCount = bathroomCount;
    }

    public GuestRoomLightweightAgent livingRoomCount(@Nonnull Integer livingRoomCount) {
        this.livingRoomCount = livingRoomCount;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="livingRoomCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getLivingRoomCount() {
        return this.livingRoomCount;
    }

    @JsonProperty(value="livingRoomCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLivingRoomCount(@Nonnull Integer livingRoomCount) {
        this.livingRoomCount = livingRoomCount;
    }

    public GuestRoomLightweightAgent maxRollaways(@Nonnull Integer maxRollaways) {
        this.maxRollaways = maxRollaways;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="maxRollaways")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getMaxRollaways() {
        return this.maxRollaways;
    }

    @JsonProperty(value="maxRollaways")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxRollaways(@Nonnull Integer maxRollaways) {
        this.maxRollaways = maxRollaways;
    }

    public GuestRoomLightweightAgent roomCategory(@Nonnull String roomCategory) {
        this.roomCategory = roomCategory;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="roomCategory")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getRoomCategory() {
        return this.roomCategory;
    }

    @JsonProperty(value="roomCategory")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomCategory(@Nonnull String roomCategory) {
        this.roomCategory = roomCategory;
    }

    public GuestRoomLightweightAgent floor(@Nullable String floor) {
        this.floor = floor;
        return this;
    }

    @Nullable
    @JsonProperty(value="floor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFloor() {
        return this.floor;
    }

    @JsonProperty(value="floor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFloor(@Nullable String floor) {
        this.floor = floor;
    }

    public GuestRoomLightweightAgent roomLocationCode(@Nonnull String roomLocationCode) {
        this.roomLocationCode = roomLocationCode;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="roomLocationCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getRoomLocationCode() {
        return this.roomLocationCode;
    }

    @JsonProperty(value="roomLocationCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomLocationCode(@Nonnull String roomLocationCode) {
        this.roomLocationCode = roomLocationCode;
    }

    public GuestRoomLightweightAgent roomViewCode(@Nonnull String roomViewCode) {
        this.roomViewCode = roomViewCode;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="roomViewCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getRoomViewCode() {
        return this.roomViewCode;
    }

    @JsonProperty(value="roomViewCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomViewCode(@Nonnull String roomViewCode) {
        this.roomViewCode = roomViewCode;
    }

    public GuestRoomLightweightAgent composite(@Nonnull Boolean composite) {
        this.composite = composite;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="composite")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getComposite() {
        return this.composite;
    }

    @JsonProperty(value="composite")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setComposite(@Nonnull Boolean composite) {
        this.composite = composite;
    }

    public GuestRoomLightweightAgent compositeCount(@Nonnull Integer compositeCount) {
        this.compositeCount = compositeCount;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="compositeCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getCompositeCount() {
        return this.compositeCount;
    }

    @JsonProperty(value="compositeCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCompositeCount(@Nonnull Integer compositeCount) {
        this.compositeCount = compositeCount;
    }

    public GuestRoomLightweightAgent roomClassificationCode(@Nonnull String roomClassificationCode) {
        this.roomClassificationCode = roomClassificationCode;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="roomClassificationCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getRoomClassificationCode() {
        return this.roomClassificationCode;
    }

    @JsonProperty(value="roomClassificationCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomClassificationCode(@Nonnull String roomClassificationCode) {
        this.roomClassificationCode = roomClassificationCode;
    }

    public GuestRoomLightweightAgent roomArchitectureCode(@Nonnull String roomArchitectureCode) {
        this.roomArchitectureCode = roomArchitectureCode;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="roomArchitectureCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getRoomArchitectureCode() {
        return this.roomArchitectureCode;
    }

    @JsonProperty(value="roomArchitectureCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomArchitectureCode(@Nonnull String roomArchitectureCode) {
        this.roomArchitectureCode = roomArchitectureCode;
    }

    public GuestRoomLightweightAgent roomGender(@Nullable RoomGenderEnum roomGender) {
        this.roomGender = roomGender;
        return this;
    }

    @Nullable
    @JsonProperty(value="roomGender")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RoomGenderEnum getRoomGender() {
        return this.roomGender;
    }

    @JsonProperty(value="roomGender")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoomGender(@Nullable RoomGenderEnum roomGender) {
        this.roomGender = roomGender;
    }

    public GuestRoomLightweightAgent sharedRoomInd(@Nonnull Boolean sharedRoomInd) {
        this.sharedRoomInd = sharedRoomInd;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="sharedRoomInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getSharedRoomInd() {
        return this.sharedRoomInd;
    }

    @JsonProperty(value="sharedRoomInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSharedRoomInd(@Nonnull Boolean sharedRoomInd) {
        this.sharedRoomInd = sharedRoomInd;
    }

    public GuestRoomLightweightAgent maxCribs(@Nonnull Integer maxCribs) {
        this.maxCribs = maxCribs;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="maxCribs")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getMaxCribs() {
        return this.maxCribs;
    }

    @JsonProperty(value="maxCribs")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxCribs(@Nonnull Integer maxCribs) {
        this.maxCribs = maxCribs;
    }

    public GuestRoomLightweightAgent amenities(@Nullable List<String> amenities) {
        this.amenities = amenities;
        return this;
    }

    public GuestRoomLightweightAgent addAmenitiesItem(String amenitiesItem) {
        if (this.amenities == null) {
            this.amenities = new ArrayList<String>();
        }
        this.amenities.add(amenitiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="amenities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAmenities() {
        return this.amenities;
    }

    @JsonProperty(value="amenities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmenities(@Nullable List<String> amenities) {
        this.amenities = amenities;
    }

    public GuestRoomLightweightAgent includedAdultOccupancy(@Nonnull Integer includedAdultOccupancy) {
        this.includedAdultOccupancy = includedAdultOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="includedAdultOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getIncludedAdultOccupancy() {
        return this.includedAdultOccupancy;
    }

    @JsonProperty(value="includedAdultOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIncludedAdultOccupancy(@Nonnull Integer includedAdultOccupancy) {
        this.includedAdultOccupancy = includedAdultOccupancy;
    }

    public GuestRoomLightweightAgent includedChildOccupancy(@Nonnull Integer includedChildOccupancy) {
        this.includedChildOccupancy = includedChildOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="includedChildOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getIncludedChildOccupancy() {
        return this.includedChildOccupancy;
    }

    @JsonProperty(value="includedChildOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIncludedChildOccupancy(@Nonnull Integer includedChildOccupancy) {
        this.includedChildOccupancy = includedChildOccupancy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GuestRoomLightweightAgent guestRoomLightweightAgent = (GuestRoomLightweightAgent)o;
        return Objects.equals(this.identifier, guestRoomLightweightAgent.identifier) && Objects.equals(this.hotelIdentifier, guestRoomLightweightAgent.hotelIdentifier) && Objects.equals(this.featuredInd, guestRoomLightweightAgent.featuredInd) && Objects.equals((Object)this.lifestyleType, (Object)guestRoomLightweightAgent.lifestyleType) && Objects.equals(this.location, guestRoomLightweightAgent.location) && Objects.equals(this.descriptions, guestRoomLightweightAgent.descriptions) && Objects.equals(this.multimedias, guestRoomLightweightAgent.multimedias) && Objects.equals(this.contact, guestRoomLightweightAgent.contact) && Objects.equals(this.address, guestRoomLightweightAgent.address) && Objects.equals(this.commissionable, guestRoomLightweightAgent.commissionable) && Objects.equals(this.name, guestRoomLightweightAgent.name) && Objects.equals(this.proximityCode, guestRoomLightweightAgent.proximityCode) && Objects.equals(this.sort, guestRoomLightweightAgent.sort) && Objects.equals(this.minAgeAppropriateCode, guestRoomLightweightAgent.minAgeAppropriateCode) && Objects.equals(this.bookable, guestRoomLightweightAgent.bookable) && Objects.equals(this.active, guestRoomLightweightAgent.active) && Objects.equals(this.disabilityFeatures, guestRoomLightweightAgent.disabilityFeatures) && Objects.equals(this.securityFeatures, guestRoomLightweightAgent.securityFeatures) && Objects.equals(this.socials, guestRoomLightweightAgent.socials) && Objects.equals((Object)this.pricePoint, (Object)guestRoomLightweightAgent.pricePoint) && Objects.equals(this.recognitionList, guestRoomLightweightAgent.recognitionList) && Objects.equals(this.maxOccupancy, guestRoomLightweightAgent.maxOccupancy) && Objects.equals(this.minOccupancy, guestRoomLightweightAgent.minOccupancy) && Objects.equals(this.quantity, guestRoomLightweightAgent.quantity) && Objects.equals(this.nonSmoking, guestRoomLightweightAgent.nonSmoking) && Objects.equals(this.bedroomConfigurationList, guestRoomLightweightAgent.bedroomConfigurationList) && Objects.equals(this.size, guestRoomLightweightAgent.size) && Objects.equals(this.maxAdultOccupancy, guestRoomLightweightAgent.maxAdultOccupancy) && Objects.equals(this.maxChildOccupancy, guestRoomLightweightAgent.maxChildOccupancy) && Objects.equals(this.bathroomCount, guestRoomLightweightAgent.bathroomCount) && Objects.equals(this.livingRoomCount, guestRoomLightweightAgent.livingRoomCount) && Objects.equals(this.maxRollaways, guestRoomLightweightAgent.maxRollaways) && Objects.equals(this.roomCategory, guestRoomLightweightAgent.roomCategory) && Objects.equals(this.floor, guestRoomLightweightAgent.floor) && Objects.equals(this.roomLocationCode, guestRoomLightweightAgent.roomLocationCode) && Objects.equals(this.roomViewCode, guestRoomLightweightAgent.roomViewCode) && Objects.equals(this.composite, guestRoomLightweightAgent.composite) && Objects.equals(this.compositeCount, guestRoomLightweightAgent.compositeCount) && Objects.equals(this.roomClassificationCode, guestRoomLightweightAgent.roomClassificationCode) && Objects.equals(this.roomArchitectureCode, guestRoomLightweightAgent.roomArchitectureCode) && Objects.equals((Object)this.roomGender, (Object)guestRoomLightweightAgent.roomGender) && Objects.equals(this.sharedRoomInd, guestRoomLightweightAgent.sharedRoomInd) && Objects.equals(this.maxCribs, guestRoomLightweightAgent.maxCribs) && Objects.equals(this.amenities, guestRoomLightweightAgent.amenities) && Objects.equals(this.includedAdultOccupancy, guestRoomLightweightAgent.includedAdultOccupancy) && Objects.equals(this.includedChildOccupancy, guestRoomLightweightAgent.includedChildOccupancy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.hotelIdentifier, this.featuredInd, this.lifestyleType, this.location, this.descriptions, this.multimedias, this.contact, this.address, this.commissionable, this.name, this.proximityCode, this.sort, this.minAgeAppropriateCode, this.bookable, this.active, this.disabilityFeatures, this.securityFeatures, this.socials, this.pricePoint, this.recognitionList, this.maxOccupancy, this.minOccupancy, this.quantity, this.nonSmoking, this.bedroomConfigurationList, this.size, this.maxAdultOccupancy, this.maxChildOccupancy, this.bathroomCount, this.livingRoomCount, this.maxRollaways, this.roomCategory, this.floor, this.roomLocationCode, this.roomViewCode, this.composite, this.compositeCount, this.roomClassificationCode, this.roomArchitectureCode, this.roomGender, this.sharedRoomInd, this.maxCribs, this.amenities, this.includedAdultOccupancy, this.includedChildOccupancy});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GuestRoomLightweightAgent {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    featuredInd: ").append(this.toIndentedString(this.featuredInd)).append("\n");
        sb.append("    lifestyleType: ").append(this.toIndentedString((Object)this.lifestyleType)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    multimedias: ").append(this.toIndentedString(this.multimedias)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    commissionable: ").append(this.toIndentedString(this.commissionable)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    proximityCode: ").append(this.toIndentedString(this.proximityCode)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    minAgeAppropriateCode: ").append(this.toIndentedString(this.minAgeAppropriateCode)).append("\n");
        sb.append("    bookable: ").append(this.toIndentedString(this.bookable)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    disabilityFeatures: ").append(this.toIndentedString(this.disabilityFeatures)).append("\n");
        sb.append("    securityFeatures: ").append(this.toIndentedString(this.securityFeatures)).append("\n");
        sb.append("    socials: ").append(this.toIndentedString(this.socials)).append("\n");
        sb.append("    pricePoint: ").append(this.toIndentedString((Object)this.pricePoint)).append("\n");
        sb.append("    recognitionList: ").append(this.toIndentedString(this.recognitionList)).append("\n");
        sb.append("    maxOccupancy: ").append(this.toIndentedString(this.maxOccupancy)).append("\n");
        sb.append("    minOccupancy: ").append(this.toIndentedString(this.minOccupancy)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    nonSmoking: ").append(this.toIndentedString(this.nonSmoking)).append("\n");
        sb.append("    bedroomConfigurationList: ").append(this.toIndentedString(this.bedroomConfigurationList)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    maxAdultOccupancy: ").append(this.toIndentedString(this.maxAdultOccupancy)).append("\n");
        sb.append("    maxChildOccupancy: ").append(this.toIndentedString(this.maxChildOccupancy)).append("\n");
        sb.append("    bathroomCount: ").append(this.toIndentedString(this.bathroomCount)).append("\n");
        sb.append("    livingRoomCount: ").append(this.toIndentedString(this.livingRoomCount)).append("\n");
        sb.append("    maxRollaways: ").append(this.toIndentedString(this.maxRollaways)).append("\n");
        sb.append("    roomCategory: ").append(this.toIndentedString(this.roomCategory)).append("\n");
        sb.append("    floor: ").append(this.toIndentedString(this.floor)).append("\n");
        sb.append("    roomLocationCode: ").append(this.toIndentedString(this.roomLocationCode)).append("\n");
        sb.append("    roomViewCode: ").append(this.toIndentedString(this.roomViewCode)).append("\n");
        sb.append("    composite: ").append(this.toIndentedString(this.composite)).append("\n");
        sb.append("    compositeCount: ").append(this.toIndentedString(this.compositeCount)).append("\n");
        sb.append("    roomClassificationCode: ").append(this.toIndentedString(this.roomClassificationCode)).append("\n");
        sb.append("    roomArchitectureCode: ").append(this.toIndentedString(this.roomArchitectureCode)).append("\n");
        sb.append("    roomGender: ").append(this.toIndentedString((Object)this.roomGender)).append("\n");
        sb.append("    sharedRoomInd: ").append(this.toIndentedString(this.sharedRoomInd)).append("\n");
        sb.append("    maxCribs: ").append(this.toIndentedString(this.maxCribs)).append("\n");
        sb.append("    amenities: ").append(this.toIndentedString(this.amenities)).append("\n");
        sb.append("    includedAdultOccupancy: ").append(this.toIndentedString(this.includedAdultOccupancy)).append("\n");
        sb.append("    includedChildOccupancy: ").append(this.toIndentedString(this.includedChildOccupancy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PricePointEnum {
        HALF(String.valueOf("HALF")),
        ONE(String.valueOf("ONE")),
        ONE_HALF(String.valueOf("ONE_HALF")),
        TWO(String.valueOf("TWO")),
        TWO_HALF(String.valueOf("TWO_HALF")),
        THREE(String.valueOf("THREE")),
        THREE_HALF(String.valueOf("THREE_HALF")),
        FOUR(String.valueOf("FOUR")),
        FOUR_HALF(String.valueOf("FOUR_HALF")),
        FIVE(String.valueOf("FIVE"));

        private String value;

        private PricePointEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricePointEnum fromValue(String value) {
            for (PricePointEnum b : PricePointEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RoomGenderEnum {
        MALE(String.valueOf("Male")),
        FEMALE(String.valueOf("Female")),
        MALE_AND_FEMALE(String.valueOf("MaleAndFemale")),
        UNKNOWN(String.valueOf("Unknown"));

        private String value;

        private RoomGenderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RoomGenderEnum fromValue(String value) {
            for (RoomGenderEnum b : RoomGenderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum LifestyleTypeEnum {
        LIFESTYLE_HEALTH_FITNESS(String.valueOf("LIFESTYLE_HEALTH_FITNESS")),
        LIFESTYLE_RELAX(String.valueOf("LIFESTYLE_RELAX")),
        LIFESTYLE_ADULT_ONLY(String.valueOf("LIFESTYLE_ADULT_ONLY")),
        LIFESTYLE_ADVENTURE(String.valueOf("LIFESTYLE_ADVENTURE")),
        LIFESTYLE_BUSINESS(String.valueOf("LIFESTYLE_BUSINESS")),
        LIFESTYLE_LGBT(String.valueOf("LIFESTYLE_LGBT")),
        LIFESTYLE_SINGLE_PARENT(String.valueOf("LIFESTYLE_SINGLE_PARENT")),
        LIFESTYLE_SOLO_FEMALE(String.valueOf("LIFESTYLE_SOLO_FEMALE")),
        LIFESTYLE_BEAUTY(String.valueOf("LIFESTYLE_BEAUTY")),
        LIFESTYLE_FOODIE(String.valueOf("LIFESTYLE_FOODIE")),
        LIFESTYLE_FAMILY(String.valueOf("LIFESTYLE_FAMILY")),
        LIFESTYLE_ROMANCE(String.valueOf("LIFESTYLE_ROMANCE")),
        LIFESTYLE_COUPLE(String.valueOf("LIFESTYLE_COUPLE")),
        LIFESTYLE_SOLO(String.valueOf("LIFESTYLE_SOLO")),
        LIFESTYLE_BACKPACKER(String.valueOf("LIFESTYLE_BACKPACKER")),
        LIFESTYLE_SHOPPING(String.valueOf("LIFESTYLE_SHOPPING")),
        LIFESTYLE_SPORTS(String.valueOf("LIFESTYLE_SPORTS")),
        LIFESTYLE_MOUNTAIN(String.valueOf("LIFESTYLE_MOUNTAIN")),
        LIFESTYLE_BEACH(String.valueOf("LIFESTYLE_BEACH")),
        LIFESTYLE_CITY(String.valueOf("LIFESTYLE_CITY")),
        LIFESTYLE_COUNTRY(String.valueOf("LIFESTYLE_COUNTRY")),
        LIFESTYLE_CULTURE(String.valueOf("LIFESTYLE_CULTURE")),
        LIFESTYLE_ECO(String.valueOf("LIFESTYLE_ECO"));

        private String value;

        private LifestyleTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LifestyleTypeEnum fromValue(String value) {
            for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

