/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.travel.agent.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.travel.agent.model.BedroomConfigurationAgent;
import travel.wink.sdk.travel.agent.model.CancellationPolicyLightweightAgent;
import travel.wink.sdk.travel.agent.model.CustomMonetaryAmount;
import travel.wink.sdk.travel.agent.model.ExtraChargesAgent;
import travel.wink.sdk.travel.agent.model.GuestRoomLightweightAgent;
import travel.wink.sdk.travel.agent.model.PerkLightweightAgent;
import travel.wink.sdk.travel.agent.model.PropertyPolicyAgent;
import travel.wink.sdk.travel.agent.model.RoomConfigurationPriceRatePlanAgent;
import travel.wink.sdk.travel.agent.model.StayRateAgent;

@JsonPropertyOrder(value={"policy", "room", "rooms", "bedroomConfiguration", "adults", "children", "startDate", "endDate", "price", "roomRateIdentifier", "roomRateInternalName", "ratePlan", "perkTypes", "extraCharges", "activeCancellationPolicy", "cancellable", "cancellableByHotel", "cancellableWithPotentialCharge", "roomNights", "guests", "rateSource", "sourceTotal", "userSpecifiedCurrencyTotal", "internalTotal"})
@JsonTypeName(value="RoomStay_Agent")
public class RoomStayAgent {
    public static final String JSON_PROPERTY_POLICY = "policy";
    @Nonnull
    private PropertyPolicyAgent policy;
    public static final String JSON_PROPERTY_ROOM = "room";
    @Nonnull
    private GuestRoomLightweightAgent room;
    public static final String JSON_PROPERTY_ROOMS = "rooms";
    @Nonnull
    private Integer rooms = 1;
    public static final String JSON_PROPERTY_BEDROOM_CONFIGURATION = "bedroomConfiguration";
    @Nonnull
    private BedroomConfigurationAgent bedroomConfiguration;
    public static final String JSON_PROPERTY_ADULTS = "adults";
    @Nonnull
    private Integer adults = 2;
    public static final String JSON_PROPERTY_CHILDREN = "children";
    @Nonnull
    private Integer children = 0;
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    @Nonnull
    private LocalDate startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    @Nonnull
    private LocalDate endDate;
    public static final String JSON_PROPERTY_PRICE = "price";
    @Nonnull
    private StayRateAgent price;
    public static final String JSON_PROPERTY_ROOM_RATE_IDENTIFIER = "roomRateIdentifier";
    @Nonnull
    private UUID roomRateIdentifier;
    public static final String JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME = "roomRateInternalName";
    @Nonnull
    private String roomRateInternalName;
    public static final String JSON_PROPERTY_RATE_PLAN = "ratePlan";
    @Nonnull
    private RoomConfigurationPriceRatePlanAgent ratePlan;
    public static final String JSON_PROPERTY_PERK_TYPES = "perkTypes";
    @Nullable
    private List<@Valid PerkLightweightAgent> perkTypes = new ArrayList<PerkLightweightAgent>();
    public static final String JSON_PROPERTY_EXTRA_CHARGES = "extraCharges";
    @Nonnull
    private ExtraChargesAgent extraCharges;
    public static final String JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY = "activeCancellationPolicy";
    @Nonnull
    private CancellationPolicyLightweightAgent activeCancellationPolicy;
    public static final String JSON_PROPERTY_CANCELLABLE = "cancellable";
    @Nullable
    private Boolean cancellable;
    public static final String JSON_PROPERTY_CANCELLABLE_BY_HOTEL = "cancellableByHotel";
    @Nullable
    private Boolean cancellableByHotel;
    public static final String JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGE = "cancellableWithPotentialCharge";
    @Nullable
    private Boolean cancellableWithPotentialCharge;
    public static final String JSON_PROPERTY_ROOM_NIGHTS = "roomNights";
    @Nullable
    private Long roomNights;
    public static final String JSON_PROPERTY_GUESTS = "guests";
    @Nullable
    private Integer guests;
    public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
    @Nullable
    private String rateSource;
    public static final String JSON_PROPERTY_SOURCE_TOTAL = "sourceTotal";
    @Nullable
    private CustomMonetaryAmount sourceTotal;
    public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL = "userSpecifiedCurrencyTotal";
    @Nullable
    private CustomMonetaryAmount userSpecifiedCurrencyTotal;
    public static final String JSON_PROPERTY_INTERNAL_TOTAL = "internalTotal";
    @Nullable
    private CustomMonetaryAmount internalTotal;

    public RoomStayAgent policy(@Nonnull PropertyPolicyAgent policy) {
        this.policy = policy;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PropertyPolicyAgent getPolicy() {
        return this.policy;
    }

    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPolicy(@Nonnull PropertyPolicyAgent policy) {
        this.policy = policy;
    }

    public RoomStayAgent room(@Nonnull GuestRoomLightweightAgent room) {
        this.room = room;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="room")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GuestRoomLightweightAgent getRoom() {
        return this.room;
    }

    @JsonProperty(value="room")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoom(@Nonnull GuestRoomLightweightAgent room) {
        this.room = room;
    }

    public RoomStayAgent rooms(@Nonnull Integer rooms) {
        this.rooms = rooms;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="rooms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getRooms() {
        return this.rooms;
    }

    @JsonProperty(value="rooms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRooms(@Nonnull Integer rooms) {
        this.rooms = rooms;
    }

    public RoomStayAgent bedroomConfiguration(@Nonnull BedroomConfigurationAgent bedroomConfiguration) {
        this.bedroomConfiguration = bedroomConfiguration;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="bedroomConfiguration")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BedroomConfigurationAgent getBedroomConfiguration() {
        return this.bedroomConfiguration;
    }

    @JsonProperty(value="bedroomConfiguration")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBedroomConfiguration(@Nonnull BedroomConfigurationAgent bedroomConfiguration) {
        this.bedroomConfiguration = bedroomConfiguration;
    }

    public RoomStayAgent adults(@Nonnull Integer adults) {
        this.adults = adults;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="adults")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getAdults() {
        return this.adults;
    }

    @JsonProperty(value="adults")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAdults(@Nonnull Integer adults) {
        this.adults = adults;
    }

    public RoomStayAgent children(@Nonnull Integer children) {
        this.children = children;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getChildren() {
        return this.children;
    }

    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setChildren(@Nonnull Integer children) {
        this.children = children;
    }

    public RoomStayAgent startDate(@Nonnull LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStartDate(@Nonnull LocalDate startDate) {
        this.startDate = startDate;
    }

    public RoomStayAgent endDate(@Nonnull LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEndDate(@Nonnull LocalDate endDate) {
        this.endDate = endDate;
    }

    public RoomStayAgent price(@Nonnull StayRateAgent price) {
        this.price = price;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StayRateAgent getPrice() {
        return this.price;
    }

    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPrice(@Nonnull StayRateAgent price) {
        this.price = price;
    }

    public RoomStayAgent roomRateIdentifier(@Nonnull UUID roomRateIdentifier) {
        this.roomRateIdentifier = roomRateIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="roomRateIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getRoomRateIdentifier() {
        return this.roomRateIdentifier;
    }

    @JsonProperty(value="roomRateIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomRateIdentifier(@Nonnull UUID roomRateIdentifier) {
        this.roomRateIdentifier = roomRateIdentifier;
    }

    public RoomStayAgent roomRateInternalName(@Nonnull String roomRateInternalName) {
        this.roomRateInternalName = roomRateInternalName;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="roomRateInternalName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getRoomRateInternalName() {
        return this.roomRateInternalName;
    }

    @JsonProperty(value="roomRateInternalName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomRateInternalName(@Nonnull String roomRateInternalName) {
        this.roomRateInternalName = roomRateInternalName;
    }

    public RoomStayAgent ratePlan(@Nonnull RoomConfigurationPriceRatePlanAgent ratePlan) {
        this.ratePlan = ratePlan;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="ratePlan")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RoomConfigurationPriceRatePlanAgent getRatePlan() {
        return this.ratePlan;
    }

    @JsonProperty(value="ratePlan")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRatePlan(@Nonnull RoomConfigurationPriceRatePlanAgent ratePlan) {
        this.ratePlan = ratePlan;
    }

    public RoomStayAgent perkTypes(@Nullable List<@Valid PerkLightweightAgent> perkTypes) {
        this.perkTypes = perkTypes;
        return this;
    }

    public RoomStayAgent addPerkTypesItem(PerkLightweightAgent perkTypesItem) {
        if (this.perkTypes == null) {
            this.perkTypes = new ArrayList<PerkLightweightAgent>();
        }
        this.perkTypes.add(perkTypesItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="perkTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid List<@Valid PerkLightweightAgent> getPerkTypes() {
        return this.perkTypes;
    }

    @JsonProperty(value="perkTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPerkTypes(@Nullable List<@Valid PerkLightweightAgent> perkTypes) {
        this.perkTypes = perkTypes;
    }

    public RoomStayAgent extraCharges(@Nonnull ExtraChargesAgent extraCharges) {
        this.extraCharges = extraCharges;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="extraCharges")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ExtraChargesAgent getExtraCharges() {
        return this.extraCharges;
    }

    @JsonProperty(value="extraCharges")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExtraCharges(@Nonnull ExtraChargesAgent extraCharges) {
        this.extraCharges = extraCharges;
    }

    public RoomStayAgent activeCancellationPolicy(@Nonnull CancellationPolicyLightweightAgent activeCancellationPolicy) {
        this.activeCancellationPolicy = activeCancellationPolicy;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="activeCancellationPolicy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CancellationPolicyLightweightAgent getActiveCancellationPolicy() {
        return this.activeCancellationPolicy;
    }

    @JsonProperty(value="activeCancellationPolicy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setActiveCancellationPolicy(@Nonnull CancellationPolicyLightweightAgent activeCancellationPolicy) {
        this.activeCancellationPolicy = activeCancellationPolicy;
    }

    public RoomStayAgent cancellable(@Nullable Boolean cancellable) {
        this.cancellable = cancellable;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellable() {
        return this.cancellable;
    }

    @JsonProperty(value="cancellable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellable(@Nullable Boolean cancellable) {
        this.cancellable = cancellable;
    }

    public RoomStayAgent cancellableByHotel(@Nullable Boolean cancellableByHotel) {
        this.cancellableByHotel = cancellableByHotel;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellableByHotel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableByHotel() {
        return this.cancellableByHotel;
    }

    @JsonProperty(value="cancellableByHotel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableByHotel(@Nullable Boolean cancellableByHotel) {
        this.cancellableByHotel = cancellableByHotel;
    }

    public RoomStayAgent cancellableWithPotentialCharge(@Nullable Boolean cancellableWithPotentialCharge) {
        this.cancellableWithPotentialCharge = cancellableWithPotentialCharge;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellableWithPotentialCharge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableWithPotentialCharge() {
        return this.cancellableWithPotentialCharge;
    }

    @JsonProperty(value="cancellableWithPotentialCharge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableWithPotentialCharge(@Nullable Boolean cancellableWithPotentialCharge) {
        this.cancellableWithPotentialCharge = cancellableWithPotentialCharge;
    }

    public RoomStayAgent roomNights(@Nullable Long roomNights) {
        this.roomNights = roomNights;
        return this;
    }

    @Nullable
    @JsonProperty(value="roomNights")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getRoomNights() {
        return this.roomNights;
    }

    @JsonProperty(value="roomNights")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoomNights(@Nullable Long roomNights) {
        this.roomNights = roomNights;
    }

    public RoomStayAgent guests(@Nullable Integer guests) {
        this.guests = guests;
        return this;
    }

    @Nullable
    @JsonProperty(value="guests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getGuests() {
        return this.guests;
    }

    @JsonProperty(value="guests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuests(@Nullable Integer guests) {
        this.guests = guests;
    }

    public RoomStayAgent rateSource(@Nullable String rateSource) {
        this.rateSource = rateSource;
        return this;
    }

    @Nullable
    @JsonProperty(value="rateSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRateSource() {
        return this.rateSource;
    }

    @JsonProperty(value="rateSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRateSource(@Nullable String rateSource) {
        this.rateSource = rateSource;
    }

    public RoomStayAgent sourceTotal(@Nullable CustomMonetaryAmount sourceTotal) {
        this.sourceTotal = sourceTotal;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="sourceTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getSourceTotal() {
        return this.sourceTotal;
    }

    @JsonProperty(value="sourceTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceTotal(@Nullable CustomMonetaryAmount sourceTotal) {
        this.sourceTotal = sourceTotal;
    }

    public RoomStayAgent userSpecifiedCurrencyTotal(@Nullable CustomMonetaryAmount userSpecifiedCurrencyTotal) {
        this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="userSpecifiedCurrencyTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getUserSpecifiedCurrencyTotal() {
        return this.userSpecifiedCurrencyTotal;
    }

    @JsonProperty(value="userSpecifiedCurrencyTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserSpecifiedCurrencyTotal(@Nullable CustomMonetaryAmount userSpecifiedCurrencyTotal) {
        this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
    }

    public RoomStayAgent internalTotal(@Nullable CustomMonetaryAmount internalTotal) {
        this.internalTotal = internalTotal;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="internalTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getInternalTotal() {
        return this.internalTotal;
    }

    @JsonProperty(value="internalTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalTotal(@Nullable CustomMonetaryAmount internalTotal) {
        this.internalTotal = internalTotal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoomStayAgent roomStayAgent = (RoomStayAgent)o;
        return Objects.equals(this.policy, roomStayAgent.policy) && Objects.equals(this.room, roomStayAgent.room) && Objects.equals(this.rooms, roomStayAgent.rooms) && Objects.equals(this.bedroomConfiguration, roomStayAgent.bedroomConfiguration) && Objects.equals(this.adults, roomStayAgent.adults) && Objects.equals(this.children, roomStayAgent.children) && Objects.equals(this.startDate, roomStayAgent.startDate) && Objects.equals(this.endDate, roomStayAgent.endDate) && Objects.equals(this.price, roomStayAgent.price) && Objects.equals(this.roomRateIdentifier, roomStayAgent.roomRateIdentifier) && Objects.equals(this.roomRateInternalName, roomStayAgent.roomRateInternalName) && Objects.equals(this.ratePlan, roomStayAgent.ratePlan) && Objects.equals(this.perkTypes, roomStayAgent.perkTypes) && Objects.equals(this.extraCharges, roomStayAgent.extraCharges) && Objects.equals(this.activeCancellationPolicy, roomStayAgent.activeCancellationPolicy) && Objects.equals(this.cancellable, roomStayAgent.cancellable) && Objects.equals(this.cancellableByHotel, roomStayAgent.cancellableByHotel) && Objects.equals(this.cancellableWithPotentialCharge, roomStayAgent.cancellableWithPotentialCharge) && Objects.equals(this.roomNights, roomStayAgent.roomNights) && Objects.equals(this.guests, roomStayAgent.guests) && Objects.equals(this.rateSource, roomStayAgent.rateSource) && Objects.equals(this.sourceTotal, roomStayAgent.sourceTotal) && Objects.equals(this.userSpecifiedCurrencyTotal, roomStayAgent.userSpecifiedCurrencyTotal) && Objects.equals(this.internalTotal, roomStayAgent.internalTotal);
    }

    public int hashCode() {
        return Objects.hash(this.policy, this.room, this.rooms, this.bedroomConfiguration, this.adults, this.children, this.startDate, this.endDate, this.price, this.roomRateIdentifier, this.roomRateInternalName, this.ratePlan, this.perkTypes, this.extraCharges, this.activeCancellationPolicy, this.cancellable, this.cancellableByHotel, this.cancellableWithPotentialCharge, this.roomNights, this.guests, this.rateSource, this.sourceTotal, this.userSpecifiedCurrencyTotal, this.internalTotal);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoomStayAgent {\n");
        sb.append("    policy: ").append(this.toIndentedString(this.policy)).append("\n");
        sb.append("    room: ").append(this.toIndentedString(this.room)).append("\n");
        sb.append("    rooms: ").append(this.toIndentedString(this.rooms)).append("\n");
        sb.append("    bedroomConfiguration: ").append(this.toIndentedString(this.bedroomConfiguration)).append("\n");
        sb.append("    adults: ").append(this.toIndentedString(this.adults)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    roomRateIdentifier: ").append(this.toIndentedString(this.roomRateIdentifier)).append("\n");
        sb.append("    roomRateInternalName: ").append(this.toIndentedString(this.roomRateInternalName)).append("\n");
        sb.append("    ratePlan: ").append(this.toIndentedString(this.ratePlan)).append("\n");
        sb.append("    perkTypes: ").append(this.toIndentedString(this.perkTypes)).append("\n");
        sb.append("    extraCharges: ").append(this.toIndentedString(this.extraCharges)).append("\n");
        sb.append("    activeCancellationPolicy: ").append(this.toIndentedString(this.activeCancellationPolicy)).append("\n");
        sb.append("    cancellable: ").append(this.toIndentedString(this.cancellable)).append("\n");
        sb.append("    cancellableByHotel: ").append(this.toIndentedString(this.cancellableByHotel)).append("\n");
        sb.append("    cancellableWithPotentialCharge: ").append(this.toIndentedString(this.cancellableWithPotentialCharge)).append("\n");
        sb.append("    roomNights: ").append(this.toIndentedString(this.roomNights)).append("\n");
        sb.append("    guests: ").append(this.toIndentedString(this.guests)).append("\n");
        sb.append("    rateSource: ").append(this.toIndentedString(this.rateSource)).append("\n");
        sb.append("    sourceTotal: ").append(this.toIndentedString(this.sourceTotal)).append("\n");
        sb.append("    userSpecifiedCurrencyTotal: ").append(this.toIndentedString(this.userSpecifiedCurrencyTotal)).append("\n");
        sb.append("    internalTotal: ").append(this.toIndentedString(this.internalTotal)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

