/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant payment widget for all other entities.   - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # User Settings API The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink. This API lets you:  1. Application: Manage 3rd party access to Wink. 2. Bucket List: Manage your bucket list on Wink. 3. Webhook: Subscribe to receive Wink events as they occur in realtime. 4. User: Manage user settings.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.3.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.user.settings.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Customer preferences
 */
@JsonPropertyOrder({
  PreferencesNonAuthenticatedEntity.JSON_PROPERTY_PROPERTY_LOCATION_PREF,
  PreferencesNonAuthenticatedEntity.JSON_PROPERTY_PROPERTY_TYPE_PREF,
  PreferencesNonAuthenticatedEntity.JSON_PROPERTY_HOTEL_CHAIN_PREF,
  PreferencesNonAuthenticatedEntity.JSON_PROPERTY_PROPERTY_AMENITY_PREF,
  PreferencesNonAuthenticatedEntity.JSON_PROPERTY_RECREATION_SRVC_PREF,
  PreferencesNonAuthenticatedEntity.JSON_PROPERTY_BUSINESS_SRVC_PREF,
  PreferencesNonAuthenticatedEntity.JSON_PROPERTY_SECURITY_FEATURE_PREF,
  PreferencesNonAuthenticatedEntity.JSON_PROPERTY_PHYS_CHAL_FEATURE_PREF,
  PreferencesNonAuthenticatedEntity.JSON_PROPERTY_SMOKING_ALLOWED,
  PreferencesNonAuthenticatedEntity.JSON_PROPERTY_ROOM_LOCATION_PREF,
  PreferencesNonAuthenticatedEntity.JSON_PROPERTY_BED_TYPE_PREF,
  PreferencesNonAuthenticatedEntity.JSON_PROPERTY_FOOD_SRVC_PREF,
  PreferencesNonAuthenticatedEntity.JSON_PROPERTY_ROOM_AMENITY_PREF,
  PreferencesNonAuthenticatedEntity.JSON_PROPERTY_GUEST_TYPE,
  PreferencesNonAuthenticatedEntity.JSON_PROPERTY_MEAL_PREF,
  PreferencesNonAuthenticatedEntity.JSON_PROPERTY_CUISINE_PREF,
  PreferencesNonAuthenticatedEntity.JSON_PROPERTY_INTEREST_PREF,
  PreferencesNonAuthenticatedEntity.JSON_PROPERTY_BEVERAGE_PREF,
  PreferencesNonAuthenticatedEntity.JSON_PROPERTY_FOOD_PREF,
  PreferencesNonAuthenticatedEntity.JSON_PROPERTY_ALLERGIES,
  PreferencesNonAuthenticatedEntity.JSON_PROPERTY_PETS_PREF
})
@JsonTypeName("Preferences_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-12T10:05:45.651516091+07:00[Asia/Bangkok]")
public class PreferencesNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_PROPERTY_LOCATION_PREF = "propertyLocationPref";
  private String propertyLocationPref;

  public static final String JSON_PROPERTY_PROPERTY_TYPE_PREF = "propertyTypePref";
  private String propertyTypePref;

  public static final String JSON_PROPERTY_HOTEL_CHAIN_PREF = "hotelChainPref";
  private String hotelChainPref;

  public static final String JSON_PROPERTY_PROPERTY_AMENITY_PREF = "propertyAmenityPref";
  private List<String> propertyAmenityPref;

  public static final String JSON_PROPERTY_RECREATION_SRVC_PREF = "recreationSrvcPref";
  private List<String> recreationSrvcPref;

  public static final String JSON_PROPERTY_BUSINESS_SRVC_PREF = "businessSrvcPref";
  private List<String> businessSrvcPref;

  public static final String JSON_PROPERTY_SECURITY_FEATURE_PREF = "securityFeaturePref";
  private List<String> securityFeaturePref;

  public static final String JSON_PROPERTY_PHYS_CHAL_FEATURE_PREF = "physChalFeaturePref";
  private List<String> physChalFeaturePref;

  public static final String JSON_PROPERTY_SMOKING_ALLOWED = "smokingAllowed";
  private Boolean smokingAllowed;

  public static final String JSON_PROPERTY_ROOM_LOCATION_PREF = "roomLocationPref";
  private String roomLocationPref;

  public static final String JSON_PROPERTY_BED_TYPE_PREF = "bedTypePref";
  private String bedTypePref;

  public static final String JSON_PROPERTY_FOOD_SRVC_PREF = "foodSrvcPref";
  private String foodSrvcPref;

  public static final String JSON_PROPERTY_ROOM_AMENITY_PREF = "roomAmenityPref";
  private List<String> roomAmenityPref;

  public static final String JSON_PROPERTY_GUEST_TYPE = "guestType";
  private String guestType;

  public static final String JSON_PROPERTY_MEAL_PREF = "mealPref";
  private String mealPref;

  public static final String JSON_PROPERTY_CUISINE_PREF = "cuisinePref";
  private String cuisinePref;

  public static final String JSON_PROPERTY_INTEREST_PREF = "interestPref";
  private List<String> interestPref;

  public static final String JSON_PROPERTY_BEVERAGE_PREF = "beveragePref";
  private List<String> beveragePref;

  public static final String JSON_PROPERTY_FOOD_PREF = "foodPref";
  private List<String> foodPref;

  public static final String JSON_PROPERTY_ALLERGIES = "allergies";
  private List<String> allergies;

  public static final String JSON_PROPERTY_PETS_PREF = "petsPref";
  private List<String> petsPref;

  public PreferencesNonAuthenticatedEntity() {
  }

  public PreferencesNonAuthenticatedEntity propertyLocationPref(String propertyLocationPref) {
    
    this.propertyLocationPref = propertyLocationPref;
    return this;
  }

   /**
   * Indicates preference for hotel property locations.
   * @return propertyLocationPref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROPERTY_LOCATION_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPropertyLocationPref() {
    return propertyLocationPref;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_LOCATION_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertyLocationPref(String propertyLocationPref) {
    this.propertyLocationPref = propertyLocationPref;
  }


  public PreferencesNonAuthenticatedEntity propertyTypePref(String propertyTypePref) {
    
    this.propertyTypePref = propertyTypePref;
    return this;
  }

   /**
   * Indicates preference for hotel property types.
   * @return propertyTypePref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROPERTY_TYPE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPropertyTypePref() {
    return propertyTypePref;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_TYPE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertyTypePref(String propertyTypePref) {
    this.propertyTypePref = propertyTypePref;
  }


  public PreferencesNonAuthenticatedEntity hotelChainPref(String hotelChainPref) {
    
    this.hotelChainPref = hotelChainPref;
    return this;
  }

   /**
   * Identifies a preferred company by name.
   * @return hotelChainPref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_CHAIN_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelChainPref() {
    return hotelChainPref;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_CHAIN_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelChainPref(String hotelChainPref) {
    this.hotelChainPref = hotelChainPref;
  }


  public PreferencesNonAuthenticatedEntity propertyAmenityPref(List<String> propertyAmenityPref) {
    
    this.propertyAmenityPref = propertyAmenityPref;
    return this;
  }

  public PreferencesNonAuthenticatedEntity addPropertyAmenityPrefItem(String propertyAmenityPrefItem) {
    if (this.propertyAmenityPref == null) {
      this.propertyAmenityPref = new ArrayList<>();
    }
    this.propertyAmenityPref.add(propertyAmenityPrefItem);
    return this;
  }

   /**
   * Indicates preferences for hotel property amenities.
   * @return propertyAmenityPref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROPERTY_AMENITY_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPropertyAmenityPref() {
    return propertyAmenityPref;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_AMENITY_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertyAmenityPref(List<String> propertyAmenityPref) {
    this.propertyAmenityPref = propertyAmenityPref;
  }


  public PreferencesNonAuthenticatedEntity recreationSrvcPref(List<String> recreationSrvcPref) {
    
    this.recreationSrvcPref = recreationSrvcPref;
    return this;
  }

  public PreferencesNonAuthenticatedEntity addRecreationSrvcPrefItem(String recreationSrvcPrefItem) {
    if (this.recreationSrvcPref == null) {
      this.recreationSrvcPref = new ArrayList<>();
    }
    this.recreationSrvcPref.add(recreationSrvcPrefItem);
    return this;
  }

   /**
   * Indicates preference for the type of recreation services in a hotel
   * @return recreationSrvcPref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RECREATION_SRVC_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getRecreationSrvcPref() {
    return recreationSrvcPref;
  }


  @JsonProperty(JSON_PROPERTY_RECREATION_SRVC_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecreationSrvcPref(List<String> recreationSrvcPref) {
    this.recreationSrvcPref = recreationSrvcPref;
  }


  public PreferencesNonAuthenticatedEntity businessSrvcPref(List<String> businessSrvcPref) {
    
    this.businessSrvcPref = businessSrvcPref;
    return this;
  }

  public PreferencesNonAuthenticatedEntity addBusinessSrvcPrefItem(String businessSrvcPrefItem) {
    if (this.businessSrvcPref == null) {
      this.businessSrvcPref = new ArrayList<>();
    }
    this.businessSrvcPref.add(businessSrvcPrefItem);
    return this;
  }

   /**
   * Indicates preference for type of business services in a hotel
   * @return businessSrvcPref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BUSINESS_SRVC_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getBusinessSrvcPref() {
    return businessSrvcPref;
  }


  @JsonProperty(JSON_PROPERTY_BUSINESS_SRVC_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBusinessSrvcPref(List<String> businessSrvcPref) {
    this.businessSrvcPref = businessSrvcPref;
  }


  public PreferencesNonAuthenticatedEntity securityFeaturePref(List<String> securityFeaturePref) {
    
    this.securityFeaturePref = securityFeaturePref;
    return this;
  }

  public PreferencesNonAuthenticatedEntity addSecurityFeaturePrefItem(String securityFeaturePrefItem) {
    if (this.securityFeaturePref == null) {
      this.securityFeaturePref = new ArrayList<>();
    }
    this.securityFeaturePref.add(securityFeaturePrefItem);
    return this;
  }

   /**
   * Indicates preference of rtype of security features in a hotel
   * @return securityFeaturePref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SECURITY_FEATURE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getSecurityFeaturePref() {
    return securityFeaturePref;
  }


  @JsonProperty(JSON_PROPERTY_SECURITY_FEATURE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecurityFeaturePref(List<String> securityFeaturePref) {
    this.securityFeaturePref = securityFeaturePref;
  }


  public PreferencesNonAuthenticatedEntity physChalFeaturePref(List<String> physChalFeaturePref) {
    
    this.physChalFeaturePref = physChalFeaturePref;
    return this;
  }

  public PreferencesNonAuthenticatedEntity addPhysChalFeaturePrefItem(String physChalFeaturePrefItem) {
    if (this.physChalFeaturePref == null) {
      this.physChalFeaturePref = new ArrayList<>();
    }
    this.physChalFeaturePref.add(physChalFeaturePrefItem);
    return this;
  }

   /**
   * Indicates preferences for type of features required to meet the needs of persons with physical challenges, disabilities, etc.
   * @return physChalFeaturePref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PHYS_CHAL_FEATURE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPhysChalFeaturePref() {
    return physChalFeaturePref;
  }


  @JsonProperty(JSON_PROPERTY_PHYS_CHAL_FEATURE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhysChalFeaturePref(List<String> physChalFeaturePref) {
    this.physChalFeaturePref = physChalFeaturePref;
  }


  public PreferencesNonAuthenticatedEntity smokingAllowed(Boolean smokingAllowed) {
    
    this.smokingAllowed = smokingAllowed;
    return this;
  }

   /**
   * Indicates preference for smooking allowed rooms..
   * @return smokingAllowed
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SMOKING_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSmokingAllowed() {
    return smokingAllowed;
  }


  @JsonProperty(JSON_PROPERTY_SMOKING_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSmokingAllowed(Boolean smokingAllowed) {
    this.smokingAllowed = smokingAllowed;
  }


  public PreferencesNonAuthenticatedEntity roomLocationPref(String roomLocationPref) {
    
    this.roomLocationPref = roomLocationPref;
    return this;
  }

   /**
   * Indicates preference for hotel room locations.
   * @return roomLocationPref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ROOM_LOCATION_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoomLocationPref() {
    return roomLocationPref;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_LOCATION_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomLocationPref(String roomLocationPref) {
    this.roomLocationPref = roomLocationPref;
  }


  public PreferencesNonAuthenticatedEntity bedTypePref(String bedTypePref) {
    
    this.bedTypePref = bedTypePref;
    return this;
  }

   /**
   * Indicates preferences for the size and features of hotel bed types.
   * @return bedTypePref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BED_TYPE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBedTypePref() {
    return bedTypePref;
  }


  @JsonProperty(JSON_PROPERTY_BED_TYPE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBedTypePref(String bedTypePref) {
    this.bedTypePref = bedTypePref;
  }


  public PreferencesNonAuthenticatedEntity foodSrvcPref(String foodSrvcPref) {
    
    this.foodSrvcPref = foodSrvcPref;
    return this;
  }

   /**
   * Indicates preferences for type of food listener facilities in a hotel.
   * @return foodSrvcPref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FOOD_SRVC_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFoodSrvcPref() {
    return foodSrvcPref;
  }


  @JsonProperty(JSON_PROPERTY_FOOD_SRVC_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFoodSrvcPref(String foodSrvcPref) {
    this.foodSrvcPref = foodSrvcPref;
  }


  public PreferencesNonAuthenticatedEntity roomAmenityPref(List<String> roomAmenityPref) {
    
    this.roomAmenityPref = roomAmenityPref;
    return this;
  }

  public PreferencesNonAuthenticatedEntity addRoomAmenityPrefItem(String roomAmenityPrefItem) {
    if (this.roomAmenityPref == null) {
      this.roomAmenityPref = new ArrayList<>();
    }
    this.roomAmenityPref.add(roomAmenityPrefItem);
    return this;
  }

   /**
   * Indicates preferences for hotel room amenities.
   * @return roomAmenityPref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ROOM_AMENITY_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getRoomAmenityPref() {
    return roomAmenityPref;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_AMENITY_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomAmenityPref(List<String> roomAmenityPref) {
    this.roomAmenityPref = roomAmenityPref;
  }


  public PreferencesNonAuthenticatedEntity guestType(String guestType) {
    
    this.guestType = guestType;
    return this;
  }

   /**
   * Guest type
   * @return guestType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GUEST_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGuestType() {
    return guestType;
  }


  @JsonProperty(JSON_PROPERTY_GUEST_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGuestType(String guestType) {
    this.guestType = guestType;
  }


  public PreferencesNonAuthenticatedEntity mealPref(String mealPref) {
    
    this.mealPref = mealPref;
    return this;
  }

   /**
   * Indicates meal preference.
   * @return mealPref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MEAL_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMealPref() {
    return mealPref;
  }


  @JsonProperty(JSON_PROPERTY_MEAL_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMealPref(String mealPref) {
    this.mealPref = mealPref;
  }


  public PreferencesNonAuthenticatedEntity cuisinePref(String cuisinePref) {
    
    this.cuisinePref = cuisinePref;
    return this;
  }

   /**
   * Indicates cuisine preference.
   * @return cuisinePref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CUISINE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCuisinePref() {
    return cuisinePref;
  }


  @JsonProperty(JSON_PROPERTY_CUISINE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCuisinePref(String cuisinePref) {
    this.cuisinePref = cuisinePref;
  }


  public PreferencesNonAuthenticatedEntity interestPref(List<String> interestPref) {
    
    this.interestPref = interestPref;
    return this;
  }

  public PreferencesNonAuthenticatedEntity addInterestPrefItem(String interestPrefItem) {
    if (this.interestPref == null) {
      this.interestPref = new ArrayList<>();
    }
    this.interestPref.add(interestPrefItem);
    return this;
  }

   /**
   * Indicates interest preference
   * @return interestPref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INTEREST_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getInterestPref() {
    return interestPref;
  }


  @JsonProperty(JSON_PROPERTY_INTEREST_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInterestPref(List<String> interestPref) {
    this.interestPref = interestPref;
  }


  public PreferencesNonAuthenticatedEntity beveragePref(List<String> beveragePref) {
    
    this.beveragePref = beveragePref;
    return this;
  }

  public PreferencesNonAuthenticatedEntity addBeveragePrefItem(String beveragePrefItem) {
    if (this.beveragePref == null) {
      this.beveragePref = new ArrayList<>();
    }
    this.beveragePref.add(beveragePrefItem);
    return this;
  }

   /**
   * Indicates beverage preference.
   * @return beveragePref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BEVERAGE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getBeveragePref() {
    return beveragePref;
  }


  @JsonProperty(JSON_PROPERTY_BEVERAGE_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBeveragePref(List<String> beveragePref) {
    this.beveragePref = beveragePref;
  }


  public PreferencesNonAuthenticatedEntity foodPref(List<String> foodPref) {
    
    this.foodPref = foodPref;
    return this;
  }

  public PreferencesNonAuthenticatedEntity addFoodPrefItem(String foodPrefItem) {
    if (this.foodPref == null) {
      this.foodPref = new ArrayList<>();
    }
    this.foodPref.add(foodPrefItem);
    return this;
  }

   /**
   * Indicates food preference.
   * @return foodPref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FOOD_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getFoodPref() {
    return foodPref;
  }


  @JsonProperty(JSON_PROPERTY_FOOD_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFoodPref(List<String> foodPref) {
    this.foodPref = foodPref;
  }


  public PreferencesNonAuthenticatedEntity allergies(List<String> allergies) {
    
    this.allergies = allergies;
    return this;
  }

  public PreferencesNonAuthenticatedEntity addAllergiesItem(String allergiesItem) {
    if (this.allergies == null) {
      this.allergies = new ArrayList<>();
    }
    this.allergies.add(allergiesItem);
    return this;
  }

   /**
   * Indicates allergies
   * @return allergies
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ALLERGIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAllergies() {
    return allergies;
  }


  @JsonProperty(JSON_PROPERTY_ALLERGIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllergies(List<String> allergies) {
    this.allergies = allergies;
  }


  public PreferencesNonAuthenticatedEntity petsPref(List<String> petsPref) {
    
    this.petsPref = petsPref;
    return this;
  }

  public PreferencesNonAuthenticatedEntity addPetsPrefItem(String petsPrefItem) {
    if (this.petsPref == null) {
      this.petsPref = new ArrayList<>();
    }
    this.petsPref.add(petsPrefItem);
    return this;
  }

   /**
   * Indicates pet preferences
   * @return petsPref
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PETS_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPetsPref() {
    return petsPref;
  }


  @JsonProperty(JSON_PROPERTY_PETS_PREF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPetsPref(List<String> petsPref) {
    this.petsPref = petsPref;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PreferencesNonAuthenticatedEntity preferencesNonAuthenticatedEntity = (PreferencesNonAuthenticatedEntity) o;
    return Objects.equals(this.propertyLocationPref, preferencesNonAuthenticatedEntity.propertyLocationPref) &&
        Objects.equals(this.propertyTypePref, preferencesNonAuthenticatedEntity.propertyTypePref) &&
        Objects.equals(this.hotelChainPref, preferencesNonAuthenticatedEntity.hotelChainPref) &&
        Objects.equals(this.propertyAmenityPref, preferencesNonAuthenticatedEntity.propertyAmenityPref) &&
        Objects.equals(this.recreationSrvcPref, preferencesNonAuthenticatedEntity.recreationSrvcPref) &&
        Objects.equals(this.businessSrvcPref, preferencesNonAuthenticatedEntity.businessSrvcPref) &&
        Objects.equals(this.securityFeaturePref, preferencesNonAuthenticatedEntity.securityFeaturePref) &&
        Objects.equals(this.physChalFeaturePref, preferencesNonAuthenticatedEntity.physChalFeaturePref) &&
        Objects.equals(this.smokingAllowed, preferencesNonAuthenticatedEntity.smokingAllowed) &&
        Objects.equals(this.roomLocationPref, preferencesNonAuthenticatedEntity.roomLocationPref) &&
        Objects.equals(this.bedTypePref, preferencesNonAuthenticatedEntity.bedTypePref) &&
        Objects.equals(this.foodSrvcPref, preferencesNonAuthenticatedEntity.foodSrvcPref) &&
        Objects.equals(this.roomAmenityPref, preferencesNonAuthenticatedEntity.roomAmenityPref) &&
        Objects.equals(this.guestType, preferencesNonAuthenticatedEntity.guestType) &&
        Objects.equals(this.mealPref, preferencesNonAuthenticatedEntity.mealPref) &&
        Objects.equals(this.cuisinePref, preferencesNonAuthenticatedEntity.cuisinePref) &&
        Objects.equals(this.interestPref, preferencesNonAuthenticatedEntity.interestPref) &&
        Objects.equals(this.beveragePref, preferencesNonAuthenticatedEntity.beveragePref) &&
        Objects.equals(this.foodPref, preferencesNonAuthenticatedEntity.foodPref) &&
        Objects.equals(this.allergies, preferencesNonAuthenticatedEntity.allergies) &&
        Objects.equals(this.petsPref, preferencesNonAuthenticatedEntity.petsPref);
  }

  @Override
  public int hashCode() {
    return Objects.hash(propertyLocationPref, propertyTypePref, hotelChainPref, propertyAmenityPref, recreationSrvcPref, businessSrvcPref, securityFeaturePref, physChalFeaturePref, smokingAllowed, roomLocationPref, bedTypePref, foodSrvcPref, roomAmenityPref, guestType, mealPref, cuisinePref, interestPref, beveragePref, foodPref, allergies, petsPref);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PreferencesNonAuthenticatedEntity {\n");
    sb.append("    propertyLocationPref: ").append(toIndentedString(propertyLocationPref)).append("\n");
    sb.append("    propertyTypePref: ").append(toIndentedString(propertyTypePref)).append("\n");
    sb.append("    hotelChainPref: ").append(toIndentedString(hotelChainPref)).append("\n");
    sb.append("    propertyAmenityPref: ").append(toIndentedString(propertyAmenityPref)).append("\n");
    sb.append("    recreationSrvcPref: ").append(toIndentedString(recreationSrvcPref)).append("\n");
    sb.append("    businessSrvcPref: ").append(toIndentedString(businessSrvcPref)).append("\n");
    sb.append("    securityFeaturePref: ").append(toIndentedString(securityFeaturePref)).append("\n");
    sb.append("    physChalFeaturePref: ").append(toIndentedString(physChalFeaturePref)).append("\n");
    sb.append("    smokingAllowed: ").append(toIndentedString(smokingAllowed)).append("\n");
    sb.append("    roomLocationPref: ").append(toIndentedString(roomLocationPref)).append("\n");
    sb.append("    bedTypePref: ").append(toIndentedString(bedTypePref)).append("\n");
    sb.append("    foodSrvcPref: ").append(toIndentedString(foodSrvcPref)).append("\n");
    sb.append("    roomAmenityPref: ").append(toIndentedString(roomAmenityPref)).append("\n");
    sb.append("    guestType: ").append(toIndentedString(guestType)).append("\n");
    sb.append("    mealPref: ").append(toIndentedString(mealPref)).append("\n");
    sb.append("    cuisinePref: ").append(toIndentedString(cuisinePref)).append("\n");
    sb.append("    interestPref: ").append(toIndentedString(interestPref)).append("\n");
    sb.append("    beveragePref: ").append(toIndentedString(beveragePref)).append("\n");
    sb.append("    foodPref: ").append(toIndentedString(foodPref)).append("\n");
    sb.append("    allergies: ").append(toIndentedString(allergies)).append("\n");
    sb.append("    petsPref: ").append(toIndentedString(petsPref)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

