package travel.wink.sdk.user.settings.api;

import travel.wink.sdk.user.settings.invoker.ApiClient;

import travel.wink.sdk.user.settings.model.BucketListEntryAuthenticatedEntity;
import travel.wink.sdk.user.settings.model.BucketListEntryRequestAuthenticatedEntity;
import travel.wink.sdk.user.settings.model.BucketListEntryWrapperAuthenticatedEntity;
import travel.wink.sdk.user.settings.model.GenericErrorMessage;
import travel.wink.sdk.user.settings.model.RemoveEntryResponseAuthenticatedEntity;
import travel.wink.sdk.user.settings.model.ShowProfile400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T20:25:31.497336208+07:00[Asia/Bangkok]")
public class BucketListApi {
    private ApiClient apiClient;

    public BucketListApi() {
        this(new ApiClient());
    }

    @Autowired
    public BucketListApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * 
     * 
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Affiliate account identifier
     * @param bucketListEntryRequestAuthenticatedEntity The bucketListEntryRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return BucketListEntryAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec addBucketListEntryRequestCreation(String companyIdentifier, BucketListEntryRequestAuthenticatedEntity bucketListEntryRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        Object postBody = bucketListEntryRequestAuthenticatedEntity;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling addBucketListEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bucketListEntryRequestAuthenticatedEntity' is set
        if (bucketListEntryRequestAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'bucketListEntryRequestAuthenticatedEntity' when calling addBucketListEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/sell/{companyIdentifier}/bucket-list", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * 
     * 
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Affiliate account identifier
     * @param bucketListEntryRequestAuthenticatedEntity The bucketListEntryRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return BucketListEntryAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BucketListEntryAuthenticatedEntity> addBucketListEntry(String companyIdentifier, BucketListEntryRequestAuthenticatedEntity bucketListEntryRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>() {};
        return addBucketListEntryRequestCreation(companyIdentifier, bucketListEntryRequestAuthenticatedEntity, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * 
     * 
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Affiliate account identifier
     * @param bucketListEntryRequestAuthenticatedEntity The bucketListEntryRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BucketListEntryAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BucketListEntryAuthenticatedEntity>> addBucketListEntryWithHttpInfo(String companyIdentifier, BucketListEntryRequestAuthenticatedEntity bucketListEntryRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>() {};
        return addBucketListEntryRequestCreation(companyIdentifier, bucketListEntryRequestAuthenticatedEntity, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * 
     * 
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Affiliate account identifier
     * @param bucketListEntryRequestAuthenticatedEntity The bucketListEntryRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec addBucketListEntryWithResponseSpec(String companyIdentifier, BucketListEntryRequestAuthenticatedEntity bucketListEntryRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        return addBucketListEntryRequestCreation(companyIdentifier, bucketListEntryRequestAuthenticatedEntity, winkVersion);
    }
    /**
     * Create Bucket List
     * Create a new bucket list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param bucketListEntryRequestAuthenticatedEntity The bucketListEntryRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return BucketListEntryAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2AddBucketListEntryRequestCreation(BucketListEntryRequestAuthenticatedEntity bucketListEntryRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        Object postBody = bucketListEntryRequestAuthenticatedEntity;
        // verify the required parameter 'bucketListEntryRequestAuthenticatedEntity' is set
        if (bucketListEntryRequestAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'bucketListEntryRequestAuthenticatedEntity' when calling oauth2AddBucketListEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/bucket-list", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Bucket List
     * Create a new bucket list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param bucketListEntryRequestAuthenticatedEntity The bucketListEntryRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return BucketListEntryAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BucketListEntryAuthenticatedEntity> oauth2AddBucketListEntry(BucketListEntryRequestAuthenticatedEntity bucketListEntryRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>() {};
        return oauth2AddBucketListEntryRequestCreation(bucketListEntryRequestAuthenticatedEntity, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Bucket List
     * Create a new bucket list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param bucketListEntryRequestAuthenticatedEntity The bucketListEntryRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BucketListEntryAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BucketListEntryAuthenticatedEntity>> oauth2AddBucketListEntryWithHttpInfo(BucketListEntryRequestAuthenticatedEntity bucketListEntryRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>() {};
        return oauth2AddBucketListEntryRequestCreation(bucketListEntryRequestAuthenticatedEntity, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Bucket List
     * Create a new bucket list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param bucketListEntryRequestAuthenticatedEntity The bucketListEntryRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2AddBucketListEntryWithResponseSpec(BucketListEntryRequestAuthenticatedEntity bucketListEntryRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        return oauth2AddBucketListEntryRequestCreation(bucketListEntryRequestAuthenticatedEntity, winkVersion);
    }
    /**
     * Delete Bucket List Entry
     * Remove bucket list entry by entry identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param bucketListItemIdentifier The bucketListItemIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2RemoveBucketListRequestCreation(String bucketListItemIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'bucketListItemIdentifier' is set
        if (bucketListItemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bucketListItemIdentifier' when calling oauth2RemoveBucketList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("bucketListItemIdentifier", bucketListItemIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/bucket-list/{bucketListItemIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Bucket List Entry
     * Remove bucket list entry by entry identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param bucketListItemIdentifier The bucketListItemIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseAuthenticatedEntity> oauth2RemoveBucketList(String bucketListItemIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity>() {};
        return oauth2RemoveBucketListRequestCreation(bucketListItemIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Bucket List Entry
     * Remove bucket list entry by entry identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param bucketListItemIdentifier The bucketListItemIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RemoveEntryResponseAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseAuthenticatedEntity>> oauth2RemoveBucketListWithHttpInfo(String bucketListItemIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity>() {};
        return oauth2RemoveBucketListRequestCreation(bucketListItemIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Delete Bucket List Entry
     * Remove bucket list entry by entry identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param bucketListItemIdentifier The bucketListItemIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2RemoveBucketListWithResponseSpec(String bucketListItemIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return oauth2RemoveBucketListRequestCreation(bucketListItemIdentifier, winkVersion, accept);
    }
    /**
     * Get Bucket Lists
     * Retrieve all bucket lists for caller
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;BucketListEntryWrapperAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowBucketListRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BucketListEntryWrapperAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryWrapperAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/bucket-list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get Bucket Lists
     * Retrieve all bucket lists for caller
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;BucketListEntryWrapperAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BucketListEntryWrapperAuthenticatedEntity> oauth2ShowBucketList(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryWrapperAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryWrapperAuthenticatedEntity>() {};
        return oauth2ShowBucketListRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Get Bucket Lists
     * Retrieve all bucket lists for caller
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;BucketListEntryWrapperAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<BucketListEntryWrapperAuthenticatedEntity>>> oauth2ShowBucketListWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryWrapperAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryWrapperAuthenticatedEntity>() {};
        return oauth2ShowBucketListRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Get Bucket Lists
     * Retrieve all bucket lists for caller
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowBucketListWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return oauth2ShowBucketListRequestCreation(winkVersion, accept);
    }
    /**
     * Get Bucket List
     * Retrieve all bucket list entries for caller
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;BucketListEntryAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowBucketListEntriesRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/bucket-list/entries", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get Bucket List
     * Retrieve all bucket list entries for caller
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;BucketListEntryAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BucketListEntryAuthenticatedEntity> oauth2ShowBucketListEntries(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>() {};
        return oauth2ShowBucketListEntriesRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Get Bucket List
     * Retrieve all bucket list entries for caller
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;BucketListEntryAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<BucketListEntryAuthenticatedEntity>>> oauth2ShowBucketListEntriesWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>() {};
        return oauth2ShowBucketListEntriesRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Get Bucket List
     * Retrieve all bucket list entries for caller
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowBucketListEntriesWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return oauth2ShowBucketListEntriesRequestCreation(winkVersion, accept);
    }
    /**
     * Get Bucket List Entries
     * Retrieve bucket list entries for a specific by bucket list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param type The type parameter
     * @param identifier The identifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return BucketListEntryAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowBucketListEntryRequestCreation(String type, String identifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'type' is set
        if (type == null) {
            throw new WebClientResponseException("Missing the required parameter 'type' when calling oauth2ShowBucketListEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling oauth2ShowBucketListEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("type", type);
        pathParams.put("identifier", identifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/bucket-list/{type}/{identifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get Bucket List Entries
     * Retrieve bucket list entries for a specific by bucket list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param type The type parameter
     * @param identifier The identifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return BucketListEntryAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BucketListEntryAuthenticatedEntity> oauth2ShowBucketListEntry(String type, String identifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>() {};
        return oauth2ShowBucketListEntryRequestCreation(type, identifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Get Bucket List Entries
     * Retrieve bucket list entries for a specific by bucket list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param type The type parameter
     * @param identifier The identifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;BucketListEntryAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BucketListEntryAuthenticatedEntity>> oauth2ShowBucketListEntryWithHttpInfo(String type, String identifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>() {};
        return oauth2ShowBucketListEntryRequestCreation(type, identifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Get Bucket List Entries
     * Retrieve bucket list entries for a specific by bucket list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param type The type parameter
     * @param identifier The identifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowBucketListEntryWithResponseSpec(String type, String identifier, String winkVersion, String accept) throws WebClientResponseException {
        return oauth2ShowBucketListEntryRequestCreation(type, identifier, winkVersion, accept);
    }
    /**
     * 
     * 
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Affiliate account identifier
     * @param bucketListItemIdentifier The bucketListItemIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeBucketListRequestCreation(String companyIdentifier, String bucketListItemIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeBucketList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bucketListItemIdentifier' is set
        if (bucketListItemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bucketListItemIdentifier' when calling removeBucketList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("bucketListItemIdentifier", bucketListItemIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/sell/{companyIdentifier}/bucket-list/{bucketListItemIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * 
     * 
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Affiliate account identifier
     * @param bucketListItemIdentifier The bucketListItemIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseAuthenticatedEntity> removeBucketList(String companyIdentifier, String bucketListItemIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity>() {};
        return removeBucketListRequestCreation(companyIdentifier, bucketListItemIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * 
     * 
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Affiliate account identifier
     * @param bucketListItemIdentifier The bucketListItemIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RemoveEntryResponseAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseAuthenticatedEntity>> removeBucketListWithHttpInfo(String companyIdentifier, String bucketListItemIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity>() {};
        return removeBucketListRequestCreation(companyIdentifier, bucketListItemIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * 
     * 
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Affiliate account identifier
     * @param bucketListItemIdentifier The bucketListItemIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeBucketListWithResponseSpec(String companyIdentifier, String bucketListItemIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return removeBucketListRequestCreation(companyIdentifier, bucketListItemIdentifier, winkVersion, accept);
    }
    /**
     * 
     * 
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Affiliate account identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;BucketListEntryWrapperAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBucketListRequestCreation(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showBucketList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BucketListEntryWrapperAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryWrapperAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/sell/{companyIdentifier}/bucket-list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * 
     * 
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Affiliate account identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;BucketListEntryWrapperAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BucketListEntryWrapperAuthenticatedEntity> showBucketList(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryWrapperAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryWrapperAuthenticatedEntity>() {};
        return showBucketListRequestCreation(companyIdentifier, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * 
     * 
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Affiliate account identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;BucketListEntryWrapperAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<BucketListEntryWrapperAuthenticatedEntity>>> showBucketListWithHttpInfo(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryWrapperAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryWrapperAuthenticatedEntity>() {};
        return showBucketListRequestCreation(companyIdentifier, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * 
     * 
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Affiliate account identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showBucketListWithResponseSpec(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showBucketListRequestCreation(companyIdentifier, winkVersion, accept);
    }
    /**
     * 
     * 
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Affiliate account identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;BucketListEntryAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBucketListEntriesRequestCreation(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showBucketListEntries", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/sell/{companyIdentifier}/bucket-list/entries", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * 
     * 
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Affiliate account identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;BucketListEntryAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BucketListEntryAuthenticatedEntity> showBucketListEntries(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>() {};
        return showBucketListEntriesRequestCreation(companyIdentifier, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * 
     * 
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Affiliate account identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;BucketListEntryAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<BucketListEntryAuthenticatedEntity>>> showBucketListEntriesWithHttpInfo(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>() {};
        return showBucketListEntriesRequestCreation(companyIdentifier, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * 
     * 
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Affiliate account identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showBucketListEntriesWithResponseSpec(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showBucketListEntriesRequestCreation(companyIdentifier, winkVersion, accept);
    }
    /**
     * 
     * 
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Affiliate account identifier
     * @param type The type parameter
     * @param identifier The identifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return BucketListEntryAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBucketListEntryRequestCreation(String companyIdentifier, String type, String identifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showBucketListEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'type' is set
        if (type == null) {
            throw new WebClientResponseException("Missing the required parameter 'type' when calling showBucketListEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling showBucketListEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("type", type);
        pathParams.put("identifier", identifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/sell/{companyIdentifier}/bucket-list/{type}/{identifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * 
     * 
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Affiliate account identifier
     * @param type The type parameter
     * @param identifier The identifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return BucketListEntryAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BucketListEntryAuthenticatedEntity> showBucketListEntry(String companyIdentifier, String type, String identifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>() {};
        return showBucketListEntryRequestCreation(companyIdentifier, type, identifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * 
     * 
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Affiliate account identifier
     * @param type The type parameter
     * @param identifier The identifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;BucketListEntryAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BucketListEntryAuthenticatedEntity>> showBucketListEntryWithHttpInfo(String companyIdentifier, String type, String identifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>() {};
        return showBucketListEntryRequestCreation(companyIdentifier, type, identifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * 
     * 
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Affiliate account identifier
     * @param type The type parameter
     * @param identifier The identifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showBucketListEntryWithResponseSpec(String companyIdentifier, String type, String identifier, String winkVersion, String accept) throws WebClientResponseException {
        return showBucketListEntryRequestCreation(companyIdentifier, type, identifier, winkVersion, accept);
    }
}
