/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.user.settings.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.user.settings.invoker.ApiClient;
import travel.wink.sdk.user.settings.model.BucketListEntryAuthenticatedEntity;
import travel.wink.sdk.user.settings.model.BucketListEntryRequestAuthenticatedEntity;
import travel.wink.sdk.user.settings.model.BucketListEntryViewAuthenticatedEntity;
import travel.wink.sdk.user.settings.model.BucketListEntryWrapperAuthenticatedEntity;

public class BucketListApi {
    private ApiClient apiClient;

    public BucketListApi() {
        this(new ApiClient());
    }

    @Autowired
    public BucketListApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec oauth2AddBucketListEntryRequestCreation(BucketListEntryRequestAuthenticatedEntity bucketListEntryRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        BucketListEntryRequestAuthenticatedEntity postBody = bucketListEntryRequestAuthenticatedEntity;
        if (bucketListEntryRequestAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'bucketListEntryRequestAuthenticatedEntity' when calling oauth2AddBucketListEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BucketListEntryViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryViewAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/bucket-list", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BucketListEntryViewAuthenticatedEntity> oauth2AddBucketListEntry(BucketListEntryRequestAuthenticatedEntity bucketListEntryRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryViewAuthenticatedEntity>(this){};
        return this.oauth2AddBucketListEntryRequestCreation(bucketListEntryRequestAuthenticatedEntity, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BucketListEntryViewAuthenticatedEntity>> oauth2AddBucketListEntryWithHttpInfo(BucketListEntryRequestAuthenticatedEntity bucketListEntryRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryViewAuthenticatedEntity>(this){};
        return this.oauth2AddBucketListEntryRequestCreation(bucketListEntryRequestAuthenticatedEntity, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec oauth2AddBucketListEntryWithResponseSpec(BucketListEntryRequestAuthenticatedEntity bucketListEntryRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        return this.oauth2AddBucketListEntryRequestCreation(bucketListEntryRequestAuthenticatedEntity, winkVersion);
    }

    private WebClient.ResponseSpec oauth2RemoveBucketListRequestCreation(String bucketListItemIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (bucketListItemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bucketListItemIdentifier' when calling oauth2RemoveBucketList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("bucketListItemIdentifier", bucketListItemIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BucketListEntryViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryViewAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/bucket-list/{bucketListItemIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BucketListEntryViewAuthenticatedEntity> oauth2RemoveBucketList(String bucketListItemIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryViewAuthenticatedEntity>(this){};
        return this.oauth2RemoveBucketListRequestCreation(bucketListItemIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BucketListEntryViewAuthenticatedEntity>> oauth2RemoveBucketListWithHttpInfo(String bucketListItemIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryViewAuthenticatedEntity>(this){};
        return this.oauth2RemoveBucketListRequestCreation(bucketListItemIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec oauth2RemoveBucketListWithResponseSpec(String bucketListItemIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.oauth2RemoveBucketListRequestCreation(bucketListItemIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec oauth2ShowBucketListRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BucketListEntryWrapperAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryWrapperAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/bucket-list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<BucketListEntryWrapperAuthenticatedEntity> oauth2ShowBucketList(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryWrapperAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryWrapperAuthenticatedEntity>(this){};
        return this.oauth2ShowBucketListRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<BucketListEntryWrapperAuthenticatedEntity>>> oauth2ShowBucketListWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryWrapperAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryWrapperAuthenticatedEntity>(this){};
        return this.oauth2ShowBucketListRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec oauth2ShowBucketListWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.oauth2ShowBucketListRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec oauth2ShowBucketListEntriesRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/bucket-list/entries", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<BucketListEntryAuthenticatedEntity> oauth2ShowBucketListEntries(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>(this){};
        return this.oauth2ShowBucketListEntriesRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<BucketListEntryAuthenticatedEntity>>> oauth2ShowBucketListEntriesWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>(this){};
        return this.oauth2ShowBucketListEntriesRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec oauth2ShowBucketListEntriesWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.oauth2ShowBucketListEntriesRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec oauth2ShowBucketListEntryRequestCreation(String type, String identifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (type == null) {
            throw new WebClientResponseException("Missing the required parameter 'type' when calling oauth2ShowBucketListEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling oauth2ShowBucketListEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("type", type);
        pathParams.put("identifier", identifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/bucket-list/{type}/{identifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BucketListEntryAuthenticatedEntity> oauth2ShowBucketListEntry(String type, String identifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>(this){};
        return this.oauth2ShowBucketListEntryRequestCreation(type, identifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BucketListEntryAuthenticatedEntity>> oauth2ShowBucketListEntryWithHttpInfo(String type, String identifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>(this){};
        return this.oauth2ShowBucketListEntryRequestCreation(type, identifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec oauth2ShowBucketListEntryWithResponseSpec(String type, String identifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.oauth2ShowBucketListEntryRequestCreation(type, identifier, winkVersion, accept);
    }
}

