/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.user.settings.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.user.settings.invoker.ApiClient;
import travel.wink.sdk.user.settings.model.Application;
import travel.wink.sdk.user.settings.model.CreateApplicationResponse;
import travel.wink.sdk.user.settings.model.ManagingEntity;
import travel.wink.sdk.user.settings.model.RemoveEntryResponse;
import travel.wink.sdk.user.settings.model.RevokeClientIdResponse;
import travel.wink.sdk.user.settings.model.UpdateApplicationResponse;
import travel.wink.sdk.user.settings.model.UpsertApplicationRequest;

public class ApplicationApi {
    private ApiClient apiClient;

    public ApplicationApi() {
        this(new ApiClient());
    }

    @Autowired
    public ApplicationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createApplicationRequestCreation(UpsertApplicationRequest upsertApplicationRequest, String winkVersion) throws WebClientResponseException {
        UpsertApplicationRequest postBody = upsertApplicationRequest;
        if (upsertApplicationRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertApplicationRequest' when calling createApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CreateApplicationResponse> localVarReturnType = new ParameterizedTypeReference<CreateApplicationResponse>(this){};
        return this.apiClient.invokeAPI("/api/application", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CreateApplicationResponse> createApplication(UpsertApplicationRequest upsertApplicationRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CreateApplicationResponse> localVarReturnType = new ParameterizedTypeReference<CreateApplicationResponse>(this){};
        return this.createApplicationRequestCreation(upsertApplicationRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CreateApplicationResponse>> createApplicationWithHttpInfo(UpsertApplicationRequest upsertApplicationRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CreateApplicationResponse> localVarReturnType = new ParameterizedTypeReference<CreateApplicationResponse>(this){};
        return this.createApplicationRequestCreation(upsertApplicationRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createApplicationWithResponseSpec(UpsertApplicationRequest upsertApplicationRequest, String winkVersion) throws WebClientResponseException {
        return this.createApplicationRequestCreation(upsertApplicationRequest, winkVersion);
    }

    private WebClient.ResponseSpec deleteApplicationRequestCreation(String id, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling deleteApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(this){};
        return this.apiClient.invokeAPI("/api/application/{id}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> deleteApplication(String id, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(this){};
        return this.deleteApplicationRequestCreation(id, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> deleteApplicationWithHttpInfo(String id, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(this){};
        return this.deleteApplicationRequestCreation(id, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec deleteApplicationWithResponseSpec(String id, String winkVersion, String accept) throws WebClientResponseException {
        return this.deleteApplicationRequestCreation(id, winkVersion, accept);
    }

    private WebClient.ResponseSpec loadApplicationRequestCreation(String id, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling loadApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Application> localVarReturnType = new ParameterizedTypeReference<Application>(this){};
        return this.apiClient.invokeAPI("/api/application/{id}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Application> loadApplication(String id, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Application> localVarReturnType = new ParameterizedTypeReference<Application>(this){};
        return this.loadApplicationRequestCreation(id, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Application>> loadApplicationWithHttpInfo(String id, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Application> localVarReturnType = new ParameterizedTypeReference<Application>(this){};
        return this.loadApplicationRequestCreation(id, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec loadApplicationWithResponseSpec(String id, String winkVersion, String accept) throws WebClientResponseException {
        return this.loadApplicationRequestCreation(id, winkVersion, accept);
    }

    private WebClient.ResponseSpec revokeApplicationRequestCreation(String id, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling revokeApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RevokeClientIdResponse> localVarReturnType = new ParameterizedTypeReference<RevokeClientIdResponse>(this){};
        return this.apiClient.invokeAPI("/api/application/{id}/revoke", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RevokeClientIdResponse> revokeApplication(String id, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RevokeClientIdResponse> localVarReturnType = new ParameterizedTypeReference<RevokeClientIdResponse>(this){};
        return this.revokeApplicationRequestCreation(id, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RevokeClientIdResponse>> revokeApplicationWithHttpInfo(String id, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RevokeClientIdResponse> localVarReturnType = new ParameterizedTypeReference<RevokeClientIdResponse>(this){};
        return this.revokeApplicationRequestCreation(id, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec revokeApplicationWithResponseSpec(String id, String winkVersion, String accept) throws WebClientResponseException {
        return this.revokeApplicationRequestCreation(id, winkVersion, accept);
    }

    private WebClient.ResponseSpec showApplicationsRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Application> localVarReturnType = new ParameterizedTypeReference<Application>(this){};
        return this.apiClient.invokeAPI("/api/application/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<Application> showApplications(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Application> localVarReturnType = new ParameterizedTypeReference<Application>(this){};
        return this.showApplicationsRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<Application>>> showApplicationsWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Application> localVarReturnType = new ParameterizedTypeReference<Application>(this){};
        return this.showApplicationsRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showApplicationsWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.showApplicationsRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec showManagingEntitiesRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ManagingEntity> localVarReturnType = new ParameterizedTypeReference<ManagingEntity>(this){};
        return this.apiClient.invokeAPI("/api/managing-entity/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<ManagingEntity> showManagingEntities(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ManagingEntity> localVarReturnType = new ParameterizedTypeReference<ManagingEntity>(this){};
        return this.showManagingEntitiesRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<ManagingEntity>>> showManagingEntitiesWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ManagingEntity> localVarReturnType = new ParameterizedTypeReference<ManagingEntity>(this){};
        return this.showManagingEntitiesRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showManagingEntitiesWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.showManagingEntitiesRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec updateApplicationRequestCreation(String id, UpsertApplicationRequest upsertApplicationRequest, String winkVersion) throws WebClientResponseException {
        UpsertApplicationRequest postBody = upsertApplicationRequest;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertApplicationRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertApplicationRequest' when calling updateApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<UpdateApplicationResponse> localVarReturnType = new ParameterizedTypeReference<UpdateApplicationResponse>(this){};
        return this.apiClient.invokeAPI("/api/application/{id}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<UpdateApplicationResponse> updateApplication(String id, UpsertApplicationRequest upsertApplicationRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateApplicationResponse> localVarReturnType = new ParameterizedTypeReference<UpdateApplicationResponse>(this){};
        return this.updateApplicationRequestCreation(id, upsertApplicationRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<UpdateApplicationResponse>> updateApplicationWithHttpInfo(String id, UpsertApplicationRequest upsertApplicationRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateApplicationResponse> localVarReturnType = new ParameterizedTypeReference<UpdateApplicationResponse>(this){};
        return this.updateApplicationRequestCreation(id, upsertApplicationRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateApplicationWithResponseSpec(String id, UpsertApplicationRequest upsertApplicationRequest, String winkVersion) throws WebClientResponseException {
        return this.updateApplicationRequestCreation(id, upsertApplicationRequest, winkVersion);
    }
}

