/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.user.settings.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import travel.wink.sdk.user.settings.model.SimpleMultimedia;

@JsonPropertyOrder(value={"firstName", "lastName", "username", "profilePicture"})
public class UpsertUserProfileRequest {
    public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
    private String firstName;
    public static final String JSON_PROPERTY_LAST_NAME = "lastName";
    private String lastName;
    public static final String JSON_PROPERTY_USERNAME = "username";
    private String username;
    public static final String JSON_PROPERTY_PROFILE_PICTURE = "profilePicture";
    private SimpleMultimedia profilePicture;

    public UpsertUserProfileRequest firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public UpsertUserProfileRequest lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLastName() {
        return this.lastName;
    }

    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public UpsertUserProfileRequest username(String username) {
        this.username = username;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUsername(String username) {
        this.username = username;
    }

    public UpsertUserProfileRequest profilePicture(SimpleMultimedia profilePicture) {
        this.profilePicture = profilePicture;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="profilePicture")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SimpleMultimedia getProfilePicture() {
        return this.profilePicture;
    }

    @JsonProperty(value="profilePicture")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfilePicture(SimpleMultimedia profilePicture) {
        this.profilePicture = profilePicture;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpsertUserProfileRequest upsertUserProfileRequest = (UpsertUserProfileRequest)o;
        return Objects.equals(this.firstName, upsertUserProfileRequest.firstName) && Objects.equals(this.lastName, upsertUserProfileRequest.lastName) && Objects.equals(this.username, upsertUserProfileRequest.username) && Objects.equals(this.profilePicture, upsertUserProfileRequest.profilePicture);
    }

    public int hashCode() {
        return Objects.hash(this.firstName, this.lastName, this.username, this.profilePicture);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpsertUserProfileRequest {\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    profilePicture: ").append(this.toIndentedString(this.profilePicture)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

