package travel.wink.sdk.user.settings.api;

import travel.wink.sdk.user.settings.invoker.ApiClient;

import travel.wink.sdk.user.settings.model.BooleanResponse;
import travel.wink.sdk.user.settings.model.ChangePasswordRequest;
import travel.wink.sdk.user.settings.model.GenericErrorMessage;
import travel.wink.sdk.user.settings.model.ProfileViewNonAuthenticatedEntity;
import travel.wink.sdk.user.settings.model.ShowProfile400Response;
import travel.wink.sdk.user.settings.model.UpsertProfileRequestNonAuthenticatedEntity;
import travel.wink.sdk.user.settings.model.UpsertUserProfileRequest;
import travel.wink.sdk.user.settings.model.UpsertUserProfileResponse;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-03-04T20:51:20.637878362+07:00[Asia/Bangkok]")
public class UserSettingsApi {
    private ApiClient apiClient;

    public UserSettingsApi() {
        this(new ApiClient());
    }

    @Autowired
    public UserSettingsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Change password
     * Updates currently authenticated user&#39;s password.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param changePasswordRequest The changePasswordRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return BooleanResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec changePasswordRequestCreation(ChangePasswordRequest changePasswordRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = changePasswordRequest;
        // verify the required parameter 'changePasswordRequest' is set
        if (changePasswordRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'changePasswordRequest' when calling changePassword", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BooleanResponse> localVarReturnType = new ParameterizedTypeReference<BooleanResponse>() {};
        return apiClient.invokeAPI("/api/user-settings/change-password", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Change password
     * Updates currently authenticated user&#39;s password.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param changePasswordRequest The changePasswordRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return BooleanResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BooleanResponse> changePassword(ChangePasswordRequest changePasswordRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponse> localVarReturnType = new ParameterizedTypeReference<BooleanResponse>() {};
        return changePasswordRequestCreation(changePasswordRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Change password
     * Updates currently authenticated user&#39;s password.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param changePasswordRequest The changePasswordRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BooleanResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BooleanResponse>> changePasswordWithHttpInfo(ChangePasswordRequest changePasswordRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponse> localVarReturnType = new ParameterizedTypeReference<BooleanResponse>() {};
        return changePasswordRequestCreation(changePasswordRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Change password
     * Updates currently authenticated user&#39;s password.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param changePasswordRequest The changePasswordRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec changePasswordWithResponseSpec(ChangePasswordRequest changePasswordRequest, String winkVersion) throws WebClientResponseException {
        return changePasswordRequestCreation(changePasswordRequest, winkVersion);
    }
    /**
     * Show Profile
     * Show profile by profile owner.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ProfileViewNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showProfileRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ProfileViewNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ProfileViewNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/profile", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Profile
     * Show profile by profile owner.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ProfileViewNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ProfileViewNonAuthenticatedEntity> showProfile(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ProfileViewNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ProfileViewNonAuthenticatedEntity>() {};
        return showProfileRequestCreation(winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Profile
     * Show profile by profile owner.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;ProfileViewNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ProfileViewNonAuthenticatedEntity>> showProfileWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ProfileViewNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ProfileViewNonAuthenticatedEntity>() {};
        return showProfileRequestCreation(winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Profile
     * Show profile by profile owner.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showProfileWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return showProfileRequestCreation(winkVersion, accept);
    }
    /**
     * Show User Profile
     * Retrieves user profile data.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return UpsertUserProfileResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showUserProfileRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UpsertUserProfileResponse> localVarReturnType = new ParameterizedTypeReference<UpsertUserProfileResponse>() {};
        return apiClient.invokeAPI("/api/user-settings/profile", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show User Profile
     * Retrieves user profile data.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return UpsertUserProfileResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpsertUserProfileResponse> showUserProfile(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UpsertUserProfileResponse> localVarReturnType = new ParameterizedTypeReference<UpsertUserProfileResponse>() {};
        return showUserProfileRequestCreation(winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show User Profile
     * Retrieves user profile data.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;UpsertUserProfileResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<UpsertUserProfileResponse>> showUserProfileWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UpsertUserProfileResponse> localVarReturnType = new ParameterizedTypeReference<UpsertUserProfileResponse>() {};
        return showUserProfileRequestCreation(winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show User Profile
     * Retrieves user profile data.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showUserProfileWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return showUserProfileRequestCreation(winkVersion, accept);
    }
    /**
     * Update Profile
     * Update profile by profile owner.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertProfileRequestNonAuthenticatedEntity The upsertProfileRequestNonAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ProfileViewNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateProfileRequestCreation(UpsertProfileRequestNonAuthenticatedEntity upsertProfileRequestNonAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertProfileRequestNonAuthenticatedEntity;
        // verify the required parameter 'upsertProfileRequestNonAuthenticatedEntity' is set
        if (upsertProfileRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertProfileRequestNonAuthenticatedEntity' when calling updateProfile", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ProfileViewNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ProfileViewNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/profile", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Profile
     * Update profile by profile owner.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertProfileRequestNonAuthenticatedEntity The upsertProfileRequestNonAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ProfileViewNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ProfileViewNonAuthenticatedEntity> updateProfile(UpsertProfileRequestNonAuthenticatedEntity upsertProfileRequestNonAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ProfileViewNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ProfileViewNonAuthenticatedEntity>() {};
        return updateProfileRequestCreation(upsertProfileRequestNonAuthenticatedEntity, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Profile
     * Update profile by profile owner.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertProfileRequestNonAuthenticatedEntity The upsertProfileRequestNonAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;ProfileViewNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ProfileViewNonAuthenticatedEntity>> updateProfileWithHttpInfo(UpsertProfileRequestNonAuthenticatedEntity upsertProfileRequestNonAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ProfileViewNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ProfileViewNonAuthenticatedEntity>() {};
        return updateProfileRequestCreation(upsertProfileRequestNonAuthenticatedEntity, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Profile
     * Update profile by profile owner.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertProfileRequestNonAuthenticatedEntity The upsertProfileRequestNonAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateProfileWithResponseSpec(UpsertProfileRequestNonAuthenticatedEntity upsertProfileRequestNonAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        return updateProfileRequestCreation(upsertProfileRequestNonAuthenticatedEntity, winkVersion);
    }
    /**
     * Update User Profile
     * Updates user profile data.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertUserProfileRequest The upsertUserProfileRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return UpsertUserProfileResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateUserProfileRequestCreation(UpsertUserProfileRequest upsertUserProfileRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertUserProfileRequest;
        // verify the required parameter 'upsertUserProfileRequest' is set
        if (upsertUserProfileRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertUserProfileRequest' when calling updateUserProfile", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UpsertUserProfileResponse> localVarReturnType = new ParameterizedTypeReference<UpsertUserProfileResponse>() {};
        return apiClient.invokeAPI("/api/user-settings/profile", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update User Profile
     * Updates user profile data.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertUserProfileRequest The upsertUserProfileRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return UpsertUserProfileResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpsertUserProfileResponse> updateUserProfile(UpsertUserProfileRequest upsertUserProfileRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpsertUserProfileResponse> localVarReturnType = new ParameterizedTypeReference<UpsertUserProfileResponse>() {};
        return updateUserProfileRequestCreation(upsertUserProfileRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update User Profile
     * Updates user profile data.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertUserProfileRequest The upsertUserProfileRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;UpsertUserProfileResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<UpsertUserProfileResponse>> updateUserProfileWithHttpInfo(UpsertUserProfileRequest upsertUserProfileRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpsertUserProfileResponse> localVarReturnType = new ParameterizedTypeReference<UpsertUserProfileResponse>() {};
        return updateUserProfileRequestCreation(upsertUserProfileRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update User Profile
     * Updates user profile data.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertUserProfileRequest The upsertUserProfileRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateUserProfileWithResponseSpec(UpsertUserProfileRequest upsertUserProfileRequest, String winkVersion) throws WebClientResponseException {
        return updateUserProfileRequestCreation(upsertUserProfileRequest, winkVersion);
    }
}
