package travel.wink.sdk.user.settings.api;

import travel.wink.sdk.user.settings.invoker.ApiClient;

import travel.wink.sdk.user.settings.model.GenericErrorMessage;
import travel.wink.sdk.user.settings.model.KeyValuePair;
import travel.wink.sdk.user.settings.model.RemoveEntryResponse;
import travel.wink.sdk.user.settings.model.ShowProfile400Response;
import travel.wink.sdk.user.settings.model.UpsertWebhookRequest;
import travel.wink.sdk.user.settings.model.Webhook;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-03-04T20:51:20.637878362+07:00[Asia/Bangkok]")
public class WebhookApi {
    private ApiClient apiClient;

    public WebhookApi() {
        this(new ApiClient());
    }

    @Autowired
    public WebhookApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Webhook
     * Create a new webhook
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param upsertWebhookRequest The upsertWebhookRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Webhook
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createWebhookRequestCreation(UpsertWebhookRequest upsertWebhookRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertWebhookRequest;
        // verify the required parameter 'upsertWebhookRequest' is set
        if (upsertWebhookRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertWebhookRequest' when calling createWebhook", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Webhook> localVarReturnType = new ParameterizedTypeReference<Webhook>() {};
        return apiClient.invokeAPI("/api/webhook", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Webhook
     * Create a new webhook
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param upsertWebhookRequest The upsertWebhookRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Webhook
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Webhook> createWebhook(UpsertWebhookRequest upsertWebhookRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Webhook> localVarReturnType = new ParameterizedTypeReference<Webhook>() {};
        return createWebhookRequestCreation(upsertWebhookRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Webhook
     * Create a new webhook
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param upsertWebhookRequest The upsertWebhookRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;Webhook&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Webhook>> createWebhookWithHttpInfo(UpsertWebhookRequest upsertWebhookRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Webhook> localVarReturnType = new ParameterizedTypeReference<Webhook>() {};
        return createWebhookRequestCreation(upsertWebhookRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Webhook
     * Create a new webhook
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param upsertWebhookRequest The upsertWebhookRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createWebhookWithResponseSpec(UpsertWebhookRequest upsertWebhookRequest, String winkVersion) throws WebClientResponseException {
        return createWebhookRequestCreation(upsertWebhookRequest, winkVersion);
    }
    /**
     * Delete Webhook
     * Remove a specific webhook
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec deleteWebhookRequestCreation(String id, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling deleteWebhook", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/webhook/{id}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Webhook
     * Remove a specific webhook
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> deleteWebhook(String id, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return deleteWebhookRequestCreation(id, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Webhook
     * Remove a specific webhook
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RemoveEntryResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponse>> deleteWebhookWithHttpInfo(String id, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return deleteWebhookRequestCreation(id, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Delete Webhook
     * Remove a specific webhook
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec deleteWebhookWithResponseSpec(String id, String winkVersion, String accept) throws WebClientResponseException {
        return deleteWebhookRequestCreation(id, winkVersion, accept);
    }
    /**
     * Show Webhook
     * Show a specific webhook
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return Webhook
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec loadWebhookRequestCreation(String id, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling loadWebhook", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Webhook> localVarReturnType = new ParameterizedTypeReference<Webhook>() {};
        return apiClient.invokeAPI("/api/webhook/{id}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Webhook
     * Show a specific webhook
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return Webhook
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Webhook> loadWebhook(String id, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Webhook> localVarReturnType = new ParameterizedTypeReference<Webhook>() {};
        return loadWebhookRequestCreation(id, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Webhook
     * Show a specific webhook
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;Webhook&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Webhook>> loadWebhookWithHttpInfo(String id, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Webhook> localVarReturnType = new ParameterizedTypeReference<Webhook>() {};
        return loadWebhookRequestCreation(id, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Webhook
     * Show a specific webhook
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec loadWebhookWithResponseSpec(String id, String winkVersion, String accept) throws WebClientResponseException {
        return loadWebhookRequestCreation(id, winkVersion, accept);
    }
    /**
     * Show Webhook Event List
     * List all valid webhook events that can be subsccribed to
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePair&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showWebhookEventsRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return apiClient.invokeAPI("/api/webhook/event/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Webhook Event List
     * List all valid webhook events that can be subsccribed to
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePair&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePair> showWebhookEvents(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return showWebhookEventsRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Webhook Event List
     * List all valid webhook events that can be subsccribed to
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePair&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePair>>> showWebhookEventsWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return showWebhookEventsRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Webhook Event List
     * List all valid webhook events that can be subsccribed to
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showWebhookEventsWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return showWebhookEventsRequestCreation(winkVersion, accept);
    }
    /**
     * Show Webhooks
     * List all webhooks owned by creating entity
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;Webhook&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showWebhooksRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Webhook> localVarReturnType = new ParameterizedTypeReference<Webhook>() {};
        return apiClient.invokeAPI("/api/webhook/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Webhooks
     * List all webhooks owned by creating entity
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;Webhook&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<Webhook> showWebhooks(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Webhook> localVarReturnType = new ParameterizedTypeReference<Webhook>() {};
        return showWebhooksRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Webhooks
     * List all webhooks owned by creating entity
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;Webhook&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<Webhook>>> showWebhooksWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Webhook> localVarReturnType = new ParameterizedTypeReference<Webhook>() {};
        return showWebhooksRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Webhooks
     * List all webhooks owned by creating entity
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showWebhooksWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return showWebhooksRequestCreation(winkVersion, accept);
    }
    /**
     * Update Webhook
     * Update an existing webhook
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param upsertWebhookRequest The upsertWebhookRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Webhook
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateWebhookRequestCreation(String id, UpsertWebhookRequest upsertWebhookRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertWebhookRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateWebhook", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertWebhookRequest' is set
        if (upsertWebhookRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertWebhookRequest' when calling updateWebhook", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Webhook> localVarReturnType = new ParameterizedTypeReference<Webhook>() {};
        return apiClient.invokeAPI("/api/webhook/{id}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Webhook
     * Update an existing webhook
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param upsertWebhookRequest The upsertWebhookRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return Webhook
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Webhook> updateWebhook(String id, UpsertWebhookRequest upsertWebhookRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Webhook> localVarReturnType = new ParameterizedTypeReference<Webhook>() {};
        return updateWebhookRequestCreation(id, upsertWebhookRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Webhook
     * Update an existing webhook
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param upsertWebhookRequest The upsertWebhookRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;Webhook&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Webhook>> updateWebhookWithHttpInfo(String id, UpsertWebhookRequest upsertWebhookRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Webhook> localVarReturnType = new ParameterizedTypeReference<Webhook>() {};
        return updateWebhookRequestCreation(id, upsertWebhookRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Webhook
     * Update an existing webhook
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param upsertWebhookRequest The upsertWebhookRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateWebhookWithResponseSpec(String id, UpsertWebhookRequest upsertWebhookRequest, String winkVersion) throws WebClientResponseException {
        return updateWebhookRequestCreation(id, upsertWebhookRequest, winkVersion);
    }
}
