/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.user.settings.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import travel.wink.sdk.user.settings.model.ManagingEntity;

@JsonPropertyOrder(value={"name", "entity", "enabled", "eventUrl", "eventList"})
public class UpsertWebhookRequest {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ENTITY = "entity";
    private ManagingEntity entity;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled = true;
    public static final String JSON_PROPERTY_EVENT_URL = "eventUrl";
    private String eventUrl;
    public static final String JSON_PROPERTY_EVENT_LIST = "eventList";
    private List<String> eventList = new ArrayList<String>();

    public UpsertWebhookRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public UpsertWebhookRequest entity(ManagingEntity entity) {
        this.entity = entity;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="entity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ManagingEntity getEntity() {
        return this.entity;
    }

    @JsonProperty(value="entity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEntity(ManagingEntity entity) {
        this.entity = entity;
    }

    public UpsertWebhookRequest enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public UpsertWebhookRequest eventUrl(String eventUrl) {
        this.eventUrl = eventUrl;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="eventUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEventUrl() {
        return this.eventUrl;
    }

    @JsonProperty(value="eventUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEventUrl(String eventUrl) {
        this.eventUrl = eventUrl;
    }

    public UpsertWebhookRequest eventList(List<String> eventList) {
        this.eventList = eventList;
        return this;
    }

    public UpsertWebhookRequest addEventListItem(String eventListItem) {
        if (this.eventList == null) {
            this.eventList = new ArrayList<String>();
        }
        this.eventList.add(eventListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="eventList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getEventList() {
        return this.eventList;
    }

    @JsonProperty(value="eventList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEventList(List<String> eventList) {
        this.eventList = eventList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpsertWebhookRequest upsertWebhookRequest = (UpsertWebhookRequest)o;
        return Objects.equals(this.name, upsertWebhookRequest.name) && Objects.equals(this.entity, upsertWebhookRequest.entity) && Objects.equals(this.enabled, upsertWebhookRequest.enabled) && Objects.equals(this.eventUrl, upsertWebhookRequest.eventUrl) && Objects.equals(this.eventList, upsertWebhookRequest.eventList);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.entity, this.enabled, this.eventUrl, this.eventList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpsertWebhookRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    entity: ").append(this.toIndentedString(this.entity)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    eventUrl: ").append(this.toIndentedString(this.eventUrl)).append("\n");
        sb.append("    eventList: ").append(this.toIndentedString(this.eventList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

