package travel.wink.sdk.user.settings.api;

import travel.wink.sdk.user.settings.invoker.ApiClient;

import travel.wink.sdk.user.settings.model.Application;
import travel.wink.sdk.user.settings.model.CreateApplicationResponse;
import travel.wink.sdk.user.settings.model.GenericErrorMessage;
import travel.wink.sdk.user.settings.model.ManagingEntityAuthenticatedEntity;
import travel.wink.sdk.user.settings.model.RemoveEntryResponse;
import travel.wink.sdk.user.settings.model.RevokeClientIdResponse;
import travel.wink.sdk.user.settings.model.ShowProfile400Response;
import travel.wink.sdk.user.settings.model.UpdateApplicationResponse;
import travel.wink.sdk.user.settings.model.UpsertApplicationRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Arrays;
import java.util.stream.Collectors;

import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:22:15.850489898+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class ApplicationApi {
    private ApiClient apiClient;

    public ApplicationApi() {
        this(new ApiClient());
    }

    @Autowired
    public ApplicationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    
    /**
     * Create Application
     * Create a new application
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param upsertApplicationRequest The upsertApplicationRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return CreateApplicationResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createApplicationRequestCreation(@jakarta.annotation.Nonnull UpsertApplicationRequest upsertApplicationRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = upsertApplicationRequest;
        // verify the required parameter 'upsertApplicationRequest' is set
        if (upsertApplicationRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertApplicationRequest' when calling createApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CreateApplicationResponse> localVarReturnType = new ParameterizedTypeReference<CreateApplicationResponse>() {};
        return apiClient.invokeAPI("/api/application", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Application
     * Create a new application
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param upsertApplicationRequest The upsertApplicationRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return CreateApplicationResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CreateApplicationResponse> createApplication(@jakarta.annotation.Nonnull UpsertApplicationRequest upsertApplicationRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CreateApplicationResponse> localVarReturnType = new ParameterizedTypeReference<CreateApplicationResponse>() {};
        return createApplicationRequestCreation(upsertApplicationRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Application
     * Create a new application
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param upsertApplicationRequest The upsertApplicationRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;CreateApplicationResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CreateApplicationResponse>> createApplicationWithHttpInfo(@jakarta.annotation.Nonnull UpsertApplicationRequest upsertApplicationRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CreateApplicationResponse> localVarReturnType = new ParameterizedTypeReference<CreateApplicationResponse>() {};
        return createApplicationRequestCreation(upsertApplicationRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Application
     * Create a new application
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param upsertApplicationRequest The upsertApplicationRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createApplicationWithResponseSpec(@jakarta.annotation.Nonnull UpsertApplicationRequest upsertApplicationRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return createApplicationRequestCreation(upsertApplicationRequest, winkVersion);
    }

    /**
     * Delete Application
     * Remove a specific application
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec deleteApplicationRequestCreation(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling deleteApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/application/{id}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Application
     * Remove a specific application
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> deleteApplication(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return deleteApplicationRequestCreation(id, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Application
     * Remove a specific application
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RemoveEntryResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponse>> deleteApplicationWithHttpInfo(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return deleteApplicationRequestCreation(id, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Delete Application
     * Remove a specific application
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec deleteApplicationWithResponseSpec(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return deleteApplicationRequestCreation(id, winkVersion, accept);
    }

    /**
     * Show Application
     * Show a specific application
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return Application
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec loadApplicationRequestCreation(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling loadApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Application> localVarReturnType = new ParameterizedTypeReference<Application>() {};
        return apiClient.invokeAPI("/api/application/{id}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Application
     * Show a specific application
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return Application
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Application> loadApplication(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Application> localVarReturnType = new ParameterizedTypeReference<Application>() {};
        return loadApplicationRequestCreation(id, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Application
     * Show a specific application
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;Application&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Application>> loadApplicationWithHttpInfo(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Application> localVarReturnType = new ParameterizedTypeReference<Application>() {};
        return loadApplicationRequestCreation(id, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Application
     * Show a specific application
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec loadApplicationWithResponseSpec(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return loadApplicationRequestCreation(id, winkVersion, accept);
    }

    /**
     * Revoke Application Credentials
     * Refreshes the clientId and secretKey properties.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RevokeClientIdResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec revokeApplicationRequestCreation(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling revokeApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RevokeClientIdResponse> localVarReturnType = new ParameterizedTypeReference<RevokeClientIdResponse>() {};
        return apiClient.invokeAPI("/api/application/{id}/revoke", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Revoke Application Credentials
     * Refreshes the clientId and secretKey properties.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RevokeClientIdResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RevokeClientIdResponse> revokeApplication(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RevokeClientIdResponse> localVarReturnType = new ParameterizedTypeReference<RevokeClientIdResponse>() {};
        return revokeApplicationRequestCreation(id, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Revoke Application Credentials
     * Refreshes the clientId and secretKey properties.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RevokeClientIdResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RevokeClientIdResponse>> revokeApplicationWithHttpInfo(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RevokeClientIdResponse> localVarReturnType = new ParameterizedTypeReference<RevokeClientIdResponse>() {};
        return revokeApplicationRequestCreation(id, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Revoke Application Credentials
     * Refreshes the clientId and secretKey properties.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec revokeApplicationWithResponseSpec(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return revokeApplicationRequestCreation(id, winkVersion, accept);
    }

    /**
     * Show Applications
     * List all applications owned by creating entity
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param ownerIdentifier Optional ownerIdentifier to filter on
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;Application&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showApplicationsRequestCreation(@jakarta.annotation.Nullable String ownerIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "ownerIdentifier", ownerIdentifier));
        

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<Application> localVarReturnType = new ParameterizedTypeReference<Application>() {};
        return apiClient.invokeAPI("/api/application/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Applications
     * List all applications owned by creating entity
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param ownerIdentifier Optional ownerIdentifier to filter on
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;Application&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<Application> showApplications(@jakarta.annotation.Nullable String ownerIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Application> localVarReturnType = new ParameterizedTypeReference<Application>() {};
        return showApplicationsRequestCreation(ownerIdentifier, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Applications
     * List all applications owned by creating entity
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param ownerIdentifier Optional ownerIdentifier to filter on
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;Application&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<Application>>> showApplicationsWithHttpInfo(@jakarta.annotation.Nullable String ownerIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Application> localVarReturnType = new ParameterizedTypeReference<Application>() {};
        return showApplicationsRequestCreation(ownerIdentifier, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Applications
     * List all applications owned by creating entity
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param ownerIdentifier Optional ownerIdentifier to filter on
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showApplicationsWithResponseSpec(@jakarta.annotation.Nullable String ownerIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showApplicationsRequestCreation(ownerIdentifier, winkVersion, accept);
    }

    /**
     * Show Managing Entities
     * Lists all entities, including user entity, owned by user.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param subType Optional subType to filter on
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;ManagingEntityAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showManagingEntitiesRequestCreation(@jakarta.annotation.Nullable String subType, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "subType", subType));
        

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ManagingEntityAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ManagingEntityAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/managing-entity/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Managing Entities
     * Lists all entities, including user entity, owned by user.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param subType Optional subType to filter on
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;ManagingEntityAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<ManagingEntityAuthenticatedEntity> showManagingEntities(@jakarta.annotation.Nullable String subType, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ManagingEntityAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ManagingEntityAuthenticatedEntity>() {};
        return showManagingEntitiesRequestCreation(subType, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Managing Entities
     * Lists all entities, including user entity, owned by user.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param subType Optional subType to filter on
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;ManagingEntityAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<ManagingEntityAuthenticatedEntity>>> showManagingEntitiesWithHttpInfo(@jakarta.annotation.Nullable String subType, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ManagingEntityAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ManagingEntityAuthenticatedEntity>() {};
        return showManagingEntitiesRequestCreation(subType, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Managing Entities
     * Lists all entities, including user entity, owned by user.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param subType Optional subType to filter on
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showManagingEntitiesWithResponseSpec(@jakarta.annotation.Nullable String subType, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showManagingEntitiesRequestCreation(subType, winkVersion, accept);
    }

    /**
     * Show Managing Entity
     * Load single managing entity.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param managingEntityIdentifier Managing entity ID
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ManagingEntityAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showManagingEntityRequestCreation(@jakarta.annotation.Nonnull String managingEntityIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'managingEntityIdentifier' is set
        if (managingEntityIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'managingEntityIdentifier' when calling showManagingEntity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("managingEntityIdentifier", managingEntityIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ManagingEntityAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ManagingEntityAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/managing-entity/{managingEntityIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Managing Entity
     * Load single managing entity.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param managingEntityIdentifier Managing entity ID
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ManagingEntityAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ManagingEntityAuthenticatedEntity> showManagingEntity(@jakarta.annotation.Nonnull String managingEntityIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ManagingEntityAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ManagingEntityAuthenticatedEntity>() {};
        return showManagingEntityRequestCreation(managingEntityIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Managing Entity
     * Load single managing entity.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param managingEntityIdentifier Managing entity ID
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;ManagingEntityAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ManagingEntityAuthenticatedEntity>> showManagingEntityWithHttpInfo(@jakarta.annotation.Nonnull String managingEntityIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ManagingEntityAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ManagingEntityAuthenticatedEntity>() {};
        return showManagingEntityRequestCreation(managingEntityIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Managing Entity
     * Load single managing entity.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param managingEntityIdentifier Managing entity ID
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showManagingEntityWithResponseSpec(@jakarta.annotation.Nonnull String managingEntityIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showManagingEntityRequestCreation(managingEntityIdentifier, winkVersion, accept);
    }

    /**
     * Update Application
     * Update an existing application
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param upsertApplicationRequest The upsertApplicationRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return UpdateApplicationResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateApplicationRequestCreation(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull UpsertApplicationRequest upsertApplicationRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = upsertApplicationRequest;
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertApplicationRequest' is set
        if (upsertApplicationRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertApplicationRequest' when calling updateApplication", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UpdateApplicationResponse> localVarReturnType = new ParameterizedTypeReference<UpdateApplicationResponse>() {};
        return apiClient.invokeAPI("/api/application/{id}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Application
     * Update an existing application
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param upsertApplicationRequest The upsertApplicationRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return UpdateApplicationResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpdateApplicationResponse> updateApplication(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull UpsertApplicationRequest upsertApplicationRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateApplicationResponse> localVarReturnType = new ParameterizedTypeReference<UpdateApplicationResponse>() {};
        return updateApplicationRequestCreation(id, upsertApplicationRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Application
     * Update an existing application
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param upsertApplicationRequest The upsertApplicationRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;UpdateApplicationResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<UpdateApplicationResponse>> updateApplicationWithHttpInfo(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull UpsertApplicationRequest upsertApplicationRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateApplicationResponse> localVarReturnType = new ParameterizedTypeReference<UpdateApplicationResponse>() {};
        return updateApplicationRequestCreation(id, upsertApplicationRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Application
     * Update an existing application
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param id The id parameter
     * @param upsertApplicationRequest The upsertApplicationRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateApplicationWithResponseSpec(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull UpsertApplicationRequest upsertApplicationRequest, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return updateApplicationRequestCreation(id, upsertApplicationRequest, winkVersion);
    }
}
