package travel.wink.sdk.user.settings.api;

import travel.wink.sdk.user.settings.invoker.ApiClient;

import travel.wink.sdk.user.settings.model.BucketListEntryAuthenticatedEntity;
import travel.wink.sdk.user.settings.model.BucketListEntryRequestAuthenticatedEntity;
import travel.wink.sdk.user.settings.model.BucketListEntryViewAuthenticatedEntity;
import travel.wink.sdk.user.settings.model.BucketListEntryWrapperAuthenticatedEntity;
import travel.wink.sdk.user.settings.model.GenericErrorMessage;
import travel.wink.sdk.user.settings.model.ShowProfile400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Arrays;
import java.util.stream.Collectors;

import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:22:15.850489898+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class BucketListApi {
    private ApiClient apiClient;

    public BucketListApi() {
        this(new ApiClient());
    }

    @Autowired
    public BucketListApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    
    /**
     * Create Bucket List
     * Create a new bucket list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param bucketListEntryRequestAuthenticatedEntity The bucketListEntryRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return BucketListEntryViewAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec addBucketListEntryRequestCreation(@jakarta.annotation.Nonnull BucketListEntryRequestAuthenticatedEntity bucketListEntryRequestAuthenticatedEntity, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = bucketListEntryRequestAuthenticatedEntity;
        // verify the required parameter 'bucketListEntryRequestAuthenticatedEntity' is set
        if (bucketListEntryRequestAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'bucketListEntryRequestAuthenticatedEntity' when calling addBucketListEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BucketListEntryViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryViewAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/bucket-list", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Bucket List
     * Create a new bucket list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param bucketListEntryRequestAuthenticatedEntity The bucketListEntryRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return BucketListEntryViewAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BucketListEntryViewAuthenticatedEntity> addBucketListEntry(@jakarta.annotation.Nonnull BucketListEntryRequestAuthenticatedEntity bucketListEntryRequestAuthenticatedEntity, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryViewAuthenticatedEntity>() {};
        return addBucketListEntryRequestCreation(bucketListEntryRequestAuthenticatedEntity, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Bucket List
     * Create a new bucket list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param bucketListEntryRequestAuthenticatedEntity The bucketListEntryRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BucketListEntryViewAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BucketListEntryViewAuthenticatedEntity>> addBucketListEntryWithHttpInfo(@jakarta.annotation.Nonnull BucketListEntryRequestAuthenticatedEntity bucketListEntryRequestAuthenticatedEntity, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryViewAuthenticatedEntity>() {};
        return addBucketListEntryRequestCreation(bucketListEntryRequestAuthenticatedEntity, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Bucket List
     * Create a new bucket list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param bucketListEntryRequestAuthenticatedEntity The bucketListEntryRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec addBucketListEntryWithResponseSpec(@jakarta.annotation.Nonnull BucketListEntryRequestAuthenticatedEntity bucketListEntryRequestAuthenticatedEntity, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return addBucketListEntryRequestCreation(bucketListEntryRequestAuthenticatedEntity, winkVersion);
    }

    /**
     * Delete Bucket List Entry
     * Remove bucket list entry by entry identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param bucketListItemIdentifier The bucketListItemIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return BucketListEntryViewAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeBucketListRequestCreation(@jakarta.annotation.Nonnull String bucketListItemIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'bucketListItemIdentifier' is set
        if (bucketListItemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bucketListItemIdentifier' when calling removeBucketList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("bucketListItemIdentifier", bucketListItemIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BucketListEntryViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryViewAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/bucket-list/{bucketListItemIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Bucket List Entry
     * Remove bucket list entry by entry identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param bucketListItemIdentifier The bucketListItemIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return BucketListEntryViewAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BucketListEntryViewAuthenticatedEntity> removeBucketList(@jakarta.annotation.Nonnull String bucketListItemIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryViewAuthenticatedEntity>() {};
        return removeBucketListRequestCreation(bucketListItemIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Bucket List Entry
     * Remove bucket list entry by entry identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param bucketListItemIdentifier The bucketListItemIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;BucketListEntryViewAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BucketListEntryViewAuthenticatedEntity>> removeBucketListWithHttpInfo(@jakarta.annotation.Nonnull String bucketListItemIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryViewAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryViewAuthenticatedEntity>() {};
        return removeBucketListRequestCreation(bucketListItemIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Delete Bucket List Entry
     * Remove bucket list entry by entry identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param bucketListItemIdentifier The bucketListItemIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeBucketListWithResponseSpec(@jakarta.annotation.Nonnull String bucketListItemIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return removeBucketListRequestCreation(bucketListItemIdentifier, winkVersion, accept);
    }

    /**
     * Get Bucket Lists
     * Retrieve all bucket lists for caller
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;BucketListEntryWrapperAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBucketListRequestCreation(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BucketListEntryWrapperAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryWrapperAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/bucket-list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get Bucket Lists
     * Retrieve all bucket lists for caller
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;BucketListEntryWrapperAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BucketListEntryWrapperAuthenticatedEntity> showBucketList(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryWrapperAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryWrapperAuthenticatedEntity>() {};
        return showBucketListRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Get Bucket Lists
     * Retrieve all bucket lists for caller
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;BucketListEntryWrapperAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<BucketListEntryWrapperAuthenticatedEntity>>> showBucketListWithHttpInfo(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryWrapperAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryWrapperAuthenticatedEntity>() {};
        return showBucketListRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Get Bucket Lists
     * Retrieve all bucket lists for caller
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showBucketListWithResponseSpec(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showBucketListRequestCreation(winkVersion, accept);
    }

    /**
     * Get Bucket List
     * Retrieve all bucket list entries for caller
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;BucketListEntryAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBucketListEntriesRequestCreation(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/bucket-list/entries", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get Bucket List
     * Retrieve all bucket list entries for caller
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;BucketListEntryAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BucketListEntryAuthenticatedEntity> showBucketListEntries(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>() {};
        return showBucketListEntriesRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Get Bucket List
     * Retrieve all bucket list entries for caller
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;BucketListEntryAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<BucketListEntryAuthenticatedEntity>>> showBucketListEntriesWithHttpInfo(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>() {};
        return showBucketListEntriesRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Get Bucket List
     * Retrieve all bucket list entries for caller
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showBucketListEntriesWithResponseSpec(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showBucketListEntriesRequestCreation(winkVersion, accept);
    }

    /**
     * Get Bucket List Entries
     * Retrieve bucket list entries for a specific by bucket list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param type The type parameter
     * @param identifier The identifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return BucketListEntryAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBucketListEntryRequestCreation(@jakarta.annotation.Nonnull String type, @jakarta.annotation.Nonnull String identifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'type' is set
        if (type == null) {
            throw new WebClientResponseException("Missing the required parameter 'type' when calling showBucketListEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling showBucketListEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("type", type);
        pathParams.put("identifier", identifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/bucket-list/{type}/{identifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get Bucket List Entries
     * Retrieve bucket list entries for a specific by bucket list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param type The type parameter
     * @param identifier The identifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return BucketListEntryAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BucketListEntryAuthenticatedEntity> showBucketListEntry(@jakarta.annotation.Nonnull String type, @jakarta.annotation.Nonnull String identifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>() {};
        return showBucketListEntryRequestCreation(type, identifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Get Bucket List Entries
     * Retrieve bucket list entries for a specific by bucket list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param type The type parameter
     * @param identifier The identifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;BucketListEntryAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BucketListEntryAuthenticatedEntity>> showBucketListEntryWithHttpInfo(@jakarta.annotation.Nonnull String type, @jakarta.annotation.Nonnull String identifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BucketListEntryAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BucketListEntryAuthenticatedEntity>() {};
        return showBucketListEntryRequestCreation(type, identifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Get Bucket List Entries
     * Retrieve bucket list entries for a specific by bucket list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param type The type parameter
     * @param identifier The identifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showBucketListEntryWithResponseSpec(@jakarta.annotation.Nonnull String type, @jakarta.annotation.Nonnull String identifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showBucketListEntryRequestCreation(type, identifier, winkVersion, accept);
    }
}
