/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/customization-client): A single endpoint to retrieve whitelabel + customization information for the booking customization.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # User Settings API The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink. This API lets you:  1. Application: Manage 3rd party access to Wink. 2. Bucket List: Manage your bucket list on Wink. 3. Webhook: Subscribe to receive Wink events as they occur in realtime. 4. User: Manage user settings.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.user.settings.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.UUID;
import travel.wink.sdk.user.settings.model.CustomMonetaryAmount;
import travel.wink.sdk.user.settings.model.GeoJsonPointAuthenticatedEntity;
import travel.wink.sdk.user.settings.model.InventoryAddressAuthenticatedEntity;
import travel.wink.sdk.user.settings.model.SalesChannelLightweightAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * InventoryAuthenticatedEntity
 */
@JsonPropertyOrder({
  InventoryAuthenticatedEntity.JSON_PROPERTY_ID,
  InventoryAuthenticatedEntity.JSON_PROPERTY_CREATED_DATE,
  InventoryAuthenticatedEntity.JSON_PROPERTY_LAST_UPDATE,
  InventoryAuthenticatedEntity.JSON_PROPERTY_VERSION,
  InventoryAuthenticatedEntity.JSON_PROPERTY_SALES_CHANNEL,
  InventoryAuthenticatedEntity.JSON_PROPERTY_INVENTORY_TYPE,
  InventoryAuthenticatedEntity.JSON_PROPERTY_INVENTORY_IDENTIFIER,
  InventoryAuthenticatedEntity.JSON_PROPERTY_INVENTORY_NAME,
  InventoryAuthenticatedEntity.JSON_PROPERTY_INVENTORY_NAME_IN_ENGLISH,
  InventoryAuthenticatedEntity.JSON_PROPERTY_ENABLED,
  InventoryAuthenticatedEntity.JSON_PROPERTY_IMAGE_IDENTIFIER,
  InventoryAuthenticatedEntity.JSON_PROPERTY_PRICE_POINT,
  InventoryAuthenticatedEntity.JSON_PROPERTY_LOCATION,
  InventoryAuthenticatedEntity.JSON_PROPERTY_ADDRESS,
  InventoryAuthenticatedEntity.JSON_PROPERTY_QUANTITY,
  InventoryAuthenticatedEntity.JSON_PROPERTY_COMMISSIONABLE,
  InventoryAuthenticatedEntity.JSON_PROPERTY_BOOKABLE,
  InventoryAuthenticatedEntity.JSON_PROPERTY_LOWEST_PRICE,
  InventoryAuthenticatedEntity.JSON_PROPERTY_LOWEST_DISPLAY_PRICE
})
@JsonTypeName("Inventory_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:22:15.850489898+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class InventoryAuthenticatedEntity {
  public static final String JSON_PROPERTY_ID = "id";
  @jakarta.annotation.Nullable
  private String id;

  public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
  @jakarta.annotation.Nullable
  private java.time.LocalDateTime createdDate;

  public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
  @jakarta.annotation.Nullable
  private java.time.LocalDateTime lastUpdate;

  public static final String JSON_PROPERTY_VERSION = "version";
  @jakarta.annotation.Nullable
  private Long version;

  public static final String JSON_PROPERTY_SALES_CHANNEL = "salesChannel";
  @jakarta.annotation.Nonnull
  private SalesChannelLightweightAuthenticatedEntity salesChannel;

  /**
   * Inventory type
   */
  public enum InventoryTypeEnum {
    GUEST_ROOM(String.valueOf("GUEST_ROOM")),
    
    ADD_ON(String.valueOf("ADD_ON")),
    
    MEETING_ROOM(String.valueOf("MEETING_ROOM")),
    
    RESTAURANT(String.valueOf("RESTAURANT")),
    
    SPA(String.valueOf("SPA")),
    
    ATTRACTION(String.valueOf("ATTRACTION")),
    
    PLACE(String.valueOf("PLACE")),
    
    ACTIVITY(String.valueOf("ACTIVITY"));

    private String value;

    InventoryTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InventoryTypeEnum fromValue(String value) {
      for (InventoryTypeEnum b : InventoryTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INVENTORY_TYPE = "inventoryType";
  @jakarta.annotation.Nonnull
  private InventoryTypeEnum inventoryType;

  public static final String JSON_PROPERTY_INVENTORY_IDENTIFIER = "inventoryIdentifier";
  @jakarta.annotation.Nonnull
  private UUID inventoryIdentifier;

  public static final String JSON_PROPERTY_INVENTORY_NAME = "inventoryName";
  @jakarta.annotation.Nonnull
  private String inventoryName;

  public static final String JSON_PROPERTY_INVENTORY_NAME_IN_ENGLISH = "inventoryNameInEnglish";
  @jakarta.annotation.Nonnull
  private String inventoryNameInEnglish;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  @jakarta.annotation.Nonnull
  private Boolean enabled = true;

  public static final String JSON_PROPERTY_IMAGE_IDENTIFIER = "imageIdentifier";
  @jakarta.annotation.Nonnull
  private String imageIdentifier;

  /**
   * Level of expensiveness.
   */
  public enum PricePointEnum {
    HALF(String.valueOf("HALF")),
    
    ONE(String.valueOf("ONE")),
    
    ONE_HALF(String.valueOf("ONE_HALF")),
    
    TWO(String.valueOf("TWO")),
    
    TWO_HALF(String.valueOf("TWO_HALF")),
    
    THREE(String.valueOf("THREE")),
    
    THREE_HALF(String.valueOf("THREE_HALF")),
    
    FOUR(String.valueOf("FOUR")),
    
    FOUR_HALF(String.valueOf("FOUR_HALF")),
    
    FIVE(String.valueOf("FIVE"));

    private String value;

    PricePointEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricePointEnum fromValue(String value) {
      for (PricePointEnum b : PricePointEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICE_POINT = "pricePoint";
  @jakarta.annotation.Nonnull
  private PricePointEnum pricePoint = PricePointEnum.THREE;

  public static final String JSON_PROPERTY_LOCATION = "location";
  @jakarta.annotation.Nonnull
  private GeoJsonPointAuthenticatedEntity location;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  @jakarta.annotation.Nonnull
  private InventoryAddressAuthenticatedEntity address;

  public static final String JSON_PROPERTY_QUANTITY = "quantity";
  @jakarta.annotation.Nonnull
  private Integer quantity = 0;

  public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
  @jakarta.annotation.Nonnull
  private Boolean commissionable = false;

  public static final String JSON_PROPERTY_BOOKABLE = "bookable";
  @jakarta.annotation.Nonnull
  private Boolean bookable = true;

  public static final String JSON_PROPERTY_LOWEST_PRICE = "lowestPrice";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount lowestPrice;

  public static final String JSON_PROPERTY_LOWEST_DISPLAY_PRICE = "lowestDisplayPrice";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount lowestDisplayPrice;

  public InventoryAuthenticatedEntity() {
  }

  public InventoryAuthenticatedEntity id(@jakarta.annotation.Nullable String id) {
    
    this.id = id;
    return this;
  }

  /**
   * Document UUID
   * @return id
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(@jakarta.annotation.Nullable String id) {
    this.id = id;
  }

  public InventoryAuthenticatedEntity createdDate(@jakarta.annotation.Nullable java.time.LocalDateTime createdDate) {
    
    this.createdDate = createdDate;
    return this;
  }

  /**
   * Datetime this record was first created
   * @return createdDate
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCreatedDate() {
    return createdDate;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedDate(@jakarta.annotation.Nullable java.time.LocalDateTime createdDate) {
    this.createdDate = createdDate;
  }

  public InventoryAuthenticatedEntity lastUpdate(@jakarta.annotation.Nullable java.time.LocalDateTime lastUpdate) {
    
    this.lastUpdate = lastUpdate;
    return this;
  }

  /**
   * Datetime this record was last updated
   * @return lastUpdate
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getLastUpdate() {
    return lastUpdate;
  }


  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastUpdate(@jakarta.annotation.Nullable java.time.LocalDateTime lastUpdate) {
    this.lastUpdate = lastUpdate;
  }

  public InventoryAuthenticatedEntity version(@jakarta.annotation.Nullable Long version) {
    
    this.version = version;
    return this;
  }

  /**
   * Version property that shows how many times this document has been persisted. Document will not persist if the version property is less than current version property in the system. Result in an optimistic locking exception.
   * @return version
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(@jakarta.annotation.Nullable Long version) {
    this.version = version;
  }

  public InventoryAuthenticatedEntity salesChannel(@jakarta.annotation.Nonnull SalesChannelLightweightAuthenticatedEntity salesChannel) {
    
    this.salesChannel = salesChannel;
    return this;
  }

  /**
   * Parent sales channel
   * @return salesChannel
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SALES_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SalesChannelLightweightAuthenticatedEntity getSalesChannel() {
    return salesChannel;
  }


  @JsonProperty(JSON_PROPERTY_SALES_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSalesChannel(@jakarta.annotation.Nonnull SalesChannelLightweightAuthenticatedEntity salesChannel) {
    this.salesChannel = salesChannel;
  }

  public InventoryAuthenticatedEntity inventoryType(@jakarta.annotation.Nonnull InventoryTypeEnum inventoryType) {
    
    this.inventoryType = inventoryType;
    return this;
  }

  /**
   * Inventory type
   * @return inventoryType
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public InventoryTypeEnum getInventoryType() {
    return inventoryType;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInventoryType(@jakarta.annotation.Nonnull InventoryTypeEnum inventoryType) {
    this.inventoryType = inventoryType;
  }

  public InventoryAuthenticatedEntity inventoryIdentifier(@jakarta.annotation.Nonnull UUID inventoryIdentifier) {
    
    this.inventoryIdentifier = inventoryIdentifier;
    return this;
  }

  /**
   * Inventory type identifier
   * @return inventoryIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getInventoryIdentifier() {
    return inventoryIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInventoryIdentifier(@jakarta.annotation.Nonnull UUID inventoryIdentifier) {
    this.inventoryIdentifier = inventoryIdentifier;
  }

  public InventoryAuthenticatedEntity inventoryName(@jakarta.annotation.Nonnull String inventoryName) {
    
    this.inventoryName = inventoryName;
    return this;
  }

  /**
   * Name of blocking as hotel is seeing it
   * @return inventoryName
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_INVENTORY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getInventoryName() {
    return inventoryName;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInventoryName(@jakarta.annotation.Nonnull String inventoryName) {
    this.inventoryName = inventoryName;
  }

  public InventoryAuthenticatedEntity inventoryNameInEnglish(@jakarta.annotation.Nonnull String inventoryNameInEnglish) {
    
    this.inventoryNameInEnglish = inventoryNameInEnglish;
    return this;
  }

  /**
   * Name of blocking as traveler is seeing it
   * @return inventoryNameInEnglish
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_INVENTORY_NAME_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getInventoryNameInEnglish() {
    return inventoryNameInEnglish;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_NAME_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInventoryNameInEnglish(@jakarta.annotation.Nonnull String inventoryNameInEnglish) {
    this.inventoryNameInEnglish = inventoryNameInEnglish;
  }

  public InventoryAuthenticatedEntity enabled(@jakarta.annotation.Nonnull Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

  /**
   * Whether this blocking is enabled or not
   * @return enabled
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnabled(@jakarta.annotation.Nonnull Boolean enabled) {
    this.enabled = enabled;
  }

  public InventoryAuthenticatedEntity imageIdentifier(@jakarta.annotation.Nonnull String imageIdentifier) {
    
    this.imageIdentifier = imageIdentifier;
    return this;
  }

  /**
   * Main image of blocking
   * @return imageIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getImageIdentifier() {
    return imageIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setImageIdentifier(@jakarta.annotation.Nonnull String imageIdentifier) {
    this.imageIdentifier = imageIdentifier;
  }

  public InventoryAuthenticatedEntity pricePoint(@jakarta.annotation.Nonnull PricePointEnum pricePoint) {
    
    this.pricePoint = pricePoint;
    return this;
  }

  /**
   * Level of expensiveness.
   * @return pricePoint
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRICE_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricePointEnum getPricePoint() {
    return pricePoint;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricePoint(@jakarta.annotation.Nonnull PricePointEnum pricePoint) {
    this.pricePoint = pricePoint;
  }

  public InventoryAuthenticatedEntity location(@jakarta.annotation.Nonnull GeoJsonPointAuthenticatedEntity location) {
    
    this.location = location;
    return this;
  }

  /**
   * Location
   * @return location
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GeoJsonPointAuthenticatedEntity getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLocation(@jakarta.annotation.Nonnull GeoJsonPointAuthenticatedEntity location) {
    this.location = location;
  }

  public InventoryAuthenticatedEntity address(@jakarta.annotation.Nonnull InventoryAddressAuthenticatedEntity address) {
    
    this.address = address;
    return this;
  }

  /**
   * Defaults to property address.
   * @return address
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public InventoryAddressAuthenticatedEntity getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAddress(@jakarta.annotation.Nonnull InventoryAddressAuthenticatedEntity address) {
    this.address = address;
  }

  public InventoryAuthenticatedEntity quantity(@jakarta.annotation.Nonnull Integer quantity) {
    
    this.quantity = quantity;
    return this;
  }

  /**
   * quantity
   * @return quantity
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getQuantity() {
    return quantity;
  }


  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setQuantity(@jakarta.annotation.Nonnull Integer quantity) {
    this.quantity = quantity;
  }

  public InventoryAuthenticatedEntity commissionable(@jakarta.annotation.Nonnull Boolean commissionable) {
    
    this.commissionable = commissionable;
    return this;
  }

  /**
   * Whether this is commissionable or not
   * @return commissionable
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getCommissionable() {
    return commissionable;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCommissionable(@jakarta.annotation.Nonnull Boolean commissionable) {
    this.commissionable = commissionable;
  }

  public InventoryAuthenticatedEntity bookable(@jakarta.annotation.Nonnull Boolean bookable) {
    
    this.bookable = bookable;
    return this;
  }

  /**
   * Whether blocking can be booked
   * @return bookable
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBookable() {
    return bookable;
  }


  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBookable(@jakarta.annotation.Nonnull Boolean bookable) {
    this.bookable = bookable;
  }

  public InventoryAuthenticatedEntity lowestPrice(@jakarta.annotation.Nullable CustomMonetaryAmount lowestPrice) {
    
    this.lowestPrice = lowestPrice;
    return this;
  }

  /**
   * Best price of the room type or facility ancillary
   * @return lowestPrice
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LOWEST_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getLowestPrice() {
    return lowestPrice;
  }


  @JsonProperty(JSON_PROPERTY_LOWEST_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLowestPrice(@jakarta.annotation.Nullable CustomMonetaryAmount lowestPrice) {
    this.lowestPrice = lowestPrice;
  }

  public InventoryAuthenticatedEntity lowestDisplayPrice(@jakarta.annotation.Nullable CustomMonetaryAmount lowestDisplayPrice) {
    
    this.lowestDisplayPrice = lowestDisplayPrice;
    return this;
  }

  /**
   * Best price of the room type or facility ancillary in platform currency
   * @return lowestDisplayPrice
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LOWEST_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getLowestDisplayPrice() {
    return lowestDisplayPrice;
  }


  @JsonProperty(JSON_PROPERTY_LOWEST_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLowestDisplayPrice(@jakarta.annotation.Nullable CustomMonetaryAmount lowestDisplayPrice) {
    this.lowestDisplayPrice = lowestDisplayPrice;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InventoryAuthenticatedEntity inventoryAuthenticatedEntity = (InventoryAuthenticatedEntity) o;
    return Objects.equals(this.id, inventoryAuthenticatedEntity.id) &&
        Objects.equals(this.createdDate, inventoryAuthenticatedEntity.createdDate) &&
        Objects.equals(this.lastUpdate, inventoryAuthenticatedEntity.lastUpdate) &&
        Objects.equals(this.version, inventoryAuthenticatedEntity.version) &&
        Objects.equals(this.salesChannel, inventoryAuthenticatedEntity.salesChannel) &&
        Objects.equals(this.inventoryType, inventoryAuthenticatedEntity.inventoryType) &&
        Objects.equals(this.inventoryIdentifier, inventoryAuthenticatedEntity.inventoryIdentifier) &&
        Objects.equals(this.inventoryName, inventoryAuthenticatedEntity.inventoryName) &&
        Objects.equals(this.inventoryNameInEnglish, inventoryAuthenticatedEntity.inventoryNameInEnglish) &&
        Objects.equals(this.enabled, inventoryAuthenticatedEntity.enabled) &&
        Objects.equals(this.imageIdentifier, inventoryAuthenticatedEntity.imageIdentifier) &&
        Objects.equals(this.pricePoint, inventoryAuthenticatedEntity.pricePoint) &&
        Objects.equals(this.location, inventoryAuthenticatedEntity.location) &&
        Objects.equals(this.address, inventoryAuthenticatedEntity.address) &&
        Objects.equals(this.quantity, inventoryAuthenticatedEntity.quantity) &&
        Objects.equals(this.commissionable, inventoryAuthenticatedEntity.commissionable) &&
        Objects.equals(this.bookable, inventoryAuthenticatedEntity.bookable) &&
        Objects.equals(this.lowestPrice, inventoryAuthenticatedEntity.lowestPrice) &&
        Objects.equals(this.lowestDisplayPrice, inventoryAuthenticatedEntity.lowestDisplayPrice);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdDate, lastUpdate, version, salesChannel, inventoryType, inventoryIdentifier, inventoryName, inventoryNameInEnglish, enabled, imageIdentifier, pricePoint, location, address, quantity, commissionable, bookable, lowestPrice, lowestDisplayPrice);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InventoryAuthenticatedEntity {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    lastUpdate: ").append(toIndentedString(lastUpdate)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    salesChannel: ").append(toIndentedString(salesChannel)).append("\n");
    sb.append("    inventoryType: ").append(toIndentedString(inventoryType)).append("\n");
    sb.append("    inventoryIdentifier: ").append(toIndentedString(inventoryIdentifier)).append("\n");
    sb.append("    inventoryName: ").append(toIndentedString(inventoryName)).append("\n");
    sb.append("    inventoryNameInEnglish: ").append(toIndentedString(inventoryNameInEnglish)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    imageIdentifier: ").append(toIndentedString(imageIdentifier)).append("\n");
    sb.append("    pricePoint: ").append(toIndentedString(pricePoint)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    commissionable: ").append(toIndentedString(commissionable)).append("\n");
    sb.append("    bookable: ").append(toIndentedString(bookable)).append("\n");
    sb.append("    lowestPrice: ").append(toIndentedString(lowestPrice)).append("\n");
    sb.append("    lowestDisplayPrice: ").append(toIndentedString(lowestDisplayPrice)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

