/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/customization-client): A single endpoint to retrieve whitelabel + customization information for the booking customization.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # User Settings API The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink. This API lets you:  1. Application: Manage 3rd party access to Wink. 2. Bucket List: Manage your bucket list on Wink. 3. Webhook: Subscribe to receive Wink events as they occur in realtime. 4. User: Manage user settings.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.user.settings.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * ManagingEntityAuthenticatedEntity
 */
@JsonPropertyOrder({
  ManagingEntityAuthenticatedEntity.JSON_PROPERTY_IDENTIFIER,
  ManagingEntityAuthenticatedEntity.JSON_PROPERTY_NAME,
  ManagingEntityAuthenticatedEntity.JSON_PROPERTY_TYPE,
  ManagingEntityAuthenticatedEntity.JSON_PROPERTY_SUB_TYPE,
  ManagingEntityAuthenticatedEntity.JSON_PROPERTY_PRICE_LOOKUP_KEY
})
@JsonTypeName("ManagingEntity_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:22:15.850489898+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class ManagingEntityAuthenticatedEntity {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  @jakarta.annotation.Nonnull
  private String identifier;

  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nonnull
  private String name;

  /**
   * Type of entity.
   */
  public enum TypeEnum {
    USER(String.valueOf("USER")),
    
    COMPANY(String.valueOf("COMPANY")),
    
    ACCOUNT(String.valueOf("ACCOUNT"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  @jakarta.annotation.Nonnull
  private TypeEnum type;

  /**
   * This is for Wink entities only. Does not apply to TripPay.
   */
  public enum SubTypeEnum {
    DIRECT(String.valueOf("DIRECT")),
    
    APPLICATION(String.valueOf("APPLICATION")),
    
    HOTEL(String.valueOf("HOTEL")),
    
    TRAVELIKO(String.valueOf("TRAVELIKO")),
    
    CORPORATE(String.valueOf("CORPORATE")),
    
    TRAVEL_AGENT(String.valueOf("TRAVEL_AGENT")),
    
    INFLUENCER(String.valueOf("INFLUENCER")),
    
    BLOGGER(String.valueOf("BLOGGER")),
    
    DESTINATION(String.valueOf("DESTINATION")),
    
    CHANNEL_MANAGER(String.valueOf("CHANNEL_MANAGER")),
    
    PROPERTY_MANAGEMENT_SYSTEM(String.valueOf("PROPERTY_MANAGEMENT_SYSTEM")),
    
    CENTRAL_RESERVATION_SYSTEM(String.valueOf("CENTRAL_RESERVATION_SYSTEM")),
    
    GOOGLE_HOTEL_API(String.valueOf("GOOGLE_HOTEL_API")),
    
    MANAGEMENT_COMPANY(String.valueOf("MANAGEMENT_COMPANY")),
    
    CHAIN(String.valueOf("CHAIN")),
    
    BRAND(String.valueOf("BRAND")),
    
    EVENT_ORGANIZER(String.valueOf("EVENT_ORGANIZER"));

    private String value;

    SubTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SubTypeEnum fromValue(String value) {
      for (SubTypeEnum b : SubTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SUB_TYPE = "subType";
  @jakarta.annotation.Nonnull
  private SubTypeEnum subType;

  /**
   * price lookup key
   */
  public enum PriceLookupKeyEnum {
    STARTER_MONTHLY(String.valueOf("STARTER_MONTHLY")),
    
    STARTER_YEARLY(String.valueOf("STARTER_YEARLY")),
    
    GROWTH_MONTHLY(String.valueOf("GROWTH_MONTHLY")),
    
    GROWTH_YEARLY(String.valueOf("GROWTH_YEARLY")),
    
    ELITE_MONTHLY(String.valueOf("ELITE_MONTHLY")),
    
    ELITE_YEARLY(String.valueOf("ELITE_YEARLY"));

    private String value;

    PriceLookupKeyEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PriceLookupKeyEnum fromValue(String value) {
      for (PriceLookupKeyEnum b : PriceLookupKeyEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICE_LOOKUP_KEY = "priceLookupKey";
  @jakarta.annotation.Nullable
  private PriceLookupKeyEnum priceLookupKey;

  public ManagingEntityAuthenticatedEntity() {
  }

  public ManagingEntityAuthenticatedEntity identifier(@jakarta.annotation.Nonnull String identifier) {
    
    this.identifier = identifier;
    return this;
  }

  /**
   * The value that should be persisted.
   * @return identifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(@jakarta.annotation.Nonnull String identifier) {
    this.identifier = identifier;
  }

  public ManagingEntityAuthenticatedEntity name(@jakarta.annotation.Nonnull String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Text representation of the value.
   * @return name
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(@jakarta.annotation.Nonnull String name) {
    this.name = name;
  }

  public ManagingEntityAuthenticatedEntity type(@jakarta.annotation.Nonnull TypeEnum type) {
    
    this.type = type;
    return this;
  }

  /**
   * Type of entity.
   * @return type
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(@jakarta.annotation.Nonnull TypeEnum type) {
    this.type = type;
  }

  public ManagingEntityAuthenticatedEntity subType(@jakarta.annotation.Nonnull SubTypeEnum subType) {
    
    this.subType = subType;
    return this;
  }

  /**
   * This is for Wink entities only. Does not apply to TripPay.
   * @return subType
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SubTypeEnum getSubType() {
    return subType;
  }


  @JsonProperty(JSON_PROPERTY_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSubType(@jakarta.annotation.Nonnull SubTypeEnum subType) {
    this.subType = subType;
  }

  public ManagingEntityAuthenticatedEntity priceLookupKey(@jakarta.annotation.Nullable PriceLookupKeyEnum priceLookupKey) {
    
    this.priceLookupKey = priceLookupKey;
    return this;
  }

  /**
   * price lookup key
   * @return priceLookupKey
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PRICE_LOOKUP_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PriceLookupKeyEnum getPriceLookupKey() {
    return priceLookupKey;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_LOOKUP_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPriceLookupKey(@jakarta.annotation.Nullable PriceLookupKeyEnum priceLookupKey) {
    this.priceLookupKey = priceLookupKey;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ManagingEntityAuthenticatedEntity managingEntityAuthenticatedEntity = (ManagingEntityAuthenticatedEntity) o;
    return Objects.equals(this.identifier, managingEntityAuthenticatedEntity.identifier) &&
        Objects.equals(this.name, managingEntityAuthenticatedEntity.name) &&
        Objects.equals(this.type, managingEntityAuthenticatedEntity.type) &&
        Objects.equals(this.subType, managingEntityAuthenticatedEntity.subType) &&
        Objects.equals(this.priceLookupKey, managingEntityAuthenticatedEntity.priceLookupKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, name, type, subType, priceLookupKey);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ManagingEntityAuthenticatedEntity {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    subType: ").append(toIndentedString(subType)).append("\n");
    sb.append("    priceLookupKey: ").append(toIndentedString(priceLookupKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

