/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.user.settings.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"id", "ownerIdentifier", "ownerName", "ownerType", "name", "redirectUris", "clientId", "secretKey"})
public class CreateApplicationResponse {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private UUID id;
    public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
    @Nonnull
    private UUID ownerIdentifier;
    public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
    @Nonnull
    private String ownerName;
    public static final String JSON_PROPERTY_OWNER_TYPE = "ownerType";
    @Nonnull
    private OwnerTypeEnum ownerType;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_REDIRECT_URIS = "redirectUris";
    @Nullable
    private List<String> redirectUris = new ArrayList<String>();
    public static final String JSON_PROPERTY_CLIENT_ID = "clientId";
    @Nonnull
    private String clientId;
    public static final String JSON_PROPERTY_SECRET_KEY = "secretKey";
    @Nonnull
    private String secretKey;

    public CreateApplicationResponse id(@Nonnull UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull UUID id) {
        this.id = id;
    }

    public CreateApplicationResponse ownerIdentifier(@Nonnull UUID ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getOwnerIdentifier() {
        return this.ownerIdentifier;
    }

    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerIdentifier(@Nonnull UUID ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
    }

    public CreateApplicationResponse ownerName(@Nonnull String ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getOwnerName() {
        return this.ownerName;
    }

    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerName(@Nonnull String ownerName) {
        this.ownerName = ownerName;
    }

    public CreateApplicationResponse ownerType(@Nonnull OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OwnerTypeEnum getOwnerType() {
        return this.ownerType;
    }

    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerType(@Nonnull OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
    }

    public CreateApplicationResponse name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public CreateApplicationResponse redirectUris(@Nullable List<String> redirectUris) {
        this.redirectUris = redirectUris;
        return this;
    }

    public CreateApplicationResponse addRedirectUrisItem(String redirectUrisItem) {
        if (this.redirectUris == null) {
            this.redirectUris = new ArrayList<String>();
        }
        this.redirectUris.add(redirectUrisItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="redirectUris")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getRedirectUris() {
        return this.redirectUris;
    }

    @JsonProperty(value="redirectUris")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRedirectUris(@Nullable List<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    public CreateApplicationResponse clientId(@Nonnull String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="clientId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="clientId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setClientId(@Nonnull String clientId) {
        this.clientId = clientId;
    }

    public CreateApplicationResponse secretKey(@Nonnull String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="secretKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSecretKey() {
        return this.secretKey;
    }

    @JsonProperty(value="secretKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSecretKey(@Nonnull String secretKey) {
        this.secretKey = secretKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateApplicationResponse createApplicationResponse = (CreateApplicationResponse)o;
        return Objects.equals(this.id, createApplicationResponse.id) && Objects.equals(this.ownerIdentifier, createApplicationResponse.ownerIdentifier) && Objects.equals(this.ownerName, createApplicationResponse.ownerName) && Objects.equals((Object)this.ownerType, (Object)createApplicationResponse.ownerType) && Objects.equals(this.name, createApplicationResponse.name) && Objects.equals(this.redirectUris, createApplicationResponse.redirectUris) && Objects.equals(this.clientId, createApplicationResponse.clientId) && Objects.equals(this.secretKey, createApplicationResponse.secretKey);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.ownerIdentifier, this.ownerName, this.ownerType, this.name, this.redirectUris, this.clientId, this.secretKey});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateApplicationResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    ownerIdentifier: ").append(this.toIndentedString(this.ownerIdentifier)).append("\n");
        sb.append("    ownerName: ").append(this.toIndentedString(this.ownerName)).append("\n");
        sb.append("    ownerType: ").append(this.toIndentedString((Object)this.ownerType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    redirectUris: ").append(this.toIndentedString(this.redirectUris)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secretKey: ").append(this.toIndentedString(this.secretKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OwnerTypeEnum {
        USER(String.valueOf("USER")),
        COMPANY(String.valueOf("COMPANY")),
        ACCOUNT(String.valueOf("ACCOUNT"));

        private String value;

        private OwnerTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OwnerTypeEnum fromValue(String value) {
            for (OwnerTypeEnum b : OwnerTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

