/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.user.settings.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import travel.wink.sdk.user.settings.model.SimpleMultimedia;

@JsonPropertyOrder(value={"firstName", "lastName", "username", "profilePicture"})
public class UpsertUserProfileRequest {
    public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
    @Nonnull
    private String firstName;
    public static final String JSON_PROPERTY_LAST_NAME = "lastName";
    @Nonnull
    private String lastName;
    public static final String JSON_PROPERTY_USERNAME = "username";
    @Nonnull
    private String username;
    public static final String JSON_PROPERTY_PROFILE_PICTURE = "profilePicture";
    @Nullable
    private SimpleMultimedia profilePicture;

    public UpsertUserProfileRequest firstName(@Nonnull String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFirstName(@Nonnull String firstName) {
        this.firstName = firstName;
    }

    public UpsertUserProfileRequest lastName(@Nonnull String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getLastName() {
        return this.lastName;
    }

    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLastName(@Nonnull String lastName) {
        this.lastName = lastName;
    }

    public UpsertUserProfileRequest username(@Nonnull String username) {
        this.username = username;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUsername(@Nonnull String username) {
        this.username = username;
    }

    public UpsertUserProfileRequest profilePicture(@Nullable SimpleMultimedia profilePicture) {
        this.profilePicture = profilePicture;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="profilePicture")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SimpleMultimedia getProfilePicture() {
        return this.profilePicture;
    }

    @JsonProperty(value="profilePicture")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfilePicture(@Nullable SimpleMultimedia profilePicture) {
        this.profilePicture = profilePicture;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpsertUserProfileRequest upsertUserProfileRequest = (UpsertUserProfileRequest)o;
        return Objects.equals(this.firstName, upsertUserProfileRequest.firstName) && Objects.equals(this.lastName, upsertUserProfileRequest.lastName) && Objects.equals(this.username, upsertUserProfileRequest.username) && Objects.equals(this.profilePicture, upsertUserProfileRequest.profilePicture);
    }

    public int hashCode() {
        return Objects.hash(this.firstName, this.lastName, this.username, this.profilePicture);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpsertUserProfileRequest {\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    profilePicture: ").append(this.toIndentedString(this.profilePicture)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

