package travel.wink.wise.partner.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.web.server.ResponseStatusException;

import java.beans.ConstructorProperties;
import java.time.LocalDateTime;

/**
 * The type Api error.
 */
@Value
public class ApiError {

    LocalDateTime timestamp;
    HttpStatusCode status;
    String message;

    /**
     * Instantiates a new Api error.
     *
     * @param timestamp the timestamp
     * @param status    the status
     * @param message   the message
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "timestamp",
            "impl",
            "message"
    })
    public ApiError(
            @JsonProperty("timestamp") @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "dd-MM-yyyy hh:mm:ss") LocalDateTime timestamp,
            @JsonProperty("impl") HttpStatusCode status,
            @JsonProperty("message") String message
    ) {
        this.timestamp = timestamp;
        this.status = status;
        this.message = message;
    }

    /**
     * Of api error.
     *
     * @param cause the cause
     * @return the api error
     */
    public static ApiError of(final ResponseStatusException cause) {
        return new ApiError(
                LocalDateTime.now(),
                cause.getStatusCode(),
                cause.getReason()
        );
    }

    /**
     * Of api error.
     *
     * @param cause the cause
     * @return the api error
     */
    public static ApiError of(final WebClientResponseException cause) {
        return new ApiError(
                LocalDateTime.now(),
                cause.getStatusCode(),
                cause.getResponseBodyAsString()
        );
    }
}
