package travel.wink.wise.partner.client;

import java.util.UUID;

/**
 * The interface Transfer wise paths.
 */
public interface TransferWisePaths {

    /**
     * The constant OAUTH_TOKEN_PATH.
     */
    String OAUTH_TOKEN_PATH = "/oauth/token";

    /**
     * The constant PROFILES_PATH_V1.
     */
    String PROFILES_PATH_V1 = "/v1/profiles";
    /**
     * The constant PROFILES_PATH_V2.
     */
    String PROFILES_PATH_V2 = "/v2/profiles";
    /**
     * The constant RECIPIENTS_PATH_V1.
     */
    String RECIPIENTS_PATH_V1 = "/v1/accounts";
    /**
     * The constant RECIPIENTS_PATH_V2.
     */
    String RECIPIENTS_PATH_V2 = "/v2/accounts";
    /**
     * The constant QUOTES_PATH_V1.
     */
    String QUOTES_PATH_V1 = "/v1/quotes";
    /**
     * The constant QUOTES_PATH_V2.
     */
    String QUOTES_PATH_V2 = "/v2/quotes/";

    /**
     * The constant SIGNUP_PATH.
     */
    String SIGNUP_PATH = "/v1/user/signup/registration_code";

    /**
     * The constant TRANSFER_REQUIREMENTS_PATH.
     */
    String TRANSFER_REQUIREMENTS_PATH = "/v1/transfer-requirements";
    /**
     * The constant TRANSFERS_PATH.
     */
    String TRANSFERS_PATH = "/v1/transfers";

    /**
     * The constant ADDRESS_PATH.
     */
    String ADDRESS_PATH = "/v1/addresses";
    /**
     * The constant CURRENCY_PATH.
     */
    String CURRENCY_PATH = "/v1/currencies";

    /**
     * Recipient requirements path string.
     *
     * @param quoteId the quote id
     * @return the string
     */
    static String recipientRequirementsPath(final UUID quoteId) {
        return QUOTES_PATH_V1 + "/" + quoteId + "/account-requirements";
    }

    /**
     * Recipient by id path string.
     *
     * @param recipientId the recipient id
     * @return the string
     */
    static String recipientByIdPath(final Long recipientId) {
        return RECIPIENTS_PATH_V2 + "/" + recipientId;
    }

    /**
     * Quotes path v 2 string.
     *
     * @param quoteId the quote id
     * @return the string
     */
    static String quotesPathV2(final UUID quoteId) {
        return QUOTES_PATH_V2 + quoteId;
    }

    /**
     * Gets profile path.
     *
     * @param profileId the profile id
     * @return the profile path
     */
    static String getProfilePath(final Long profileId) {
        return PROFILES_PATH_V1 + "/" + profileId;
    }

    /**
     * Update window path string.
     *
     * @param profileId the profile id
     * @return the string
     */
    static String updateWindowPath(final Long profileId) {
        return PROFILES_PATH_V1 + "/" + profileId + "/update-window";
    }

    /**
     * Gets address by id path.
     *
     * @param addressId the address id
     * @return the address by id path
     */
    static String getAddressByIdPath(final Long addressId) { return ADDRESS_PATH + "/" + addressId; }
}
