package travel.wink.wise.partner.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.Value;
import org.springframework.web.util.UriBuilder;
import travel.wink.wise.partner.client.params.Parameter;

import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.function.Function;

import static travel.wink.wise.partner.client.BodyRequests.multiMap;

/**
 * The type Uri with params.
 */
@Value
public class UriWithParams implements Function<UriBuilder, URI> {
    String uri;
    Parameter[] parameters;

    /**
     * Instantiates a new Uri with params.
     *
     * @param uri        the uri
     * @param parameters the parameters
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "uri",
            "parameters",
    })
    public UriWithParams(final String uri, final Parameter... parameters) {
        this.uri = uri;
        this.parameters = parameters;
    }

    @Override
    public URI apply(final UriBuilder builder) {
        return builder
                .path(uri)
                .queryParams(multiMap(parameters))
                .build();
    }
}
