package travel.wink.wise.partner.client.params;

import static java.util.UUID.randomUUID;

/**
 * The type Registration code.
 */
public final class RegistrationCode extends Parameter {

    /**
     * Instantiates a new Registration code.
     */
    public RegistrationCode() {
        super(randomUUID().toString());
    }

    /**
     * Instantiates a new Registration code.
     *
     * @param registrationCode the registration code
     */
    public RegistrationCode(final String registrationCode) {
        super(registrationCode);
    }

    @Override
    public String key() {
        return "registration_code";
    }

    /**
     * V 1 v 1 registration code.
     *
     * @return the v 1 registration code
     */
    public V1RegistrationCode v1() {
        return new V1RegistrationCode(value());
    }
}
