/*
 * Copyright (c) 2024 Wink.
 */

package travel.wink.wise.partner.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.NotBlank;
import lombok.Value;
import org.hibernate.validator.constraints.URL;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

import java.beans.ConstructorProperties;

/**
 * Created on: 3/7/24.
 *
 * @author Bjorn Harvold
 */
@Value
@ConfigurationProperties(prefix = "wise")
public class WiseConfigProperties {
    @NotBlank
    @URL
    String baseUrl;

    @NotBlank
    String clientId;

    @NotBlank
    String clientSecret;

    @NotBlank
    String redirectUri;

    /**
     * Instantiates a new Wise config properties.
     *
     * @param baseUrl      the base url
     * @param clientId     the client id
     * @param clientSecret the client secret
     * @param redirectUri  the redirect uri
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "baseUrl",
            "clientId",
            "clientSecret",
            "redirectUri"
    })
    public WiseConfigProperties(
            @JsonProperty(value = "baseUrl", required = true) @NotBlank @URL String baseUrl,
            @JsonProperty(value = "clientId", required = true) @NotBlank String clientId,
            @JsonProperty(value = "clientSecret", required = true) @NotBlank String clientSecret,
            @JsonProperty(value = "redirectUri", required = true) @NotBlank String redirectUri
    ) {
        Assert.hasText(baseUrl, "baseUrl must not be empty");
        Assert.hasText(clientId, "clientId must not be empty");
        Assert.hasText(clientSecret, "clientSecret must not be empty");
        Assert.hasText(redirectUri, "redirectUri must not be empty");

        this.baseUrl = baseUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectUri = redirectUri;
    }
}
