package travel.wink.wise.partner.credentials.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;

/**
 * The type Create address.
 */
@Value
public class CreateAddress {

    Long profile;
    WiseAddress details;

    /**
     * Instantiates a new Create address.
     *
     * @param profile the profile
     * @param details the details
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "profile",
            "details"
    })
    public CreateAddress(
            @JsonProperty("profile") Long profile,
            @JsonProperty("details") WiseAddress details
    ) {
        this.profile = profile;
        this.details = details;
    }

}
