package travel.wink.wise.partner.credentials.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;

/**
 * The type Create personal profile.
 */
@Value
public class CreatePersonalProfile {
    String type;
    ProfileDetails details;

    /**
     * Instantiates a new Create personal profile.
     *
     * @param type    the type
     * @param details the details
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "type",
            "details",
    })
    public CreatePersonalProfile(
            @JsonProperty("type") String type,
            @JsonProperty("details") ProfileDetails details
    ) {
        this.type = type;
        this.details = details;
    }
}
