package travel.wink.wise.partner.credentials.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;

/**
 * The type Profile details.
 */
@Value
public class ProfileDetails {
    String firstName;
    String lastName;
    String dateOfBirth;
    String phoneNumber;

    /**
     * Instantiates a new Profile details.
     *
     * @param firstName   the first name
     * @param lastName    the last name
     * @param dateOfBirth the date of birth
     * @param phoneNumber the phone number
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "firstName",
            "lastName",
            "dateOfBirth",
            "phoneNumber"
    })
    public ProfileDetails(
            @JsonProperty("firstName") String firstName,
            @JsonProperty("lastName") String lastName,
            @JsonProperty("dateOfBirth") String dateOfBirth,
            @JsonProperty("phoneNumber") String phoneNumber
    ) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.dateOfBirth = dateOfBirth;
        this.phoneNumber = phoneNumber;
    }

    /**
     * Of profile details.
     *
     * @param details the details
     * @return the profile details
     */
    public static ProfileDetails of(WiseProfileDetails details) {
        return new ProfileDetails(details.getFirstName(),
                details.getLastName(),
                details.getDateOfBirth(),
                details.getPhoneNumber()
        );
    }
}
