package travel.wink.wise.partner.credentials.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;

/**
 * The type Update personal profile.
 */
@Value
public class UpdatePersonalProfile {

    Long id;
    String type;
    ProfileDetails details;

    /**
     * Instantiates a new Update personal profile.
     *
     * @param id      the id
     * @param type    the type
     * @param details the details
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "id",
            "type",
            "details"
    })
    public UpdatePersonalProfile(
            @JsonProperty("id") Long id,
            @JsonProperty("type") String type,
            @JsonProperty("details") ProfileDetails details
    ) {
        this.id = id;
        this.type = type;
        this.details = details;
    }
}
