package travel.wink.wise.partner.credentials.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;

/**
 * The type Wise address response.
 */
@Value
public class WiseAddressResponse {

    Long id;
    Long profile;
    WiseAddress details;

    /**
     * Instantiates a new Wise address response.
     *
     * @param id        the id
     * @param profile   the profile
     * @param twAddress the tw address
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "id",
            "profile",
            "twAddress"
    })
    public WiseAddressResponse(
            @JsonProperty("id") Long id,
            @JsonProperty("profile") Long profile,
            @JsonProperty("details") WiseAddress twAddress
    ) {

        this.id = id;
        this.profile = profile;
        this.details = twAddress;
    }

}
