package travel.wink.wise.partner.credentials.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;

import static java.time.ZonedDateTime.now;

/**
 * The type Wise client credentials.
 */
@Value
public class WiseClientCredentials {

    String token;
    ZonedDateTime expiresIn;

    /**
     * Instantiates a new Wise client credentials.
     *
     * @param token     the token
     * @param expiresIn the expires in
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "token",
            "expiresIn",
    })
    public WiseClientCredentials(
            @JsonProperty("access_token") final String token,
            @JsonProperty("expires_in") final Integer expiresIn
    ) {
        this.token = token;
        this.expiresIn = now().plusSeconds(expiresIn);
    }

    /**
     * Bearer string.
     *
     * @return the string
     */
    public String bearer() {
        return String.format("Bearer %s", token);
    }
}
