package travel.wink.wise.partner.credentials.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;
import travel.wink.wise.partner.customer.api.Occupation;

import java.beans.ConstructorProperties;

/**
 * The type Wise occupation.
 */
@Value
public class WiseOccupation {

    String code;
    String format;

    /**
     * Instantiates a new Wise occupation.
     *
     * @param code   the code
     * @param format the format
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "code",
            "format",
    })
    public WiseOccupation(
            @JsonProperty("code") String code,
            @JsonProperty("format") String format
    ) {
        this.code = code;
        this.format = format;
    }

    /**
     * Of wise occupation.
     *
     * @param occupation the occupation
     * @return the wise occupation
     */
    public static WiseOccupation of(Occupation occupation) {
        return new WiseOccupation(
                occupation.getCode(),
                occupation.getFormat()
        );
    }
}
