package travel.wink.wise.partner.credentials.api;

import travel.wink.wise.partner.customer.api.Customer;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

/**
 * The type Wise profile comparator.
 */
public class WiseProfileComparator {

    /**
     * Is tw profile equal to customer boolean.
     *
     * @param twProfile the tw profile
     * @param customer  the customer
     * @return the boolean
     */
    public static Boolean isTwProfileEqualToCustomer(final WiseProfile twProfile, final Customer customer) {
        ProfileDetails profileDetails = twProfile.getProfileDetails();

        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

        if (profileDetails.getFirstName() != null ? !profileDetails.getFirstName().equals(customer.getFirstName()) : customer.getFirstName() != null) {
            return false;
        }
        if (profileDetails.getLastName() != null ? !profileDetails.getLastName().equals(customer.getLastName()) : customer.getLastName() != null) {
            return false;
        }
        if (profileDetails.getDateOfBirth() != null ? !LocalDate.parse(profileDetails.getDateOfBirth(), formatter).equals(customer.getDateOfBirth()) : customer.getDateOfBirth() != null) {
            return false;
        }
        if (profileDetails.getPhoneNumber() != null ? !profileDetails.getPhoneNumber().equals(customer.getPhoneNumber()) : customer.getPhoneNumber() == null) {
            return false;
        }

        return true;
    }
}
