package travel.wink.wise.partner.credentials.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;

/**
 * The type Wise profile details.
 */
@Value
public class WiseProfileDetails {

    String firstName;
    String lastName;
    String dateOfBirth;
    String phoneNumber;

    /**
     * Instantiates a new Wise profile details.
     *
     * @param firstName   the first name
     * @param lastName    the last name
     * @param dateOfBirth the date of birth
     * @param phoneNumber the phone number
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "firstName",
            "lastName",
            "dateOfBirth",
            "phoneNumber"
    })
    public WiseProfileDetails(
            @JsonProperty("firstName") String firstName,
            @JsonProperty("lastName") String lastName,
            @JsonProperty("dateOfBirth") String dateOfBirth,
            @JsonProperty("phoneNumber") String phoneNumber
    ) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.dateOfBirth = dateOfBirth;
        this.phoneNumber = phoneNumber;
    }
}
