package travel.wink.wise.partner.credentials.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;

/**
 * The type Wise profile response.
 */
@Value
public class WiseProfileResponse {

    Long id;
    String type;
    WiseProfileDetails details;

    /**
     * Instantiates a new Wise profile response.
     *
     * @param id      the id
     * @param type    the type
     * @param details the details
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "id",
            "type",
            "details"
    })
    public WiseProfileResponse(
            @JsonProperty("id") Long id,
            @JsonProperty("type") String type,
            @JsonProperty("details") WiseProfileDetails details
    ) {
        this.id = id;
        this.type = type;
        this.details = details;
    }
}
