package travel.wink.wise.partner.credentials.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;

/**
 * The type Wise sign up request.
 */
@Value
public class WiseSignUpRequest {

    String email;
    String registrationCode;

    /**
     * Instantiates a new Wise sign up request.
     *
     * @param email            the email
     * @param registrationCode the registration code
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "email",
            "registrationCode"
    })
    public WiseSignUpRequest(
            @JsonProperty("email") String email,
            @JsonProperty("registrationCode") String registrationCode
    ) {
        this.email = email;
        this.registrationCode = registrationCode;
    }

}
