package travel.wink.wise.partner.credentials.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;

/**
 * The type Wise user.
 */
@Value
public class WiseUser {
    Long twUserId;
    String registrationCode;
    Long customerId;
    String email;
    Boolean active;

    /**
     * Instantiates a new Wise user.
     *
     * @param twUserId         the tw user id
     * @param registrationCode the registration code
     * @param customerId       the customer id
     * @param email            the email
     * @param active           the active
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "twUserId",
            "registrationCode",
            "customerId",
            "email",
            "active"
    })
    public WiseUser(
            @JsonProperty("twUserId") Long twUserId,
            @JsonProperty("registrationCode") String registrationCode,
            @JsonProperty("customerId") Long customerId,
            @JsonProperty("email") String email,
            @JsonProperty("active") Boolean active
    ) {
        this.twUserId = twUserId;
        this.registrationCode = registrationCode;
        this.customerId = customerId;
        this.email = email;
        this.active = active;
    }

    /**
     * Of wise user.
     *
     * @param twUserId the tw user id
     * @param email    the email
     * @param active   the active
     * @return the wise user
     */
    public static WiseUser of(
            Long twUserId,
            String email,
            Boolean active
    ) {
        return new WiseUser(
                twUserId,
                null,
                null,
                email,
                active
        );
    }

    /**
     * Update customer id wise user.
     *
     * @param customerId the customer id
     * @return the wise user
     */
    public WiseUser updateCustomerId(final Long customerId) {
        return new WiseUser(
                this.twUserId,
                this.registrationCode,
                customerId,
                this.email,
                this.active
        );
    }

    /**
     * Update registration code wise user.
     *
     * @param registrationCode the registration code
     * @return the wise user
     */
    public WiseUser updateRegistrationCode(final String registrationCode) {
        return new WiseUser(
                this.twUserId,
                registrationCode,
                this.customerId,
                this.email,
                this.active
        );
    }
}
