package travel.wink.wise.partner.credentials.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;

/**
 * The type Wise user response.
 */
@Value
public class WiseUserResponse {

    Long id;
    String email;
    Boolean active;

    /**
     * Instantiates a new Wise user response.
     *
     * @param id     the id
     * @param email  the email
     * @param active the active
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "id",
            "email",
            "active"
    })
    public WiseUserResponse(
            @JsonProperty("id") Long id,
            @JsonProperty("email") String email,
            @JsonProperty("active") Boolean active
    ) {
        this.id = id;
        this.email = email;
        this.active = active;
    }

}
