package travel.wink.wise.partner.credentials.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;

/**
 * The type Wise user tokens.
 */
@Value
public class WiseUserTokens {

    Long customerId;
    Long twUserId;
    String accessToken;
    String refreshToken;
    ZonedDateTime expiryTime;

    /**
     * Instantiates a new Wise user tokens.
     *
     * @param customerId   the customer id
     * @param twUserId     the tw user id
     * @param accessToken  the access token
     * @param refreshToken the refresh token
     * @param expiryTime   the expiry time
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "customerId",
            "twUserId",
            "accessToken",
            "refreshToken",
            "expiryTime"
    })
    public WiseUserTokens(
            @JsonProperty("customerId") Long customerId,
            @JsonProperty("twUserId") Long twUserId,
            @JsonProperty("accessToken") String accessToken,
            @JsonProperty("refreshToken") String refreshToken,
            @JsonProperty("expiryTime") ZonedDateTime expiryTime
    ) {
        this.customerId = customerId;
        this.twUserId = twUserId;
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.expiryTime = expiryTime;
    }

    /**
     * Bearer string.
     *
     * @return the string
     */
    public String bearer() {
        return String.format("Bearer %s", accessToken);
    }
}
