package travel.wink.wise.partner.credentials.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;

/**
 * The type Wise user tokens response.
 */
@Value
public class WiseUserTokensResponse {

    String accessToken;
    String refreshToken;
    Integer expiresIn;

    /**
     * Instantiates a new Wise user tokens response.
     *
     * @param accessToken  the access token
     * @param refreshToken the refresh token
     * @param expiresIn    the expires in
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "accessToken",
            "refreshToken",
            "expiresIn",
    })
    public WiseUserTokensResponse(
            @JsonProperty("access_token") final String accessToken,
            @JsonProperty("refresh_token") final String refreshToken,
            @JsonProperty("expires_in") final Integer expiresIn
    ) {
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.expiresIn = expiresIn;
    }
}
