package travel.wink.wise.partner.credentials.client;

import travel.wink.wise.partner.credentials.api.CreateAddress;
import travel.wink.wise.partner.credentials.api.WiseUserTokens;
import travel.wink.wise.partner.credentials.api.WiseAddressResponse;
import reactor.core.publisher.Mono;

import java.util.Optional;

/**
 * The interface Wise address client.
 */
public interface WiseAddressClient {

    /**
     * Create address mono.
     *
     * @param twUserTokens  the tw user tokens
     * @param createAddress the create address
     * @return the mono
     */
    Mono<WiseAddressResponse> createAddress(Optional<WiseUserTokens> twUserTokens, CreateAddress createAddress);
}
