package travel.wink.wise.partner.credentials.client;

import reactor.core.publisher.Mono;
import travel.wink.wise.partner.credentials.api.WiseUser;
import travel.wink.wise.partner.credentials.api.WiseUserTokens;

/**
 * The interface Wise credentials client.
 */
public interface WiseCredentialsClient {

    /**
     * Sign up mono.
     *
     * @param email            the email
     * @param registrationCode the registration code
     * @return the mono
     */
    Mono<WiseUser> signUp(String email, String registrationCode);

    /**
     * Gets user tokens for code.
     *
     * @param code       the code
     * @param customerId the customer id
     * @return the user tokens for code
     */
    Mono<WiseUserTokens> getUserTokensForCode(String code, Long customerId);

    /**
     * Gets user tokens.
     *
     * @param twUser the tw user
     * @return the user tokens
     */
    Mono<WiseUserTokens> getUserTokens(WiseUser twUser);

    /**
     * Refresh mono.
     *
     * @param twUserTokens the tw user tokens
     * @return the mono
     */
    Mono<WiseUserTokens> refresh(WiseUserTokens twUserTokens);
}
