package travel.wink.wise.partner.credentials.client;

import travel.wink.wise.partner.credentials.api.WiseUserTokens;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.wise.partner.credentials.api.CreatePersonalProfile;
import travel.wink.wise.partner.credentials.api.WiseProfile;
import travel.wink.wise.partner.credentials.api.UpdatePersonalProfile;

/**
 * The interface Wise profile client.
 */
public interface WiseProfileClient {

    /**
     * Create personal profile mono.
     *
     * @param twUserTokens          the tw user tokens
     * @param createPersonalProfile the create personal profile
     * @return the mono
     */
    Mono<WiseProfile> createPersonalProfile(WiseUserTokens twUserTokens, CreatePersonalProfile createPersonalProfile);

    /**
     * Update personal profile mono.
     *
     * @param twUserTokens          the tw user tokens
     * @param updatePersonalProfile the update personal profile
     * @return the mono
     */
    Mono<WiseProfile> updatePersonalProfile(WiseUserTokens twUserTokens, UpdatePersonalProfile updatePersonalProfile);

    /**
     * Gets profile.
     *
     * @param twUserTokens the tw user tokens
     * @param twProfileId  the tw profile id
     * @return the profile
     */
    Mono<WiseProfile> getProfile(WiseUserTokens twUserTokens, Long twProfileId);

    /**
     * Gets profiles.
     *
     * @param twUserTokens the tw user tokens
     * @return the profiles
     */
    Flux<WiseProfile> getProfiles(WiseUserTokens twUserTokens);

    /**
     * Open update window mono.
     *
     * @param twUserTokens the tw user tokens
     * @param twProfileId  the tw profile id
     * @return the mono
     */
    Mono<Boolean> openUpdateWindow(WiseUserTokens twUserTokens, Long twProfileId);

    /**
     * Close update window mono.
     *
     * @param twUserTokens the tw user tokens
     * @param twProfileId  the tw profile id
     * @return the mono
     */
    Mono<Boolean> closeUpdateWindow(WiseUserTokens twUserTokens, Long twProfileId);
}
