package travel.wink.wise.partner.credentials.client.impl;

import lombok.RequiredArgsConstructor;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import travel.wink.wise.partner.credentials.api.CreateAddress;
import travel.wink.wise.partner.credentials.api.WiseAddressResponse;
import travel.wink.wise.partner.credentials.api.WiseUserTokens;
import travel.wink.wise.partner.credentials.client.WiseAddressClient;
import travel.wink.wise.partner.exceptions.WiseException;

import java.util.Optional;

import static org.springframework.http.HttpHeaders.AUTHORIZATION;
import static org.springframework.http.MediaType.APPLICATION_JSON;
import static travel.wink.wise.partner.client.TransferWisePaths.ADDRESS_PATH;

/**
 * The type Wise address client.
 */
@RequiredArgsConstructor
public class WiseAddressClientImpl implements WiseAddressClient {
    private final WebClient client;

    @Override
    public Mono<WiseAddressResponse> createAddress(
            Optional<WiseUserTokens> twUserTokens,
            CreateAddress createAddress
    ) {

        return twUserTokens
                .map(wiseUserTokens -> client.post()
                        .uri(ADDRESS_PATH)
                        .contentType(APPLICATION_JSON)
                        .header(AUTHORIZATION, wiseUserTokens.bearer())
                        .bodyValue(createAddress)
                        .retrieve()
                        .bodyToMono(WiseAddressResponse.class))
                .orElseGet(() -> Mono.error(new IllegalStateException("Cannot create Wise address. Reason: Missing auth token.")))
                ;
    }
}
