package travel.wink.wise.partner.currency.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;
import java.util.List;

/**
 * The type Wise currency.
 */
@Value
public class WiseCurrency {

    String code;
    String symbol;
    String name;
    List<String> countryKeywords;
    Boolean supportsDecimals;

    /**
     * Instantiates a new Wise currency.
     *
     * @param code             the code
     * @param symbol           the symbol
     * @param name             the name
     * @param supportsDecimals the supports decimals
     * @param countryKeywords  the country keywords
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "code",
            "symbol",
            "name",
            "supportsDecimals",
            "countryKeywords"
    })
    public WiseCurrency(
            @JsonProperty("code") String code,
            @JsonProperty("symbol") String symbol,
            @JsonProperty("name") String name,
            @JsonProperty("supportsDecimals") Boolean supportsDecimals,
            @JsonProperty("countryKeywords") List<String> countryKeywords
    ) {
        this.code = code;
        this.symbol = symbol;
        this.name = name;
        this.supportsDecimals = supportsDecimals;
        this.countryKeywords = countryKeywords;
    }
}
