package travel.wink.wise.partner.currency.client;

import reactor.core.publisher.Flux;
import travel.wink.wise.partner.credentials.api.CreateAddress;
import travel.wink.wise.partner.credentials.api.WiseUserTokens;
import travel.wink.wise.partner.currency.api.WiseCurrency;

import java.util.Optional;

/**
 * The interface Wise currency client.
 */
public interface WiseCurrencyClient {

    /**
     * Create address flux.
     *
     * @param twUserTokens  the tw user tokens
     * @param createAddress the create address
     * @return the flux
     */
    Flux<WiseCurrency> createAddress(Optional<WiseUserTokens> twUserTokens, CreateAddress createAddress);
}
