package travel.wink.wise.partner.currency.client.impl;

import lombok.RequiredArgsConstructor;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import travel.wink.wise.partner.credentials.api.CreateAddress;
import travel.wink.wise.partner.credentials.api.WiseUserTokens;
import travel.wink.wise.partner.currency.api.WiseCurrency;
import travel.wink.wise.partner.currency.client.WiseCurrencyClient;

import java.util.Optional;

import static org.springframework.http.HttpHeaders.AUTHORIZATION;
import static org.springframework.http.MediaType.APPLICATION_JSON;
import static travel.wink.wise.partner.client.TransferWisePaths.CURRENCY_PATH;

/**
 * The type Wise currency client.
 */
@RequiredArgsConstructor
public class WiseCurrencyClientImpl implements WiseCurrencyClient {
    private final WebClient client;

    @Override
    public Flux<WiseCurrency> createAddress(
            Optional<WiseUserTokens> twUserTokens,
            CreateAddress createAddress
    ) {

        return twUserTokens
                .map(wiseUserTokens -> client.get()
                        .uri(CURRENCY_PATH)
                        .accept(APPLICATION_JSON)
                        .header(AUTHORIZATION, wiseUserTokens.bearer())
                        .retrieve()
                        .bodyToFlux(WiseCurrency.class))
                .orElseGet(() -> Flux.error(new IllegalStateException("Cannot retrieve Wise currencies. Reason: Missing auth token.")))
                ;
    }
}
